/*
 * Decompiled with CFR 0.152.
 */
package com.sk.jclient.services;

import com.sk.SKML;
import com.sk.jclient.ContentServer;
import com.sk.jclient.InterpreterOperation;
import com.sk.jclient.services.IService;
import com.sk.jclient.ui.components.SKGauge;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import javax.microedition.io.ConnectionNotFoundException;
import javax.microedition.io.Connector;
import javax.microedition.io.HttpConnection;

public class HttpService
implements IService,
Runnable,
SKML {
    private int bytesTotal = 0;
    private SKGauge gauge;
    private int gaugeMaxInc;
    private int gaugeInit;
    private HttpConnection conn;
    private InputStream is;
    private OutputStream os;
    private ContentServer contentServer;
    private InterpreterOperation operation;
    private String ssuid;

    public final String toString() {
        return "skapploader.loadData";
    }

    public final void invoke(InterpreterOperation interpreterOperation, ContentServer contentServer) {
        this.contentServer = contentServer;
        this.operation = interpreterOperation;
        if (interpreterOperation.gauge != null) {
            this.gauge = interpreterOperation.gauge;
            this.gaugeInit = (Integer)interpreterOperation.gauge.value_;
            this.gaugeMaxInc = interpreterOperation.gaugeMaxInc > 0 ? interpreterOperation.gaugeMaxInc : this.gauge.maxValue;
        }
        contentServer.setBusy(true, "Please wait...");
        new Thread(this).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            byte[] byArray = this.request(this.operation.parameters);
            if (this.operation.onComplete != null) {
                this.operation.onComplete.onError = this.operation.onError;
                this.operation.onComplete.dataContent = byArray;
                if (this.operation.onComplete.action.equals("doUpdate")) {
                    this.operation.onComplete.parameters = new Object[]{this.ssuid, this.is, new Integer(this.bytesTotal)};
                } else if (this.operation.onComplete.action.equals("storeData")) {
                    String string = (String)this.operation.onComplete.parameters[0];
                    this.operation.onComplete.parameters = new Object[]{string, this.is, new Integer(this.bytesTotal)};
                }
            }
            this.contentServer.completedOK(this.operation.onComplete);
        }
        catch (ConnectionNotFoundException connectionNotFoundException) {
            this.showError("Host not found.");
        }
        catch (InterruptedIOException interruptedIOException) {
            this.showError("Connection has broken or timeout.");
        }
        catch (IOException iOException) {
            if (iOException.getMessage().startsWith("HTTP Status Code")) {
                this.showError("Error " + iOException.getMessage());
            } else {
                this.showError("Unspecified network error.");
            }
        }
        catch (SecurityException securityException) {
            this.showError("The application has no permission to open the connection.");
        }
        finally {
            this.stop();
            this.contentServer.setBusy(false, null);
        }
    }

    private void showError(String string) {
        if (this.operation.onError != null) {
            InterpreterOperation interpreterOperation = new InterpreterOperation("navigator", "alert", new String[]{string, "Network error", null});
            interpreterOperation.onComplete = this.operation.onError;
            this.contentServer.completedWithError(interpreterOperation);
        }
        ContentServer.flags = (byte)(ContentServer.flags & 0xFFFFFFFE);
    }

    public void stop() {
        try {
            if (this.os != null) {
                this.os.close();
            }
            if (this.is != null) {
                this.is.close();
            }
            if (this.conn != null) {
                this.conn.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.contentServer != null) {
            this.contentServer.deregisterService(this);
        }
    }

    public byte[] request(Object[] objectArray) throws IOException {
        int n;
        String string = (String)objectArray[0];
        String string2 = (String)objectArray[1];
        String string3 = (String)objectArray[3];
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.conn = (HttpConnection)Connector.open((String)string, (int)3, (boolean)true);
        this.conn.setRequestProperty("Accept", "*/*");
        if (string2.equals("get")) {
            this.conn.setRequestMethod("GET");
        } else if (string2.equals("post")) {
            this.conn.setRequestMethod("POST");
            byte[] byArray = (byte[])objectArray[2];
            this.conn.setRequestProperty("Content-Length", byArray + "");
            this.conn.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + string3);
            this.os = this.conn.openOutputStream();
            this.os.write(byArray);
        } else if (string2.equals("stream")) {
            this.conn.setRequestMethod("POST");
            this.conn.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + string3);
            this.os = this.conn.openOutputStream();
            this.contentServer.updateManager.getCmdList(this.os);
        }
        int n2 = this.conn.getResponseCode();
        if (n2 != 200) {
            throw new IOException("HTTP Status Code: " + this.conn.getResponseCode() + " " + this.conn.getResponseMessage());
        }
        this.ssuid = this.conn.getHeaderField("ssuid");
        this.is = this.conn.openInputStream();
        int n3 = 0;
        try {
            this.bytesTotal = Integer.parseInt(this.conn.getHeaderField("Content-Length"));
        }
        catch (Exception exception) {
            this.bytesTotal = 4096;
        }
        if (this.operation.onComplete.action.equals("doUpdate") && this.bytesTotal > 3 || this.operation.onComplete.action.equals("storeData")) {
            return new byte[]{-1};
        }
        byte[] byArray = new byte[2048];
        if (this.gauge != null) {
            this.gauge.setValue(this.gaugeInit);
        }
        while ((n = this.is.read(byArray)) != -1) {
            byteArrayOutputStream.write(byArray, 0, n);
            n3 += n;
            if (this.gauge == null || this.bytesTotal <= 100) continue;
            this.gauge.setValue(n3 * this.gauge.maxValue / this.bytesTotal);
        }
        if (this.gauge != null) {
            if (this.bytesTotal > 100) {
                this.gauge.setValue(this.gauge.maxValue);
            } else {
                this.gauge.setValue(3);
            }
        }
        return byteArrayOutputStream.toByteArray();
    }
}

