/*
 * Decompiled with CFR 0.152.
 */
package com.sk.jclient.util;

import com.sk.SKML;
import com.sk.jclient.ContentServer;
import com.sk.jclient.Main;
import com.sk.jclient.util.ResourceConsumer;
import com.sk.jclient.util.ResourceDescriptor;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.microedition.io.Connector;
import javax.microedition.io.file.FileConnection;
import javax.microedition.lcdui.Image;
import javax.microedition.rms.InvalidRecordIDException;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;

public final class ResourceMgr
implements SKML {
    public static final byte CTR_WAP = 116;
    public static final byte CTR_SMS = 117;
    public static final byte CTR_RINGTONE = 118;
    public static final byte CTR_APP = 119;
    public static final byte CTR_NEWS = 120;
    public static final byte CTR_FORMAT = 121;
    private final String fn;
    public static final String STORENAME = "dlData";
    static final Hashtable imageCache = new Hashtable();
    private static ResourceLoader loader;
    private static final StringBuffer sbuf;
    private Hashtable storeCache = new Hashtable();
    private boolean resetStore = false;
    private static Image placeHolder_img;
    private RecordStore rs_ = null;
    private static String urlContext_;

    public static final String getProtocolFromUrl(String string) {
        int n = string.indexOf("://");
        if (n > -1) {
            return string.substring(0, n);
        }
        if (string.startsWith("/")) {
            return "/";
        }
        return "";
    }

    public static final String getContentFromUrl(String string) {
        int n = string.indexOf(":///");
        if (n > -1) {
            return string.substring(n + 4);
        }
        if (string.startsWith("/")) {
            return string.substring(1);
        }
        if (string.startsWith("http")) {
            return string.substring(7);
        }
        if (string.startsWith("https")) {
            return string.substring(8);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final long getAvailableStorage() throws IOException {
        FileConnection fileConnection = null;
        try {
            fileConnection = (FileConnection)Connector.open((String)Main.instance.FILESYSTEM_ROOT);
            long l = fileConnection.availableSize();
            return l;
        }
        finally {
            try {
                fileConnection.close();
            }
            catch (Exception exception) {}
        }
    }

    final void adjustContext(String string) {
        int n = string.lastIndexOf(47);
        if (n != -1) {
            urlContext_ = string.substring(0, n + 1);
        }
    }

    public static final String completeURL(String string) {
        if (string.startsWith("/") || string.startsWith("http") || string.startsWith("https") || string.startsWith("file") || string.startsWith("rs")) {
            return string;
        }
        if (string.startsWith("..")) {
            int n = -1;
            String string2 = urlContext_.substring(0, urlContext_.length() - 1);
            if (!string2.equals("") && !string2.endsWith("//")) {
                n = string2.lastIndexOf(47);
                return urlContext_.substring(0, n) + string.substring(2);
            }
            throw new NullPointerException("The directory ../ does not exist");
        }
        return urlContext_ + string;
    }

    public final byte[] getSkml(String string) throws IOException, IllegalArgumentException {
        String string2 = ResourceMgr.getProtocolFromUrl(string);
        if (string2.equals("http")) {
            throw new IllegalArgumentException("Remote SKML not supported in this release");
        }
        if (!string2.equals("")) {
            this.adjustContext(string);
            return this.getData(string);
        }
        String string3 = ResourceMgr.completeURL(string);
        this.adjustContext(string3);
        return this.getData(string3);
    }

    public final byte[] getData(String string) throws IOException, IllegalArgumentException {
        String string2 = ResourceMgr.getProtocolFromUrl(string);
        byte[] byArray = null;
        if ("file".equals(string2)) {
            byArray = ResourceMgr.getResource(ResourceMgr.getContentFromUrl(string));
        } else {
            if ("http".equals(string2) || "https".equals(string2)) {
                throw new IllegalArgumentException();
            }
            if ("rs".equals(string2) || "/".equals(string2)) {
                String string3 = ResourceMgr.getContentFromUrl(string);
                try {
                    byArray = this.readValue(string3);
                }
                catch (RecordStoreException recordStoreException) {
                    byArray = ResourceMgr.getResource(string3);
                }
            } else {
                byArray = this.getData(ResourceMgr.completeURL(string));
            }
        }
        return byArray;
    }

    public ResourceMgr() {
        this.fn = "counter";
        try {
            placeHolder_img = Image.createImage((String)"/o.png");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        loader = new ResourceLoader();
        loader.start();
        this.updateCache();
    }

    public final void shutdown(boolean bl) {
        loader.shutdown();
        loader = null;
        if (bl) {
            imageCache.clear();
        }
    }

    static final byte[] getResource(String string) throws IOException {
        InputStream inputStream = null;
        byte[] byArray = null;
        byte[] byArray2 = new byte[1024];
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            int n;
            if (!string.startsWith("/")) {
                string = "/" + string;
            }
            inputStream = string.getClass().getResourceAsStream(string);
            while ((n = inputStream.read(byArray2)) != -1) {
                byteArrayOutputStream.write(byArray2, 0, n);
            }
            byArray = byteArrayOutputStream.toByteArray();
        }
        catch (NullPointerException nullPointerException) {
            throw new IOException("Resource " + string + " missing");
        }
        finally {
            try {
                inputStream.close();
                byteArrayOutputStream.close();
            }
            catch (Exception exception) {}
        }
        return byArray;
    }

    public final synchronized Image getImage(String string, ResourceConsumer resourceConsumer) {
        if (imageCache.containsKey(string)) {
            Image image = (Image)imageCache.get(string);
            resourceConsumer.resourceEventOccurred((byte)3, string, image);
            return image;
        }
        if (imageCache.containsKey(string.toLowerCase())) {
            Image image = (Image)imageCache.get(string.toLowerCase());
            resourceConsumer.resourceEventOccurred((byte)3, string, image);
            return image;
        }
        if (loader == null) {
            loader = new ResourceLoader();
            loader.start();
        }
        loader.loadResource(string, resourceConsumer);
        return placeHolder_img;
    }

    public static final boolean isPlaceHolder(Image image) {
        return image != null && image.equals(placeHolder_img);
    }

    private final void openRecordStore() {
        try {
            this.rs_ = RecordStore.openRecordStore((String)STORENAME, (boolean)true);
        }
        catch (RecordStoreException recordStoreException) {
            try {
                this.rs_ = RecordStore.openRecordStore((String)STORENAME, (boolean)true);
            }
            catch (RecordStoreException recordStoreException2) {
                // empty catch block
            }
        }
    }

    private final void reopenRecordStore() {
        if (this.rs_ != null) {
            try {
                this.rs_.closeRecordStore();
            }
            catch (RecordStoreException recordStoreException) {
                // empty catch block
            }
        }
        this.openRecordStore();
    }

    public final void writeValue(String string, byte[] byArray) {
        imageCache.remove(string);
        this.writeValueToFS(string, byArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void writeValueToFS(String string, byte[] byArray) {
        FileConnection fileConnection = null;
        OutputStream outputStream = null;
        try {
            fileConnection = this.getFileConnection(string, Main.instance.FILESYSTEM_ROOT);
            outputStream = fileConnection.openDataOutputStream();
            outputStream.write(byArray);
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                if (outputStream != null) {
                    outputStream.close();
                }
                fileConnection.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void writeValueToFS(String string, InputStream inputStream, int n) {
        FileConnection fileConnection = null;
        OutputStream outputStream = null;
        try {
            int n2;
            fileConnection = this.getFileConnection(string, "");
            outputStream = fileConnection.openDataOutputStream();
            byte[] byArray = new byte[2048];
            int n3 = 0;
            while ((n2 = inputStream.read(byArray)) != -1) {
                outputStream.write(byArray, 0, n2);
                n3 += n2;
                if (ContentServer.currentPage.gauge_ == null || n <= 100) continue;
                ContentServer.currentPage.gauge_.setValue(n3 * ContentServer.currentPage.gauge_.maxValue / n);
            }
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                if (outputStream != null) {
                    outputStream.close();
                }
                fileConnection.close();
            }
            catch (Exception exception) {}
        }
    }

    private FileConnection getFileConnection(String string, String string2) throws IOException {
        FileConnection fileConnection = null;
        FileConnection fileConnection2 = null;
        int n = string.lastIndexOf(47);
        String string3 = n != -1 ? string.substring(0, n) : "";
        String string4 = (string2 + string).toLowerCase();
        String string5 = (string2 + string3).toLowerCase();
        fileConnection2 = (FileConnection)Connector.open((String)string5);
        if (fileConnection2.exists()) {
            fileConnection2.close();
            fileConnection = (FileConnection)Connector.open((String)string4);
            if (fileConnection.exists()) {
                fileConnection.delete();
                fileConnection.create();
            } else {
                fileConnection.create();
            }
        } else {
            fileConnection2.close();
            this.mkdirs(string4);
            fileConnection = (FileConnection)Connector.open((String)string4);
            fileConnection.create();
        }
        return fileConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final synchronized void mkdirs(String string) {
        String string2 = ResourceMgr.getContentFromUrl(string);
        try {
            String string3;
            int n;
            String string4 = string2.substring(0, string2.lastIndexOf(47) + 1);
            StringBuffer stringBuffer = new StringBuffer(string4);
            StringBuffer stringBuffer2 = new StringBuffer("/");
            while ((n = (string3 = stringBuffer.toString()).indexOf(47)) != -1) {
                String string5 = string3.substring(0, n + 1);
                stringBuffer2.append(string5);
                String string6 = stringBuffer2.toString();
                FileConnection fileConnection = null;
                try {
                    fileConnection = (FileConnection)Connector.open((String)("file://" + string6));
                    if (!fileConnection.exists()) {
                        fileConnection.mkdir();
                    }
                }
                catch (IOException iOException) {
                }
                finally {
                    try {
                        fileConnection.close();
                    }
                    catch (Exception exception) {}
                }
                stringBuffer.delete(0, string5.length());
            }
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    final synchronized byte[] readValue(String string) throws RecordStoreException {
        try {
            return ResourceMgr.readFile((Main.instance.FILESYSTEM_ROOT + string).toLowerCase());
        }
        catch (IOException iOException) {
            throw new RecordStoreException();
        }
    }

    public final boolean fileExists(String string) {
        return this.fileExistsFS(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean fileExistsFS(String string) {
        FileConnection fileConnection = null;
        boolean bl = false;
        try {
            fileConnection = (FileConnection)Connector.open((String)(Main.instance.FILESYSTEM_ROOT + string));
            bl = fileConnection.exists();
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                fileConnection.close();
            }
            catch (Exception exception) {}
        }
        return bl;
    }

    final void deleteValue(String string) {
        this.deleteValueFS(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final Vector getRecordsRS() {
        Vector<ResourceDescriptor> vector = new Vector<ResourceDescriptor>();
        RecordStore recordStore = null;
        try {
            recordStore = RecordStore.openRecordStore((String)STORENAME, (boolean)false);
            for (int i = 1; i < recordStore.getNextRecordID(); i += 2) {
                try {
                    String string = new String(recordStore.getRecord(i));
                    byte[] byArray = recordStore.getRecord(i + 1);
                    ResourceDescriptor resourceDescriptor = new ResourceDescriptor(new String(string), recordStore.getName(), i + 1, byArray);
                    vector.addElement(resourceDescriptor);
                    continue;
                }
                catch (InvalidRecordIDException invalidRecordIDException) {
                    // empty catch block
                }
            }
            vector.trimToSize();
        }
        catch (RecordStoreException recordStoreException) {
        }
        finally {
            try {
                recordStore.closeRecordStore();
            }
            catch (Exception exception) {}
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final synchronized void recreateStore() {
        if (this.resetStore) {
            this.resetStore = false;
            int n = 0;
            Vector<String> vector = new Vector<String>();
            Vector<Object> vector2 = new Vector<Object>();
            try {
                Object object;
                this.openRecordStore();
                Enumeration enumeration = this.storeCache.keys();
                while (enumeration.hasMoreElements()) {
                    String string = (String)enumeration.nextElement();
                    n = (Integer)this.storeCache.get(string) + 1;
                    object = this.rs_.getRecord(n);
                    vector.addElement(string);
                    vector2.addElement(object);
                }
                this.rs_.closeRecordStore();
                RecordStore.deleteRecordStore((String)STORENAME);
                this.rs_ = null;
                this.openRecordStore();
                for (int i = 0; i < vector.size(); ++i) {
                    object = (String)vector.elementAt(i);
                    byte[] byArray = (byte[])vector2.elementAt(i);
                    this.rs_.addRecord(((String)object).getBytes(), 0, ((String)object).length());
                    this.rs_.addRecord(byArray, 0, byArray.length);
                    this.storeCache.put(object, new Integer(2 * i + 1));
                }
            }
            catch (RecordStoreException recordStoreException) {
            }
            finally {
                try {
                    this.rs_.closeRecordStore();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private final void deleteValueFS(String string) {
        String string2;
        block27: {
            FileConnection fileConnection;
            block26: {
                if (string == null) {
                    return;
                }
                imageCache.remove(string);
                sbuf.setLength(0);
                if (!string.startsWith(Main.instance.FILESYSTEM_ROOT)) {
                    sbuf.append(Main.instance.FILESYSTEM_ROOT);
                }
                sbuf.append(string);
                fileConnection = null;
                try {
                    fileConnection = (FileConnection)Connector.open((String)sbuf.toString().toLowerCase());
                    if (fileConnection.exists()) {
                        fileConnection.delete();
                    }
                }
                catch (IOException iOException) {
                }
                finally {
                    try {
                        fileConnection.close();
                    }
                    catch (Exception exception) {}
                }
                int n = sbuf.toString().lastIndexOf(47);
                sbuf.delete(n, sbuf.length());
                string2 = sbuf.toString().toLowerCase();
                fileConnection = (FileConnection)Connector.open((String)string2);
                Enumeration enumeration = fileConnection.list();
                if (!enumeration.hasMoreElements()) break block26;
                throw new IOException(string2 + " not empty");
            }
            try {
                fileConnection.close();
            }
            catch (Exception exception) {}
            break block27;
            catch (IOException iOException) {
                try {
                    fileConnection.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return;
                catch (Throwable throwable) {
                    try {
                        fileConnection.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
        }
        if (sbuf.toString().equals(Main.instance.FILESYSTEM_ROOT)) {
            return;
        }
        this.deleteValueFS(string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final Vector getRecordsDir(String string) {
        Vector vector;
        block14: {
            FileConnection fileConnection = null;
            vector = new Vector();
            try {
                fileConnection = (FileConnection)Connector.open((String)(Main.instance.FILESYSTEM_ROOT + string));
                if (!fileConnection.exists()) break block14;
                Enumeration enumeration = fileConnection.list();
                fileConnection.close();
                while (enumeration.hasMoreElements()) {
                    Object object;
                    String string2 = (String)enumeration.nextElement();
                    fileConnection = (FileConnection)Connector.open((String)(Main.instance.FILESYSTEM_ROOT + string + string2));
                    if (fileConnection.isDirectory()) {
                        fileConnection.close();
                        object = ResourceMgr.getRecordsDir(string + string2);
                        for (int i = 0; i < ((Vector)object).size(); ++i) {
                            vector.addElement(((Vector)object).elementAt(i));
                        }
                        continue;
                    }
                    fileConnection.close();
                    object = string + string2;
                    byte[] byArray = ResourceMgr.readFile(Main.instance.FILESYSTEM_ROOT + (String)object);
                    ResourceDescriptor resourceDescriptor = new ResourceDescriptor((String)object, null, 0, byArray);
                    vector.addElement(resourceDescriptor);
                }
            }
            catch (IOException iOException) {
            }
            finally {
                try {
                    fileConnection.close();
                }
                catch (Exception exception) {}
            }
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final byte[] readFile(String string) throws IOException {
        FileConnection fileConnection = null;
        DataInputStream dataInputStream = null;
        byte[] byArray = null;
        byte[] byArray2 = new byte[1024];
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            int n;
            fileConnection = (FileConnection)Connector.open((String)string);
            dataInputStream = fileConnection.openDataInputStream();
            while ((n = ((InputStream)dataInputStream).read(byArray2)) != -1) {
                byteArrayOutputStream.write(byArray2, 0, n);
            }
            byArray = byteArrayOutputStream.toByteArray();
        }
        finally {
            try {
                if (dataInputStream != null) {
                    ((InputStream)dataInputStream).close();
                }
                if (byteArrayOutputStream != null) {
                    byteArrayOutputStream.close();
                }
                fileConnection.close();
            }
            catch (Exception exception) {}
        }
        return byArray;
    }

    public static final void reset(boolean bl) {
        if (bl) {
            imageCache.clear();
        }
        loader.reset();
    }

    private final int getPosition(String string) throws RecordStoreException {
        if (this.storeCache.containsKey(string)) {
            int n = (Integer)this.storeCache.get(string);
            return n + 1;
        }
        if (this.storeCache.containsKey(string.toLowerCase())) {
            int n = (Integer)this.storeCache.get(string.toLowerCase());
            return n + 1;
        }
        throw new RecordStoreException("key not found");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final synchronized void updateCache() {
        try {
            this.openRecordStore();
            int n = this.rs_.getNextRecordID();
            for (int i = 1; i < n; i += 2) {
                try {
                    String string = new String(this.rs_.getRecord(i));
                    this.storeCache.put(string, new Integer(i));
                    continue;
                }
                catch (InvalidRecordIDException invalidRecordIDException) {
                    // empty catch block
                }
            }
        }
        catch (RecordStoreException recordStoreException) {
        }
        finally {
            try {
                this.rs_.closeRecordStore();
            }
            catch (Exception exception) {}
        }
    }

    public synchronized void notifyConsumers(String string, Object object) {
        if (string.endsWith(".png")) {
            byte[] byArray = (byte[])object;
            object = Image.createImage((byte[])byArray, (int)0, (int)byArray.length);
        }
        ResourceMgr.loader.notifyConsumers((byte)3, string, object);
    }

    private final boolean equals(byte[] byArray, byte[] byArray2) {
        if (byArray == null || byArray2 == null) {
            return false;
        }
        int n = byArray.length;
        if (n != byArray2.length) {
            return false;
        }
        boolean bl = true;
        for (int i = 0; i < n; ++i) {
            if (byArray2[i] == byArray[i]) continue;
            bl = false;
            break;
        }
        return bl;
    }

    public String incrementCounter(byte by) {
        Closeable closeable;
        Closeable closeable2;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        byte[] byArray = null;
        try {
            byArray = this.readValue("counter");
            closeable2 = new ByteArrayInputStream(byArray);
            closeable = new DataInputStream((InputStream)closeable2);
            n = ((DataInputStream)closeable).readShort();
            n2 = ((DataInputStream)closeable).readShort();
            n3 = ((DataInputStream)closeable).readShort();
            n4 = ((DataInputStream)closeable).readShort();
            n5 = ((DataInputStream)closeable).readShort();
            ((FilterInputStream)closeable).close();
            ((ByteArrayInputStream)closeable2).close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        switch (by) {
            case 116: {
                n = (short)(n + 1);
                break;
            }
            case 117: {
                n2 = (short)(n2 + 1);
                break;
            }
            case 118: {
                n3 = (short)(n3 + 1);
                break;
            }
            case 119: {
                n4 = (short)(n4 + 1);
                break;
            }
            case 120: {
                n5 = (short)(n5 + 1);
                break;
            }
            case 121: {
                return this.formatEventCounts(n, n2, n3, n4, n5);
            }
        }
        try {
            closeable2 = new ByteArrayOutputStream();
            closeable = new DataOutputStream((OutputStream)closeable2);
            ((DataOutputStream)closeable).writeShort(n);
            ((DataOutputStream)closeable).writeShort(n2);
            ((DataOutputStream)closeable).writeShort(n3);
            ((DataOutputStream)closeable).writeShort(n4);
            ((DataOutputStream)closeable).writeShort(n5);
            byArray = ((ByteArrayOutputStream)closeable2).toByteArray();
            ((FilterOutputStream)closeable).close();
            ((ByteArrayOutputStream)closeable2).close();
            this.writeValue("counter", byArray);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    private String formatEventCounts(int n, int n2, int n3, int n4, int n5) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        int n6 = calendar.get(1);
        int n7 = calendar.get(2) + 1;
        int n8 = calendar.get(5);
        String string = Integer.toString(n7);
        if (n7 < 10) {
            string = "0" + string;
        }
        String string2 = n6 + string + n8;
        String string3 = "<counts>\n     <val date=\"" + string2 + "\" type=\"SMS\" total=\"" + n2 + "\"/>\n" + "     <val date=\"" + string2 + "\" type=\"MMS\" total=\"" + 0 + "\"/>\n" + "     <val date=\"" + string2 + "\" type=\"Voice\" total=\"" + 0 + "\"/>\n" + "     <val date=\"" + string2 + "\" type=\"ICMENU\" total=\"" + n4 + "\"/>\n" + "     <val date=\"" + string2 + "\" type=\"WAP\" total=\"" + n + "\"/>\n" + "</counts>";
        return string3;
    }

    private void resetCounters() {
        this.writeValue("counter", new byte[]{0});
    }

    public static final boolean isImage(String string) {
        return string.endsWith(".png") || string.endsWith(".jpg") || string.endsWith(".gif") || string.endsWith(".bmp");
    }

    static final int hash(byte[] byArray) {
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < byArray.length; i += 4) {
            n2 = ResourceMgr.fillInt(byArray, i);
            n ^= n2;
        }
        return n;
    }

    private static final int fillInt(byte[] byArray, int n) {
        int n2 = 0;
        for (int i = 0; i < 4; ++i) {
            n2 <<= 8;
            if (n + i >= byArray.length) {
                return n2;
            }
            n2 |= byArray[n + i];
        }
        return n2;
    }

    static {
        sbuf = new StringBuffer();
        urlContext_ = "/";
    }

    private final class ResourceLoader
    extends Thread {
        private boolean running = true;
        private Hashtable resourceSubscribers;
        private Vector resourceList = new Vector(2);
        private Vector notAvail;

        ResourceLoader() {
            this.resourceSubscribers = new Hashtable();
            this.notAvail = new Vector(1);
        }

        synchronized void loadResource(String string, ResourceConsumer resourceConsumer) {
            if (!this.resourceSubscribers.containsKey(string) && !this.resourceSubscribers.containsKey(string.toLowerCase())) {
                Vector<ResourceConsumer> vector = new Vector<ResourceConsumer>();
                vector.addElement(resourceConsumer);
                this.resourceSubscribers.put(string, vector);
            } else {
                Vector vector = (Vector)this.resourceSubscribers.get(string);
                if (!vector.contains(resourceConsumer)) {
                    vector.addElement(resourceConsumer);
                    this.resourceSubscribers.put(string, vector);
                }
            }
            if (this.resourceList.contains(string) || this.notAvail.contains(string)) {
                return;
            }
            this.resourceList.addElement(string);
            this.notifyConsumers((byte)2, string, null);
            this.notifyAll();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (this.running) {
                String string = null;
                try {
                    Object object = this;
                    synchronized (object) {
                        if (this.resourceList.isEmpty()) {
                            this.wait();
                        }
                    }
                    if (!this.running) {
                        return;
                    }
                    try {
                        string = (String)this.resourceList.firstElement();
                        object = ResourceMgr.this.getData(string);
                        if (ResourceMgr.isImage(string)) {
                            try {
                                Image image = Image.createImage((byte[])object, (int)0, (int)((Object)object).length);
                                imageCache.remove(string);
                                imageCache.put(string, image);
                                this.notifyConsumers((byte)3, string, image);
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                this.notifyConsumers((byte)1, string, null);
                            }
                            this.notAvail.removeElement(string);
                            continue;
                        }
                        this.notifyConsumers((byte)3, string, object);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        this.notifyConsumers((byte)4, string, null);
                    }
                    catch (IOException iOException) {
                        this.notAvail.addElement(string);
                        this.notifyConsumers((byte)1, string, null);
                    }
                    finally {
                        this.resourceList.removeElement(string);
                    }
                }
                catch (InterruptedException interruptedException) {}
            }
        }

        synchronized void shutdown() {
            this.running = false;
            this.notifyAll();
        }

        void reset() {
            this.resourceList.removeAllElements();
            this.resourceSubscribers.clear();
            this.notAvail.removeAllElements();
        }

        private synchronized void notifyConsumers(byte by, String string, Object object) {
            Vector vector = (Vector)this.resourceSubscribers.get(string);
            if (vector == null) {
                return;
            }
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((ResourceConsumer)vector.elementAt(i)).resourceEventOccurred(by, string, object);
            }
            if (by == 3 || by == 1) {
                this.resourceSubscribers.remove(string);
            }
        }
    }
}

