/*
 * Decompiled with CFR 0.152.
 */
package com.sk.jclient.util;

import com.sk.SKML;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.Hashtable;
import java.util.Vector;

public final class XMLPullParser
implements SKML {
    public static final short TAG_PAGE = 1;
    public static final short TAG_IMAGE = 2;
    public static final short TAG_LABEL = 3;
    public static final short TAG_INPUT = 4;
    public static final short TAG_SOFTKEY = 5;
    public static final short TAG_SOUND = 6;
    public static final short TAG_VIDEO = 7;
    public static final short TAG_PROGRESSBAR = 8;
    public static final short TAG_SCROLLBAR = 9;
    public static final short TAG_TIMER = 10;
    public static final short TAG_LIST = 11;
    public static final short TAG_LISTITEM = 12;
    public static final short TAG_GRID = 13;
    public static final short TAG_GRIDITEM = 14;
    public static final short TAG_TICKER = 15;
    public static final short TAG_CHECKBOX = 16;
    public static final short TAG_RADIOBUTTONS = 17;
    public static final short TAG_RADIOBUTTON = 18;
    public static final short TAG_CONTAINER = 19;
    public static final short TAG_BUTTON = 20;
    public static final short TAG_TREE = 21;
    public static final short TAG_TREEITEM = 22;
    public static final short TAG_BANNER = 23;
    public static final int START_TAG = 0;
    public static final int END_TAG = 1;
    public static final int END_XML = -1;
    private static final Hashtable tags = new Hashtable();
    private final char[] _input;
    private int _length;
    private int _pos;
    private boolean _betweenTags = false;
    private int _depth = 0;
    public String _currentTag;
    public String _currentText;
    public int _status;
    private final Vector _attNames = new Vector(5);
    private final Vector _attValues = new Vector(5);
    private final StringBuffer sbuffer = new StringBuffer(20);
    private final StringBuffer sbuffer2 = new StringBuffer(20);
    private boolean _isAttEqual;
    private boolean _isAttKey;
    private boolean _isAttValue;
    private char _currentAttBracket;

    public XMLPullParser(byte[] byArray) throws IllegalArgumentException {
        try {
            this._input = this.getCharArrayUTF8(byArray);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalArgumentException("XML cannot be converted to UTF-8");
        }
    }

    public final int getDepth() {
        return this._depth;
    }

    public char[] getCharArray() {
        return this._input;
    }

    public final int getAttributeCount() {
        return this._attNames.size();
    }

    public final String getAttributeName(int n) {
        return this._attNames.size() > n ? (String)this._attNames.elementAt(n) : "";
    }

    public final String getAttributeValue(int n) {
        return this._attValues.size() > n ? (String)this._attValues.elementAt(n) : "";
    }

    private final char[] getCharArrayUTF8(byte[] byArray) throws UnsupportedEncodingException {
        char[] cArray = new char[byArray.length];
        InputStreamReader inputStreamReader = new InputStreamReader((InputStream)new ByteArrayInputStream(byArray), "UTF-8");
        try {
            this._length = inputStreamReader.read(cArray, 0, cArray.length);
            return cArray;
        }
        catch (IOException iOException) {
            throw new NullPointerException();
        }
    }

    public final void nextTag() {
        this._attNames.removeAllElements();
        this._attValues.removeAllElements();
        if (this._pos >= this._length) {
            this._status = -1;
            return;
        }
        try {
            char c = this._input[this._pos];
            while (this._pos < this._length) {
                if (c == '<') {
                    ++this._pos;
                    while (this._pos < this._length) {
                        c = this._input[this._pos];
                        if (c == '/') {
                            this._status = 1;
                            ++this._pos;
                            this.sbuffer.setLength(0);
                            c = this._input[this._pos];
                            while (this._pos < this._length) {
                                if (c == '>') {
                                    ++this._pos;
                                    if (this._betweenTags) {
                                        this._betweenTags = false;
                                    } else {
                                        --this._depth;
                                    }
                                    this._currentTag = this.sbuffer.toString();
                                    return;
                                }
                                this.sbuffer.append(c);
                                ++this._pos;
                                c = this._input[this._pos];
                            }
                        } else {
                            if (c == ' ') continue;
                            break;
                        }
                        ++this._pos;
                    }
                    if (this._status == 1) {
                        --this._depth;
                    }
                    ++this._depth;
                    this._status = 0;
                    break;
                }
                if (c == '/') {
                    this._status = 1;
                    ++this._pos;
                    return;
                }
                ++this._pos;
                c = this._input[this._pos];
            }
            this._betweenTags = false;
            this.sbuffer.setLength(0);
            c = this._input[this._pos];
            while (this._pos < this._length && c != '>' && c != ' ') {
                if (c == '/' && this._input[this._pos + 1] == '>') {
                    ++this._pos;
                    this.initAttributes();
                    this._currentTag = this.sbuffer.toString();
                    this._currentText = "";
                    this.sbuffer.setLength(0);
                    this._status = 1;
                    this._betweenTags = false;
                    return;
                }
                this.sbuffer.append(c);
                ++this._pos;
                c = this._input[this._pos];
            }
            this._currentTag = this.sbuffer.toString();
            this.sbuffer.setLength(0);
            this.initAttributes();
            if (c == ' ') {
                ++this._pos;
                while (this._pos < this._length) {
                    c = this._input[this._pos];
                    if (c == '/') {
                        int n = this._pos + 1;
                        char c2 = this._input[n];
                        while (n < this._length) {
                            if (c2 == '>') {
                                this._currentText = "";
                                return;
                            }
                            if (c2 == ' ') {
                                c2 = this._input[++n];
                                continue;
                            }
                            break;
                        }
                    } else if (c == '>') break;
                    this.appendToAttributes(c);
                    ++this._pos;
                }
            }
            this.sbuffer.setLength(0);
            if (c == '>') {
                ++this._pos;
                c = this._input[this._pos];
                while (this._pos < this._length && c != '<') {
                    this.sbuffer.append(this.decodeByte(c));
                    ++this._pos;
                    c = this._input[this._pos];
                }
            }
            this._currentText = this.sbuffer.toString();
            this._betweenTags = true;
            this._status = 0;
            this._attNames.trimToSize();
            this._attValues.trimToSize();
            return;
        }
        catch (Exception exception) {
            String string = "";
            try {
                string = "Parse xml error, " + exception.getMessage() + "Parsed part (before error): " + new String(this._input, 0, this._pos) + "Parsed part (after error) : ";
                if (this._pos < this._input.length) {
                    string = string + new String(this._input, this._pos, this._input.length - this._pos);
                }
            }
            catch (Exception exception2) {
                // empty catch block
            }
            throw new RuntimeException(string);
        }
    }

    private final void appendToAttributes(char c) {
        if (this._isAttValue) {
            if (c != this._currentAttBracket) {
                c = this.decodeByte(c);
                this.sbuffer.append(c);
            } else {
                this._isAttKey = true;
                this._isAttValue = false;
                String string = this.sbuffer.toString().trim();
                this._attValues.addElement(string);
                this.sbuffer.setLength(0);
            }
        } else if (this._isAttKey) {
            if (c != '=') {
                this.sbuffer.append(c);
            } else {
                this._isAttEqual = true;
                this._isAttKey = false;
                String string = this.sbuffer.toString().trim();
                this._attNames.addElement(string);
                this.sbuffer.setLength(0);
            }
        } else if (this._isAttEqual && c != ' ') {
            this._isAttValue = true;
            this._isAttEqual = false;
            if (c == '\'' || c == '\"') {
                this._currentAttBracket = c;
            }
        }
    }

    private final void initAttributes() {
        this.sbuffer2.setLength(0);
        this._attNames.removeAllElements();
        this._attValues.removeAllElements();
        this._isAttEqual = false;
        this._isAttKey = true;
        this._isAttValue = false;
        this._currentAttBracket = (char)39;
    }

    private final char decodeByte(char c) {
        char c2;
        char c3 = c2 = c >= '\u0000' ? c : (char)(256 + c);
        if (c2 != '&') {
            return c2;
        }
        this.sbuffer2.setLength(0);
        int n = this._pos++;
        c2 = this._input[this._pos];
        while (';' != c2 && '\"' != c2 && '\'' != c2) {
            this.sbuffer2.append(c2);
            ++this._pos;
            c2 = this._input[this._pos];
        }
        if (c2 == '\"' || c2 == '\'') {
            this._pos = n;
            return this._input[n];
        }
        String string = this.sbuffer2.toString();
        if (this.sbuffer2.charAt(0) == '#') {
            return string.length() > 1 ? (char)Integer.parseInt(string.substring(1)) : c2;
        }
        if ("lt".equals(string)) {
            return '<';
        }
        if ("gt".equals(string)) {
            return '>';
        }
        if ("amp".equals(string)) {
            return '&';
        }
        if ("quot".equals(string)) {
            return '\"';
        }
        if ("apos".equals(string)) {
            return '\'';
        }
        return c2;
    }

    public final short getTag() {
        try {
            Short s = (Short)tags.get(this._currentTag);
            return s;
        }
        catch (NullPointerException nullPointerException) {
            return 0;
        }
    }

    public static final Vector tokenise(String string, char c) {
        Vector<String> vector = new Vector<String>(5, 2);
        int n = 0;
        while ((n = string.indexOf(c)) != -1) {
            String string2 = string.substring(0, n);
            string = string.substring(n + 1);
            vector.addElement(string2);
        }
        vector.addElement(string);
        vector.trimToSize();
        return vector;
    }

    static {
        tags.put("page", new Short(1));
        tags.put("image", new Short(2));
        tags.put("label", new Short(3));
        tags.put("input", new Short(4));
        tags.put("softkey", new Short(5));
        tags.put("sound", new Short(6));
        tags.put("video", new Short(7));
        tags.put("progressbar", new Short(8));
        tags.put("scrollindicator", new Short(9));
        tags.put("timer", new Short(10));
        tags.put("list", new Short(11));
        tags.put("listitem", new Short(12));
        tags.put("grid", new Short(13));
        tags.put("griditem", new Short(14));
        tags.put("ticker", new Short(15));
        tags.put("checkbox", new Short(16));
        tags.put("radiobuttons", new Short(17));
        tags.put("radiobutton", new Short(18));
        tags.put("container", new Short(19));
        tags.put("button", new Short(20));
        tags.put("banner", new Short(23));
    }
}

