/*
 * Decompiled with CFR 0.152.
 */
package com.gravitymobile.logger;

import com.gravitymobile.logger.Logger;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;
import javax.microedition.io.Connector;
import javax.microedition.io.HttpConnection;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import tagit.TAGit;

public abstract class LoggerCanvas
extends Canvas {
    public static final int LSK = -6;
    public static final int MSK = -5;
    public static final int RSK = -7;
    public static final int CLEAR = -8;
    public static final int LG_CLEAR = -16;
    public static final int NOKIA_CLEAR = 48;
    public static final int SIEMENS_LSK = -1;
    public static final int SIEMENS_RSK = -4;
    public static final int MOTOROLA_LSK = -21;
    public static final int MOTOROLA_RSK = -22;
    protected static boolean logToRMS = true;
    protected static boolean isPublic = true;
    protected static boolean isWritable = true;
    protected static String recordName = "logger";
    protected static String vendorName = null;
    protected static String suiteName = null;
    protected Vector lines = null;
    protected int lineScrollX = 0;
    protected int lineScrollY = 0;
    protected int lineScrollStep = 20;
    protected int lineSpacing = 2;
    protected int visibleLines = 0;
    protected int screenHeight = 0;
    protected int fontHeight = 0;
    protected int backgroundColor = 0;
    protected int infoTextColor = 0xFFFFFF;
    protected int errorTextColor = 255;
    protected int scrollbarColor = 0xFFFFFF;
    protected int traceTextColor = 65280;

    public LoggerCanvas() {
        if (!TAGit.callFullScreenOnlyOnce) {
            this.setFullScreenMode(true);
        }
    }

    public abstract void returnToMIDlet();

    public void setBackgroundColor(int r, int g, int b) {
        this.backgroundColor = (r << 16) + (g << 8) + b;
    }

    public void setInfoTextColor(int r, int g, int b) {
        this.infoTextColor = (r << 16) + (g << 8) + b;
    }

    public void setErrorTextColor(int r, int g, int b) {
        this.errorTextColor = (r << 16) + (g << 8) + b;
    }

    public void setScrollbarColor(int r, int g, int b) {
        this.scrollbarColor = (r << 16) + (g << 8) + b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int uploadToURL(String url) {
        HttpConnection con = null;
        InputStream in = null;
        OutputStream out = null;
        ByteArrayOutputStream bos = null;
        Object sin = null;
        bos = new ByteArrayOutputStream();
        int responseCode = -1;
        Vector logLines = Logger.loadLogFromRMS();
        if (Logger.isDebug()) {
            System.out.print("\nURL:\n" + url);
            TAGit.sendToConsole("\nRequest:\n--------------");
            TAGit.sendToConsole(bos.toString());
        }
        byte[] request = bos.toByteArray();
        int messageLength = request.length;
        try {
            con = (HttpConnection)Connector.open((String)url, (int)3);
            con.setRequestMethod("POST");
            con.setRequestProperty("Content-Length", Integer.toString(messageLength));
            con.setRequestProperty("Content-Type", "text");
            out = con.openOutputStream();
            out.write(request);
            responseCode = con.getResponseCode();
            if (responseCode != 200) {
                int n = responseCode;
                return n;
            }
            in = con.openInputStream();
            bos = new ByteArrayOutputStream();
            int b = in.read();
            while (b != -1) {
                bos.write(b);
                b = in.read();
            }
        }
        catch (Exception e) {
            TAGit.sendToConsole("Oops. Failed to upload logfile!");
            TAGit.sendToConsole(e.getMessage());
            e.printStackTrace();
        }
        finally {
            try {
                if (con != null) {
                    con.close();
                }
                if (in != null) {
                    in.close();
                }
                if (out != null) {
                    out.close();
                }
            }
            catch (Exception e) {
                Logger.info("Error while cleaning up network connections:", e);
            }
        }
        byte[] bytes = bos.toByteArray();
        String respString = new String(bytes);
        if (Logger.isDebug()) {
            TAGit.sendToConsole("-----------------");
            TAGit.sendToConsole(respString);
        }
        return responseCode;
    }

    public void showNotify() {
        this.lines = Logger.loadLogFromRMS();
        if (this.lines == null || this.lines.size() == 0) {
            return;
        }
        this.screenHeight = this.getHeight();
        this.fontHeight = TAGit.font.getHeight();
        this.visibleLines = this.screenHeight / (this.fontHeight + this.lineSpacing);
        this.lineScrollY = this.lines.size() - this.visibleLines;
    }

    public void hideNotify() {
        this.lines = null;
    }

    public void paint(Graphics g) {
        if (!TAGit.callFullScreenOnlyOnce) {
            this.setFullScreenMode(true);
        }
        int x = 0;
        int y = 0;
        g.setFont(Font.getFont((int)32, (int)0, (int)8));
        g.setColor(this.backgroundColor);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (this.lines == null || this.lines.size() == 0) {
            g.setColor(this.infoTextColor);
            g.drawString("No log. Press CLR/BACK.", 3, 3, 20);
            return;
        }
        for (int i = 0; i < this.lines.size(); ++i) {
            String line;
            if (i < this.lineScrollY || (line = (String)this.lines.elementAt(i)) == null) continue;
            if (line.startsWith("ERROR")) {
                g.setColor(this.errorTextColor);
            } else if (line.startsWith("TRACE")) {
                g.setColor(this.traceTextColor);
            } else {
                g.setColor(this.infoTextColor);
            }
            line = "" + i + " " + line;
            g.drawString(line, x - this.lineScrollX, y, 20);
            if ((y += this.fontHeight + this.lineSpacing) > this.screenHeight) break;
        }
        if (this.visibleLines >= this.lines.size()) {
            return;
        }
        g.setColor(this.backgroundColor);
        g.fillRect(this.getWidth() - 4, 0, 4, this.getHeight());
        int barHPct = this.visibleLines * 100 / this.lines.size();
        int barYPct = this.lineScrollY * (100 - barHPct) / (this.lines.size() - this.visibleLines);
        int barY = barYPct * this.getHeight() / 100;
        int barH = barHPct * this.getHeight() / 100;
        g.setColor(this.scrollbarColor);
        g.fillRect(this.getWidth() - 3, barY, 3, barH);
    }

    protected void pointerPressed(int x, int y) {
        this.returnToMIDlet();
    }

    protected void keyPressed(int keyCode) {
        int action = this.getGameAction(keyCode);
        int nLines = this.lines == null ? 0 : this.lines.size();
        switch (action) {
            case 1: {
                if (nLines > this.visibleLines) {
                    if (this.lineScrollY == 0) {
                        this.lineScrollY = nLines - this.visibleLines;
                    } else if (this.lineScrollY > 0) {
                        --this.lineScrollY;
                    }
                }
                this.repaint();
                return;
            }
            case 6: {
                if (nLines > this.visibleLines) {
                    this.lineScrollY = this.lineScrollY >= nLines - this.visibleLines ? 0 : ++this.lineScrollY;
                }
                this.repaint();
                return;
            }
            case 2: {
                if (this.lineScrollX > 0) {
                    this.lineScrollX -= this.lineScrollStep;
                    if (this.lineScrollX < 0) {
                        this.lineScrollX = 0;
                    }
                }
                this.repaint();
                return;
            }
            case 5: {
                this.lineScrollX += this.lineScrollStep;
                this.repaint();
                return;
            }
            case 8: {
                this.lineScrollX = 0;
                this.repaint();
                return;
            }
            case 57: {
                keyCode = -8;
            }
        }
        switch (keyCode) {
            case -19: 
            case -16: 
            case -8: 
            case 48: 
            case 51: {
                this.returnToMIDlet();
                break;
            }
            case 42: {
                this.lines = null;
                this.showNotify();
                this.repaint();
                break;
            }
            case 35: {
                this.lineScrollX = 0;
                Logger.clearLogFromRMS();
                this.lines = null;
                this.repaint();
                break;
            }
            case -21: 
            case -6: 
            case -1: {
                break;
            }
            case -22: 
            case -7: 
            case -4: {
                break;
            }
        }
    }

    protected void keyReleased(int keyCode) {
    }

    protected void keyRepeated(int keyCode) {
        this.keyPressed(keyCode);
        this.keyPressed(keyCode);
        this.keyPressed(keyCode);
    }
}

