/*
 * Decompiled with CFR 0.152.
 */
package tagit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.microedition.io.Connector;
import javax.microedition.io.HttpConnection;
import javax.microedition.rms.RecordStore;
import tagit.ResourceText;
import tagit.TAGit;
import tagit.Tag;

public class AudioSubmission
implements Runnable {
    private static final int RESOURCE_CHUNK_SIZE = 512;
    private static final boolean CHECK_SUBSCRIPTION = true;
    private static final boolean CHECK_MEDIA_TYPES = true;
    private static final boolean CHECK_FULL_SONG = true;
    private static final boolean CHECK_SMS = true;
    private byte[] recResource;
    private String serviceID2 = "69";
    private String ownerIdentifier;
    private String subscription = null;
    private int analysisState;
    private Thread th;
    private TAGit midlet;
    private Tag recTag;

    public AudioSubmission(TAGit midlet) {
        try {
            this.midlet = midlet;
            this.ownerIdentifier = midlet.getOwnerIdentifier();
            this.serviceID2 = new Integer(midlet.getHandsetID()).toString();
        }
        catch (Exception e) {
            TAGit.IMerror("audiosubmission.audiosubmission: " + e.toString());
        }
    }

    public void start(byte[] resourceName) {
        try {
            if (resourceName == null) {
                TAGit.IMerror("resourceName is null");
            }
            this.recResource = resourceName;
            this.th = new Thread(this);
            this.setState(0);
            this.th.start();
        }
        catch (Exception e) {
            TAGit.IMerror("audiosubmission.start: " + e.toString());
        }
    }

    public void stop() {
        try {
            this.th = null;
            this.recResource = null;
        }
        catch (Exception e) {
            TAGit.IMerror("audiosubmission.stop: " + e.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            AudioSubmission audioSubmission = this;
            synchronized (audioSubmission) {
                this.recTag = this.doUserRecognition(this.recResource);
            }
        }
        catch (Exception e) {
            TAGit.IMerror("audiosubmission.run: " + e.toString());
        }
    }

    public Tag getTag() {
        return this.recTag;
    }

    public Tag doUserRecognition(byte[] resourceName) {
        block5: {
            try {
                if (!this.midlet.isRFormStillRunning()) break block5;
                String userURL = null;
                Tag response = null;
                try {
                    userURL = TAGit.recognitionURL + "?id=" + this.serviceID2 + "&ownerIdentifier=" + this.ownerIdentifier + "&ph=3334445555";
                    String preloadID = this.checkPreloadID();
                    if (preloadID != "") {
                        userURL = userURL + "&preload=" + preloadID;
                    }
                    TAGit.IMinfo("post URL: " + userURL);
                    this.setState(4);
                    response = this.postDocument(userURL, resourceName);
                    this.setState(5);
                }
                catch (Exception e) {
                    TAGit.IMerror("douserrcognition: " + e.toString());
                }
                return response;
            }
            catch (Exception e) {
                TAGit.IMerror("audiosubmission.douserrecognition: " + e.toString());
                return null;
            }
        }
        return null;
    }

    public void setState(int state) {
        try {
            this.analysisState = state;
        }
        catch (Exception e) {
            TAGit.IMerror("audiosubmission.setstate: " + e.toString());
        }
    }

    public int getState() {
        return this.analysisState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Tag postDocument(String url, byte[] resName) {
        try {
            int err = 0;
            HttpConnection httpconn = null;
            byte[] buffer = new byte[512];
            OutputStream oStream = null;
            ByteArrayInputStream is = null;
            try {
                int bytesRead;
                if (!this.midlet.isRFormStillRunning()) return this.readResponse(httpconn);
                is = new ByteArrayInputStream(resName);
                err = 1;
                httpconn = (HttpConnection)Connector.open((String)url);
                err = 2;
                httpconn.setRequestMethod("POST");
                err = 3;
                oStream = httpconn.openOutputStream();
                err = 4;
                httpconn.setRequestProperty("Content-type", "application/octet-stream");
                err = 5;
                while ((bytesRead = is.read(buffer)) != -1) {
                    oStream.write(buffer, 0, bytesRead);
                }
                err = 6;
                return this.readResponse(httpconn);
            }
            catch (Exception e) {
                TAGit.IMerror("postdocument: " + err + "   " + e.toString());
                this.setState(6);
                Tag tag = null;
                return tag;
            }
            finally {
                try {
                    if (oStream != null) {
                        oStream.close();
                    }
                    if (is != null) {
                        is.close();
                    }
                    buffer = null;
                }
                catch (Exception e4) {}
            }
        }
        catch (Exception e3) {
            TAGit.IMerror("audiosubmission.postdocument: " + e3.toString());
            return null;
        }
    }

    private String checkPreloadID() {
        try {
            RecordStore preloadStore = RecordStore.openRecordStore((String)"preload", (boolean)false);
            byte[] preloadIDbytes = preloadStore.getRecord(1);
            preloadStore.closeRecordStore();
            String preloadID = "";
            for (int x = 0; x < preloadIDbytes.length; ++x) {
                preloadID = preloadID + (char)preloadIDbytes[x];
            }
            return preloadID;
        }
        catch (Exception e) {
            TAGit.IMinfo("audiosubmission.checkpreloadid: " + e.toString());
            return "";
        }
    }

    public Tag parseXMLResults(String retString) {
        try {
            TAGit.IMinfo("XML response: " + retString);
            Tag audioTag = null;
            String album = null;
            String artist = null;
            String track = null;
            String wallpaperURL = null;
            String ringerURL = null;
            String recommendURL = null;
            String smsMessage = null;
            String fullSongURL = null;
            try {
                String albumStr = "<ALBUM>";
                String albumEndStr = "</ALBUM>";
                String artistStr = "<ARTIST>";
                String artistEndStr = "</ARTIST>";
                String trackStr = "<TRACK_TITLE>";
                String trackEndStr = "</TRACK_TITLE>";
                String albumArtStr = "<ALBUM_ART>";
                String albumArtEndStr = "</ALBUM_ART>";
                String subscribeStr = "<SUBSCRIPTION>";
                String subscribeEndStr = "</SUBSCRIPTION>";
                String wallpaperMediaStr = "<WALLPAPER>";
                String wallpaperMediaEndStr = "</WALLPAPER>";
                String ringerMediaStr = "<RINGER>";
                String ringerMediaEndStr = "</RINGER>";
                String smsStr = "<SMS_MESSAGE>";
                String smsEndStr = "</SMS_MESSAGE>";
                String recommendMediaStr = "<RECOMMEND>";
                String recommendMediaEndStr = "</RECOMMEND>";
                String fullSongStr = "<FULL_SONG>";
                String fullSongEndStr = "</FULL_SONG>";
                int firstTag = retString.indexOf(albumStr);
                int lastTag = retString.indexOf(albumEndStr);
                if (firstTag != -1 && lastTag != -1) {
                    album = retString.substring(firstTag + albumStr.length(), lastTag);
                    TAGit.IMinfo("album = " + album);
                }
                firstTag = retString.indexOf(artistStr);
                lastTag = retString.indexOf(artistEndStr);
                if (firstTag != -1 && lastTag != -1) {
                    artist = retString.substring(firstTag + artistStr.length(), lastTag);
                    TAGit.IMinfo("artist = " + artist);
                }
                firstTag = retString.indexOf(trackStr);
                lastTag = retString.indexOf(trackEndStr);
                if (firstTag != -1 && lastTag != -1) {
                    track = retString.substring(firstTag + trackStr.length(), lastTag);
                    TAGit.IMinfo("track = " + track);
                }
                audioTag = new Tag(album, artist, track);
                firstTag = retString.indexOf(albumArtStr);
                lastTag = retString.indexOf(albumArtEndStr);
                if (firstTag != -1 && lastTag != -1) {
                    String albumImageURL = retString.substring(firstTag + albumArtStr.length(), lastTag);
                    audioTag.setAlbumImageURL(albumImageURL);
                    TAGit.IMinfo("album art = " + albumImageURL);
                }
                firstTag = retString.indexOf(subscribeStr);
                lastTag = retString.indexOf(subscribeEndStr);
                if (firstTag != -1 && lastTag != -1) {
                    this.subscription = retString.substring(firstTag + subscribeStr.length(), lastTag);
                    TAGit.IMinfo("sub url = " + this.subscription + " = expired");
                    audioTag.setSubscriptionURL(this.subscription);
                    audioTag.setCurrentSubscription(ResourceText.EXPIRED_SUBSCRIPTION);
                } else {
                    TAGit.IMinfo("subscription is valid");
                    audioTag.setCurrentSubscription(ResourceText.VALID_SUBSCRIPTION);
                }
                firstTag = retString.indexOf(wallpaperMediaStr);
                lastTag = retString.indexOf(wallpaperMediaEndStr);
                if (firstTag != -1 && lastTag != -1) {
                    wallpaperURL = retString.substring(firstTag + wallpaperMediaStr.length(), lastTag);
                    TAGit.IMinfo("wallpaper = " + wallpaperURL);
                    if (wallpaperURL.compareTo("null") == 0) {
                        wallpaperURL = null;
                    }
                    audioTag.setWallpaperURL(wallpaperURL);
                }
                firstTag = retString.indexOf(ringerMediaStr);
                lastTag = retString.indexOf(ringerMediaEndStr);
                if (firstTag != -1 && lastTag != -1) {
                    ringerURL = retString.substring(firstTag + ringerMediaStr.length(), lastTag);
                    TAGit.IMinfo("ringer = " + ringerURL);
                    if (ringerURL.compareTo("null") == 0) {
                        ringerURL = null;
                    }
                    audioTag.setRingerURL(ringerURL);
                }
                firstTag = retString.indexOf(recommendMediaStr);
                lastTag = retString.indexOf(recommendMediaEndStr);
                if (firstTag != -1 && lastTag != -1) {
                    recommendURL = retString.substring(firstTag + recommendMediaStr.length(), lastTag);
                    TAGit.IMinfo("idPicks = " + recommendURL);
                    if (recommendURL.compareTo("null") == 0) {
                        recommendURL = null;
                    }
                    audioTag.setRecommendedURL(recommendURL);
                }
                firstTag = retString.indexOf(fullSongStr);
                lastTag = retString.indexOf(fullSongEndStr);
                if (firstTag != -1 && lastTag != -1) {
                    fullSongURL = retString.substring(firstTag + fullSongStr.length(), lastTag);
                    TAGit.IMinfo("fullsong = " + fullSongURL);
                }
                if (fullSongURL == null || fullSongURL.compareTo("null") == 0) {
                    fullSongURL = null;
                }
                audioTag.setFullSongURL(fullSongURL);
                firstTag = retString.indexOf(smsStr);
                lastTag = retString.indexOf(smsEndStr);
                if (firstTag != -1 && lastTag != -1) {
                    smsMessage = retString.substring(firstTag + smsStr.length(), lastTag);
                    TAGit.IMinfo("sms = " + smsMessage);
                    if (smsMessage.compareTo("null") == 0) {
                        smsMessage = null;
                    }
                    audioTag.setSMSMessage(smsMessage);
                }
                this.setState(5);
            }
            catch (Exception e) {
                TAGit.IMerror("ANALYZING EXCEPTION: " + e.toString());
                this.setState(6);
            }
            if (this.getState() == 6) {
                return null;
            }
            return audioTag;
        }
        catch (Exception e) {
            TAGit.IMerror("audiosubmission.parseXMLResults: " + e.toString());
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Tag readResponse(HttpConnection httpconn) {
        try {
            if (!this.midlet.isRFormStillRunning()) return null;
            String retString = "";
            InputStream is = null;
            byte[] httpbuff = new byte[1024];
            try {
                int rc = httpconn.getResponseCode();
                if (rc != 200) {
                    throw new IOException("HTTP response code: " + rc);
                }
                String preloadID = httpconn.getHeaderField("preload-id");
                TAGit.IMinfo("preload = " + preloadID);
                String daysValid = httpconn.getHeaderField("days-valid");
                TAGit.IMinfo("days = " + daysValid);
                String subscribeURL = httpconn.getHeaderField("sub-url");
                TAGit.IMinfo("subscribe = " + subscribeURL);
                if (preloadID != null && !this.storePreloadID(preloadID, daysValid, subscribeURL)) {
                    TAGit.IMerror("preloadID not stored");
                    this.setState(6);
                    Tag tag = null;
                    return tag;
                }
                is = httpconn.openInputStream();
                if (!this.midlet.LGWorkaround(this)) {
                    int bytes_read = 0;
                    while ((bytes_read = is.read(httpbuff)) != -1) {
                        retString = retString + new String(httpbuff, 0, bytes_read);
                    }
                } else {
                    while (is.available() > 0) {
                        retString = retString + (char)is.read();
                    }
                }
                TAGit.IMinfo("return string = " + retString);
            }
            catch (Exception e) {
                TAGit.IMerror("readResponse: exception: " + e.toString());
                this.setState(6);
            }
            finally {
                try {
                    if (is != null) {
                        is.close();
                    }
                    if (httpconn != null) {
                        httpconn.close();
                    }
                    httpbuff = null;
                }
                catch (Exception e) {}
            }
            if (this.getState() == 6) {
                return null;
            }
            TAGit.IMinfo("about to parse: " + retString);
            return this.parseXMLResults(retString);
        }
        catch (Exception e) {
            TAGit.IMerror("audiosubmission.readresponse: " + e.toString());
            return null;
        }
    }

    private boolean storePreloadID(String preloadID, String daysValidStr, String subURL) {
        try {
            long daysLeft;
            try {
                daysLeft = Integer.parseInt(daysValidStr);
            }
            catch (Exception e) {
                daysLeft = 7L;
            }
            try {
                RecordStore preloadStore = RecordStore.openRecordStore((String)"preload", (boolean)true);
                byte[] preloadIDbytes = preloadID.getBytes();
                preloadStore.addRecord(preloadIDbytes, 0, preloadIDbytes.length);
                long expDate = System.currentTimeMillis() + daysLeft * 86400000L;
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                DataOutputStream dos = new DataOutputStream(baos);
                dos.writeLong(expDate);
                dos.close();
                byte[] dateOut = baos.toByteArray();
                preloadStore.addRecord(dateOut, 0, dateOut.length);
                byte[] subscribeURLBytes = subURL.getBytes();
                preloadStore.addRecord(subscribeURLBytes, 0, subscribeURLBytes.length);
                preloadStore.closeRecordStore();
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }
        catch (Exception e) {
            TAGit.IMerror("audiosubmission.storepreloadid: " + e.toString());
            return false;
        }
    }

    public static interface States {
        public static final int PREPARING = 0;
        public static final int RECORDING = 1;
        public static final int RECORDING_COMPLETED = 2;
        public static final int RECORDING_EXCEPTION = 3;
        public static final int ANALYZING = 4;
        public static final int ANALYSIS_COMPLETE = 5;
        public static final int ANALYSIS_EXCEPTION = 6;
    }
}

