/*
 * Decompiled with CFR 0.152.
 */
package tagit;

import java.util.Vector;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import tagit.Keys;
import tagit.ResourceName;
import tagit.ResourceText;
import tagit.TAGit;
import tagit.TouchScreenSoftKey;

public class HelpScreen
extends Canvas {
    TAGit midlet;
    private static Image header;
    private static String text;
    private static int TEXT_START;
    private static int TEXT_BORDER;
    private static int selection;
    private static Vector lines;
    private static final int ALT_FOOTER_H;
    private static int footerHeight;
    private static boolean textOverLap;
    private static final int FONT_H;
    private static int BODY_H;
    private static int screenNumber;
    private static int numberOfScreens;
    private static int linesPerScreen;
    public static final int UP = -1;
    public static final int DOWN = -2;
    public static final int LEFT = -3;
    public static final int RIGHT = -4;
    public static final int FIRE = -5;
    private static boolean initted;
    private final int flippedFooterHeight = TAGit.font.getHeight() + 4;
    private TouchScreenSoftKey lsk;
    private TouchScreenSoftKey rsk;

    public HelpScreen(TAGit midlet, int selection) {
        try {
            this.midlet = midlet;
            HelpScreen.selection = selection;
            this.init();
            this.setFullScreenMode(true);
        }
        catch (Exception e) {
            TAGit.IMerror("helpscreen.helpscreen: " + e.toString());
        }
    }

    public void setSelectionTo(int s) {
        selection = s;
        initted = false;
        this.clearOldSetup();
        this.repaint();
    }

    public void sizeChanged(int x, int y) {
        try {
            initted = false;
            this.midlet.sizeChanged(x, y);
            this.clearOldSetup();
            this.repaint();
        }
        catch (Exception e) {
            TAGit.IMerror("helpscreen.sizechanged: " + e.toString());
        }
    }

    private void clearOldSetup() {
        try {
            lines = null;
            header = null;
            this.rsk = null;
            this.lsk = null;
            text = "";
            System.gc();
        }
        catch (Exception e) {
            TAGit.IMerror("helpscreen.clearoldsetup: " + e.toString());
        }
    }

    public void pointerPressed(int x, int y) {
        this.midlet.vibrateForPointerPressed();
        if (this.lsk.selectThisButton(x, y)) {
            this.goBack();
        } else {
            this.down();
        }
    }

    private void init() {
        try {
            lines = new Vector();
            header = TAGit.createImage(ResourceName.MAINMENU_HEADER_IMAGE);
            TEXT_BORDER = TAGit.font.stringWidth("   ");
            TEXT_START = header.getHeight() + TEXT_BORDER;
            footerHeight = this.flippedFooterHeight;
            this.lsk = new TouchScreenSoftKey("Back", false);
            this.rsk = new TouchScreenSoftKey("", true);
            switch (selection) {
                case 0: {
                    text = ResourceText.HELP_OPTION1_DETAILTEXT;
                    break;
                }
                case 1: {
                    text = ResourceText.HELP_OPTION2_DETAILTEXT;
                    break;
                }
                case 2: {
                    text = TAGit.compact ? ResourceText.COMPACT_HELP_OPTION3_DETAILTEXT : ResourceText.HELP_OPTION3_DETAILTEXT;
                }
            }
        }
        catch (Exception e) {
            TAGit.IMerror("helpscreen.init: " + e.toString());
        }
        initted = true;
        if (System.getProperty("microedition.platform").toString().equals("SunMicrosystems_wtk")) {
            text = text + text + text + text + text;
        }
    }

    public void paint(Graphics g) {
        try {
            g.setFont(TAGit.font);
            this.midlet.updateMemStatus();
            if (!initted) {
                this.init();
            }
            TAGit.paintEmulatorExtras(g);
            TAGit.IMinfo("screenheight = " + TAGit.globalScreenHeight + ":helpscreen.paint");
            g.setColor(255, 255, 255);
            g.fillRect(0, 0, TAGit.globalScreenWidth, TAGit.globalScreenHeight);
            if (header != null) {
                g.drawImage(header, 0, 0, 20);
            }
            switch (selection) {
                case 0: 
                case 1: 
                case 2: {
                    this.sortTextLines();
                    this.displayTextLines(g);
                    break;
                }
                case 3: {
                    this.showAboutScreen(g);
                }
            }
            if (textOverLap) {
                this.rsk.updateLabel("Down");
            } else {
                this.rsk.updateLabel("");
            }
            this.lsk.draw(g);
            this.rsk.draw(g);
        }
        catch (Exception e) {
            this.midlet.IMerror("helpscreen.paint: " + e.toString(), (Displayable)this);
        }
        TAGit.drawPreReleaseBanner(g);
    }

    private void displayTextLines(Graphics g) {
        try {
            int c = 0;
            g.setColor(0);
            int displayLineCounter = 0;
            int x = 0;
            int y = 0;
            for (c = this.getFirstLine(); c < lines.size() && displayLineCounter < linesPerScreen; ++displayLineCounter, ++c) {
                x = (TAGit.globalScreenWidth - TAGit.font.stringWidth((String)lines.elementAt(c))) / 2;
                y = TEXT_START - TEXT_BORDER / 2 + TAGit.font.getHeight() * displayLineCounter;
                g.drawString((String)lines.elementAt(c), x, y, 20);
            }
        }
        catch (Exception e) {
            TAGit.IMerror("helpscreen.displaytextlines: " + e.toString());
        }
    }

    private int getFirstLine() {
        return linesPerScreen * screenNumber;
    }

    private void sortTextLines() {
        if (lines.size() > 0) {
            lines.removeAllElements();
        }
        int err = 0;
        int p1 = 0;
        int p2 = 0;
        int MAX_TEXT_WIDTH = TAGit.globalScreenWidth - 2 * TEXT_BORDER;
        int MAX_CHARS = MAX_TEXT_WIDTH / TAGit.font.stringWidth("0");
        try {
            p2 = text.lastIndexOf(32, MAX_CHARS);
            int LENGTH_OF_TEXT = text.length();
            int placeholder = 0;
            while (p2 < LENGTH_OF_TEXT && p2 != -1 && p1 != p2) {
                String sub = text.substring(p1, p2);
                if (TAGit.font.stringWidth(sub) < MAX_TEXT_WIDTH) {
                    placeholder = p2;
                    p2 = text.indexOf(" ", p2 + 1);
                    continue;
                }
                p2 = placeholder;
                lines.addElement(text.substring(p1, p2 + 1).trim());
                p1 = p2;
                p2 = text.lastIndexOf(32, p1 + MAX_CHARS);
            }
            if (text.substring(p1, text.length()).length() < MAX_TEXT_WIDTH) {
                p2 = text.lastIndexOf(32, p1 + text.length() - 5);
                lines.addElement(text.substring(p1, p2).trim());
                p1 = p2 + 1;
            }
            err = 1;
            lines.addElement(text.substring(p1, text.length()).trim());
            err = 2;
            linesPerScreen = lines.size();
            err = 3;
            BODY_H = TAGit.globalScreenHeight - header.getHeight() - footerHeight - TEXT_BORDER / 3;
            err = 4;
            if (FONT_H * linesPerScreen > BODY_H) {
                err = 7;
                linesPerScreen = BODY_H / FONT_H;
                err = 8;
                numberOfScreens = lines.size() / linesPerScreen;
                if (numberOfScreens < 1) {
                    numberOfScreens = 1;
                } else if (numberOfScreens >= 1 && lines.size() % linesPerScreen > 1) {
                    ++numberOfScreens;
                }
                if (numberOfScreens > 1) {
                    textOverLap = true;
                }
                err = 9;
            }
            err = 10;
        }
        catch (Exception e) {
            TAGit.IMerror("helpscreen.sorttextlines: :" + p2 + ":" + err + e.toString());
        }
    }

    private void showAboutScreen(Graphics g) {
        try {
            if (TAGit.compact) {
                this.showCompactAboutScreen(g);
                return;
            }
            g.setColor(0);
            String line = "MusicID";
            int line_x = (TAGit.globalScreenWidth - TAGit.font.stringWidth(line)) / 2;
            g.drawString(line, line_x, TEXT_START, 20);
            line = "Version " + this.midlet.getProperty("MIDlet-Version");
            line_x = (TAGit.globalScreenWidth - TAGit.font.stringWidth(line)) / 2;
            g.drawString(line, line_x, FONT_H + TEXT_START, 20);
            line = this.stringCropper(System.getProperty("microedition.platform")) + " (" + this.midlet.getHandsetID() + ")";
            line_x = (TAGit.globalScreenWidth - TAGit.font.stringWidth(line)) / 2;
            g.drawString(line, line_x, 2 * FONT_H + TEXT_START, 20);
            line = "Shazam";
            line_x = (TAGit.globalScreenWidth - TAGit.font.stringWidth(line)) / 2;
            g.drawString(line, line_x, 4 * FONT_H + TEXT_START, 20);
            line = "Entertainment";
            line_x = (TAGit.globalScreenWidth - TAGit.font.stringWidth(line)) / 2;
            g.drawString(line, line_x, 5 * FONT_H + TEXT_START, 20);
            line = "Ltd.";
            line_x = (TAGit.globalScreenWidth - TAGit.font.stringWidth(line)) / 2;
            g.drawString(line, line_x, 6 * FONT_H + TEXT_START, 20);
        }
        catch (Exception e) {
            TAGit.IMerror("helpscreen.showaboutscreen: " + e.toString());
        }
    }

    private void showCompactAboutScreen(Graphics g) {
        try {
            g.setColor(0);
            String line = "MusicID " + this.midlet.getProperty("MIDlet-Version");
            int line_x = (TAGit.globalScreenWidth - TAGit.font.stringWidth(line)) / 2;
            g.drawString(line, line_x, TEXT_START, 20);
            line = this.stringCropper(System.getProperty("microedition.platform")) + " (" + this.midlet.getHandsetID() + ")";
            line_x = (TAGit.globalScreenWidth - TAGit.font.stringWidth(line)) / 2;
            g.drawString(line, line_x, FONT_H + TEXT_START, 20);
            line = "";
            line_x = (TAGit.globalScreenWidth - TAGit.font.stringWidth(line)) / 2;
            g.drawString(line, line_x, 2 * FONT_H + TEXT_START, 20);
            line = "Shazam Entertainment";
            line_x = (TAGit.globalScreenWidth - TAGit.font.stringWidth(line)) / 2;
            g.drawString(line, line_x, 3 * FONT_H + TEXT_START, 20);
            line = "Ltd.";
            line_x = (TAGit.globalScreenWidth - TAGit.font.stringWidth(line)) / 2;
            g.drawString(line, line_x, 4 * FONT_H + TEXT_START, 20);
        }
        catch (Exception e) {
            TAGit.IMerror("helpscreen.showcompactaboutscreen: " + e.toString());
        }
    }

    private String stringCropper(String line) {
        try {
            String temp = line.substring(0, line.indexOf("/"));
            return temp;
        }
        catch (Exception e) {
            return line;
        }
    }

    public void keyPressed(int keyCode) {
        try {
            this.midlet.vibrateForKeyPressed();
            if (Keys.isBackKey(keyCode)) {
                this.goBack();
            } else if (this.lsk.keyPressed(keyCode)) {
                this.goBack();
            } else if (this.rsk.keyPressed(keyCode)) {
                this.down();
            }
            if (keyCode == -2) {
                this.down();
            } else if (keyCode == -1) {
                this.up();
            }
            if (keyCode == 53) {
                this.midlet.showLog();
            }
        }
        catch (Exception e) {
            this.midlet.IMerror("helpscreen.keypressed: " + e.toString(), (Displayable)this);
        }
    }

    private void goBack() {
        try {
            this.midlet.display.setCurrent(this.midlet.displayStore.popDisplay("helpscreen.keypressed: "));
            TAGit.IMinfo("should have gone back to help menu");
            text = "";
            TAGit.IMinfo("test is now empty");
            textOverLap = false;
            TAGit.IMinfo("text overlap is set to false");
            screenNumber = 0;
            TAGit.IMinfo("screen number is now zero");
        }
        catch (Exception e) {
            TAGit.IMerror("helpscreen.goback: " + e.toString());
        }
    }

    private void down() {
        try {
            if (textOverLap && ++screenNumber > numberOfScreens - 1) {
                screenNumber = 0;
            }
            this.repaint();
        }
        catch (Exception e) {
            TAGit.IMerror("helpscreen.down: " + e.toString());
        }
    }

    private void up() {
        try {
            if (textOverLap && --screenNumber < 0) {
                screenNumber = numberOfScreens - 1;
            }
            this.repaint();
        }
        catch (Exception e) {
            TAGit.IMerror("helpscreen.up: " + e.toString());
        }
    }

    public void hideNotify() {
        text = "";
    }

    public void showNotify() {
        try {
            this.init();
            if (!TAGit.callFullScreenOnlyOnce) {
                this.setFullScreenMode(true);
            }
            this.repaint();
        }
        catch (Exception e) {
            TAGit.IMerror("helpscreen.shownotify: " + e.toString());
        }
    }

    static {
        text = "";
        footerHeight = ALT_FOOTER_H = TAGit.font.getHeight() * 2;
        textOverLap = false;
        FONT_H = TAGit.font.getHeight();
        screenNumber = 0;
        numberOfScreens = 1;
        initted = false;
    }
}

