/*
 * Decompiled with CFR 0.152.
 */
package tagit;

import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import tagit.Keys;
import tagit.ResourceName;
import tagit.TAGit;
import tagit.Tag;

public class InformationCanvas
extends Canvas {
    protected int screenWidth;
    protected int screenHeight;
    protected boolean scrollable;
    protected boolean launchSubscription;
    private String informationText;
    private TAGit midlet;
    private Tag resultsTag;
    private Image header;
    private Image footer;
    private Image mainImage;
    private boolean border;
    private int outerPanelX;
    private int outerPanelY;
    private int innerPanelX;
    private int innerPanelY;
    private boolean initted = false;

    public InformationCanvas(TAGit midlet) {
        this.midlet = midlet;
        if (!TAGit.callFullScreenOnlyOnce) {
            this.setFullScreenMode(true);
        }
        this.header = null;
        this.footer = null;
        this.informationText = null;
        this.launchSubscription = true;
        this.resultsTag = new Tag(null, null, null);
    }

    protected void keyPressed(int keyCode) {
        this.midlet.vibrateForKeyPressed();
        if (Keys.isLeftSoftKey(keyCode)) {
            this.leftSoftButton();
        } else if (Keys.isRightSoftKey(keyCode)) {
            this.rightSoftButton();
        }
        this.repaint();
    }

    public void setLaunchSubscriptionOnRSK(boolean launch) {
        this.launchSubscription = launch;
    }

    public void leftSoftButton() {
        try {
            this.launchSubscription = true;
            this.midlet.display.setCurrent(this.midlet.displayStore.popDisplay("infocanvas.leftsoftbutton"));
        }
        catch (Exception e) {
            TAGit.IMerror("Exception in leftSoftButton: " + e.toString());
        }
    }

    public void rightSoftButton() {
        try {
            if (this.launchSubscription && this.resultsTag != null) {
                this.midlet.platformRequest(this.resultsTag.getSubscriptionURL());
            }
            InformationCanvas informationCanvas = this;
            informationCanvas.midlet.exitApp();
        }
        catch (Exception e) {
            try {
                this.midlet.platformRequest(ResourceName.SUBSCRIBE_URL);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public boolean isScrollable() {
        return this.scrollable;
    }

    public void setScrollable(boolean scroll) {
        this.scrollable = scroll;
    }

    public void addBorder() {
        this.border = true;
    }

    public void addScrollBar() {
    }

    protected void init() {
        try {
            this.setLayout();
            this.initted = true;
        }
        catch (Exception e) {
            TAGit.IMerror("Error initializing InformationCanvas: " + e.toString());
        }
    }

    public void showNotify() {
        if (!this.initted) {
            this.init();
        }
    }

    public void hideNotify() {
        this.initted = false;
    }

    public void setPanelOffsetX(int ofstx) {
        this.outerPanelX = ofstx;
    }

    public void setPanelOffsetY(int ofsty) {
        this.outerPanelY = ofsty;
    }

    public void setBorderWidth(int brdrw) {
        this.innerPanelY = this.innerPanelX = this.outerPanelX + brdrw;
    }

    public void setLayout() {
        this.screenWidth = this.getWidth();
        this.screenHeight = this.getHeight();
    }

    public void setHeader(Image hdr) {
        try {
            this.header = Image.createImage((Image)hdr);
        }
        catch (Exception e) {
            TAGit.IMerror("Error setting header: " + e.toString());
            this.header = null;
        }
    }

    public void setImage(Image mImage) {
        this.mainImage = mImage != null ? Image.createImage((Image)mImage) : null;
    }

    public void setFooter(Image ftr) {
        try {
            this.footer = Image.createImage((Image)ftr);
        }
        catch (Exception e) {
            TAGit.IMerror("Error setting footer: " + e.toString());
            this.footer = null;
        }
    }

    public void displayText(String stext) {
        this.informationText = stext;
    }

    public void setTag(Tag rTag) {
        this.resultsTag = rTag;
    }

    public void paint(Graphics g) {
        if (!TAGit.callFullScreenOnlyOnce) {
            this.setFullScreenMode(true);
        }
        if (!this.initted) {
            this.init();
        }
        g.setColor(255, 255, 255);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (this.header != null) {
            g.drawImage(this.header, 0, 0, 20);
        }
        if (this.mainImage != null) {
            if (this.header == null) {
                g.drawImage(this.mainImage, 0, 0, 20);
            } else {
                g.drawImage(this.mainImage, 0, this.header.getHeight(), 20);
            }
        }
        if (this.border) {
            g.setColor(255, 0, 0);
            g.fillRoundRect(this.outerPanelX, this.outerPanelY + this.header.getHeight(), this.screenWidth - 2 * this.outerPanelX, this.screenHeight - this.header.getHeight() - 2 * this.outerPanelY, 20, 20);
            g.setColor(255, 255, 255);
            g.fillRoundRect(this.innerPanelX, this.innerPanelY + this.header.getHeight(), this.screenWidth - 2 * this.innerPanelX, this.screenHeight - this.header.getHeight() - 2 * this.innerPanelY, 20, 20);
        }
        g.setColor(0, 0, 0);
        if (this.informationText != null) {
            g.drawString(this.informationText, this.innerPanelX + 10, this.innerPanelY + this.header.getHeight() + 10, 20);
        }
        if (this.footer != null) {
            g.drawImage(this.footer, 0, this.getHeight() - this.footer.getHeight(), 20);
        }
        TAGit.drawPreReleaseBanner(g);
    }
}

