/*
 * Decompiled with CFR 0.152.
 */
package tagit;

import java.util.Vector;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import tagit.CanvasButton;
import tagit.Keys;
import tagit.ResourceName;
import tagit.SMSCanvas;
import tagit.SMSForm;
import tagit.TAGit;
import tagit.Tag;
import tagit.TouchScreenButton;
import tagit.TouchScreenSoftKey;

public class NewTagRCanvas
extends Canvas
implements Runnable,
CanvasButton {
    private Tag tag;
    private TAGit midlet;
    private static Image ALBUM_LOGO;
    private static Image HEADER;
    private static Image GET;
    private static Image ALBUM_ART;
    private static Image RINGTONE;
    private static Image WALLPAPER;
    private static Image FULLSONG;
    private static Image IDPICKS;
    private static Image SHAREID;
    private static Image RINGTONE_SELECTED;
    private static Image WALLPAPER_SELECTED;
    private static Image FULLSONG_SELECTED;
    private static Image IDPICKS_SELECTED;
    private static Image SHAREID_SELECTED;
    private static boolean paintAll;
    private static String artist;
    private static String track;
    private static final String ARTIST_LABEL = "Artist: ";
    private static final String TRACK_LABEL = "Track: ";
    private static int H_BUFFER;
    private static int V_BUFFER;
    private static int ALBUM_X;
    private static int ALBUM_Y;
    private static int MENU_X;
    private static int MENU_Y;
    private static int MENU_ITEM_H;
    private static int artist_y;
    private static int track_y;
    private static int totalMenuItems;
    private static int itemSelected;
    private static String contentURL;
    private SMSCanvas resultsSMS;
    private SMSForm form;
    private static boolean scrollArtist;
    private static boolean scrollTrack;
    private static Graphics g;
    private static boolean requiresSetup;
    private static Vector menuItems;
    private static boolean initted;
    private static TextScroller artistThread;
    private static TextScroller trackThread;
    public int artist_x = 0;
    public int track_x = 0;
    private TouchScreenSoftKey lsk;
    private TouchScreenSoftKey rsk;

    public NewTagRCanvas(TAGit midlet) {
        try {
            this.setFullScreenMode(true);
            this.midlet = midlet;
            this.setupStaticImages();
            menuItems = new Vector();
            this.setupVariables();
            artistThread = new TextScroller(true);
            trackThread = new TextScroller(false);
            artistThread.start();
            trackThread.start();
        }
        catch (Exception e) {
            TAGit.IMerror("newtagrcanvas.newtagrcanvas: " + e.toString());
        }
    }

    public void sizeChanged(int width, int height) {
        try {
            this.midlet.sizeChanged(width, height);
            initted = false;
            this.repaint();
        }
        catch (Exception e) {
            TAGit.IMerror("newTRCanvas.sizechanged: " + e.toString());
        }
    }

    private void init() {
        try {
            this.stopFlipper();
            this.setupStaticImages();
            this.setupVariables();
            this.clearAllButtons();
            this.enableAllButtonVectors();
            this.setAllButtons();
            paintAll = true;
            initted = true;
        }
        catch (Exception e) {
            TAGit.IMerror("newTRCanvas.init: " + e.toString());
        }
    }

    private void setupVariables() {
        try {
            MENU_ITEM_H = FULLSONG_SELECTED.getHeight();
            H_BUFFER = (TAGit.globalScreenWidth - ALBUM_LOGO.getWidth() - FULLSONG_SELECTED.getWidth()) / 3;
            V_BUFFER = (TAGit.globalScreenHeight - 2 * TAGit.font.getHeight() - 5 * MENU_ITEM_H - GET.getHeight() - HEADER.getHeight() - this.lsk.getHeight()) / 3;
            ALBUM_X = H_BUFFER;
            ALBUM_Y = TAGit.font.getHeight() * 2 + V_BUFFER * 2 + HEADER.getHeight() + (TAGit.compact ? 1 : 0);
            MENU_X = H_BUFFER * 2 + ALBUM_LOGO.getWidth();
            MENU_Y = V_BUFFER * 2 + TAGit.font.getHeight() * 2 + HEADER.getHeight();
            artist_y = HEADER.getHeight() + V_BUFFER;
            track_y = artist_y + TAGit.font.getHeight();
        }
        catch (Exception e) {
            TAGit.IMerror("newTRCanvas.setup variables: " + e.toString());
        }
    }

    public void pointerPressed(int x, int y) {
        this.midlet.vibrateForPointerPressed();
        try {
            for (int c = 0; c < menuItems.size(); ++c) {
                TagMenuItem item = (TagMenuItem)menuItems.elementAt(c);
                if (!item.button.selectThisButton(x, y)) continue;
                if (itemSelected != c) {
                    itemSelected = c;
                    this.runButton(item.button);
                    return;
                }
                this.fire();
                return;
            }
            if (this.lsk.selectThisButton(x, y)) {
                if (TAGit.weNeedToFlipSoftKeys) {
                    this.doNewID();
                } else {
                    this.goBack();
                }
                return;
            }
            if (this.rsk.selectThisButton(x, y)) {
                if (TAGit.weNeedToFlipSoftKeys) {
                    this.goBack();
                } else {
                    this.doNewID();
                }
            }
        }
        catch (Exception e) {
            TAGit.IMerror("newTRCanvas.pointerpressed: " + e.toString());
        }
    }

    private void setupStaticImages() {
        try {
            ALBUM_LOGO = TAGit.createImage(ResourceName.NO_ALBUM_ART_IMAGE);
            HEADER = TAGit.createImage(ResourceName.FOUND_HEADER_IMAGE);
            GET = TAGit.createImage(ResourceName.RESULTS_MENU_HEADER_IMAGE);
            RINGTONE = TAGit.createImage(ResourceName.RESULTS_MENU_OPTION1_IMAGE);
            WALLPAPER = TAGit.createImage(ResourceName.RESULTS_MENU_OPTION2_IMAGE);
            FULLSONG = TAGit.createImage(ResourceName.RESULTS_MENU_FULL_SONG);
            IDPICKS = TAGit.createImage(ResourceName.RESULTS_MENU_OPTION5_IMAGE);
            SHAREID = TAGit.createImage(ResourceName.RESULTS_MENU_OPTION4_IMAGE);
            RINGTONE_SELECTED = TAGit.createImage(ResourceName.RESULTS_MENU_SELECT1_IMAGE);
            WALLPAPER_SELECTED = TAGit.createImage(ResourceName.RESULTS_MENU_SELECT2_IMAGE);
            FULLSONG_SELECTED = TAGit.createImage(ResourceName.RESULTS_MENU_FULL_SONG_SELECTED);
            IDPICKS_SELECTED = TAGit.createImage(ResourceName.RESULTS_MENU_SELECT5_IMAGE);
            SHAREID_SELECTED = TAGit.createImage(ResourceName.RESULTS_MENU_SELECT4_IMAGE);
        }
        catch (Exception e) {
            TAGit.IMerror("newTagRCanvas.setupstaticimages: " + e.toString());
        }
    }

    public void paint(Graphics g) {
        try {
            this.midlet.updateMemStatus();
            NewTagRCanvas.g = g;
            artistThread.setG(g);
            trackThread.setG(g);
            g.setFont(TAGit.font);
            if (!initted) {
                this.init();
            }
            if (paintAll) {
                TAGit.paintEmulatorExtras(g);
                g.setColor(0xFFFFFF);
                g.fillRect(0, 0, TAGit.globalScreenWidth, TAGit.globalScreenHeight);
                g.drawImage(HEADER, 0, 0, 20);
                g.drawImage(GET, MENU_X, MENU_Y, 20);
                if (ALBUM_ART != null) {
                    g.drawImage(ALBUM_ART, ALBUM_X, ALBUM_Y, 20);
                } else {
                    g.drawImage(ALBUM_LOGO, ALBUM_X, ALBUM_Y, 20);
                }
                this.drawTrackInfo(g);
                paintAll = false;
            }
            this.drawMenuItems(g);
            this.lsk.draw(g);
            this.rsk.draw(g);
        }
        catch (Exception e) {
            TAGit.IMerror("newtagrcanvas.paint: " + e.toString());
        }
        if (!TAGit.isMako) {
            TAGit.drawPreReleaseBanner(g, HEADER);
        }
    }

    private void drawTrackInfo(Graphics g) {
        try {
            String artist = ARTIST_LABEL + NewTagRCanvas.artist;
            String track = TRACK_LABEL + NewTagRCanvas.track;
            g.setFont(TAGit.font);
            g.setColor(0);
            if (TAGit.font.stringWidth(artist) < TAGit.globalScreenWidth) {
                NewTagRCanvas.artistThread.visible = false;
                scrollArtist = false;
                this.artist_x = (TAGit.globalScreenWidth - TAGit.font.stringWidth(artist)) / 2;
                g.drawString(artist, this.artist_x, artist_y, 20);
            } else {
                scrollArtist = true;
                this.artist_x = TAGit.font.stringWidth(ARTIST_LABEL);
                g.drawString(artist, NewTagRCanvas.artistThread.setNewIndex() + 2, artist_y + TAGit.font.getHeight(), 40);
                NewTagRCanvas.artistThread.visible = true;
            }
            TAGit.IMinfo("artistlength = " + TAGit.font.stringWidth(artist));
            if (TAGit.font.stringWidth(track) < TAGit.globalScreenWidth) {
                NewTagRCanvas.trackThread.visible = false;
                scrollTrack = false;
                this.track_x = (TAGit.globalScreenWidth - TAGit.font.stringWidth(track)) / 2;
                g.drawString(track, this.track_x, track_y, 20);
            } else {
                scrollTrack = true;
                this.track_x = TAGit.font.stringWidth(TRACK_LABEL);
                g.drawString(track, NewTagRCanvas.trackThread.setNewIndex() + 2, track_y + TAGit.font.getHeight(), 40);
                NewTagRCanvas.trackThread.visible = true;
            }
            TAGit.IMinfo("track length = " + TAGit.font.stringWidth(track));
            TAGit.IMinfo("screen width = " + TAGit.globalScreenWidth);
        }
        catch (Exception e) {
            TAGit.IMerror("newtagrcanvas.drawtrackinfo: " + e.toString());
        }
    }

    private void drawMenuItems(Graphics g) {
        try {
            int MenuItem_Y = MENU_Y + GET.getHeight();
            int currentMenuItem_Y = 0;
            for (int c = 0; c < menuItems.size(); ++c) {
                currentMenuItem_Y = MenuItem_Y + c * MENU_ITEM_H;
                TagMenuItem item = (TagMenuItem)menuItems.elementAt(c);
                if (item.x == 0) {
                    item.setCoordinates(MENU_X, currentMenuItem_Y);
                }
                if (itemSelected == c) {
                    g.drawImage(item.selected, item.x, item.y, 20);
                    continue;
                }
                g.drawImage(item.unselected, item.x, item.y, 20);
            }
        }
        catch (Exception e) {
            TAGit.IMerror("newtagrcanvas.drawmenuitems: " + e.toString());
        }
    }

    public void showNotify() {
        try {
            if (!TAGit.callFullScreenOnlyOnce) {
                this.setFullScreenMode(true);
            }
            if (requiresSetup) {
                this.setup();
            }
            paintAll = true;
            this.repaint();
        }
        catch (Exception e) {
            TAGit.IMerror("newTRCanvas.shownotify: " + e.toString());
        }
    }

    public void hideNotify() {
        try {
            ALBUM_ART = null;
            requiresSetup = true;
            this.stopFlipper();
            itemSelected = 0;
            initted = false;
        }
        catch (Exception e) {
            TAGit.IMerror("newTRCanvas.hidenotify: " + e.toString());
        }
    }

    private void stopFlipper() {
        try {
            NewTagRCanvas.artistThread.visible = false;
            NewTagRCanvas.trackThread.visible = false;
        }
        catch (Exception e) {
            TAGit.IMerror("newTRCanvas.stopflipper: " + e.toString());
        }
    }

    public void keyPressed(int keyCode) {
        this.midlet.vibrateForKeyPressed();
        try {
            TAGit.IMinfo("keypressed in newtagrcanvas.");
            switch (this.getGameAction(keyCode)) {
                case 1: {
                    this.up();
                    break;
                }
                case 6: {
                    this.down();
                    break;
                }
                case 8: {
                    this.fire();
                }
            }
            if (Keys.isBackKey(keyCode)) {
                this.goBack();
            } else if (this.lsk.keyPressed(keyCode)) {
                this.goBack();
            } else if (this.rsk.keyPressed(keyCode)) {
                this.doNewID();
            }
            this.repaint();
        }
        catch (Exception e) {
            TAGit.IMerror("newtagrcanvas.keypressed: " + e.toString());
        }
    }

    private void up() {
        try {
            TAGit.IMinfo("up");
            if (totalMenuItems > 0) {
                itemSelected = itemSelected == 0 ? totalMenuItems - 1 : --itemSelected;
            }
        }
        catch (Exception e) {
            TAGit.IMerror("newTRCanvas.up: " + e.toString());
        }
    }

    private void down() {
        try {
            TAGit.IMinfo("down");
            if (totalMenuItems > 0) {
                itemSelected = (itemSelected + 1) % totalMenuItems;
            }
        }
        catch (Exception e) {
            TAGit.IMerror("newTRCanvas.down: " + e.toString());
        }
    }

    public void fire() {
        try {
            TAGit.IMinfo("fire");
            if (this.handleSelection()) {
                this.midlet.platformRequest(contentURL);
                if (this.midlet.getManufacturer() == 2) {
                    NewTagRCanvas newTagRCanvas = this;
                    newTagRCanvas.midlet.exitApp();
                }
            } else {
                this.midlet.displayStore.addDisplay((Displayable)this);
                this.showShareIDScreen();
            }
        }
        catch (Exception e) {
            TAGit.IMerror("tagresultscanvas.newtagbutton: " + e.toString());
        }
    }

    public void goBack() {
        try {
            this.stopFlipper();
            this.midlet.display.setCurrent(this.midlet.displayStore.popDisplay("newtagrcanvas.backbutton"));
        }
        catch (Exception e) {
            TAGit.IMerror("newTRCanvas.goback: " + e.toString());
        }
    }

    public void doNewID() {
        try {
            this.stopFlipper();
            this.midlet.restartRecordForm((Displayable)this);
        }
        catch (Exception e) {
            TAGit.IMerror("tagresultscanvas.donewid: " + e.toString());
        }
    }

    private void showShareIDScreen() {
        try {
            TAGit.IMinfo("showsharidscreen");
            if ("true".equalsIgnoreCase(this.midlet.getProperty("ShowSMSForm"))) {
                if (this.form == null && this.tag != null && this.midlet != null) {
                    this.form = new SMSForm(this.tag, this.midlet);
                } else {
                    this.form.setTag(this.tag);
                }
                this.midlet.display.setCurrent((Displayable)this.form);
            } else {
                if (this.resultsSMS == null) {
                    this.resultsSMS = new SMSCanvas(this.midlet);
                }
                this.resultsSMS.setTag(this.tag);
                this.midlet.display.setCurrent((Displayable)this.resultsSMS);
            }
        }
        catch (Exception e) {
            TAGit.IMerror("newtagrcanvas.showshareidscreen: " + e.toString());
        }
    }

    private boolean handleSelection() {
        try {
            TAGit.IMinfo("handleselection");
            contentURL = new String(((TagMenuItem)NewTagRCanvas.menuItems.elementAt((int)NewTagRCanvas.itemSelected)).url);
            TAGit.IMinfo(contentURL);
            return !contentURL.equalsIgnoreCase("shareid");
        }
        catch (Exception e) {
            TAGit.IMerror("newtagrcanvas.handleselection: " + e.toString());
            return false;
        }
    }

    public boolean setTag(Tag tag) {
        this.tag = tag;
        return this.setup();
    }

    private boolean setup() {
        try {
            if (this.tag == null) {
                return false;
            }
            artist = " " + this.tag.getArtist() + " ";
            track = " " + this.tag.getTrack() + " ";
            this.setAlbumArt();
            this.clearAllButtons();
            this.enableAllButtonVectors();
            this.setAllButtons();
            contentURL = "";
            paintAll = true;
            scrollArtist = false;
            scrollTrack = false;
            NewTagRCanvas.artistThread.visible = false;
            NewTagRCanvas.trackThread.visible = false;
            requiresSetup = false;
            this.repaint();
            return true;
        }
        catch (Exception e) {
            TAGit.IMerror("newTagresultscanvas.setup: " + e.toString());
            return false;
        }
    }

    private void clearAllButtons() {
        try {
            menuItems = null;
            System.gc();
        }
        catch (Exception e) {
            TAGit.IMerror("newTRCanvas.clearallbuttons: " + e.toString());
        }
    }

    private void enableAllButtonVectors() {
        try {
            menuItems = new Vector();
        }
        catch (Exception e) {
            TAGit.IMerror("newTRCanvas.enableallbuttonvectors: " + e.toString());
        }
    }

    private void setAlbumArt() {
        try {
            int id = this.tag.getAlbumImageID();
            if (id > 0) {
                ALBUM_ART = this.midlet.getIDCollector().lookupImage(id);
            }
        }
        catch (Exception e) {
            ALBUM_ART = null;
        }
    }

    private void setAllButtons() {
        try {
            this.setMenuItems();
            this.setSoftKeys();
        }
        catch (Exception e) {
            TAGit.IMerror("newTRCanvas.sizechanged: " + e.toString());
        }
    }

    private void setMenuItems() {
        try {
            if (this.tag.getFullSongURL() != null) {
                menuItems.addElement(new TagMenuItem("FullSong", FULLSONG_SELECTED, FULLSONG, this.tag.getFullSongURL()));
            }
            if (this.tag.getRingerURL() != null) {
                menuItems.addElement(new TagMenuItem("Ringtone", RINGTONE_SELECTED, RINGTONE, this.tag.getRingerURL()));
            }
            if (this.tag.getWallpaperURL() != null) {
                menuItems.addElement(new TagMenuItem("Wallpaper", WALLPAPER_SELECTED, WALLPAPER, this.tag.getWallpaperURL()));
            }
            if (this.tag.getRecommendedURL() != null) {
                menuItems.addElement(new TagMenuItem("IDPicks", IDPICKS_SELECTED, IDPICKS, this.tag.getRecommendedURL()));
            }
            menuItems.addElement(new TagMenuItem("ShareID", SHAREID_SELECTED, SHAREID, "shareid"));
            totalMenuItems = menuItems.size();
        }
        catch (Exception e) {
            e.printStackTrace();
            TAGit.IMerror("newtagrcanvas.setmenuitems: " + e.toString());
        }
    }

    private void setSoftKeys() {
        try {
            this.lsk = new TouchScreenSoftKey("Back", false);
            this.rsk = new TouchScreenSoftKey("New ID", true);
        }
        catch (Exception e) {
            TAGit.IMerror("newTRCanvas.setsoftkeys: " + e.toString());
        }
    }

    public void run() {
        try {
            this.midlet.display.setCurrent((Displayable)this);
            this.repaint();
        }
        catch (Exception e) {
            TAGit.IMerror("newTRCanvas.run: " + e.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runButton(TouchScreenButton tsb) {
        try {
            NewTagRCanvas newTagRCanvas = this;
            synchronized (newTagRCanvas) {
                Thread th = new Thread(tsb);
                tsb.setMonitor(this);
                th.run();
            }
        }
        catch (Exception e) {
            TAGit.IMerror("newTRCanvas.runbutton: " + e.toString());
        }
    }

    public boolean externalPaintCall() {
        try {
            this.repaint();
            this.serviceRepaints();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    static {
        paintAll = false;
        itemSelected = 0;
        contentURL = "";
        scrollArtist = false;
        scrollTrack = false;
        requiresSetup = true;
        initted = false;
        artistThread = null;
        trackThread = null;
    }

    public class TagMenuItem {
        public String name;
        public Image unselected;
        public Image selected;
        public String url;
        public int x = 0;
        public int y = 0;
        private TouchScreenButton button;

        public TagMenuItem(String n, Image s, Image u, String link) {
            try {
                this.name = n;
                this.selected = s;
                this.unselected = u;
                this.url = link;
            }
            catch (Exception e) {
                NewTagRCanvas.this.midlet;
                TAGit.IMerror("newTRCanvas.tagmenuitem: " + e.toString());
            }
        }

        public void setCoordinates(int x, int y) {
            try {
                this.x = x;
                this.y = y;
                this.button = new TouchScreenButton(this.name, this.selected, x, y);
            }
            catch (Exception e) {
                NewTagRCanvas.this.midlet;
                TAGit.IMerror("newTRCanvas.setcoordinates: " + e.toString());
            }
        }
    }

    public class TextScroller
    extends Thread {
        private static final int PAUSE_BETWEEN_SROLLS = 2000;
        private static final int PAUSE_BETWEEN_PAINTS = 100;
        private String labelCopy = "";
        private int x = 0;
        private int y = 0;
        public int index = 0;
        private int position = 0;
        public boolean visible = false;
        private boolean isArtist = false;
        private boolean allowOneMoreDraw = false;
        private String type = "";
        private Graphics g;

        TextScroller(boolean isArtist) {
            this.isArtist = isArtist;
            this.type = isArtist ? "artist" : "track";
        }

        public void setG(Graphics g) {
            this.g = g;
        }

        public void run() {
            try {
                TAGit.sendToConsole("start running");
                while (true) {
                    this.drawLabel();
                    while (!this.visible) {
                    }
                    TextScroller.sleep(2000L);
                    this.position = this.index;
                    while (this.position > TAGit.globalScreenWidth && this.visible) {
                        if (this.visible) {
                            this.drawLabel();
                        }
                        if (this.visible) {
                            TextScroller.sleep(100L);
                        }
                        --this.position;
                    }
                    if (this.visible) {
                        TextScroller.sleep(2000L);
                    }
                    this.position = this.index;
                    if (!scrollTrack || !scrollArtist || !this.isArtist || !this.visible) continue;
                    this.allowOneMoreDraw = true;
                }
            }
            catch (Exception e) {
                NewTagRCanvas.this.midlet;
                TAGit.IMerror("newtagrcanvas.textscroller.run: " + e.toString());
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized void drawLabel() {
            if (this.g == null) {
                return;
            }
            Graphics graphics = this.g;
            synchronized (graphics) {
                if (!this.visible) {
                    return;
                }
                if (this.isArtist) {
                    if (!this.labelCopy.equals(artist)) {
                        this.setNewIndex();
                    }
                } else if (!this.labelCopy.equals(track)) {
                    this.setNewIndex();
                }
                try {
                    if (this.visible) {
                        this.g.setColor(0xFFFFFF);
                        this.g.setClip(this.x, this.y, TAGit.globalScreenWidth - this.x, TAGit.font.getHeight());
                        this.g.fillRect(this.x, this.y, TAGit.font.stringWidth(this.labelCopy), TAGit.font.getHeight());
                        this.g.setColor(0);
                        this.g.setFont(TAGit.font);
                        this.g.drawString(this.labelCopy, this.position, this.y + TAGit.font.getHeight(), 40);
                        this.g.setColor(0xFFFFFF);
                        this.g.setClip(0, this.y, this.x, TAGit.font.getHeight());
                        this.g.fillRect(0, this.y, this.x, TAGit.font.getHeight());
                        this.g.setColor(0);
                        this.g.drawString(this.isArtist ? NewTagRCanvas.ARTIST_LABEL : NewTagRCanvas.TRACK_LABEL, this.x + 2, this.y, 24);
                        this.g.setClip(0, 0, TAGit.globalScreenWidth, TAGit.globalScreenHeight);
                        NewTagRCanvas.this.repaint();
                    }
                    if (this.allowOneMoreDraw) {
                        this.allowOneMoreDraw = false;
                        this.visible = false;
                    }
                }
                catch (Exception e) {
                    NewTagRCanvas.this.midlet;
                    TAGit.IMerror("newtagrcanvas.textscroller.drawlabel: " + e.toString());
                }
            }
        }

        private int setNewIndex() {
            if (this.isArtist) {
                this.labelCopy = artist;
                this.x = NewTagRCanvas.this.artist_x;
                this.y = artist_y;
            } else {
                this.labelCopy = track;
                this.x = NewTagRCanvas.this.track_x;
                this.y = track_y;
            }
            this.position = this.index = TAGit.font.stringWidth(this.labelCopy) + this.x;
            return this.index;
        }
    }
}

