/*
 * Decompiled with CFR 0.152.
 */
package tagit;

import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import tagit.Keys;
import tagit.RecordForm;
import tagit.ResourceName;
import tagit.TAGit;
import tagit.TouchScreenSoftKey;

public class RFormError
extends Canvas
implements Runnable {
    private TAGit midlet;
    private static Image header;
    private static Image body;
    RecordForm recordform;
    private String errorMessage = "";
    private boolean mediaError = false;
    private static boolean initted;
    private TouchScreenSoftKey lsk;
    private TouchScreenSoftKey rsk;

    public RFormError(TAGit midlet, boolean mediaError, RecordForm recordform) {
        this.recordform = recordform;
        this.midlet = midlet;
        this.mediaError = mediaError;
        this.setFullScreenMode(true);
    }

    private void init() {
        try {
            body = null;
            this.recordform.th = null;
            System.gc();
            if (!this.mediaError) {
                body = TAGit.createImage(ResourceName.NETWORK_FAILURE_IMAGE);
            }
            this.lsk = new TouchScreenSoftKey("Back", false);
            this.rsk = new TouchScreenSoftKey("", true);
            header = TAGit.createImage(ResourceName.MAINMENU_HEADER_IMAGE);
            initted = true;
        }
        catch (Exception e) {
            this.midlet.IMerror("networkerror.networkerror: " + e.toString(), (Displayable)this);
        }
    }

    public void sizeChanged(int x, int y) {
        this.midlet.sizeChanged(x, y);
        initted = false;
        this.repaint();
    }

    public void pointerPressed(int x, int y) {
        this.midlet.vibrateForPointerPressed();
        if (this.lsk.selectThisButton(x, y)) {
            this.goBack();
        }
    }

    public void showNotify() {
        if (!TAGit.callFullScreenOnlyOnce) {
            this.setFullScreenMode(true);
        }
        this.repaint();
    }

    public void hideNotify() {
        initted = false;
    }

    private int calculateY() {
        return (TAGit.globalScreenHeight - header.getHeight() - this.lsk.getHeight()) / 2 + header.getHeight();
    }

    public void paint(Graphics g) {
        try {
            if (!initted) {
                this.init();
            }
            TAGit.paintEmulatorExtras(g);
            g.setFont(TAGit.font);
            int fontHeight = TAGit.font.getHeight();
            int msgStart = (TAGit.globalScreenHeight - fontHeight * 4) / 2;
            this.midlet.updateMemStatus();
            if (!TAGit.callFullScreenOnlyOnce) {
                this.setFullScreenMode(true);
            }
            g.setColor(255, 255, 255);
            g.fillRect(0, 0, TAGit.globalScreenWidth, TAGit.globalScreenHeight);
            if (header != null) {
                g.drawImage(header, 0, 0, 20);
            }
            if (body != null) {
                g.drawImage(body, TAGit.globalScreenWidth / 2, this.calculateY(), 3);
            }
            this.lsk.draw(g);
            this.rsk.draw(g);
            if (!this.errorMessage.equals("")) {
                g.setColor(0);
                g.drawString(this.errorMessage, 5, 50, 20);
            }
            if (this.mediaError) {
                String line = null;
                int line_x = 0;
                g.setColor(0, 120, 193);
                for (int c = 0; c < 5; ++c) {
                    switch (c) {
                        case 1: {
                            line = "Could Not ID Music!";
                            break;
                        }
                        case 2: {
                            line = "Please make sure you";
                            break;
                        }
                        case 3: {
                            line = "are not using any other";
                            break;
                        }
                        case 4: {
                            line = "music apps and try again.";
                            break;
                        }
                        default: {
                            line = "";
                        }
                    }
                    line_x = (TAGit.globalScreenWidth - TAGit.font.stringWidth(line)) / 2;
                    g.drawString(line, line_x, msgStart + fontHeight * c, 20);
                }
            }
        }
        catch (Exception e) {
            this.midlet.IMerror("networkerror.paint: " + e.toString(), (Displayable)this);
        }
        TAGit.drawPreReleaseBanner(g);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void keyPressed(int keyCode) {
        this.midlet.vibrateForKeyPressed();
        try {
            if (Keys.isBackKey(keyCode)) {
                this.goBack();
                return;
            }
            if (this.lsk.keyPressed(keyCode)) {
                this.goBack();
                return;
            }
            if (!this.rsk.keyPressed(keyCode)) return;
        }
        catch (Exception e) {
            TAGit.IMerror("networkerror.keypressed: " + e.toString());
        }
    }

    private void goBack() {
        this.mediaError = false;
        this.errorMessage = "";
        this.midlet.display.setCurrent(this.midlet.displayStore.popDisplay("rformerror.keypressed"));
    }

    public void run() {
        TAGit.IMinfo("+++++++ Exception on RecordForm:");
        this.recordform.stop();
        this.recordform.th = null;
        System.gc();
        if (!RecordForm.suspended) {
            RecordForm.atWill = true;
            this.midlet.display.setCurrent((Displayable)this);
        }
    }

    static {
        initted = false;
    }
}

