/*
 * Decompiled with CFR 0.152.
 */
package tagit;

import java.util.Enumeration;
import java.util.Vector;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import tagit.TAGit;

public abstract class SelectionMenu
extends Canvas
implements CommandListener {
    protected Vector items;
    protected Vector activeItems;
    protected int numItems;
    protected int totalItemHeight = 0;
    protected int edgeSpacing = 0;
    protected int itemSpacing = 0;
    protected int menuLayoutPolicy;
    protected int maxItemsPerScreen;

    public SelectionMenu() {
        try {
            this.items = new Vector();
            this.activeItems = new Vector();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void releaseImages() {
        this.items.removeAllElements();
        this.activeItems.removeAllElements();
    }

    public void setLayout(boolean spaceItems) {
        this.numItems = 10;
        Enumeration e = this.activeItems.elements();
        while (e.hasMoreElements()) {
            MenuTile mtile = (MenuTile)e.nextElement();
            this.totalItemHeight += mtile.getImage().getHeight();
        }
        int minItemSpacing = this.totalItemHeight / this.numItems / 10;
        this.maxItemsPerScreen = TAGit.globalScreenHeight / (((MenuTile)this.activeItems.elementAt(0)).getImage().getHeight() + minItemSpacing);
        this.edgeSpacing = 0;
        this.itemSpacing = spaceItems ? (TAGit.globalScreenHeight - this.totalItemHeight) / (this.numItems + 2) : 0;
    }

    public void setImageLocation() {
    }

    public void setLayoutPolicy(int layoutPolicy) {
        this.menuLayoutPolicy = layoutPolicy;
    }

    public void removeMenuItem(String menuItem) {
        int nItem = 0;
        MenuTile previousTile = new MenuTile(null, 0, 0);
        MenuTile tmpTile = new MenuTile(null, 0, 0);
        int nItems = this.activeItems.size();
        Enumeration e = this.activeItems.elements();
        while (e.hasMoreElements()) {
            MenuTile currentTile;
            previousTile = currentTile = (MenuTile)e.nextElement();
            if (currentTile.getName().compareTo(menuItem) == 0) {
                MenuTile iTile = new MenuTile(null, 0, 0);
                if (this.menuLayoutPolicy != 1) break;
                for (int i = nItem + 1; i < nItems; ++i) {
                    iTile = (MenuTile)this.activeItems.elementAt(i);
                    tmpTile = new MenuTile(iTile.getImage(), iTile.getX(), iTile.getY());
                    iTile.setX(previousTile.getX());
                    iTile.setY(previousTile.getY());
                    this.activeItems.setElementAt(iTile, i);
                    previousTile = tmpTile;
                }
                this.activeItems.removeElementAt(nItem);
                break;
            }
            ++nItem;
        }
    }

    public void commandAction(Command command, Displayable displayable) {
    }

    public void paint(Graphics g) {
        if (!TAGit.callFullScreenOnlyOnce) {
            this.setFullScreenMode(true);
        }
    }

    protected class MenuTile {
        private Image image;
        private Image selectImage;
        private int x;
        private int y;
        private String tileName;

        public MenuTile(Image mImage, int mx, int my) {
            this.image = mImage;
            this.x = mx;
            this.y = my;
        }

        public void setSelectImage(Image image) {
            this.selectImage = image;
        }

        public Image getSelectImage() {
            return this.selectImage;
        }

        public Image getImage() {
            return this.image;
        }

        public void setName(String tName) {
            this.tileName = tName;
        }

        public String getName() {
            return this.tileName;
        }

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }

        public void setX(int px) {
            this.x = px;
        }

        public void setY(int py) {
            this.y = py;
        }
    }
}

