/*
 * Decompiled with CFR 0.152.
 */
package tagit;

import java.util.Enumeration;
import java.util.Vector;
import javax.microedition.lcdui.Image;
import javax.microedition.rms.RecordComparator;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordListener;
import javax.microedition.rms.RecordStore;
import tagit.RemoteResource;
import tagit.TAGit;
import tagit.Tag;

public class SongIDCollector {
    public Vector myIDS;
    private RecordStore tagStore;
    private RecordStore imageStore;
    private boolean USE_RECORD_STORE = true;
    private static final int MAX_ITEMS = 10;
    public static final String TAG_STORE_NAME = "TagStore";
    public static final String IMAGE_STORE_NAME = "ImageStore";
    private static final String delimiter = "\\z\\1";
    private byte[] albumImageData;
    private TimestampComparator tagComparator;
    private TagListener tagListener;
    private boolean initialPass;
    private boolean tagAdded;
    private boolean tagUpdated;
    private RemoteResource imageResource;
    private TAGit midlet;

    public SongIDCollector(TAGit mid) {
        try {
            this.midlet = mid;
            this.myIDS = new Vector();
            this.openTagStore();
            this.openImageStore();
            this.tagAdded = false;
            this.imageResource = new RemoteResource(this.midlet);
            this.tagComparator = new TimestampComparator();
            this.tagListener = new TagListener();
            this.tagStore.addRecordListener((RecordListener)this.tagListener);
            this.initialPass = true;
        }
        catch (Exception e) {
            TAGit.IMerror("songidcollector.songidcollector: " + e.toString());
        }
    }

    public Vector collectSongIDs() throws Exception {
        try {
            if (this.USE_RECORD_STORE) {
                int recid = 0;
                if (this.tagStore.getNumRecords() > 0) {
                    RecordEnumeration recEnum = this.tagStore.enumerateRecords(null, (RecordComparator)this.tagComparator, false);
                    while (recEnum.hasNextElement()) {
                        recid = recEnum.nextRecordId();
                        if (this.contains(recid)) continue;
                        Tag tmpTag = this.getTagFromRecord(recid);
                        if (this.initialPass) {
                            this.myIDS.addElement(tmpTag);
                        } else {
                            this.myIDS.insertElementAt(tmpTag, 0);
                        }
                        tmpTag = null;
                    }
                    this.initialPass = false;
                }
            }
            return this.myIDS;
        }
        catch (Exception e) {
            TAGit.IMerror("songidcollector.collectsongids: " + e.toString());
            return null;
        }
    }

    private void openTagStore() {
        try {
            this.tagStore = RecordStore.openRecordStore((String)TAG_STORE_NAME, (boolean)true);
        }
        catch (Exception e) {
            TAGit.IMinfo("songidcollector.opentagstore: " + e.toString());
        }
    }

    private void openImageStore() {
        try {
            this.imageStore = RecordStore.openRecordStore((String)IMAGE_STORE_NAME, (boolean)true);
        }
        catch (Exception e) {
            TAGit.IMinfo("songidcollector.openimagestore: " + e.toString());
        }
    }

    public boolean closeRecordStores() {
        try {
            this.tagStore.closeRecordStore();
            this.imageStore.closeRecordStore();
        }
        catch (Exception e) {
            TAGit.IMerror("failed to close recordstores: " + e.toString());
            return false;
        }
        return true;
    }

    public void setRecordAdded(boolean updated) {
        try {
            this.tagAdded = updated;
        }
        catch (Exception e) {
            TAGit.IMinfo("songidcollector.setrecordadded: " + e.toString());
        }
    }

    public boolean getRecordAdded() {
        return this.tagAdded;
    }

    public void setRecordsUpdated(boolean updated) {
        try {
            this.tagUpdated = updated;
        }
        catch (Exception e) {
            TAGit.IMinfo("songidcollector.setrecordsupdated: " + e.toString());
        }
    }

    public boolean getRecordsUpdated() {
        return this.tagUpdated;
    }

    public boolean addTag(Tag newTag) {
        try {
            int imgRecNum;
            if (this.myIDS.size() < 1) {
                this.collectSongIDs();
            }
            while (this.tagStore.getNumRecords() >= 10) {
                int recid = ((Tag)this.myIDS.elementAt(9)).getTagID();
                Tag rmTag = this.getTagFromRecord(recid);
                imgRecNum = rmTag.getAlbumImageID();
                if (imgRecNum > 0) {
                    this.imageStore.deleteRecord(imgRecNum);
                }
                this.tagStore.deleteRecord(recid);
                this.myIDS.removeElementAt(9);
            }
            this.albumImageData = this.getAlbumImageData(newTag);
            imgRecNum = this.albumImageData != null ? this.imageStore.addRecord(this.albumImageData, 0, this.albumImageData.length) : -1;
            newTag.setAlbumImageID(imgRecNum);
            String imgRecStr = Integer.toString(imgRecNum);
            String storeTag = String.valueOf(newTag.getTagTimestamp()) + delimiter + newTag.getTagIDDate() + delimiter + newTag.getAlbum() + delimiter + newTag.getArtist() + delimiter + newTag.getTrack() + delimiter + newTag.getWallpaperURL() + delimiter + newTag.getRingerURL() + delimiter + newTag.getRecommendedURL() + delimiter + newTag.getSMSMessage() + delimiter + imgRecStr + delimiter + newTag.getFullSongURL() + delimiter;
            byte[] storeData = storeTag.getBytes();
            int recid = this.tagStore.addRecord(storeData, 0, storeData.length);
            newTag.setTagID(recid);
            return true;
        }
        catch (Exception e) {
            TAGit.IMerror("songidcollector.openimagestore: " + e.toString());
            return false;
        }
    }

    public void removeTagStore() throws Exception {
        try {
            this.tagStore.closeRecordStore();
            RecordStore.deleteRecordStore((String)TAG_STORE_NAME);
        }
        catch (Exception e) {
            TAGit.IMerror("songidcollector.removetagstore: " + e.toString());
        }
    }

    public byte[] getAlbumImageData(Tag newTag) {
        try {
            String albumURL = newTag.getAlbumImageURL();
            if (albumURL.equals("null") || albumURL.equals("NULL")) {
                return null;
            }
            byte[] albumImageData = null;
            try {
                albumImageData = this.imageResource.createImage(newTag.getAlbumImageURL());
            }
            catch (Exception e) {
                e.printStackTrace();
                albumImageData = null;
            }
            return albumImageData;
        }
        catch (Exception e) {
            TAGit.IMerror("songidcollector.getalbumimagedata: " + e.toString());
            return null;
        }
    }

    public void deleteAllRecords() {
        try {
            RecordEnumeration recEnum = this.tagStore.enumerateRecords(null, null, false);
            while (recEnum.hasNextElement()) {
                this.tagStore.deleteRecord(recEnum.nextRecordId());
            }
            recEnum = this.imageStore.enumerateRecords(null, null, false);
            while (recEnum.hasNextElement()) {
                this.imageStore.deleteRecord(recEnum.nextRecordId());
            }
        }
        catch (Exception e) {
            TAGit.IMinfo("songidcollector.deleteallrecords: " + e.toString());
        }
    }

    public Vector deleteRecord(int recid) {
        try {
            Tag tag = this.getTagFromRecord(recid);
            int imgRecNum = tag.getAlbumImageID();
            if (imgRecNum > 0) {
                this.imageStore.deleteRecord(imgRecNum);
            }
            this.tagStore.deleteRecord(recid);
            if (this.myIDS != null) {
                Enumeration e = this.myIDS.elements();
                while (e.hasMoreElements()) {
                    tag = (Tag)e.nextElement();
                    int tagid = tag.getTagID();
                    if (tagid != recid) continue;
                    this.myIDS.removeElement(tag);
                    break;
                }
            }
            return this.myIDS;
        }
        catch (Exception e) {
            TAGit.IMerror("songIDcollector.deleterecord: " + e.toString());
            return null;
        }
    }

    public boolean contains(int tid) {
        try {
            boolean hasid = false;
            if (this.myIDS != null) {
                Enumeration e = this.myIDS.elements();
                while (e.hasMoreElements() && !hasid) {
                    int tagid = ((Tag)e.nextElement()).getTagID();
                    if (tagid == tid) {
                        hasid = true;
                        break;
                    }
                    hasid = false;
                }
            }
            return hasid;
        }
        catch (Exception e) {
            TAGit.IMerror("songIDcollector.contains: " + e.toString());
            return false;
        }
    }

    public Tag getTagFromRecord(int recid) throws Exception {
        String fullSongString;
        String smsMessage;
        String recommendedURL;
        String ringerURL;
        String recString;
        byte[] rec = null;
        rec = this.tagStore.getRecord(recid);
        if (!this.midlet.LGWorkaround(this)) {
            recString = "";
            for (int x = 0; x < rec.length; ++x) {
                recString = recString + (char)rec[x];
            }
        } else {
            recString = new String(rec);
        }
        int itemStart = 0;
        int itemEnd = recString.indexOf(delimiter);
        String timestamp = recString.substring(itemStart, itemEnd);
        itemStart = itemEnd + delimiter.length();
        itemEnd = recString.indexOf(delimiter, itemStart);
        String date = recString.substring(itemStart, itemEnd);
        itemStart = itemEnd + delimiter.length();
        itemEnd = recString.indexOf(delimiter, itemStart);
        String album = recString.substring(itemStart, itemEnd);
        itemStart = itemEnd + delimiter.length();
        itemEnd = recString.indexOf(delimiter, itemStart);
        String artist = recString.substring(itemStart, itemEnd);
        itemStart = itemEnd + delimiter.length();
        itemEnd = recString.indexOf(delimiter, itemStart);
        String track = recString.substring(itemStart, itemEnd);
        itemStart = itemEnd + delimiter.length();
        String wallpaperURL = recString.substring(itemStart, itemEnd = recString.indexOf(delimiter, itemStart));
        if (wallpaperURL.compareTo("null") == 0) {
            wallpaperURL = null;
        }
        if ((ringerURL = recString.substring(itemStart = itemEnd + delimiter.length(), itemEnd = recString.indexOf(delimiter, itemStart))).compareTo("null") == 0) {
            ringerURL = null;
        }
        if ((recommendedURL = recString.substring(itemStart = itemEnd + delimiter.length(), itemEnd = recString.indexOf(delimiter, itemStart))).compareTo("null") == 0) {
            recommendedURL = null;
        }
        if ((smsMessage = recString.substring(itemStart = itemEnd + delimiter.length(), itemEnd = recString.indexOf(delimiter, itemStart))).compareTo("null") == 0) {
            smsMessage = null;
        }
        itemStart = itemEnd + delimiter.length();
        itemEnd = recString.indexOf(delimiter, itemStart);
        String imageString1 = recString.substring(itemStart, itemEnd);
        int imageID = Integer.parseInt(imageString1);
        try {
            itemStart = itemEnd + delimiter.length();
            itemEnd = recString.indexOf(delimiter, itemStart);
            fullSongString = recString.substring(itemStart, itemEnd);
            if (fullSongString.compareTo("null") == 0) {
                fullSongString = null;
            }
        }
        catch (Exception e) {
            fullSongString = null;
        }
        Tag tmpTag = new Tag(album, artist, track);
        tmpTag.setTagID(recid);
        tmpTag.setTagIDDate(date);
        tmpTag.setWallpaperURL(wallpaperURL);
        tmpTag.setRingerURL(ringerURL);
        tmpTag.setRecommendedURL(recommendedURL);
        tmpTag.setSMSMessage(smsMessage);
        tmpTag.setAlbumImageID(imageID);
        tmpTag.setFullSongURL(fullSongString);
        return tmpTag;
    }

    public RecordStore getImageStore() {
        return this.imageStore;
    }

    public RecordStore getTagStore() {
        return this.tagStore;
    }

    public Image lookupImage(int imageID) throws Exception {
        Image albumImage = null;
        if (imageID >= 0) {
            byte[] imageData = this.imageStore.getRecord(imageID);
            try {
                albumImage = Image.createImage((byte[])imageData, (int)0, (int)imageData.length);
            }
            catch (Exception e) {
                throw new Exception("Couldn't create image: imageData length is " + imageData.length);
            }
            return albumImage;
        }
        return null;
    }

    public class TagListener
    implements RecordListener {
        public void recordAdded(RecordStore recStore, int recID) {
            try {
                SongIDCollector.this.setRecordAdded(true);
                SongIDCollector.this.setRecordsUpdated(true);
            }
            catch (Exception e) {
                SongIDCollector.this.midlet;
                TAGit.IMerror("songIDcollector.taglistener.recordadded: " + e.toString());
            }
        }

        public void recordDeleted(RecordStore recStore, int recID) {
            try {
                SongIDCollector.this.setRecordsUpdated(true);
            }
            catch (Exception e) {
                SongIDCollector.this.midlet;
                TAGit.IMerror("songIDcollector.taglistener.recorddeleted: " + e.toString());
            }
        }

        public void recordChanged(RecordStore recStore, int recID) {
        }
    }

    public class TimestampComparator
    implements RecordComparator {
        public int compare(byte[] rec1, byte[] rec2) {
            try {
                long timestamp1 = 0L;
                long timestamp2 = 0L;
                String timestring1 = "";
                String timestring2 = "";
                if (!SongIDCollector.this.midlet.LGWorkaround(this)) {
                    timestring1 = new String(rec1);
                    timestring2 = new String(rec2);
                } else {
                    int x;
                    for (x = 0; x < rec1.length; ++x) {
                        timestring1 = timestring1 + (char)rec1[x];
                    }
                    for (x = 0; x < rec2.length; ++x) {
                        timestring2 = timestring2 + (char)rec2[x];
                    }
                }
                int itemEnd = timestring1.indexOf(SongIDCollector.delimiter);
                timestamp1 = Long.parseLong(timestring1.substring(0, itemEnd));
                timestamp2 = Long.parseLong(timestring2.substring(0, itemEnd));
                if (timestamp1 > timestamp2) {
                    return -1;
                }
                if (timestamp1 < timestamp2) {
                    return 1;
                }
                return 0;
            }
            catch (Exception e) {
                SongIDCollector.this.midlet;
                TAGit.IMerror("songIDcollector.compare: " + e.toString());
                return 0;
            }
        }
    }
}

