/*
 * Decompiled with CFR 0.152.
 */
package tagit;

import java.util.Timer;
import java.util.TimerTask;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import tagit.Keys;
import tagit.MainMenu;
import tagit.ResourceName;
import tagit.TAGit;
import tagit.TouchScreenSoftKey;

public class TrialCanvas
extends Canvas
implements Runnable {
    protected Image headerImage;
    protected Image messageImage;
    protected Image[] animFrames;
    protected Image splashScreen;
    protected long expireTime;
    protected boolean expired;
    protected int daysLeft = 0;
    protected int frame;
    protected TAGit midlet;
    protected String subscribeURL;
    protected Timer timer;
    protected boolean initialized;
    protected boolean drawSplash;
    private static int[] lock2 = new int[]{54, 54, 54, 53, 51, 57};
    private static int[] lock4 = new int[]{-2, -1, -2, -3, -4, -3, -4, -6, -7, -6, -7, -6};
    private static int[] lock;
    private static int pin;
    private static int locklength;
    private static boolean trylockpick;
    private TouchScreenSoftKey lsk;
    private TouchScreenSoftKey rsk;

    private boolean lockpick(int keyCode) {
        keyCode = Keys.convertFromKeySet(keyCode);
        try {
            if (trylockpick) {
                if (lock == null && keyCode == 54) {
                    locklength = 6;
                    lock = lock2;
                    ++pin;
                    return true;
                }
                if (lock == null && keyCode == -2) {
                    locklength = 12;
                    lock = lock4;
                    ++pin;
                    return true;
                }
                if (lock != null && (keyCode == 35 || keyCode == -5)) {
                    if (pin == locklength) {
                        this.midlet.deleteRMS();
                    }
                    return true;
                }
                if (lock != null && keyCode == lock[pin]) {
                    ++pin;
                    return true;
                }
                pin = 0;
                lock = null;
                locklength = -1;
                return true;
            }
            if (keyCode == 42 || keyCode == -1) {
                trylockpick = true;
                pin = 0;
                lock = null;
                locklength = -1;
                return true;
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            pin = 0;
            lock = null;
            locklength = -1;
            return false;
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    public TrialCanvas(TAGit m, long expTime, String s, boolean drawSplash) {
        super();
        try {
            this.setFullScreenMode(true);
            this.midlet = m;
            if (TAGit.resfolder.equals("")) ** GOTO lbl-1000
            if (TAGit.dualAspect) lbl-1000:
            // 2 sources

            {
                this.midlet.sizeChanged(this.getWidth(), this.getHeight());
            } else if (!TAGit.isEmulator) {
                this.midlet.setScreenSizes(this.getWidth(), this.getHeight());
            }
            this.expireTime = expTime;
            this.subscribeURL = s;
            this.drawSplash = drawSplash;
            this.frame = 0;
            currentDate = System.currentTimeMillis();
            msLeft = this.expireTime - currentDate;
            this.daysLeft = msLeft < 0L ? 0 : (int)(msLeft / 86400000L) + 1;
            TAGit.IMinfo("" + currentDate + " = current date");
            TAGit.IMinfo("" + this.expireTime + " = expired time");
            TAGit.IMinfo("" + (this.expireTime - currentDate) + " = ms Left");
            TAGit.IMinfo("" + this.daysLeft + " = days left");
            this.initialized = false;
            if (drawSplash) {
                this.runSplash();
            }
        }
        catch (Exception e) {
            TAGit.IMerror("trialcanvas.trialcanvas: " + e.toString());
        }
    }

    private void runSplash() {
        try {
            if (this.drawSplash) {
                if (TAGit.useAltSplash) {
                    this.splashScreen = TAGit.createImage(ResourceName.SPLASH_SCREEN_ALTERNATE);
                } else {
                    TAGit.IMinfo("using regular splash screen");
                    this.splashScreen = TAGit.createImage(ResourceName.SPLASH_SCREEN_IMAGE);
                }
            }
        }
        catch (Exception e) {
            this.splashScreen = null;
            this.drawSplash = false;
            TAGit.IMinfo("error at trialcanvas.runsplash: " + e.toString());
        }
        Thread t = new Thread(this);
        t.start();
    }

    public void init() {
        try {
            this.releaseImages();
            if (!TAGit.callFullScreenOnlyOnce) {
                this.setFullScreenMode(true);
            }
            try {
                if (this.daysLeft > 0) {
                    this.expired = false;
                    this.messageImage = TAGit.createImage(ResourceName.TRIAL_MESSAGE_IMAGE);
                    this.animFrames = new Image[8];
                    this.animFrames[0] = TAGit.createImage(ResourceName.TRIAL_ANIM_FRAME0);
                    this.animFrames[2] = TAGit.createImage(ResourceName.TRIAL_ANIM_FRAME2);
                    this.animFrames[3] = TAGit.createImage(ResourceName.TRIAL_ANIM_FRAME3);
                    this.animFrames[4] = TAGit.createImage(ResourceName.TRIAL_ANIM_FRAME4);
                    this.animFrames[5] = TAGit.createImage(ResourceName.TRIAL_ANIM_FRAME5);
                    this.animFrames[6] = TAGit.createImage(ResourceName.TRIAL_ANIM_FRAME6);
                    this.animFrames[7] = TAGit.createImage(ResourceName.TRIAL_ANIM_FRAME7);
                } else {
                    this.expired = true;
                    this.messageImage = TAGit.createImage(ResourceName.TRIAL_EXPIRED_IMAGE);
                }
            }
            catch (Exception e) {
                TAGit.IMinfo("trialcanvas.init: " + e.toString());
            }
            try {
                this.headerImage = TAGit.createImage(ResourceName.MAINMENU_HEADER_IMAGE);
                if (this.expired) {
                    this.lsk = new TouchScreenSoftKey("OK", false);
                    this.rsk = new TouchScreenSoftKey("Exit", true);
                } else {
                    this.lsk = new TouchScreenSoftKey("Subscribe", false);
                    this.rsk = new TouchScreenSoftKey("Continue", true);
                }
            }
            catch (Exception e) {
                TAGit.IMinfo("trialcanvas.init: " + e.toString());
            }
            this.initialized = true;
        }
        catch (Exception e) {
            TAGit.IMerror("trialcanvas.init" + e.toString());
        }
    }

    public void releaseImages() {
        try {
            this.headerImage = null;
            this.messageImage = null;
            if (this.animFrames != null) {
                for (int x = 0; x < this.animFrames.length; ++x) {
                    this.animFrames[x] = null;
                }
            }
            this.animFrames = null;
            this.splashScreen = null;
            System.gc();
        }
        catch (Exception e) {
            TAGit.IMerror("trial.releaseimages" + e.toString());
        }
    }

    public void pointerPressed(int x, int y) {
        this.midlet.vibrateForPointerPressed();
        if (this.lsk.selectThisButton(x, y)) {
            this.leftSoftButton();
        } else if (this.rsk.selectThisButton(x, y)) {
            this.rightSoftButton();
        }
    }

    public void paint(Graphics g) {
        g.setFont(TAGit.font);
        this.midlet.updateMemStatus();
        try {
            TAGit.paintEmulatorExtras(g);
            if (this.drawSplash) {
                g.setColor(0xFFFFFF);
                g.fillRect(0, 0, TAGit.globalScreenWidth, TAGit.globalScreenHeight);
                if (this.splashScreen.getWidth() >= TAGit.globalScreenWidth) {
                    g.drawImage(this.splashScreen, 0, 0, 20);
                } else {
                    g.drawImage(this.splashScreen, (TAGit.globalScreenWidth - this.splashScreen.getWidth()) / 2, 0, 20);
                }
                return;
            }
            if (!this.initialized) {
                this.init();
            }
            g.setColor(0xFFFFFF);
            g.fillRect(0, 0, TAGit.globalScreenWidth, TAGit.globalScreenHeight);
            g.drawImage(this.messageImage, TAGit.globalScreenWidth / 2, TAGit.globalScreenHeight / 2, 3);
            g.drawImage(this.headerImage, 0, 0, 20);
            if (!this.expired) {
                this.drawDaysLeft(g);
            }
            this.lsk.draw(g);
            this.rsk.draw(g);
        }
        catch (Exception e) {
            TAGit.IMerror("trial.paint: " + e.toString());
        }
        if (TAGit.isMako) {
            TAGit.drawPreReleaseBanner(g);
        }
    }

    public void sizeChanged(int newWidth, int newHeight) {
        try {
            this.midlet.sizeChanged(newWidth, newHeight);
            this.initialized = false;
            if (this.drawSplash) {
                this.runSplash();
            }
            this.repaint();
        }
        catch (Exception e) {
            TAGit.IMerror("trial.sizechanged: " + e.toString());
        }
    }

    protected void drawDaysLeft(Graphics g) {
        try {
            int x = TAGit.globalScreenWidth / 2;
            int y = TAGit.globalScreenHeight / 2;
            if (this.animFrames != null && this.animFrames[this.frame] != null) {
                g.drawImage(this.animFrames[this.frame], x, y, 3);
            }
            g.setFont(TAGit.font);
            String daysText = "" + this.daysLeft;
            int daysWidth = TAGit.font.stringWidth(daysText);
            int daysHeight = TAGit.font.getHeight();
            g.setColor(0);
            g.drawString(daysText, x - daysWidth / 2, y - daysHeight / 2, 20);
        }
        catch (Exception e) {
            TAGit.IMerror("trial.drawdaysleft" + e.toString());
        }
    }

    public void keyPressed(int keyCode) {
        TAGit.IMinfo("trialcanvas.keypressed: " + keyCode);
        this.midlet.vibrateForKeyPressed();
        try {
            boolean handled = false;
            handled = this.lockpick(keyCode);
            if (!this.drawSplash && !handled) {
                if (this.lsk.keyPressed(keyCode)) {
                    this.leftSoftButton();
                } else if (this.rsk.keyPressed(keyCode)) {
                    this.rightSoftButton();
                } else if (this.midlet.getManufacturer() == 9 && (keyCode == 8 || keyCode == 115)) {
                    this.leftSoftButton();
                }
                this.repaint();
            }
        }
        catch (Exception e) {
            TAGit.IMerror("trial.keypressed: " + e.toString());
        }
    }

    public void rightSoftButton() {
        try {
            if (!this.expired) {
                try {
                    MainMenu mainMenu;
                    this.midlet.displayable = mainMenu = new MainMenu(this.midlet, false);
                    this.midlet.display.setCurrent((Displayable)this.midlet.displayable);
                    this.repaint();
                }
                catch (Exception e) {
                    TAGit.IMerror("Exception in rightSoftButton: " + e.toString());
                }
            } else {
                try {
                    TrialCanvas trialCanvas = this;
                    trialCanvas.midlet.exitApp();
                }
                catch (Exception e) {}
            }
        }
        catch (Exception e) {
            TAGit.IMerror("trial.rightsoftbutton" + e.toString());
        }
    }

    public void leftSoftButton() {
        try {
            if (this.subscribeURL == null || this.subscribeURL.equalsIgnoreCase("")) {
                this.subscribeURL = this.midlet.getManufacturer() == 7 ? "http://www.cingularid.com/getmusicid/fullversion.php" : "http://wap.cingularextras.com/fuel/enduser/endUserWMLDesc?resourceID=66831";
            }
            this.midlet.platformRequest(this.subscribeURL);
            TrialCanvas trialCanvas = this;
            trialCanvas.midlet.exitApp();
        }
        catch (Exception e) {
            TAGit.IMerror("trial.leftsoftbutton: " + e.toString());
        }
    }

    public void hideNotify() {
        try {
            this.releaseImages();
            if (this.timer != null) {
                this.timer.cancel();
                this.timer = null;
            }
            this.initialized = false;
        }
        catch (Exception e) {
            TAGit.IMerror("trial.hidenotify" + e.toString());
        }
    }

    public void showNotify() {
        try {
            if (!TAGit.callFullScreenOnlyOnce) {
                this.setFullScreenMode(true);
            }
            if (this.drawSplash) {
                return;
            }
            if (!this.initialized) {
                this.init();
            }
            if (this.timer == null) {
                this.timer = new Timer();
                this.timer.scheduleAtFixedRate((TimerTask)new TrialTimer(), 200L, 200L);
            }
            this.repaint();
        }
        catch (Exception e) {
            TAGit.IMerror("trial.shownotify" + e.toString());
        }
    }

    public void run() {
        try {
            try {
                Thread.currentThread();
                Thread.sleep(2000L);
            }
            catch (Exception e) {
                // empty catch block
            }
            this.drawSplash = false;
            this.splashScreen = null;
            System.gc();
            if (!this.initialized) {
                this.init();
            }
            if (this.timer == null) {
                this.timer = new Timer();
                this.timer.scheduleAtFixedRate((TimerTask)new TrialTimer(), 200L, 200L);
            }
            this.repaint();
        }
        catch (Exception e) {
            TAGit.IMerror("trial.run" + e.toString());
        }
    }

    static {
        pin = 0;
        locklength = -1;
        trylockpick = false;
    }

    public class TrialTimer
    extends TimerTask {
        public void run() {
            try {
                ++TrialCanvas.this.frame;
                if (TrialCanvas.this.frame > 7) {
                    TrialCanvas.this.frame = 0;
                }
                TrialCanvas.this.repaint();
            }
            catch (Exception e) {
                TAGit cfr_ignored_0 = TrialCanvas.this.midlet;
                TAGit.IMerror("trial.trialtimer.run" + e.toString());
            }
        }
    }
}

