/*
 * Decompiled with CFR 0.152.
 */
package com.gravitymobile.logger;

import java.util.Vector;
import javax.microedition.rms.RecordStore;
import tagit.TAGit;

public class Logger {
    static boolean debug = true;
    static boolean logToRMS = true;
    static boolean isPublic = true;
    static boolean isWritable = true;
    public static String recordName = "logger";
    static String vendorName = null;
    static String suiteName = null;

    public static void setDebug(boolean dbg) {
        debug = dbg;
    }

    public static void setLogToRMS(boolean rms) {
        logToRMS = rms;
    }

    public static void setRmsProperties(String record, String vendor, String suite, boolean aPublic, boolean aWritable) {
        recordName = record;
        vendorName = vendor;
        suiteName = suite;
        isPublic = aPublic;
        isWritable = aWritable;
    }

    public static Vector loadLogFromRMS() {
        if (recordName == null) {
            return null;
        }
        RecordStore store = null;
        byte[] data = null;
        Vector<String> ret = new Vector<String>();
        try {
            store = vendorName != null && suiteName != null ? RecordStore.openRecordStore((String)recordName, (boolean)false) : RecordStore.openRecordStore((String)recordName, (boolean)false);
            int numRecords = store.getNumRecords();
            for (int i = 0; i <= numRecords; ++i) {
                data = null;
                try {
                    data = store.getRecord(i);
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (data == null) continue;
                ret.addElement(new String(data));
            }
        }
        catch (Exception e) {
            TAGit.sendToConsole("Can't open record store: " + recordName);
            e.printStackTrace();
        }
        if (store != null) {
            try {
                store.closeRecordStore();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (ret.size() == 0) {
            ret = null;
        }
        return ret;
    }

    public static boolean clearLogFromRMS() {
        try {
            RecordStore.deleteRecordStore((String)recordName);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean logToRMS(String logLine) {
        if (recordName == null) {
            return false;
        }
        RecordStore store = null;
        boolean ret = false;
        try {
            if (logLine != null) {
                store = RecordStore.openRecordStore((String)recordName, (boolean)true, (int)(isPublic ? 1 : 0), (boolean)isWritable);
                byte[] data = logLine.getBytes();
                store.addRecord(data, 0, data.length);
                ret = true;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (store != null) {
            try {
                store.closeRecordStore();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return ret;
    }

    private Logger() {
    }

    public static boolean isDebug() {
        return debug;
    }

    public static void info(String message) {
        if (logToRMS) {
            Logger.logToRMS("INFO: " + message);
        }
    }

    public static void trace(String message) {
        if (logToRMS) {
            Logger.logToRMS("TRACE: " + message);
        }
    }

    public static void info(String message, Throwable t) {
        if (debug) {
            t.printStackTrace();
        }
        if (logToRMS) {
            Logger.logToRMS("INFO: " + message + ": " + t.getMessage());
        }
    }

    public static void error(String message) {
        if (logToRMS) {
            Logger.logToRMS("ERROR: " + message);
        }
    }

    public static void error(String message, Throwable t) {
        if (debug) {
            t.printStackTrace();
        }
        if (logToRMS) {
            Logger.logToRMS("ERROR: " + message + ": " + t.getMessage());
        }
    }
}

