/*
 * Decompiled with CFR 0.152.
 */
package tagit;

import java.util.Enumeration;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import tagit.CanvasButton;
import tagit.HelpScreen;
import tagit.Keys;
import tagit.ResourceName;
import tagit.ResourceText;
import tagit.SelectionMenu;
import tagit.TAGit;
import tagit.TouchScreenButton;
import tagit.TouchScreenSoftKey;

public class HelpMenu
extends SelectionMenu
implements CanvasButton {
    private Image helpHeader;
    private Image menuItemImage;
    private TAGit midlet;
    private SelectionMenu.MenuTile mtile;
    private Graphics gr;
    private int MENU_ITEMS;
    private int labelScrollLen;
    private int labelLength;
    private int scrollPtr = 0;
    private int itemSelected = 0;
    private String labelInfo;
    private Enumeration enu;
    private static int PANEL_TEXT_OFFSET = 4;
    private Vector textResource;
    private HelpScreen helpItemDetail;
    private TimerTask flipper = null;
    private Timer timer = new Timer();
    private boolean initted = false;
    private static Vector touchScreenButtonCue;
    private static boolean deviceUsesTouchScreen;
    private TouchScreenSoftKey lsk;
    private TouchScreenSoftKey rsk;

    public HelpMenu(TAGit midlet) {
        try {
            this.textResource = new Vector();
            this.setFullScreenMode(true);
            this.midlet = midlet;
            PANEL_TEXT_OFFSET = TAGit.font.stringWidth(" ");
        }
        catch (Exception e) {
            TAGit.IMerror("helpmenu.helpmenu: " + e.toString());
        }
    }

    public void sizeChanged(int width, int height) {
        try {
            this.midlet.sizeChanged(width, height);
            this.initted = false;
            this.clearOldVectors();
            this.repaint();
        }
        catch (Exception e) {
            TAGit.IMerror("helpmenu.sizechanged: " + e.toString());
        }
    }

    private void clearOldVectors() {
        try {
            touchScreenButtonCue = null;
            this.activeItems = null;
            System.gc();
        }
        catch (Exception e) {
            TAGit.IMerror("helpmenu.clearoldvectors: " + e.toString());
        }
    }

    private void init() {
        try {
            if (this.hasPointerEvents()) {
                deviceUsesTouchScreen = true;
                touchScreenButtonCue = new Vector();
            }
            if (this.activeItems == null) {
                this.activeItems = new Vector();
            }
            try {
                this.helpHeader = TAGit.createImage(ResourceName.HELP_HEADER_IMAGE);
                this.lsk = new TouchScreenSoftKey("Back", false);
                this.rsk = new TouchScreenSoftKey("Select", true);
                int fontHeight = Font.getFont((int)0).getHeight();
                int imageHeight = fontHeight + 2 * PANEL_TEXT_OFFSET;
                this.menuItemImage = Image.createImage((int)TAGit.globalScreenWidth, (int)imageHeight);
                this.textResource.addElement(ResourceText.HELP_OPTION1_DETAILTEXT);
                this.textResource.addElement(ResourceText.HELP_OPTION2_DETAILTEXT);
                this.textResource.addElement(ResourceText.HELP_OPTION3_DETAILTEXT);
                this.textResource.addElement(" MusicID " + this.midlet.getProperty("MIDlet-Version") + "  " + System.getProperty("microedition.platform") + "\n" + this.midlet.getProperty("MIDlet-Vendor"));
                this.activeItems.addElement(ResourceText.HELP_OPTION1_TEXT);
                this.activeItems.addElement(ResourceText.HELP_OPTION2_TEXT);
                this.activeItems.addElement(ResourceText.HELP_OPTION3_TEXT);
                this.activeItems.addElement(ResourceText.HELP_OPTION4_TEXT);
                this.MENU_ITEMS = this.activeItems.size();
                System.gc();
                if (deviceUsesTouchScreen) {
                    int menuStart = this.helpHeader.getHeight();
                    touchScreenButtonCue.addElement(new TouchScreenButton(ResourceText.HELP_OPTION1_TEXT, 0, menuStart, TAGit.globalScreenWidth, menuStart + imageHeight));
                    touchScreenButtonCue.addElement(new TouchScreenButton(ResourceText.HELP_OPTION2_TEXT, 0, menuStart + imageHeight, TAGit.globalScreenWidth, menuStart + imageHeight * 2));
                    touchScreenButtonCue.addElement(new TouchScreenButton(ResourceText.HELP_OPTION3_TEXT, 0, menuStart + imageHeight * 2, TAGit.globalScreenWidth, menuStart + imageHeight * 3));
                    touchScreenButtonCue.addElement(new TouchScreenButton(ResourceText.HELP_OPTION4_TEXT, 0, menuStart + imageHeight * 3, TAGit.globalScreenWidth, menuStart + imageHeight * 4));
                }
                this.initted = true;
            }
            catch (Exception e) {
                TAGit.IMerror("Error initializing help menu: " + e.toString());
            }
        }
        catch (Exception e) {
            TAGit.IMerror("helpmenu.helpmenu: " + e.toString());
        }
    }

    protected void pointerPressed(int x, int y) {
        this.midlet.vibrateForPointerPressed();
        try {
            for (int c = 0; c < touchScreenButtonCue.size(); ++c) {
                TouchScreenButton tempButton = (TouchScreenButton)touchScreenButtonCue.elementAt(c);
                if (!tempButton.selectThisButton(x, y) || c >= 4) continue;
                if (this.itemSelected != c) {
                    this.itemSelected = c;
                    this.runButton(tempButton);
                    continue;
                }
                this.selectItem();
                return;
            }
            if (this.lsk.selectThisButton(x, y)) {
                this.goBack();
                return;
            }
            if (this.rsk.selectThisButton(x, y)) {
                this.selectItem();
                return;
            }
        }
        catch (Exception e) {
            TAGit.IMerror("helpmenu.pointerpressed: " + e.toString());
        }
    }

    protected void keyPressed(int keyCode) {
        this.midlet.vibrateForKeyPressed();
        try {
            if (!this.initted) {
                this.init();
            }
            switch (this.getGameAction(keyCode)) {
                case 1: {
                    this.up();
                    break;
                }
                case 8: {
                    this.selectItem();
                    break;
                }
                case 6: {
                    this.down();
                }
            }
            if (Keys.isBackKey(keyCode)) {
                this.goBack();
            } else if (this.lsk.keyPressed(keyCode)) {
                this.goBack();
            } else if (this.rsk.keyPressed(keyCode)) {
                this.selectItem();
            }
            this.repaint();
        }
        catch (Exception e) {
            TAGit.IMerror("helpmenu.keypressed: " + e.toString());
        }
    }

    private void up() {
        this.itemSelected = this.itemSelected == 0 ? this.MENU_ITEMS - 1 : --this.itemSelected;
    }

    private void down() {
        this.itemSelected = (this.itemSelected + 1) % this.MENU_ITEMS;
    }

    private void goBack() {
        this.stop();
        this.midlet.display.setCurrent(this.midlet.displayStore.popDisplay("helpmenu.keypressed"));
    }

    public void fire() {
        this.selectItem();
    }

    private void selectItem() {
        try {
            if (this.helpItemDetail == null) {
                this.helpItemDetail = new HelpScreen(this.midlet, this.itemSelected);
            } else {
                this.helpItemDetail.setSelectionTo(this.itemSelected);
            }
            this.midlet.displayStore.addDisplay((Displayable)this);
            this.midlet.display.setCurrent((Displayable)this.helpItemDetail);
        }
        catch (Exception e) {
            TAGit.IMerror("Error initializing help screen: " + e.toString());
        }
    }

    public void showNotify() {
        try {
            if (!TAGit.callFullScreenOnlyOnce) {
                this.setFullScreenMode(true);
            }
            if (!this.initted) {
                this.init();
            }
            this.repaint();
        }
        catch (Exception e) {
            TAGit.IMerror("helpmenu.shownotify: " + e.toString());
        }
    }

    public void hideNotify() {
        try {
            this.helpHeader = null;
            this.menuItemImage = null;
            this.activeItems.removeAllElements();
            this.textResource.removeAllElements();
            System.gc();
            this.initted = false;
        }
        catch (Exception e) {
            TAGit.IMerror("helpmenu.hidenotify: " + e.toString());
        }
    }

    public void stop() {
        this.checkFlipper();
    }

    public void paint(Graphics g) {
        try {
            TAGit.paintEmulatorExtras(g);
            g.setFont(TAGit.font);
            this.midlet.updateMemStatus();
            if (!this.initted) {
                this.init();
            }
            if (this.flipper == null) {
                this.flipper = new Flipper(g, this);
                this.timer.scheduleAtFixedRate(this.flipper, 0L, 50L);
            }
            g.setColor(255, 255, 255);
            g.fillRect(0, 0, TAGit.globalScreenWidth, TAGit.globalScreenHeight);
            this.mtile = null;
            g.drawImage(this.helpHeader, 0, 0, 20);
            this.lsk.draw(g);
            this.rsk.draw(g);
            g.setColor(0, 0, 0);
            int i = 0;
            this.enu = this.activeItems.elements();
            while (this.enu.hasMoreElements()) {
                if (i == this.itemSelected) {
                    g.setColor(255, 0, 0);
                } else {
                    g.setColor(255, 255, 255);
                }
                this.gr = this.menuItemImage.getGraphics();
                this.gr.setFont(TAGit.font);
                if (this.itemSelected == i) {
                    this.gr.setColor(255, 225, 92);
                    this.labelInfo = (String)this.activeItems.elementAt(this.itemSelected);
                    this.labelLength = TAGit.font.stringWidth(this.labelInfo);
                    this.labelScrollLen = TAGit.globalScreenWidth - this.labelLength - PANEL_TEXT_OFFSET;
                    this.labelScrollLen = this.labelScrollLen < 0 ? Math.abs(this.labelScrollLen) + 2 * TAGit.font.stringWidth("O") : 0;
                } else {
                    this.gr.setColor(255, 255, 255);
                }
                this.gr.fillRect(0, 0, this.menuItemImage.getWidth(), this.menuItemImage.getHeight());
                this.gr.setColor(0, 0, 0);
                if (this.labelScrollLen > 0 && this.itemSelected == i) {
                    this.gr.setClip(0, 0 + PANEL_TEXT_OFFSET, this.menuItemImage.getWidth(), this.menuItemImage.getHeight());
                    this.gr.drawString((String)this.enu.nextElement(), 0 - this.scrollPtr, 0 + PANEL_TEXT_OFFSET, 20);
                    this.gr.setClip(0, 0, TAGit.globalScreenWidth, TAGit.globalScreenHeight);
                } else {
                    String line = (String)this.enu.nextElement();
                    int line_x = (TAGit.globalScreenWidth - TAGit.font.stringWidth(line)) / 2;
                    this.gr.drawString(line, line_x, 0 + PANEL_TEXT_OFFSET, 20);
                }
                g.drawImage(this.menuItemImage, 0, i * this.menuItemImage.getHeight() + this.helpHeader.getHeight(), 20);
                ++i;
            }
        }
        catch (Exception e) {
            TAGit.IMerror("helpmenu.paint: " + e.toString());
        }
        TAGit.drawPreReleaseBanner(g);
    }

    public void checkFlipper() {
        if (this.flipper != null) {
            this.flipper.cancel();
            this.flipper = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runButton(TouchScreenButton tsb) {
        try {
            HelpMenu helpMenu = this;
            synchronized (helpMenu) {
                Thread th = new Thread(tsb);
                tsb.setMonitor(this);
                th.run();
            }
        }
        catch (Exception e) {
            TAGit.IMerror("helpmenu.runbutton: " + e.toString());
        }
    }

    public boolean externalPaintCall() {
        try {
            this.repaint();
            this.serviceRepaints();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    static {
        deviceUsesTouchScreen = false;
    }

    class Flipper
    extends TimerTask {
        private Graphics g = null;
        private HelpMenu helpObj;

        public Flipper(Graphics g, HelpMenu helpObj) {
            this.g = g;
            this.helpObj = helpObj;
        }

        public void run() {
            try {
                this.helpObj.scrollPtr++;
                this.helpObj.repaint();
                if (this.helpObj.labelInfo != null && this.helpObj.scrollPtr > this.helpObj.labelScrollLen) {
                    this.helpObj.scrollPtr = 0;
                }
            }
            catch (Exception e) {
                HelpMenu.this.midlet;
                TAGit.IMerror("helpmenu.flipper.run: " + e.toString());
            }
        }
    }
}

