/*
 * Decompiled with CFR 0.152.
 */
package tagit;

import java.util.Enumeration;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import tagit.CanvasButton;
import tagit.Keys;
import tagit.ResourceName;
import tagit.ResourceText;
import tagit.SelectionMenu;
import tagit.SongIDCollector;
import tagit.TAGit;
import tagit.Tag;
import tagit.TouchScreenButton;
import tagit.TouchScreenSoftKey;

public class MyIDsForm
extends SelectionMenu
implements CanvasButton {
    private TAGit midlet;
    private static int PANEL_TEXT_OFFSET = 4;
    private static int DATE_OFFSET = 15;
    private int subMenuX = 0;
    private int subMenuY;
    private int subMenuWidth;
    private int subMenuHeight;
    private Image manageHeader;
    private Image menuItemImage;
    private Image subMenuItemImage;
    private static int itemSelected = 0;
    private static int subItemSelected;
    private int numMenuItems;
    private int maxMenuItems;
    private static int menuItemBase;
    private static int displayItems;
    private int charsPerItem;
    private Tag tag;
    private SongIDCollector sidCollector;
    private Vector itemTags;
    private Vector subMenuItems;
    private Graphics gr;
    private Enumeration e;
    private int dateWidth;
    private int dateLength;
    private int menuItemHeight;
    public String songInfo;
    public int scrollPtr = -40;
    private int lastSelected = 0;
    private boolean drawSubMenu = false;
    private int numSubMenuItems;
    private int songInfoLength = 0;
    private int index;
    private TimerTask flipper = null;
    private Timer timer = new Timer();
    private boolean initted = false;
    public static final int NOKIA_DELETE = -8;
    public static final int NOKIA_BACKSPACE = 8;
    private Vector menuItemButtons;
    private static final int ALT_FOOTER_H;
    private static int footerHeight;
    private static boolean repaintMe;
    private TouchScreenSoftKey lsk;
    private TouchScreenSoftKey rsk;

    public MyIDsForm(TAGit midlet) {
        try {
            this.midlet = midlet;
            this.setFullScreenMode(true);
            PANEL_TEXT_OFFSET = TAGit.font.stringWidth(" ");
            DATE_OFFSET = TAGit.font.stringWidth("   ");
            this.menuItemButtons = new Vector();
        }
        catch (Exception e) {
            TAGit.IMerror("myidform.myidsform: " + e.toString() + ":" + e.getMessage());
        }
    }

    public void sizeChanged(int x, int y) {
        this.midlet.sizeChanged(x, y);
        this.initted = false;
        this.repaint();
    }

    protected void init() {
        try {
            this.manageHeader = TAGit.createImage(ResourceName.MANAGE_HEADER_IMAGE);
            this.sidCollector = this.midlet.getIDCollector();
            this.lsk = null;
            this.rsk = null;
            System.gc();
            if (this.sidCollector.getTagStore().getNumRecords() > 0) {
                this.lsk = new TouchScreenSoftKey("Back", false);
                this.rsk = new TouchScreenSoftKey("Options", true);
            } else {
                this.lsk = new TouchScreenSoftKey("Back", false);
                this.rsk = new TouchScreenSoftKey("", true);
            }
            footerHeight = ALT_FOOTER_H;
            this.setSubMenu();
            this.menuItemImage = null;
            int fontHeight = TAGit.font.getHeight();
            this.menuItemHeight = fontHeight + 2 * PANEL_TEXT_OFFSET;
            this.menuItemImage = Image.createImage((int)this.getWidth(), (int)this.menuItemHeight);
            this.maxMenuItems = (TAGit.globalScreenHeight - this.manageHeader.getHeight() - footerHeight) / this.menuItemHeight;
            this.charsPerItem = this.getWidth() / TAGit.font.charWidth('X');
            this.itemTags = new Vector();
            this.updateList();
            this.initted = true;
        }
        catch (Exception e) {
            TAGit.IMerror("myidform.init: " + e.toString() + ":" + e.getMessage());
        }
    }

    public void setSubMenu() {
        try {
            if (this.subMenuItems == null) {
                this.subMenuItems = new Vector();
            } else {
                this.subMenuItems.removeAllElements();
            }
            this.subMenuItems.addElement(new String(ResourceText.MYIDS_SUBMENUITEM1_TEXT));
            this.subMenuItems.addElement(new String(ResourceText.MYIDS_SUBMENUITEM2_TEXT));
            this.subMenuItems.addElement(new String(ResourceText.MYIDS_SUBMENUITEM3_TEXT));
            this.numSubMenuItems = this.subMenuItems.size();
            this.subMenuItemImage = null;
            int fontHeight = TAGit.font.getHeight();
            int subMenuImageHeight = fontHeight + 2 * PANEL_TEXT_OFFSET;
            this.subMenuWidth = this.getWidth() / 2;
            if (!TAGit.weNeedToFlipSoftKeys) {
                this.subMenuX = this.subMenuWidth;
            }
            this.subMenuHeight = subMenuImageHeight * this.numSubMenuItems;
            this.subMenuY = TAGit.globalScreenHeight - footerHeight - this.subMenuHeight;
            this.subMenuItemImage = Image.createImage((int)this.subMenuWidth, (int)subMenuImageHeight);
        }
        catch (Exception e) {
            TAGit.IMerror("myidform.setsubmenu: " + e.toString() + ":" + e.getMessage());
        }
    }

    public void updateList() {
        try {
            if (this.sidCollector == null) {
                this.sidCollector = this.midlet.getIDCollector();
            }
            try {
                this.itemTags = this.sidCollector.collectSongIDs();
            }
            catch (Exception e) {
                TAGit.IMerror("Error collecting song IDs: " + e.toString());
            }
            this.numMenuItems = this.itemTags.size();
        }
        catch (Exception e) {
            TAGit.IMerror("myidform.updatelist: " + e.toString() + ":" + e.getMessage());
        }
    }

    public void showNotify() {
        try {
            TAGit.IMinfo("CALLED SHOWNOTIFY");
            if (!TAGit.callFullScreenOnlyOnce) {
                this.setFullScreenMode(true);
            }
            if (!this.initted) {
                this.init();
            }
            this.updateList();
            this.sidCollector.setRecordAdded(false);
            this.sidCollector.setRecordsUpdated(false);
            this.scrollPtr = -40;
            this.repaint();
        }
        catch (Exception e) {
            TAGit.IMerror("myidform.shownotify: " + e.toString() + ":" + e.getMessage());
        }
    }

    public void checkFlipper() {
        if (this.flipper != null) {
            this.flipper.cancel();
            this.flipper = null;
        }
    }

    public void stop() {
        this.checkFlipper();
    }

    public void hideNotify() {
        try {
            TAGit.IMinfo("CALLED HIDENOTIFY");
            this.checkFlipper();
            this.manageHeader = null;
            this.sidCollector = null;
            this.subMenuItems.removeAllElements();
            this.menuItemImage = null;
            this.initted = false;
            System.gc();
        }
        catch (Exception e) {
            TAGit.IMerror("myidform.hidenotify: " + e.toString() + ":" + e.getMessage());
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void keyPressed(int keyCode) {
        this.midlet.vibrateForKeyPressed();
        try {
            block22: {
                block23: {
                    block21: {
                        if (this.drawSubMenu) break block21;
                        switch (this.getGameAction(keyCode)) {
                            case 1: {
                                if (MyIDsForm.itemSelected == 0) {
                                    MyIDsForm.itemSelected = this.numMenuItems - 1;
                                    break;
                                }
                                --MyIDsForm.itemSelected;
                                break;
                            }
                            case 8: {
                                this.fire();
                                break;
                            }
                            case 6: {
                                if (this.numMenuItems == 0) break;
                                MyIDsForm.itemSelected = (MyIDsForm.itemSelected + 1) % this.numMenuItems;
                            }
                        }
                        break block22;
                    }
                    if (this.midlet.getManufacturer() == 6) break block23;
                    if (this.midlet.getManufacturer() != 8) ** GOTO lbl-1000
                }
                if (Keys.isBackKey(keyCode) || Keys.isDeleteKey(keyCode)) {
                    this.drawSubMenu = false;
                } else lbl-1000:
                // 2 sources

                {
                    switch (this.getGameAction(keyCode)) {
                        case 1: {
                            if (MyIDsForm.subItemSelected == 0) {
                                MyIDsForm.subItemSelected = this.numSubMenuItems - 1;
                                break;
                            }
                            --MyIDsForm.subItemSelected;
                            break;
                        }
                        case 8: {
                            this.fire();
                            break;
                        }
                        case 6: {
                            MyIDsForm.subItemSelected = (MyIDsForm.subItemSelected + 1) % this.numSubMenuItems;
                        }
                    }
                }
            }
            if (Keys.isBackKey(keyCode)) {
                this.goBack();
            } else if (this.lsk.keyPressed(keyCode)) {
                this.goBack();
            } else if (this.rsk.keyPressed(keyCode)) {
                this.openOptionsMenu();
            }
            this.repaint();
        }
        catch (Exception e) {
            TAGit.IMerror("myidform.keypressed: " + e.toString() + ":" + e.getMessage());
        }
    }

    private void openOptionsMenu() {
        this.drawSubMenu = !this.drawSubMenu;
    }

    private void goBack() {
        this.drawSubMenu = false;
        this.midlet.display.setCurrent(this.midlet.displayStore.popDisplay("myidform.goback: "));
    }

    public void fire() {
        try {
            if (this.drawSubMenu) {
                System.gc();
                if (subItemSelected == 0) {
                    this.midlet.displayStore.addDisplay((Displayable)this);
                    this.midlet.showTagResults((Tag)this.itemTags.elementAt(itemSelected));
                } else if (subItemSelected == 1) {
                    this.itemTags = this.sidCollector.deleteRecord(((Tag)this.itemTags.elementAt(itemSelected)).getTagID());
                    this.numMenuItems = this.itemTags.size();
                    if (this.numMenuItems < 1) {
                        this.init();
                        this.updateList();
                    }
                    this.scrollPtr = -40;
                    this.drawSubMenu = false;
                    itemSelected = itemSelected == 0 ? this.numMenuItems - 1 : --itemSelected;
                    this.repaint();
                } else if (subItemSelected == 2) {
                    TAGit.IMinfo("CALLED NEW ID");
                    this.midlet.restartRecordForm((Displayable)this);
                }
                this.drawSubMenu = false;
            } else {
                System.gc();
                this.midlet.displayStore.addDisplay((Displayable)this);
                this.midlet.showTagResults((Tag)this.itemTags.elementAt(itemSelected));
            }
        }
        catch (Exception e) {
            TAGit.IMerror("myidsform.fire" + e.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics g) {
        g.setFont(TAGit.font);
        this.midlet.updateMemStatus();
        try {
            TAGit.paintEmulatorExtras(g);
            this.menuItemButtons.removeAllElements();
            if (!this.initted) {
                this.init();
            }
            if (!TAGit.callFullScreenOnlyOnce) {
                this.setFullScreenMode(true);
            }
            MyIDsForm myIDsForm = this;
            synchronized (myIDsForm) {
                if (this.lastSelected != itemSelected) {
                    this.lastSelected = itemSelected;
                    this.scrollPtr = -40;
                }
            }
            if (this.flipper == null) {
                this.flipper = new Flipper(this);
                this.timer.scheduleAtFixedRate(this.flipper, 1000L, 50L);
            }
            g.setColor(255, 255, 255);
            g.fillRect(0, 0, TAGit.globalScreenWidth, TAGit.globalScreenHeight);
            SelectionMenu.MenuTile mtile = null;
            this.e = this.activeItems.elements();
            while (this.e.hasMoreElements()) {
                mtile = (SelectionMenu.MenuTile)this.e.nextElement();
                g.drawImage(mtile.getImage(), mtile.getX(), mtile.getY(), 20);
                g.setColor(255, 255, 0);
            }
            if (this.numMenuItems > 0) {
                int item_y;
                if (itemSelected >= menuItemBase + this.maxMenuItems) {
                    menuItemBase = itemSelected - this.maxMenuItems + 1;
                } else if (itemSelected < menuItemBase) {
                    menuItemBase = itemSelected;
                }
                g.setFont(TAGit.font);
                g.setColor(255, 255, 255);
                this.gr = this.menuItemImage.getGraphics();
                this.gr.setFont(TAGit.font);
                this.index = 0;
                displayItems = this.numMenuItems < this.maxMenuItems ? this.numMenuItems : this.maxMenuItems;
                try {
                    for (int j = menuItemBase; j < menuItemBase + displayItems; ++j) {
                        this.index = j - menuItemBase;
                        if (j == itemSelected) {
                            g.setColor(255, 0, 0);
                            this.gr.setColor(255, 225, 92);
                        } else {
                            g.setColor(255, 255, 255);
                            this.gr.setColor(255, 255, 255);
                        }
                        this.gr.fillRect(0, 0, this.menuItemImage.getWidth(), this.menuItemImage.getHeight());
                        this.gr.setColor(255, 225, 92);
                        this.gr.drawRect(0, 0, this.menuItemImage.getWidth(), this.menuItemImage.getHeight());
                        this.gr.setColor(0, 0, 0);
                        this.tag = (Tag)this.itemTags.elementAt(j);
                        this.gr.drawString(this.tag.getTagIDDate(), PANEL_TEXT_OFFSET, 0 + PANEL_TEXT_OFFSET, 20);
                        this.dateWidth = TAGit.font.stringWidth(this.tag.getTagIDDate());
                        this.dateLength = this.tag.getTagIDDate().length();
                        this.songInfo = this.tag.getTrack() + "   " + this.tag.getArtist();
                        if (j == itemSelected && this.songInfo.length() > this.charsPerItem - this.dateLength - 2) {
                            this.songInfoLength = TAGit.font.stringWidth(this.songInfo);
                            this.gr.setClip(PANEL_TEXT_OFFSET + this.dateWidth + DATE_OFFSET, 0 + PANEL_TEXT_OFFSET, this.menuItemImage.getWidth(), this.menuItemImage.getHeight());
                            int scrollPos = 0;
                            MyIDsForm myIDsForm2 = this;
                            synchronized (myIDsForm2) {
                                scrollPos = this.scrollPtr;
                            }
                            if (scrollPos < 0) {
                                scrollPos = 0;
                            }
                            this.gr.drawString(this.songInfo, PANEL_TEXT_OFFSET + this.dateWidth + DATE_OFFSET - scrollPos, 0 + PANEL_TEXT_OFFSET, 20);
                            this.gr.setClip(0, 0, TAGit.globalScreenWidth, TAGit.globalScreenHeight);
                        } else {
                            this.gr.drawString(this.songInfo, PANEL_TEXT_OFFSET + this.dateWidth + DATE_OFFSET, 0 + PANEL_TEXT_OFFSET, 20);
                        }
                        item_y = this.index * this.menuItemImage.getHeight() + this.manageHeader.getHeight();
                        g.drawImage(this.menuItemImage, 0, item_y, 20);
                        this.menuItemButtons.addElement(new TouchScreenButton("" + j, this.menuItemImage, 0, item_y));
                        this.tag = null;
                    }
                }
                catch (Exception e) {
                    TAGit.IMerror("myidform.paintsub1: " + e.toString());
                }
                if (this.drawSubMenu) {
                    this.menuItemButtons.removeAllElements();
                    g.setColor(0, 0, 0);
                    g.fillRect(this.subMenuX - PANEL_TEXT_OFFSET, this.subMenuY - PANEL_TEXT_OFFSET, this.subMenuWidth + PANEL_TEXT_OFFSET + PANEL_TEXT_OFFSET, this.subMenuHeight + PANEL_TEXT_OFFSET);
                    g.setColor(255, 255, 255);
                    g.fillRect(this.subMenuX, this.subMenuY, this.subMenuWidth, this.subMenuHeight);
                    int i = 0;
                    try {
                        this.e = this.subMenuItems.elements();
                        while (this.e.hasMoreElements()) {
                            if (i == subItemSelected) {
                                g.setColor(255, 0, 0);
                            } else {
                                g.setColor(255, 255, 255);
                            }
                            this.gr = this.subMenuItemImage.getGraphics();
                            g.setFont(TAGit.font);
                            if (subItemSelected == i) {
                                this.gr.setColor(255, 225, 92);
                            } else {
                                this.gr.setColor(255, 255, 255);
                            }
                            this.gr.fillRect(0, 0, this.subMenuItemImage.getWidth(), this.subMenuItemImage.getHeight());
                            this.gr.setColor(0, 0, 0);
                            this.gr.drawString((String)this.e.nextElement(), PANEL_TEXT_OFFSET, PANEL_TEXT_OFFSET, 20);
                            item_y = i * this.subMenuItemImage.getHeight() + this.subMenuY;
                            g.drawImage(this.subMenuItemImage, this.subMenuX, item_y, 20);
                            this.menuItemButtons.addElement(new TouchScreenButton("" + this.e, this.subMenuItemImage, this.subMenuX, item_y));
                            ++i;
                        }
                    }
                    catch (Exception e) {
                        TAGit.IMerror("myidform.paintsub2: " + e.toString());
                    }
                }
            }
            this.gr = null;
            g.drawImage(this.manageHeader, 0, 0, 20);
            this.lsk.draw(g);
            this.rsk.draw(g);
        }
        catch (Exception e) {
            TAGit.IMerror("myidform.paint: " + e.toString() + ":" + e.getMessage());
        }
        TAGit.drawPreReleaseBanner(g);
    }

    protected void pointerPressed(int x, int y) {
        this.midlet.vibrateForPointerPressed();
        try {
            for (int c = 0; c < this.menuItemButtons.size(); ++c) {
                TouchScreenButton tempButton = (TouchScreenButton)this.menuItemButtons.elementAt(c);
                if (!tempButton.selectThisButton(x, y)) continue;
                if (!this.drawSubMenu) {
                    if (itemSelected != c) {
                        itemSelected = c;
                        this.runButton(tempButton);
                        continue;
                    }
                    this.fire();
                    return;
                }
                System.gc();
                if (c == 0) {
                    this.midlet.displayStore.addDisplay((Displayable)this);
                    this.midlet.showTagResults((Tag)this.itemTags.elementAt(itemSelected));
                } else if (c == 1) {
                    this.itemTags = this.sidCollector.deleteRecord(((Tag)this.itemTags.elementAt(itemSelected)).getTagID());
                    this.numMenuItems = this.itemTags.size();
                    if (this.numMenuItems < 1) {
                        this.init();
                        this.updateList();
                    }
                    this.scrollPtr = -40;
                    this.drawSubMenu = false;
                    itemSelected = itemSelected == 0 ? this.numMenuItems - 1 : --itemSelected;
                    this.repaint();
                } else if (c == 2) {
                    this.midlet.restartRecordForm((Displayable)this);
                }
                this.drawSubMenu = false;
            }
            if (this.lsk.selectThisButton(x, y)) {
                this.goBack();
                return;
            }
            if (this.rsk.selectThisButton(x, y)) {
                this.openOptionsMenu();
            }
        }
        catch (Exception e) {
            TAGit.IMerror("mainmenu.pointerpressed: " + e.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runButton(TouchScreenButton tsb) {
        MyIDsForm myIDsForm = this;
        synchronized (myIDsForm) {
            Thread th = new Thread(tsb);
            tsb.setMonitor(this);
            th.run();
        }
    }

    public boolean externalPaintCall() {
        try {
            this.repaint();
            this.serviceRepaints();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    static {
        menuItemBase = 0;
        ALT_FOOTER_H = TAGit.font.getHeight() + 4;
        repaintMe = false;
    }

    class Flipper
    extends TimerTask {
        private MyIDsForm myIdObj;

        public Flipper(MyIDsForm myIdObj) {
            this.myIdObj = myIdObj;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            MyIDsForm myIDsForm = this.myIdObj;
            synchronized (myIDsForm) {
                ++this.myIdObj.scrollPtr;
                this.myIdObj.repaint();
                if (this.myIdObj.songInfo != null && this.myIdObj.scrollPtr > this.myIdObj.songInfoLength) {
                    this.myIdObj.scrollPtr = -40;
                }
            }
        }
    }
}

