/*
 * Decompiled with CFR 0.152.
 */
package tagit;

import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import tagit.Keys;
import tagit.ResourceName;
import tagit.TAGit;
import tagit.TouchScreenSoftKey;

public class NoMatchCanvas
extends Canvas {
    TAGit midlet;
    private static Image header = null;
    private static Image body = null;
    private static boolean initted = false;
    private TouchScreenSoftKey lsk;
    private TouchScreenSoftKey rsk;

    public NoMatchCanvas(TAGit midlet) {
        this.setFullScreenMode(true);
        this.midlet = midlet;
        this.repaint();
    }

    private void init() {
        try {
            this.lsk = new TouchScreenSoftKey("Back", false);
            this.rsk = new TouchScreenSoftKey("New ID", true);
            body = TAGit.createImage(ResourceName.TAG_NOMATCH_IMAGE);
            header = TAGit.createImage(ResourceName.MAINMENU_HEADER_IMAGE);
            initted = true;
        }
        catch (Exception e) {
            this.midlet.IMerror("NoMatchCanvas.init: " + e.toString(), (Displayable)this);
        }
    }

    public void sizeChanged(int x, int y) {
        this.midlet.sizeChanged(x, y);
        initted = false;
        this.repaint();
    }

    public void pointerPressed(int x, int y) {
        this.midlet.vibrateForPointerPressed();
        if (this.lsk.selectThisButton(x, y)) {
            this.goBack();
        } else if (this.rsk.selectThisButton(x, y)) {
            this.IDSong();
        }
    }

    public void paint(Graphics g) {
        try {
            this.midlet.updateMemStatus();
            if (!initted) {
                this.init();
            }
            g.setFont(TAGit.font);
            TAGit.paintEmulatorExtras(g);
            g.setColor(255, 255, 255);
            g.fillRect(0, 0, TAGit.globalScreenWidth, TAGit.globalScreenHeight);
            if (header != null) {
                g.drawImage(header, 0, 0, 20);
            }
            if (body != null) {
                g.drawImage(body, TAGit.globalScreenWidth / 2, this.calculateY(), 3);
            }
            this.lsk.draw(g);
            this.rsk.draw(g);
        }
        catch (Exception e) {
            this.midlet.IMerror("NoMatchCanvas.paint: " + e.toString(), (Displayable)this);
        }
        TAGit.drawPreReleaseBanner(g);
    }

    private int calculateY() {
        return (TAGit.globalScreenHeight - header.getHeight() - this.lsk.getHeight()) / 2 + header.getHeight();
    }

    public void keyPressed(int keyCode) {
        this.midlet.vibrateForKeyPressed();
        try {
            if (Keys.isBackKey(keyCode) || Keys.isBackKey(keyCode)) {
                this.goBack();
            } else if (this.lsk.keyPressed(keyCode)) {
                this.goBack();
            } else if (this.rsk.keyPressed(keyCode)) {
                this.IDSong();
            }
            this.repaint();
        }
        catch (Exception e) {
            this.midlet.IMerror("NoMatchCanvas.keypressed: " + e.toString(), (Displayable)this);
        }
    }

    private void IDSong() {
        this.midlet.restartRecordForm((Displayable)this.midlet.displayable);
    }

    private void goBack() {
        this.midlet.display.setCurrent(this.midlet.displayStore.popDisplay("NoMatchCanvas.keypressed: "));
    }

    public void hideNotify() {
        initted = false;
    }

    public void showNotify() {
        try {
            if (!TAGit.callFullScreenOnlyOnce) {
                this.setFullScreenMode(true);
            }
            this.repaint();
        }
        catch (Exception e) {
            this.midlet.IMerror("NoMatchCanvas.showNotify: " + e.toString(), (Displayable)this);
        }
    }
}

