/*
 * Decompiled with CFR 0.152.
 */
package tagit;

import com.nokia.mid.ui.DeviceControl;
import java.io.InputStream;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;
import javax.microedition.media.control.VolumeControl;
import tagit.AudioSubmission;
import tagit.ResourceName;
import tagit.ResourceText;
import tagit.SongIDCollector;
import tagit.TAGit;
import tagit.Tag;
import tagit.TagRecorder;

public class RecordForm
extends Canvas
implements Runnable {
    private static final int ANIM_STEP = 15;
    private static final int RECORD_MESG_TIME = 2000;
    public static int AUDIO_PLAYER_VOLUME;
    private static final String startTrack = "Startrecord";
    private static final String transmitTrack = "transmit";
    private static final String recordingType = ".amr";
    public static boolean atWill;
    public static boolean recording;
    public static boolean suspended;
    private static boolean running;
    private static boolean mediaException;
    private Image instructions;
    private Image recordingBG;
    private Image analyzingBG;
    private Image recordingAnimation;
    private Image analyzingAnimation;
    private static Image shazamLogo;
    private static int framePause;
    private static int animX;
    private int ANIMATION_OFFSET = 0;
    private TAGit midlet;
    private Tag tag = new Tag(null, null, null);
    private SongIDCollector sidCollector;
    private AudioSubmission audioSubmit;
    private TagRecorder tagRecorder;
    public Thread th = null;
    private byte[] recordData;
    private Player player;
    private long startTime;
    private static int currentState;
    private static boolean initted;

    public RecordForm(TAGit midlet) {
        this.midlet = midlet;
        this.init();
        this.keepBacklightOn();
        this.setFullScreenMode(true);
    }

    private void keepBacklightOn() {
        Thread backlightThread = new Thread(){

            public void run() {
                while (true) {
                    try {
                        Thread.currentThread();
                        Thread.sleep(9000L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    DeviceControl.setLights((int)0, (int)100);
                }
            }
        };
        backlightThread.start();
    }

    public void sizeChanged(int x, int y) {
        this.midlet.sizeChanged(x, y);
        initted = false;
        this.repaint();
    }

    private void init() {
        try {
            if (!TAGit.callFullScreenOnlyOnce) {
                this.setFullScreenMode(true);
            }
            this.ANIMATION_OFFSET = TAGit.globalScreenHeight / 3 * 2;
            framePause = 70;
            this.sidCollector = this.midlet.getIDCollector();
            this.instructions = TAGit.createImage(ResourceName.RECORD_READY_IMAGE);
            this.recordingBG = TAGit.createImage(ResourceName.RECORDING_IMAGE);
            this.analyzingBG = TAGit.createImage(ResourceName.ANALYSIS_CHECKING_IMAGE);
            this.recordingAnimation = TAGit.createImage(ResourceName.RECORD_ANIM1_IMAGE);
            this.analyzingAnimation = TAGit.createImage(ResourceName.ANALYSIS_ANIM1_IMAGE);
            shazamLogo = TAGit.createImage(ResourceName.SHAZAM_LOGO);
            initted = true;
        }
        catch (Exception e) {
            this.midlet.IMerror("recordform.recordform: " + e.toString(), (Displayable)this);
        }
    }

    protected void keyPressed(int keyCode) {
        this.midlet.vibrateForKeyPressed();
        TAGit.IMinfo("keypressed in recordform.");
        if (!RecordForm.isRunning()) {
            this.backButton();
        }
    }

    protected void pointerPressed(int x, int y) {
        this.midlet.vibrateForPointerPressed();
        if (!this.isRunning()) {
            this.backButton();
        }
    }

    public void backButton() {
        try {
            RecordForm.quitRunning("recordform.backbutton");
            this.th = null;
            atWill = true;
            this.midlet.display.setCurrent(this.midlet.displayStore.popDisplay("recordform.backbutton"));
        }
        catch (Exception e) {
            this.midlet.IMerror("recordform.backbutton: " + e.toString(), (Displayable)this);
        }
    }

    public void showNotify() {
        try {
            TAGit.IMinfo("recordform.shownotify called");
            TAGit.IMinfo("entering showNotify()");
            if (!TAGit.callFullScreenOnlyOnce) {
                this.setFullScreenMode(true);
            }
            this.repaint();
            TAGit.IMinfo("leaving showNotify()");
            this.repaint();
        }
        catch (Exception e) {
            this.midlet.IMerror("recordform.showNotify: " + e.toString(), (Displayable)this);
        }
    }

    public void hideNotify() {
        try {
            if (atWill) {
                atWill = false;
                System.gc();
            } else if (this.isIncompatible()) {
                RecordForm.quitRunning("recordform.hidenotify");
            }
            initted = false;
        }
        catch (Exception e) {
            this.midlet.IMerror("recordform.hideNofity: " + e.toString(), (Displayable)this);
        }
    }

    private boolean isIncompatible() {
        if (this.midlet.getManufacturer() != 2) {
            return true;
        }
        switch (this.midlet.getHandsetID()) {
            case 92: 
            case 95: {
                return true;
            }
        }
        return false;
    }

    public synchronized void stop() {
        try {
            this.startTime = 0L;
            RecordForm.quitRunning("recordform.stop");
            this.th = null;
            if (this.player != null) {
                this.player.close();
            }
            if (this.audioSubmit != null) {
                this.audioSubmit.stop();
                this.audioSubmit = null;
            }
            if (this.tagRecorder != null) {
                this.tagRecorder.stop();
                this.tagRecorder.deleteRecording();
                this.tagRecorder = null;
            }
            System.gc();
        }
        catch (Exception e) {
            this.midlet.IMerror("recordform.stop: " + e.toString(), (Displayable)this);
        }
    }

    public void playAudioTrack(String trackName) {
        block3: {
            try {
                VolumeControl volControl = null;
                if (this.player != null) {
                    this.player.close();
                    this.player = null;
                    System.gc();
                }
                trackName = trackName + recordingType;
                InputStream in = this.getClass().getResourceAsStream(trackName);
                this.player = Manager.createPlayer((InputStream)in, (String)"audio/amr");
                this.player.realize();
                volControl = (VolumeControl)this.player.getControl("VolumeControl");
                volControl.setLevel(AUDIO_PLAYER_VOLUME);
                this.player.start();
                Thread.sleep(1000L);
                this.player.stop();
                this.player.close();
            }
            catch (Exception e) {
                if (this.midlet.getManufacturer() != 6) break block3;
                TAGit.IMSilentError("recordform.playaudiotrack: " + e.toString());
                mediaException = true;
                this.midlet.handleRecordFormException(mediaException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        TAGit.IMinfo("********* Entering RecordForm.run()");
        try {
            if (!this.isRunning()) {
                this.midlet.handleRecordFormBackgrounded("recordform.run1: ");
                return;
            }
            this.Prepare();
            if (!this.isRunning()) {
                this.midlet.handleRecordFormBackgrounded("recordform.run2: ");
                return;
            }
            this.Listen();
            if (!this.isRunning() || mediaException) {
                this.midlet.handleRecordFormBackgrounded("recordform.run3: ");
                return;
            }
            this.Analyze();
            this.freeResources();
            if (!this.isRunning() || mediaException) {
                this.midlet.handleRecordFormBackgrounded("recordform.run4: ");
                return;
            }
            this.Report();
            if (!this.isRunning() && !mediaException) {
                this.midlet.handleRecordFormBackgrounded("recordform.run5: ");
                return;
            }
        }
        catch (Exception e) {
            this.midlet.IMerror("recordform.run: " + e.toString(), (Displayable)this);
            this.midlet.handleRecordFormException(mediaException);
        }
        finally {
            System.gc();
        }
    }

    private void Report() {
        try {
            if (this.tag.getCurrentSubscription() == ResourceText.VALID_SUBSCRIPTION) {
                if (this.tag.getAlbum() == null && this.tag.getArtist() == null && this.tag.getTrack() == null) {
                    this.showNoMatch();
                } else {
                    this.addShowResults();
                }
            } else {
                this.showInvalidSubscription();
            }
            recording = false;
            this.repaint();
        }
        catch (Exception e) {
            this.midlet.IMerror("recordform.report: " + e.toString(), (Displayable)this);
        }
    }

    private void Prepare() {
        try {
            currentState = 0;
            this.repaint();
            running = true;
            if (!TAGit.callFullScreenOnlyOnce) {
                this.setFullScreenMode(true);
            }
            mediaException = false;
            recording = true;
            if (this.tagRecorder == null) {
                this.tagRecorder = new TagRecorder(this.midlet);
            }
            TAGit.IMinfo("RecordForm is sleeping");
            Thread.currentThread();
            Thread.sleep(2000L);
            TAGit.IMinfo("RecordForm is awake again");
            System.gc();
        }
        catch (Exception e) {
            this.midlet.IMerror("recordform.prepare: " + e.toString(), (Displayable)this);
        }
    }

    private void Listen() {
        try {
            currentState = 1;
            this.repaint();
            TAGit.IMinfo("RecordForm is about to listen");
            if (!this.isRunning()) {
                throw new Exception("No longer running!");
            }
            this.tagRecorder.setState(0);
            Thread.currentThread();
            Thread.sleep(200L);
            if (!this.isRunning()) {
                this.midlet.handleRecordFormBackgrounded("recordform.listen: ");
                return;
            }
            this.playAudioTrack(this.midlet.buildResPath(startTrack));
            TAGit.IMinfo("RecordForm is sleeping for record message");
            Thread.currentThread();
            Thread.sleep(2000L);
            TAGit.IMinfo("RecordForm is starting the recorder");
            if (!this.isRunning()) {
                this.midlet.handleRecordFormBackgrounded("recordform.listen: ");
                return;
            }
            this.tagRecorder.startRecorder();
            this.startTime = System.currentTimeMillis();
            while (this.stillRecording() && !this.ListeningExceptionThrown()) {
                if (!this.isRunning()) break;
                this.notifyUpdate();
            }
            if (!this.isRunning()) {
                this.midlet.handleRecordFormBackgrounded("recordform.listen: ");
                return;
            }
            this.tagRecorder.stop();
            if (!this.isRunning()) {
                this.midlet.handleRecordFormBackgrounded("recordform.listen: ");
                return;
            }
            this.recordData = this.tagRecorder.getRecording();
            System.gc();
        }
        catch (InterruptedException e) {
        }
        catch (Exception e) {
            this.midlet.IMerror("recordform.listen: " + e.toString(), (Displayable)this);
            this.midlet.handleRecordFormException(mediaException);
        }
    }

    private boolean ListeningExceptionThrown() {
        if (System.currentTimeMillis() >= this.startTime + 20000L) {
            RecordForm recordForm = this;
            if (!recordForm.midlet.getDebug()) {
                this.midlet.IMerror("Listening Timeout", (Displayable)this);
                this.tagRecorder.stop();
                this.tagRecorder.setState(3);
                return true;
            }
        }
        if (this.tagRecorder.getState() == 3) {
            this.midlet.IMerror("RecordForm got a recording exception", (Displayable)this);
            return true;
        }
        return false;
    }

    private boolean stillRecording() {
        try {
            return this.tagRecorder.getState() != 2 && this.tagRecorder.getState() != 3 && System.currentTimeMillis() < this.startTime + 20000L;
        }
        catch (Exception e) {
            this.midlet.IMerror("recordform.stillrecording: " + e.toString(), (Displayable)this);
            return false;
        }
    }

    private void Analyze() {
        try {
            currentState = 4;
            this.repaint();
            TAGit.IMinfo("RecordForm is about to analyze");
            if (!this.isRunning()) {
                this.midlet.handleRecordFormBackgrounded("recordform.analyze1: ");
                return;
            }
            Thread.currentThread();
            Thread.sleep(200L);
            if (!this.isRunning()) {
                this.midlet.handleRecordFormBackgrounded("recordform.analyze2: ");
                return;
            }
            this.playAudioTrack(this.midlet.buildResPath(transmitTrack));
            Thread.currentThread();
            Thread.sleep(200L);
            if (this.audioSubmit == null) {
                if (this.isRunning()) {
                    this.audioSubmit = new AudioSubmission(this.midlet);
                }
            }
            if (this.isRunning()) {
                this.audioSubmit.start(this.recordData);
            } else {
                this.midlet.handleRecordFormBackgrounded("recordform.analyze3: ");
                return;
            }
            while (this.stillAnalyzing() && !this.AnalyzingExceptionThrown()) {
                if (!this.isRunning()) break;
                this.notifyUpdate();
            }
            if (!this.isRunning()) {
                this.midlet.handleRecordFormBackgrounded("recordform.analyze4: ");
                return;
            }
            this.tag = this.audioSubmit.getTag();
            if (this.tag == null) {
                RecordForm.quitRunning("recordform.analyze");
                throw new Exception("audioSubmit didn't return a tag, failed silently");
            }
        }
        catch (Exception e) {
            RecordForm.quitRunning("recordform.analyze2");
            this.midlet.IMerror("recordform.analyze: " + e.toString(), (Displayable)this);
            this.midlet.handleRecordFormException(mediaException);
        }
    }

    private boolean AnalyzingExceptionThrown() {
        try {
            if (System.currentTimeMillis() >= this.startTime + 40000L) {
                RecordForm recordForm = this;
                if (!recordForm.midlet.getDebug()) {
                    this.midlet.IMerror("TimeOut during analyzing", (Displayable)this);
                    this.audioSubmit.stop();
                    this.audioSubmit.setState(6);
                    return true;
                }
            }
            if (this.audioSubmit.getState() == 6) {
                TAGit.IMerror("Exception in audioSubmit");
                return true;
            }
        }
        catch (Exception e) {
            this.midlet.IMerror("recordform.analyzingexceptionthrown: " + e.toString(), (Displayable)this);
        }
        return false;
    }

    private boolean stillAnalyzing() {
        try {
            return this.audioSubmit.getState() != 5;
        }
        catch (Exception e) {
            this.midlet.IMerror("recordform.stillanalyzing: " + e.toString(), (Displayable)this);
            return false;
        }
    }

    public void freeResources() {
        try {
            this.repaint();
            if (this.audioSubmit != null) {
                this.audioSubmit.stop();
                this.audioSubmit = null;
            }
            if (this.recordData != null && this.tagRecorder != null) {
                this.tagRecorder.deleteRecording();
                this.recordData = null;
                this.tagRecorder = null;
            }
            System.gc();
        }
        catch (Exception e) {
            this.midlet.IMerror("recordform.freeresources: " + e.toString(), (Displayable)this);
        }
    }

    private void showInvalidSubscription() {
        try {
            this.midlet.showTrialInfo(0L, "", false);
        }
        catch (Exception e) {
            this.midlet.IMerror("recordform.showinvalidsubscription: " + e.toString(), (Displayable)this);
            this.midlet.handleRecordFormException(mediaException);
        }
    }

    private void addShowResults() {
        try {
            if (!this.sidCollector.addTag(this.tag)) {
                TAGit.IMerror("an error occured while trying to store the tag");
                this.showNoMatch();
                return;
            }
            atWill = true;
            this.midlet.showTagResults(this.tag);
        }
        catch (Exception e) {
            this.midlet.IMerror("recordform.addshowresults: " + e.toString(), (Displayable)this);
            this.midlet.handleRecordFormException(mediaException);
        }
    }

    private void showNoMatch() {
        try {
            this.midlet.showStatusScreen();
        }
        catch (Exception e) {
            this.midlet.IMerror("recordform.shownomatch: " + e.toString(), (Displayable)this);
            this.midlet.handleRecordFormException(mediaException);
        }
    }

    public void notifyUpdate() {
        try {
            this.repaint();
            Thread.currentThread();
            Thread.sleep(framePause);
        }
        catch (Exception e) {
            this.midlet.IMerror("recordform.notifyupdate: " + e.toString(), (Displayable)this);
        }
    }

    public void restartRecordForm() {
        try {
            running = true;
            this.th = new Thread(this);
            this.th.start();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void paint(Graphics g) {
        try {
            this.midlet.updateMemStatus();
            if (!initted) {
                this.init();
            }
            TAGit.paintEmulatorExtras(g);
            g.setFont(TAGit.font);
            if (!TAGit.callFullScreenOnlyOnce) {
                this.setFullScreenMode(true);
            }
            if (currentState == 0) {
                g.setColor(0xFFFFFF);
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
                g.drawImage(this.instructions, 0, 0, 20);
            } else if (currentState == 1) {
                g.setColor(0xFFFFFF);
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
                g.drawImage(this.recordingBG, 0, 0, 20);
                g.drawImage(this.recordingAnimation, animX, this.ANIMATION_OFFSET, 6);
                g.drawImage(this.recordingAnimation, animX - this.recordingAnimation.getWidth(), this.ANIMATION_OFFSET, 6);
                animX = (animX + 15) % this.recordingAnimation.getWidth();
            } else if (currentState == 4) {
                g.setColor(0xFFFFFF);
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
                g.drawImage(this.analyzingBG, 0, 0, 20);
                g.drawImage(this.analyzingAnimation, animX, this.ANIMATION_OFFSET, 6);
                g.drawImage(this.analyzingAnimation, animX - this.analyzingAnimation.getWidth(), this.ANIMATION_OFFSET, 6);
                animX = (animX + 15) % this.analyzingAnimation.getWidth();
            }
            if (shazamLogo != null) {
                g.drawImage(shazamLogo, TAGit.globalScreenWidth, TAGit.globalScreenHeight, 40);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        TAGit.drawPreReleaseBanner(g);
    }

    public static boolean isRunning() {
        return running;
    }

    protected static void quitRunning(String caller) {
        if (TAGit.isEmulator) {
            return;
        }
        TAGit.IMinfo("quitrunning called by " + caller);
        running = false;
    }

    static {
        atWill = false;
        recording = false;
        suspended = false;
        running = true;
        mediaException = false;
        currentState = 0;
        initted = false;
    }

    public static interface States {
        public static final int PREPARING = 0;
        public static final int RECORDING = 1;
        public static final int RECORDING_COMPLETED = 2;
        public static final int RECORDING_EXCEPTION = 3;
        public static final int ANALYZING = 4;
        public static final int ANALYSIS_COMPLETE = 5;
        public static final int ANALYSIS_EXCEPTION = 6;
    }
}

