/*
 * Decompiled with CFR 0.152.
 */
package tagit;

import java.util.Vector;
import javax.microedition.io.Connector;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.wireless.messaging.Message;
import javax.wireless.messaging.MessageConnection;
import javax.wireless.messaging.TextMessage;
import tagit.InformationCanvas;
import tagit.Keys;
import tagit.ResourceName;
import tagit.TAGit;
import tagit.Tag;
import tagit.TouchScreenButton;
import tagit.TouchScreenSoftKey;

public class SMSCanvas
extends Canvas
implements Runnable {
    private static final int MAX_PHONENUM_LENGTH = 10;
    private static final boolean useCursor = true;
    private TAGit midlet;
    private boolean initted = false;
    private String phoneNumber = "";
    private String tagMessage;
    private String tagURL;
    private Tag smsTag;
    private InformationCanvas infoCanvas;
    private static final int MAX_SMS_LENGTH = 151;
    private static final int ALT_FOOTER_H = TAGit.font.getHeight() + 4;
    private static Image header;
    private static Image logo;
    private static int LINE_H;
    private static int BORDER;
    private static int BOX_H;
    private static int BOX_W;
    private static Image backspace;
    private static TouchScreenButton bs;
    private TouchScreenSoftKey lsk;
    private TouchScreenSoftKey rsk;

    public SMSCanvas(TAGit midlet) {
        try {
            this.midlet = midlet;
            this.setFullScreenMode(true);
            this.infoCanvas = midlet.getInformationCanvas();
            this.phoneNumber = "";
        }
        catch (Exception e) {
            TAGit.IMerror("smscanvas.smscanvas: " + e.toString());
        }
    }

    private void setupScreen() {
        try {
            if (!TAGit.compact) {
                logo = TAGit.createImage(ResourceName.SHARE_JACKS_IMAGE);
            }
            backspace = TAGit.createImage(ResourceName.BACKSPACE_BUTTON);
            header = TAGit.createImage(ResourceName.SMS_HEADER_IMAGE);
            if (this.phoneNumber.length() == 10) {
                this.lsk = new TouchScreenSoftKey("Back", false);
                this.rsk = new TouchScreenSoftKey("ShareID", true);
            } else {
                this.lsk = new TouchScreenSoftKey("Back", false);
                this.rsk = new TouchScreenSoftKey("", true);
            }
            LINE_H = TAGit.font.getHeight();
            BORDER = 2;
            BOX_H = LINE_H + 2 * BORDER;
            BOX_W = TAGit.font.stringWidth("000 000 0000") + 2 * BORDER + 2 * LINE_H;
        }
        catch (Exception e) {
            TAGit.IMerror("smscanvas.setupscreen: " + e.toString());
        }
    }

    private Vector getTextLines() {
        Vector<String> lines = new Vector<String>();
        lines.addElement("Enter a number to send");
        lines.addElement("Artist, Track, and a Link:");
        if (!this.linesWillFitOnScreen(lines)) {
            lines.removeAllElements();
            lines.addElement("Enter a number to");
            lines.addElement("send Artist, Track");
            lines.addElement("and a Link:");
        }
        if (!this.linesWillFitOnScreen(lines)) {
            TAGit.IMSilentError("need to make text fit on SMSCanvas");
        }
        return lines;
    }

    private boolean linesWillFitOnScreen(Vector stringVector) {
        for (int c = 0; c < stringVector.size(); ++c) {
            if (TAGit.font.stringWidth((String)stringVector.elementAt(c)) < TAGit.globalScreenWidth) continue;
            return false;
        }
        return true;
    }

    private int getCenteredX(String line) {
        return (TAGit.globalScreenWidth - TAGit.font.stringWidth(line)) / 2;
    }

    private int getCenteredX(int width) {
        return (TAGit.globalScreenWidth - width) / 2;
    }

    public void sizeChanged(int x, int y) {
        this.midlet.sizeChanged(x, y);
        this.initted = false;
        this.repaint();
    }

    public void pointerPressed(int x, int y) {
        this.midlet.vibrateForPointerPressed();
        if (this.lsk.selectThisButton(x, y)) {
            if (TAGit.weNeedToFlipSoftKeys) {
                this.rightSoftButton();
            } else {
                this.leftSoftButton();
            }
        } else if (this.rsk.selectThisButton(x, y) && this.phoneNumber.length() == 10) {
            if (TAGit.weNeedToFlipSoftKeys) {
                this.leftSoftButton();
            } else {
                this.rightSoftButton();
            }
        } else if (bs.selectThisButton(x, y)) {
            this.handleDeletePressed();
        }
    }

    private void init() {
        try {
            this.setupScreen();
            this.setErrorMessage();
            this.initted = true;
        }
        catch (Exception e) {
            TAGit.IMerror("smscanvas.init: " + e.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send() {
        String phoneNumber = this.phoneNumber;
        this.phoneNumber = "";
        MessageConnection msgConn = null;
        try {
            this.tagMessage = this.smsTag.getSMSMessage();
            if (this.tagMessage == null) {
                this.tagMessage = ResourceName.MEDIA_URL;
            }
            if (this.tagMessage.length() > 151) {
                this.tagMessage = this.tagMessage.substring(0, 151);
            }
            String destination = "sms://+1" + phoneNumber;
            msgConn = (MessageConnection)Connector.open((String)destination);
            TextMessage textMessage = (TextMessage)msgConn.newMessage("text");
            textMessage.setAddress(destination);
            textMessage.setPayloadText(this.tagMessage);
            msgConn.send((Message)textMessage);
            phoneNumber = "";
        }
        catch (Exception e) {
            e.printStackTrace();
            this.midlet.display.setCurrent((Displayable)this.infoCanvas);
        }
        finally {
            if (msgConn != null) {
                try {
                    msgConn.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void setTag(Tag resultsTag) {
        this.smsTag = resultsTag;
    }

    private void setErrorMessage() {
        try {
            this.infoCanvas.setHeader(header);
            this.infoCanvas.setFooter(TAGit.createImage(ResourceName.FOOTER_BACK_IMAGE));
            this.infoCanvas.setImage(null);
            this.infoCanvas.setLaunchSubscriptionOnRSK(false);
            this.infoCanvas.displayText("Could not Send the SMS");
        }
        catch (Exception e) {
            TAGit.IMerror("smscanvas.seterrormessage: " + e.toString());
        }
    }

    protected void keyPressed(int keyCode) {
        block7: {
            block10: {
                block9: {
                    block8: {
                        block6: {
                            this.midlet.vibrateForKeyPressed();
                            keyCode = Keys.convertFromKeySet(keyCode);
                            if (keyCode < 48 || keyCode > 57) break block6;
                            this.handleNumberPressed(keyCode);
                            break block7;
                        }
                        if (this.getGameAction(keyCode) != 2 && !Keys.isDeleteKey(keyCode) && !Keys.isBackKey(keyCode)) break block8;
                        if (this.phoneNumber.length() > 0) {
                            this.handleDeletePressed();
                        } else {
                            this.leftSoftButton();
                        }
                        break block7;
                    }
                    if (!this.lsk.keyPressed(keyCode)) break block9;
                    this.leftSoftButton();
                    break block7;
                }
                if (this.rsk.keyPressed(keyCode)) break block10;
                if (this.midlet.getManufacturer() != 9 || keyCode != 8) break block7;
            }
            if (this.phoneNumber.length() == 10) {
                this.rightSoftButton();
            }
        }
        this.repaint();
    }

    protected void handleDeletePressed() {
        int phoneLen = this.phoneNumber.length();
        if (phoneLen > 0) {
            this.phoneNumber = this.phoneNumber.substring(0, phoneLen - 1);
            if (this.phoneNumber.length() == 9) {
                this.rsk = null;
                System.gc();
                this.rsk = new TouchScreenSoftKey("", true);
            }
            this.repaint();
        }
    }

    protected void handleNumberPressed(int keyCode) {
        int digit = keyCode - 48;
        if (this.phoneNumber.length() < 10) {
            this.phoneNumber = this.phoneNumber + digit;
            if (this.phoneNumber.length() == 10) {
                this.rsk = null;
                System.gc();
                this.rsk = new TouchScreenSoftKey("ShareID", true);
            }
            this.repaint();
        }
    }

    public void leftSoftButton() {
        try {
            this.midlet.display.setCurrent(this.midlet.displayStore.popDisplay("smscanvas.leftsoftbutton"));
        }
        catch (Exception e) {
            TAGit.IMerror("smscanvas.leftsoftbutton: " + e.toString());
        }
    }

    public void rightSoftButton() {
        try {
            Thread smsThread = new Thread(this);
            smsThread.start();
            this.leftSoftButton();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void hideNotify() {
        header = null;
        logo = null;
        System.gc();
        this.initted = false;
    }

    public void showNotify() {
        if (!TAGit.callFullScreenOnlyOnce) {
            this.setFullScreenMode(true);
        }
        if (!this.initted) {
            this.init();
        }
        this.repaint();
    }

    private int getBufferHeight(Vector v) {
        try {
            int numOfItems = 2 + (TAGit.compact ? 0 : 1);
            TAGit.IMinfo("numOfItems = " + numOfItems);
            int totalItemHeight = TAGit.font.getHeight() * v.size() + BOX_H + (TAGit.compact ? 0 : logo.getHeight());
            int availableHeight = TAGit.globalScreenHeight - header.getHeight() - (TAGit.weNeedToFlipSoftKeys ? ALT_FOOTER_H : this.lsk.getHeight());
            return (availableHeight - totalItemHeight) / (numOfItems + 1);
        }
        catch (Exception e) {
            TAGit.IMerror("smscanvas.getbufferheight: " + e.toString());
            return 0;
        }
    }

    public void paint(Graphics g) {
        try {
            TAGit.paintEmulatorExtras(g);
            g.setFont(TAGit.font);
            this.midlet.updateMemStatus();
            if (!this.initted) {
                this.init();
            }
            Vector lines = this.getTextLines();
            int BUFFER_H = this.getBufferHeight(lines);
            TAGit.IMinfo("buffer = " + BUFFER_H);
            int currentY = header.getHeight() + BUFFER_H;
            g.setColor(255, 255, 255);
            g.fillRect(0, 0, TAGit.globalScreenWidth, TAGit.globalScreenHeight);
            g.setColor(0, 0, 0);
            for (int c = 0; c < lines.size(); ++c) {
                String line = (String)lines.elementAt(c);
                g.drawString(line, this.getCenteredX(line), currentY, 20);
                currentY += TAGit.font.getHeight() + 2;
            }
            g.setColor(0, 0, 255);
            g.drawRoundRect(this.getCenteredX(BOX_W), currentY += BUFFER_H, BOX_W, BOX_H, LINE_H, LINE_H);
            this.drawBSArrow(g, currentY);
            String formattedNumber = this.formatPhoneNumber(this.phoneNumber);
            g.setColor(0, 0, 0);
            g.drawString(formattedNumber, this.getCenteredX(formattedNumber), currentY + BORDER, 20);
            currentY += BOX_H + BUFFER_H;
            if (header != null) {
                g.drawImage(header, 0, 0, 20);
            }
            if (logo != null) {
                g.drawImage(logo, this.getCenteredX(logo.getWidth()), currentY, 20);
            }
            this.lsk.draw(g);
            this.rsk.draw(g);
            TAGit.drawPreReleaseBanner(g);
        }
        catch (Exception e) {
            TAGit.IMerror("smscanvas.paint: " + e.toString());
        }
    }

    private void drawBSArrow(Graphics g, int currentY) {
        if (!TAGit.useBackspace) {
            return;
        }
        int centeredX = this.getCenteredX(BOX_W);
        int x1 = centeredX + BOX_W + centeredX / 2;
        int y1 = currentY + BOX_H / 2;
        bs = new TouchScreenButton("backspace", backspace, x1, y1, true);
        g.drawImage(backspace, x1, y1, 3);
    }

    private String formatPhoneNumber(String phoneNumber) {
        if (phoneNumber != null && phoneNumber.length() > 0) {
            int phoneLen = phoneNumber.length();
            String phoneStr = "";
            if (phoneLen < 4) {
                phoneStr = phoneNumber;
            } else {
                phoneStr = phoneNumber.substring(0, 3);
                if (phoneLen < 7) {
                    phoneStr = phoneStr + " " + phoneNumber.substring(3);
                } else {
                    phoneStr = phoneStr + " " + phoneNumber.substring(3, 6);
                    if (phoneLen > 6) {
                        phoneStr = phoneStr + " " + phoneNumber.substring(6);
                    }
                }
            }
            return phoneStr;
        }
        return "";
    }

    public void run() {
        this.send();
    }
}

