/*
 * Decompiled with CFR 0.152.
 */
package tagit;

import javax.microedition.io.Connector;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.TextField;
import javax.wireless.messaging.Message;
import javax.wireless.messaging.MessageConnection;
import javax.wireless.messaging.TextMessage;
import tagit.ResourceName;
import tagit.TAGit;
import tagit.Tag;

public class SMSForm
extends Form
implements CommandListener,
Runnable {
    private TAGit midlet;
    private static final int DIGIT_LENGTH = 10;
    private static final Command SEND = new Command("Send", 4, 1);
    private static final Command BACK = new Command("Back", 2, 2);
    private static final Command OK = new Command("OK", 4, 3);
    private TextField field;
    private Tag smsTag;
    private String tagMessage;
    private static final int MAX_SMS_LENGTH = 151;
    private String phoneNumber = "SMSForm.";

    public SMSForm(Tag tag, TAGit midlet) {
        super("ShareID");
        try {
            this.midlet = midlet;
            this.smsTag = tag;
            this.field = new TextField("Touch the text box\nand enter a number to\nsend Artist, Track,\nand a Link:", "", 10, 2);
            this.addCommand(BACK);
            this.addCommand(SEND);
            this.append((Item)this.field);
            this.setCommandListener(this);
        }
        catch (Exception e) {
            midlet.IMerror("SMSForm.SMSForm: " + e.toString(), (Displayable)this);
        }
    }

    public void setTag(Tag tag) {
        this.smsTag = tag;
    }

    public void commandAction(Command c, Displayable form) {
        try {
            TAGit.IMinfo("*command action*");
            String label = c.getLabel();
            if (label.equals("Back") || c.equals(BACK)) {
                Displayable test = this.midlet.displayStore.popDisplay("smsform.commandaction");
                this.midlet.display.setCurrent(test);
            } else if (label.equals("Send") || c.equals(SEND) || c.equals(OK)) {
                TAGit.IMinfo("*command action send*");
                if (this.field.getString().length() == 10) {
                    this.phoneNumber = this.field.getString();
                    Thread smsThread = new Thread(this);
                    smsThread.start();
                    Displayable test = this.midlet.displayStore.popDisplay("smsform.commandaction2");
                    this.midlet.display.setCurrent(test);
                } else {
                    TAGit.IMinfo("not sending: 10 Digits needed");
                }
            }
        }
        catch (Exception e) {
            this.midlet.IMerror("SMSForm.commandAction: " + e.toString(), (Displayable)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send() {
        MessageConnection msgConn = null;
        try {
            this.tagMessage = this.smsTag.getSMSMessage();
            if (this.tagMessage == null) {
                this.tagMessage = ResourceName.MEDIA_URL;
            }
            if (this.tagMessage.length() > 151) {
                this.tagMessage = this.tagMessage.substring(0, 151);
            }
            String destination = "sms://+1" + this.phoneNumber;
            msgConn = (MessageConnection)Connector.open((String)destination);
            TextMessage textMessage = (TextMessage)msgConn.newMessage("text");
            textMessage.setAddress(destination);
            textMessage.setPayloadText(this.tagMessage);
            msgConn.send((Message)textMessage);
            this.phoneNumber = "";
            this.field.setString("");
            this.smsTag = null;
            this.tagMessage = "";
            this.midlet.updateMemStatus();
        }
        catch (Exception e) {
            TAGit.IMerror("SMSForm.send: " + e.toString());
        }
        finally {
            if (msgConn != null) {
                try {
                    msgConn.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void run() {
        try {
            this.send();
            this.phoneNumber = "";
            this.field.setString("");
            this.smsTag = null;
            this.tagMessage = "";
        }
        catch (Exception e) {
            this.midlet.IMerror("SMSForm.run: " + e.toString(), (Displayable)this);
        }
    }
}

