/*
 * Decompiled with CFR 0.152.
 */
package tagit;

import com.gravitymobile.logger.Logger;
import com.gravitymobile.logger.LoggerCanvas;
import com.gravitymobile.logger.MusicIDLoggerCanvas;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.midlet.MIDlet;
import javax.microedition.midlet.MIDletStateChangeException;
import javax.microedition.rms.RecordStore;
import tagit.AudioSubmission;
import tagit.DisplayStore;
import tagit.InformationCanvas;
import tagit.Keys;
import tagit.MainMenu;
import tagit.NewTagRCanvas;
import tagit.NoMatchCanvas;
import tagit.RFormError;
import tagit.RecordForm;
import tagit.SongIDCollector;
import tagit.Tag;
import tagit.TrialCanvas;

public class TAGit
extends MIDlet {
    private static boolean DEBUG = false;
    private static final boolean allowDeleteRMS = false;
    private static final boolean TRACE_ONLY = false;
    public static boolean isEmulator = false;
    public static Font font = Font.getDefaultFont();
    static TAGit instance;
    public static String resfolder;
    private LoggerCanvas loggerCanvas = null;
    private boolean exitRequest = false;
    private String ownerIdentifier = "";
    private SongIDCollector songIDCollector = null;
    public MainMenu displayable;
    public DisplayStore displayStore;
    public RecordForm recordForm = null;
    private InformationCanvas informationScreen = null;
    public static final int EMULATOR = 1;
    public static final int NOKIA = 2;
    public static final int MOTOROLA = 3;
    public static final int LG = 4;
    public static final int SONY = 5;
    public static final int SAMSUNG = 6;
    public static final int BLACKBERRY = 7;
    public static final int PANTECH = 8;
    public static final int UTSTARCOM = 9;
    private static int manufacturer;
    public long set_time;
    public DisplayMonitor display;
    protected boolean started;
    public boolean recordingCancelled;
    private static boolean appIsPaused;
    private static boolean errorMessage;
    private Thread errorThread = null;
    private RFormError rformError;
    private static int handsetID;
    private static long freeMem;
    private static long totalMem;
    private static long highMem;
    private static long lowMem;
    private static long currentMem;
    public static int globalScreenHeight;
    public static int globalScreenWidth;
    public static boolean recordingErrorThrown;
    public static boolean weNeedToFlipSoftKeys;
    public static boolean vibrateForKeyPresses;
    public static boolean vibrateForPointerPresses;
    public static String recognitionURL;
    public static int mmc_id;
    public static boolean justShowLogger;
    public static boolean useAltSplash;
    public static boolean compact;
    public static boolean dualAspect;
    private static String versionStatus;
    private static String fontType;
    public static boolean useBackspace;
    private static boolean trustScreenSize;
    public static boolean callFullScreenOnlyOnce;
    public static boolean isMako;
    private static boolean LGworkaround;
    private NewTagRCanvas tagResultCanvas;

    public TAGit() {
        try {
            this.display = new DisplayMonitor(this);
            this.displayStore = new DisplayStore(this);
            this.started = false;
            this.enableLogging(true);
            this.setDescriptors();
            this.setFont();
            Logger.setDebug(true);
            this.displayable = new MainMenu(this, true);
        }
        catch (Exception e) {
            TAGit.IMerror("tagit.tagit: " + e.toString());
        }
    }

    public void startAppWithLog() {
        try {
            instance = this;
            DEBUG = true;
            this.showLog();
        }
        catch (Exception e) {
            TAGit.IMerror("tagit.fakeStartApp: " + e.toString());
        }
    }

    public void startApp() {
        try {
            if (justShowLogger) {
                this.startAppWithLog();
                return;
            }
            instance = this;
            TAGit.IMinfo("TAGIT: Starting app");
            if (!this.started) {
                if (!this.checkPreloadStatus()) {
                    this.display.setCurrent((Displayable)this.displayable);
                }
                this.started = true;
            }
        }
        catch (Exception e) {
            TAGit.IMerror("tagit.startApp: " + e.toString());
        }
    }

    public void pauseApp() {
        try {
            TAGit.IMinfo("TAGIT: Pausing app");
            if (RecordForm.isRunning()) {
                RecordForm.quitRunning("tagit.pauseapp");
            }
        }
        catch (Exception e) {
            TAGit.IMerror("tagit.pauseApp: " + e.toString());
        }
    }

    public void destroyApp(boolean unconditional) throws MIDletStateChangeException {
        if (!unconditional) {
            throw new MIDletStateChangeException("");
        }
    }

    public static void exitApp() throws MIDletStateChangeException {
        instance.destroyApp(true);
        instance.notifyDestroyed();
        instance = null;
    }

    public void setDebug(boolean dbg) {
        DEBUG = dbg;
    }

    public void enableLogging(boolean begin) {
        try {
            if (begin) {
                Logger.setDebug(true);
                Logger.setLogToRMS(true);
                Logger.setRmsProperties("logger", null, null, true, true);
            } else {
                Logger.setDebug(false);
                Logger.setLogToRMS(false);
            }
        }
        catch (Exception e) {
            TAGit.IMerror("tagit.enablelogging: " + e.toString());
        }
    }

    public void showLog() {
        try {
            if (TAGit.getDebug()) {
                Displayable d = this.display.getCurrent();
                if (d != null && d instanceof Canvas) {
                    this.displayStore.addDisplay(d);
                }
                if (this.loggerCanvas == null) {
                    this.loggerCanvas = new MusicIDLoggerCanvas(this);
                }
                this.display.setCurrent((Displayable)this.loggerCanvas);
            }
        }
        catch (Exception e) {
            TAGit.IMerror("tagit.showLog: " + e.toString());
        }
    }

    public void goBack() {
        try {
            this.display.setCurrent(this.displayStore.popDisplay("tagit.goback"));
        }
        catch (Exception e) {
            TAGit.IMerror("tagit.goback: " + e.toString());
        }
    }

    public static boolean getDebug() {
        return DEBUG;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SongIDCollector getIDCollector() {
        if (this.songIDCollector == null) {
            TAGit tAGit = this;
            synchronized (tAGit) {
                this.songIDCollector = new SongIDCollector(this);
            }
        }
        return this.songIDCollector;
    }

    public InformationCanvas getInformationCanvas() {
        if (this.informationScreen == null) {
            this.informationScreen = new InformationCanvas(this);
        }
        return this.informationScreen;
    }

    private void setRecordForm() {
        try {
            if (this.recordForm == null) {
                this.recordForm = new RecordForm(this);
            } else {
                this.recordForm.stop();
            }
        }
        catch (Exception e) {
            this.IMerror("tagit.getrecordform: " + e.toString(), (Displayable)this.displayable);
        }
    }

    public void restartRecordForm(Displayable last) {
        try {
            if (this.songIDCollector.getRecordAdded()) {
                this.songIDCollector.collectSongIDs();
                this.songIDCollector.setRecordAdded(false);
            }
            Logger.clearLogFromRMS();
            recordingErrorThrown = false;
            this.setRecordForm();
            if (last != null && !(last instanceof NewTagRCanvas)) {
                this.displayStore.addDisplay(last);
            }
            this.recordForm.restartRecordForm();
            TAGit.IMinfo("restarting record form.");
            this.display.setCurrent((Displayable)this.recordForm);
        }
        catch (Exception e) {
            this.IMerror("initializing recordForm: " + e.toString(), (Displayable)this.displayable);
        }
    }

    public boolean getExitRequest() {
        return this.exitRequest;
    }

    public void setExitRequest(boolean request) {
        this.exitRequest = request;
    }

    public String getOwnerIdentifier() {
        return this.ownerIdentifier;
    }

    public int getHandsetID() {
        return handsetID;
    }

    public String getProperty(String p) {
        try {
            String s = this.getAppProperty(p);
            if ("null".equalsIgnoreCase(s)) {
                return "";
            }
            return s;
        }
        catch (Exception e) {
            TAGit.IMinfo("Failed to retrieve property " + p + ":" + e.toString());
            return "";
        }
    }

    private void setDescriptors() {
        String current = "";
        try {
            if (System.getProperty("microedition.platform").toString().equalsIgnoreCase("SunMicrosystems_wtk")) {
                isEmulator = true;
            }
            current = "trust";
            trustScreenSize = isEmulator ? false : !"false".equalsIgnoreCase(this.getProperty(current));
            current = "use-backspace";
            useBackspace = "true".equalsIgnoreCase(this.getProperty(current));
            current = "dual-aspect";
            dualAspect = "true".equalsIgnoreCase(this.getProperty(current));
            current = "mako";
            isMako = "true".equalsIgnoreCase(this.getProperty(current));
            current = "Version-Status";
            versionStatus = this.getProperty(current);
            current = "Font";
            fontType = this.getProperty(current);
            current = "compact";
            if ("true".equalsIgnoreCase(this.getProperty(current))) {
                compact = true;
            }
            if ("true".equalsIgnoreCase(this.getProperty(current = "special-fullscreen"))) {
                callFullScreenOnlyOnce = true;
            }
            if ("true".equalsIgnoreCase(this.getProperty(current = "use-alt-splash"))) {
                useAltSplash = true;
            }
            if ("true".equalsIgnoreCase(this.getProperty(current = "viewlog"))) {
                justShowLogger = true;
            }
            current = "recognitionURL";
            recognitionURL = this.getProperty(current);
            current = "Flip-SoftKeys";
            if ("true".equalsIgnoreCase(this.getProperty(current))) {
                weNeedToFlipSoftKeys = true;
            }
            if ("true".equalsIgnoreCase(this.getProperty(current = "vibrate-for-keypress"))) {
                vibrateForKeyPresses = true;
            }
            if ("true".equalsIgnoreCase(this.getProperty(current = "vibrate-for-pointerpress"))) {
                vibrateForPointerPresses = true;
            }
            if ("true".equalsIgnoreCase(this.getProperty(current = "LGworkaround"))) {
                LGworkaround = true;
            }
            current = "handsetID";
            try {
                handsetID = Integer.parseInt(this.getProperty(current));
            }
            catch (Exception e) {
                handsetID = 0;
            }
            current = "mmc-id";
            try {
                mmc_id = Integer.parseInt(this.getProperty(current));
            }
            catch (Exception e) {
                mmc_id = 0;
            }
            current = "ScreenWidth";
            try {
                resfolder = this.getProperty(current);
                globalScreenWidth = Integer.parseInt(resfolder);
            }
            catch (Exception e) {
                globalScreenWidth = 0;
                resfolder = "";
            }
            current = "ScreenHeight";
            try {
                globalScreenHeight = Integer.parseInt(this.getProperty(current));
            }
            catch (Exception e) {
                globalScreenHeight = 0;
            }
            current = "CarrierDeviceId";
            this.ownerIdentifier = this.getProperty(current);
            current = "PreId";
            if (this.ownerIdentifier == null || "".equals(this.ownerIdentifier)) {
                TAGit.IMinfo("using preid");
                this.ownerIdentifier = this.getProperty(current);
            } else if (this.ownerIdentifier.equals("2411")) {
                TAGit.IMinfo("using mmc trial");
                handsetID = mmc_id;
            }
            current = "keyset";
            Keys.setKeySet(this.getProperty(current));
            current = "volume";
            try {
                RecordForm.AUDIO_PLAYER_VOLUME = Integer.parseInt(this.getProperty(current));
            }
            catch (NumberFormatException nfe) {
                RecordForm.AUDIO_PLAYER_VOLUME = 50;
            }
        }
        catch (Exception e) {
            TAGit.IMerror("tagit.setdescriptors failed at " + current + " : " + e.toString());
        }
    }

    public int getManufacturer() {
        if (manufacturer != 0) {
            return manufacturer;
        }
        String manu = this.getProperty("manu");
        TAGit.IMinfo("Manufacturer is set to " + manu);
        manufacturer = "SunMicrosystems_wtk".equalsIgnoreCase(System.getProperty("microedition.platform").toString()) ? 1 : ("emulator".equalsIgnoreCase(manu) || "emu".equalsIgnoreCase(manu) ? 1 : ("nokia".equalsIgnoreCase(manu) || "nok".equalsIgnoreCase(manu) ? 2 : ("motorola".equalsIgnoreCase(manu) || "moto".equalsIgnoreCase(manu) || "mot".equalsIgnoreCase(manu) ? 3 : ("lg".equalsIgnoreCase(manu) || "lge".equalsIgnoreCase(manu) ? 4 : ("sony".equalsIgnoreCase(manu) || "semc".equalsIgnoreCase(manu) ? 5 : ("samsung".equalsIgnoreCase(manu) || "sam".equalsIgnoreCase(manu) ? 6 : ("blackberry".equalsIgnoreCase(manu) || "rim".equalsIgnoreCase(manu) ? 7 : ("pantech".equalsIgnoreCase(manu) || "pan".equalsIgnoreCase(manu) ? 8 : ("utstarcom".equalsIgnoreCase(manu) || "att".equalsIgnoreCase(manu) ? 9 : 1)))))))));
        return manufacturer;
    }

    public SongIDCollector getSongIDCollector() {
        return this.songIDCollector;
    }

    public static void sendToConsole(String msg) {
        if (DEBUG) {
            System.out.println(msg);
        }
    }

    public static void IMinfo(String e) {
        if (DEBUG) {
            Logger.info(e);
        }
        TAGit.sendToConsole("INFO: " + e);
    }

    public static void IMSilentError(String e) {
        if (DEBUG) {
            Logger.error(e);
        }
        TAGit.sendToConsole("ERROR: " + e);
    }

    public static void IMerror(String e) {
        errorMessage = true;
        TAGit.IMSilentError(e);
        if (DEBUG) {
            // empty if block
        }
    }

    public void IMerror(String msg, Exception e) {
        TAGit.IMerror(msg + e.toString());
    }

    public void IMerror(String e, Displayable NOT_USED) {
        TAGit.IMerror(e);
    }

    public static void IMtrace(String msg) {
        Logger.trace(msg);
    }

    private boolean checkPreloadStatus() {
        try {
            int val = Integer.parseInt(this.getOwnerIdentifier());
            if (val >= 10000 || val == 4668) {
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        try {
            RecordStore preloadStore = RecordStore.openRecordStore((String)"preload", (boolean)false);
            byte[] dateBytes = preloadStore.getRecord(2);
            ByteArrayInputStream bais = new ByteArrayInputStream(dateBytes);
            DataInputStream dis = new DataInputStream(bais);
            long expireTime = dis.readLong();
            byte[] subURLBytes = preloadStore.getRecord(3);
            String subURL = "";
            for (int z = 0; z < subURLBytes.length; ++z) {
                subURL = subURL + (char)subURLBytes[z];
            }
            this.showTrialInfo(expireTime, subURL, true);
            preloadStore.closeRecordStore();
            return true;
        }
        catch (Exception e) {
            TAGit.IMerror("checkPreloadStatus: " + e.toString());
            return false;
        }
    }

    public void showTrialInfo(long expTime, String subURL, boolean drawSplash) {
        TrialCanvas c = new TrialCanvas(instance, expTime, subURL, drawSplash);
        this.display.setCurrent((Displayable)c);
    }

    public void deleteRMS() {
        Logger.clearLogFromRMS();
    }

    public void showStatusScreen() {
        NoMatchCanvas noMatchScreen = new NoMatchCanvas(this);
        RecordForm.atWill = true;
        this.display.setCurrent((Displayable)noMatchScreen);
    }

    public boolean LGWorkaround(Object caller) {
        return LGworkaround && (caller instanceof AudioSubmission || caller instanceof SongIDCollector);
    }

    public void handleRecordFormBackgrounded(String caller) {
        if (!recordingErrorThrown) {
            TAGit.IMinfo("Recordform was backgrounded by OS, called by " + caller);
            Thread.currentThread().interrupt();
            this.display.setCurrent(this.displayStore.popDisplay("tagit.handlerecordformbackgrounded"));
            if (this.recordForm != null) {
                this.recordForm.stop();
                this.recordForm.freeResources();
            }
            this.recordForm = null;
            System.gc();
            this.destroyRFormErrorThread();
        }
    }

    public void handleRecordFormException(boolean isMediaError) {
        Thread.currentThread().interrupt();
        recordingErrorThrown = true;
        this.rformError = new RFormError(this, isMediaError, this.recordForm);
        this.errorThread = new Thread(this.rformError);
        this.errorThread.start();
    }

    public void destroyRFormErrorThread() {
        this.errorThread = null;
        this.rformError = null;
        System.gc();
    }

    public String buildResPath(String resourceName) {
        String resPath = "/res/" + resfolder + "/" + resourceName;
        return resPath;
    }

    public static Image createImage(String path) {
        try {
            path = "/res/" + resfolder + "/" + path;
            Image image = Image.createImage((String)path);
            return image;
        }
        catch (IOException ioe) {
            TAGit.IMerror("TAGit.creatImage: " + path + " : " + ioe.toString());
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public boolean isRFormStillRunning() {
        TAGit tAGit = this;
        return tAGit.recordForm.isRunning();
    }

    private void setFont() {
        try {
            if ("".equalsIgnoreCase(fontType) || "default".equalsIgnoreCase(fontType)) {
                return;
            }
            if ("small".equalsIgnoreCase(fontType)) {
                font = Font.getFont((int)32, (int)0, (int)8);
            } else if ("medium".equalsIgnoreCase(fontType)) {
                font = Font.getFont((int)64, (int)0, (int)0);
            }
        }
        catch (Exception e) {
            TAGit.IMerror("tagit.setspecialfont: " + e.toString());
        }
    }

    public void updateMemStatus() {
        Runtime rTime = Runtime.getRuntime();
        freeMem = rTime.freeMemory();
        totalMem = rTime.totalMemory();
        currentMem = totalMem - freeMem;
        if (currentMem > highMem) {
            highMem = currentMem;
        }
        if (lowMem == 0L) {
            lowMem = currentMem;
        } else if (currentMem < lowMem) {
            lowMem = currentMem;
        }
    }

    public void sizeChanged(int newWidth, int newHeight) {
        TAGit.IMinfo("sizeChanged called: " + newWidth + ":" + newHeight);
        this.setScreenSizes(newWidth, newHeight);
        if (!isEmulator) {
            resfolder = String.valueOf(newWidth);
        }
    }

    public void setScreenSizes(int newWidth, int newHeight) {
        if (trustScreenSize) {
            globalScreenHeight = isMako ? (newWidth == 240 ? 320 : 240) : newHeight;
            globalScreenWidth = newWidth;
        }
    }

    public void showTagResults(Tag tag) throws Exception {
        TAGit.IMinfo("entering showtagresults");
        System.gc();
        if (tag == null) {
            throw new Exception("Cannot display ID if tag is null");
        }
        if (this.tagResultCanvas == null) {
            this.tagResultCanvas = new NewTagRCanvas(this);
        }
        if (this.tagResultCanvas.setTag(tag)) {
            this.display.setCurrent((Displayable)this.tagResultCanvas);
            this.display.repaint();
        }
        TAGit.IMinfo("leaving showtagresults");
    }

    public void vibrateForPointerPressed() {
        if (!vibrateForPointerPresses) {
            return;
        }
        Display.getDisplay((MIDlet)this).vibrate(40);
    }

    public void vibrateForKeyPressed() {
        if (!vibrateForKeyPresses) {
            return;
        }
        Display.getDisplay((MIDlet)this).vibrate(40);
    }

    public void vibrateFor(int lengthOfVibration) {
        Display.getDisplay((MIDlet)this).vibrate(lengthOfVibration);
    }

    public static void drawPreReleaseBanner(Graphics g) {
        String msg = "";
        if (DEBUG) {
            msg = ":: Debug Mode On ::";
        } else {
            if (versionStatus == null) {
                return;
            }
            if ("".equalsIgnoreCase(versionStatus)) {
                return;
            }
            if ("null".equalsIgnoreCase(versionStatus)) {
                return;
            }
            msg = ":: " + versionStatus + " Version ::";
        }
        g.setColor(0);
        int fh = font.getHeight();
        g.fillRect(0, compact ? 0 : fh, globalScreenWidth, fh + 2);
        g.setColor(0xFFFFFF);
        g.drawString(msg, globalScreenWidth / 2, compact ? 0 : fh + 1, 17);
    }

    public static void drawPreReleaseBanner(Graphics g, Image header) {
        try {
            g.drawImage(header, 0, 0, 20);
            TAGit.drawPreReleaseBanner(g);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void paintEmulatorExtras(Graphics g) {
        if (isEmulator) {
            g.setColor(0);
            g.fillRect(0, 0, 240, 320);
            g.setClip(0, 0, globalScreenWidth, globalScreenHeight);
        }
    }

    static {
        resfolder = "";
        manufacturer = 0;
        appIsPaused = false;
        errorMessage = false;
        handsetID = 0;
        freeMem = 0L;
        totalMem = 0L;
        highMem = 0L;
        currentMem = 0L;
        globalScreenHeight = 0;
        globalScreenWidth = 0;
        recordingErrorThrown = false;
        weNeedToFlipSoftKeys = false;
        vibrateForKeyPresses = false;
        vibrateForPointerPresses = false;
        recognitionURL = "";
        mmc_id = 0;
        justShowLogger = false;
        useAltSplash = false;
        compact = false;
        dualAspect = false;
        versionStatus = "";
        fontType = "";
        useBackspace = false;
        trustScreenSize = true;
        callFullScreenOnlyOnce = false;
        isMako = false;
        LGworkaround = false;
    }

    public class DisplayMonitor {
        private Displayable currentDisplay;
        private Display display;
        private TAGit midlet;
        private Alert alert;

        public DisplayMonitor(TAGit midlet) {
            this.midlet = midlet;
            this.display = Display.getDisplay((MIDlet)midlet);
        }

        public void repaint() {
            if (this.currentDisplay != null && this.currentDisplay instanceof Canvas) {
                ((Canvas)this.currentDisplay).repaint();
            }
        }

        public void setCurrent(Displayable next) {
            try {
                this.currentDisplay = next;
                if (appIsPaused) {
                    TAGit.IMinfo("cannot set new displayable, app is paused.");
                } else {
                    this.display.setCurrent(this.currentDisplay);
                    if (this.currentDisplay instanceof Canvas) {
                        ((Canvas)this.currentDisplay).repaint();
                    }
                }
                DisplayMonitor displayMonitor = this;
                if (errorMessage && this.alert != null) {
                    this.display.setCurrent(this.alert, this.currentDisplay);
                }
            }
            catch (Exception e) {
                TAGit.IMerror("tagit.displaymonitor.setcurrent: " + e.toString());
            }
        }

        public void setCurrent(Alert alert, Displayable notUsed) {
            this.alert = alert;
            if (appIsPaused) {
                TAGit.IMinfo("cannot set new displayable alert, app is paused.");
            } else {
                this.display.setCurrent(alert, this.currentDisplay);
            }
        }

        public Displayable getCurrent() {
            return this.currentDisplay;
        }

        public void showCurrent() {
            errorMessage = false;
            this.display.setCurrent(this.currentDisplay);
        }
    }
}

