/*
 * Decompiled with CFR 0.152.
 */
package tagit;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;
import javax.microedition.media.control.RecordControl;
import tagit.RecordForm;
import tagit.TAGit;

public class TagRecorder
implements Runnable {
    private byte[] recording1;
    private static int RECORD_TIME = 10000;
    private String recorderEncoding;
    private int recordingState;
    private TAGit midlet;
    private Thread th = null;
    private int currentTime;
    private int updateIntervalTime;
    private int updateIntervals;
    private Player player;
    private RecordControl recordControl;
    private ByteArrayOutputStream bytes;
    private InputStream is;
    private static boolean useSubstituteTrack = true;

    public TagRecorder(TAGit midlet) throws Exception {
        try {
            this.midlet = midlet;
            this.setRecordTime();
            this.updateIntervals = 100;
            if (TAGit.isEmulator) {
                this.readInSubstitute();
            }
        }
        catch (Exception e) {
            TAGit.IMerror("tagrecorder.tagrecorder: " + e.toString());
        }
    }

    private void setRecordTime() {
        try {
            RECORD_TIME = 10000;
            if ("true".equalsIgnoreCase(this.midlet.getProperty("extended-rec"))) {
                RECORD_TIME = 15000;
            }
        }
        catch (Exception e) {
            TAGit.IMerror("tagrecorder.setrecordtime: " + e.toString());
        }
    }

    private void readInSubstitute() {
        try {
            TAGit.IMinfo("substituteRecording");
            int bytesRead = 0;
            byte[] recordBuffer = new byte[512];
            this.bytes = new ByteArrayOutputStream();
            this.is = this.getClass().getResourceAsStream(this.midlet.buildResPath("substitute.amr"));
            if (this.is != null) {
                while ((bytesRead = this.is.read(recordBuffer)) != -1) {
                    this.bytes.write(recordBuffer, 0, bytesRead);
                }
            }
            TAGit.IMinfo("end substituteRecording");
        }
        catch (Exception e) {
            TAGit.IMerror("tagrecorder.readinsubstitute: " + e.toString());
        }
    }

    public void startRecorder() {
        try {
            if (RecordForm.isRunning()) {
                this.th = new Thread(this);
                this.th.start();
            }
        }
        catch (Exception e) {
            TAGit.IMerror("tagrecorder.startrecorder: " + e.toString());
        }
    }

    public void stop() {
        try {
            this.th = null;
            TAGit.IMinfo("TagRecorder.stop(): committing recordControl");
            if (this.recordControl != null) {
                this.recordControl.commit();
            }
            System.gc();
        }
        catch (Exception e) {
            TAGit.IMerror("tagrecorder.stop: " + e.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void run() {
        double err;
        block55: {
            block61: {
                ByteArrayOutputStream outStream;
                block60: {
                    outStream = null;
                    try {
                        block59: {
                            block58: {
                                block57: {
                                    block56: {
                                        err = 0.0;
                                        this.midlet.recordingCancelled = false;
                                        if (!RecordForm.isRunning()) break block55;
                                        TagRecorder tagRecorder = this;
                                        // MONITORENTER : tagRecorder
                                        try {
                                            if (this.player != null) {
                                                this.player.close();
                                                this.player = null;
                                                System.gc();
                                            }
                                            err = 1.0;
                                            if (RecordForm.isRunning()) {
                                                this.recorderEncoding = "capture://audio";
                                                String encType = this.midlet.getProperty("recEncoding");
                                                if (encType != null && !encType.equals("")) {
                                                    this.recorderEncoding = this.recorderEncoding + "?encoding=" + encType;
                                                }
                                                break block56;
                                            }
                                            // MONITOREXIT : tagRecorder
                                        }
                                        catch (Exception e) {
                                            if (!TAGit.isEmulator) {
                                                TAGit.IMerror("***recording failure= " + err + "  " + e.toString());
                                                this.setState(3);
                                            }
                                            break block61;
                                        }
                                        try {
                                            this.th = null;
                                            this.player.close();
                                            this.player = null;
                                            System.gc();
                                        }
                                        catch (Exception e) {
                                            e.printStackTrace();
                                        }
                                        try {
                                            if (outStream == null) return;
                                            outStream.close();
                                            return;
                                        }
                                        catch (Exception e) {
                                            e.printStackTrace();
                                        }
                                        return;
                                    }
                                    err = 2.0;
                                    if (RecordForm.isRunning()) {
                                        this.player = Manager.createPlayer((String)this.recorderEncoding);
                                        this.player.realize();
                                        break block57;
                                    }
                                    // MONITOREXIT : tagRecorder
                                    try {
                                        this.th = null;
                                        this.player.close();
                                        this.player = null;
                                        System.gc();
                                    }
                                    catch (Exception e) {
                                        e.printStackTrace();
                                    }
                                    try {
                                        if (outStream == null) return;
                                        outStream.close();
                                        return;
                                    }
                                    catch (Exception e) {
                                        e.printStackTrace();
                                    }
                                    return;
                                }
                                if (RecordForm.isRunning()) {
                                    this.recordControl = (RecordControl)this.player.getControl("RecordControl");
                                    outStream = new ByteArrayOutputStream();
                                    break block58;
                                }
                                // MONITOREXIT : tagRecorder
                                try {
                                    this.th = null;
                                    this.player.close();
                                    this.player = null;
                                    System.gc();
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                                try {
                                    if (outStream == null) return;
                                    outStream.close();
                                    return;
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                                return;
                            }
                            err = 3.0;
                            if (RecordForm.isRunning()) {
                                this.recordControl.setRecordStream((OutputStream)outStream);
                                err = 3.1;
                                this.recordControl.startRecord();
                                err = 3.2;
                                this.player.start();
                                break block59;
                            }
                            // MONITOREXIT : tagRecorder
                            try {
                                this.th = null;
                                this.player.close();
                                this.player = null;
                                System.gc();
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                            try {
                                if (outStream == null) return;
                                outStream.close();
                                return;
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                            return;
                        }
                        err = 3.3;
                        err = 4.0;
                        this.setState(1);
                        this.updateIntervalTime = RECORD_TIME / this.updateIntervals;
                        this.currentTime = RECORD_TIME;
                        err = 5.0;
                        break block60;
                    }
                    catch (Exception e) {
                        TAGit.IMerror("tagrecorder.run: " + e.toString());
                        return;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                do {
                    this.wait(this.updateIntervalTime);
                    this.currentTime -= this.updateIntervalTime;
                } while (this.currentTime > this.updateIntervals & RecordForm.isRunning());
                err = 6.0;
                if (!this.midlet.recordingCancelled && RecordForm.isRunning()) {
                    err = 8.0;
                    this.stop();
                    this.recording1 = outStream.toByteArray();
                }
            }
            if (this.getState() != 3) {
                this.setState(2);
            }
            // MONITOREXIT : tagRecorder
        }
        if (!TAGit.isEmulator) return;
        if (!RecordForm.isRunning()) return;
        err = 7.0;
        if (useSubstituteTrack) {
            TAGit.IMinfo("substituting track now.");
            this.recording1 = this.bytes.toByteArray();
            useSubstituteTrack = false;
            return;
        } else {
            TAGit.IMinfo("skipping track substitution.");
            useSubstituteTrack = true;
        }
    }

    public int getState() {
        return this.recordingState;
    }

    public void setState(int recState) {
        try {
            this.recordingState = recState;
        }
        catch (Exception e) {
            TAGit.IMerror("tagrecorder.setstate: " + e.toString());
        }
    }

    public byte[] getRecording() {
        return this.recording1;
    }

    public void deleteRecording() {
        try {
            this.recording1 = null;
            System.gc();
        }
        catch (Exception e) {
            TAGit.IMerror("tagrecorder.deleterecording: " + e.toString());
        }
    }

    public static interface States {
        public static final int PREPARING = 0;
        public static final int RECORDING = 1;
        public static final int RECORDING_COMPLETED = 2;
        public static final int RECORDING_EXCEPTION = 3;
        public static final int ANALYZING = 4;
        public static final int ANALYSIS_COMPLETE = 5;
        public static final int ANALYSIS_EXCEPTION = 6;
    }
}

