/*
 * Decompiled with CFR 0.152.
 */
package tagit;

import javax.microedition.lcdui.Image;
import tagit.CanvasButton;
import tagit.SelectionMenu;

public class TouchScreenButton
implements Runnable {
    String name;
    int startX;
    int startY;
    int endY;
    int endX;
    CanvasButton monitor;

    public TouchScreenButton(String n, Image buttonImage, int x, int y) {
        this.name = n;
        this.startX = x;
        this.startY = y;
        this.endX = x + buttonImage.getWidth();
        this.endY = y + buttonImage.getHeight();
    }

    public TouchScreenButton(String n, Image buttonImage, int x, int y, boolean isCentered) {
        int xOffset = buttonImage.getWidth() / 2;
        int yOffset = buttonImage.getHeight() / 2;
        this.name = n;
        this.startX = x - xOffset;
        this.startY = y - yOffset;
        this.endX = x + xOffset;
        this.endY = y + yOffset;
    }

    public TouchScreenButton(String n, int x, int y, int x2, int y2) {
        this.name = n;
        this.startX = x;
        this.startY = y;
        this.endX = x2;
        this.endY = y2;
    }

    public TouchScreenButton() {
    }

    public TouchScreenButton(String name, SelectionMenu.MenuTile menuTile) {
        this(name, menuTile.getSelectImage(), menuTile.getX(), menuTile.getY());
    }

    public boolean selectThisButton(int pointerX, int pointerY) {
        return pointerX >= this.startX && pointerX <= this.endX && pointerY >= this.startY && pointerY <= this.endY;
    }

    public void setMonitor(CanvasButton o) {
        this.monitor = o;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        CanvasButton canvasButton = this.monitor;
        synchronized (canvasButton) {
            if (this.monitor.externalPaintCall()) {
                try {
                    Thread.sleep(150L);
                    this.monitor.fire();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

