/*
 * Decompiled with CFR 0.152.
 */
package tagit;

import javax.microedition.lcdui.Graphics;
import tagit.Keys;
import tagit.TAGit;
import tagit.TouchScreenButton;

public class TouchScreenSoftKey
extends TouchScreenButton {
    private String label;
    private boolean isRSK = false;
    private int x = 0;
    private int y = 0;
    private int height;
    private int width;
    private int labelX = 0;
    private int labelY = 0;
    private static int spacer = 0;
    private static int wideScreenWidth = 320;

    public TouchScreenSoftKey(String label, boolean isRSK) {
        try {
            this.label = label;
            this.isRSK = TAGit.weNeedToFlipSoftKeys ? !isRSK : isRSK;
            this.setup();
        }
        catch (Exception e) {
            TAGit.IMerror("touchscreensoftkey: " + e.toString());
        }
    }

    public void updateLabel(String s) {
        this.label = s;
    }

    private void setup() {
        try {
            this.height = TAGit.font.getHeight() + 4;
            this.width = TAGit.globalScreenWidth / 2;
            this.x = this.isRSK ? this.width : 0;
            this.y = TAGit.globalScreenHeight - this.height;
            spacer = TAGit.globalScreenWidth / 6;
            this.labelX = this.isRSK ? TAGit.globalScreenWidth - spacer : spacer;
            this.labelY = this.y + 2;
            this.startX = this.x;
            this.startY = this.y;
            this.endX = this.x + this.width;
            this.endY = this.y + this.height;
        }
        catch (Exception e) {
            TAGit.IMerror("touchscreensoftkey.setup: " + e.toString());
        }
    }

    public boolean keyPressed(int keyCode) {
        if (TAGit.isMako && TAGit.globalScreenWidth == wideScreenWidth) {
            return this.isRSK ? Keys.isLeftSoftKey(keyCode) : Keys.isRightSoftKey(keyCode);
        }
        return this.isRSK ? Keys.isRightSoftKey(keyCode) : Keys.isLeftSoftKey(keyCode);
    }

    public int getHeight() {
        return this.height;
    }

    public void draw(Graphics g) {
        try {
            g.setFont(TAGit.font);
            g.setColor(31174);
            g.fillRect(this.x, this.y, this.width, this.height);
            g.setColor(0xFFFFFF);
            if (TAGit.isMako && this.drawMakoLabel(g)) {
                return;
            }
            g.drawString(this.label, this.labelX, this.labelY, 17);
        }
        catch (Exception e) {
            TAGit.IMerror("touchscreensoftkey.draw: " + e.toString());
        }
    }

    private boolean drawMakoLabel(Graphics g) {
        try {
            if (TAGit.globalScreenWidth != wideScreenWidth) {
                return false;
            }
            if (this.isRSK) {
                return false;
            }
            g.setColor(31174);
            int width = TAGit.font.stringWidth(this.label);
            int height = TAGit.font.getHeight();
            g.setColor(0xFFFFFF);
            g.drawString(this.label, TAGit.globalScreenWidth - spacer, 2, 17);
        }
        catch (Exception e) {
            TAGit.IMerror("touchscreensoftkey.drawMakoLabel: " + e.toString());
        }
        return true;
    }
}

