/*
 * Decompiled with CFR 0.152.
 */
package com.canvas.view.item;

import com.canvas.TheCanvas;
import com.canvas.view.View;
import com.canvas.view.until.ViewEvent;
import com.res.Res;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class TabView
extends View {
    private Image selectImg1;
    private Image selectImg2;
    private Image imgLeft;
    private Image imgRight;
    private int itemTitleWidth = 58;
    private int itemTitleHeight = 20;
    private Vector tabItems = new Vector();
    private Vector tabNames = new Vector();
    private int startIndex = 0;
    private int currentIndex = 0;
    private int itemNumPerPage = 1;
    private int lineNum = 1;
    private View currentSubItem;
    public static final int moveStep = 40;
    public int popDirect = 0;
    private static final int POP_OUT = 1;
    private static final int POP_IN = 2;
    private boolean showImg = true;
    int iCounter = 0;

    public TabView() {
        this.type = 13;
        this.init();
    }

    public void init() {
        this.selectImg1 = (Image)Res.imageTable.get("tabitem1");
        this.selectImg2 = (Image)Res.imageTable.get("tabitem2");
        this.imgLeft = (Image)Res.imageTable.get("arrowleft");
        this.imgRight = (Image)Res.imageTable.get("arrowright");
        this.itemTitleWidth = this.selectImg1.getWidth();
        this.itemTitleHeight = this.selectImg1.getHeight();
    }

    public void setLineNum(int num) {
        this.lineNum = num;
    }

    public void setSelectImage(Image select, Image none) {
        this.selectImg1 = select;
        this.selectImg2 = none;
    }

    public void setX(int x) {
        this.x = x;
    }

    public void setY(int y) {
        this.y = y;
    }

    public void addTabItem(String title, View view) {
        view.setX(this.x);
        view.setY(this.y + this.itemTitleHeight);
        view.setWidth(this.width);
        view.setHeight(this.height - this.itemTitleHeight);
        this.tabItems.addElement(view);
        this.tabNames.addElement(title);
        if (this.tabItems.size() == 1) {
            this.currentSubItem = view;
            this.currentIndex = 0;
        } else {
            this.refreshTabView();
        }
    }

    public void refreshTabView() {
        int w = this.width - this.imgLeft.getWidth() - this.imgRight.getHeight();
        this.itemNumPerPage = (w - 2) / (this.itemTitleWidth + 2);
        if (this.currentIndex < this.tabItems.size()) {
            this.currentSubItem = (View)this.tabItems.elementAt(this.currentIndex);
        }
    }

    public void removeTabItem(String title, View view) {
        this.tabItems.removeElement(view);
        this.tabNames.removeElement(title);
    }

    public void removeAllTabItem() {
        this.tabItems.removeAllElements();
        this.tabNames.removeAllElements();
    }

    public View getCurrentSub() {
        return this.currentSubItem;
    }

    public void popout() {
        this.visible = true;
        this.popDirect = 1;
        TheCanvas.setFlashView(this);
    }

    public void popin() {
        this.popDirect = 2;
        TheCanvas.setFlashView(this);
    }

    public boolean getActionResult() {
        return this.currentX != this.x || this.currentY != this.y;
    }

    public void setActionResult(boolean result) {
        if (this.popDirect == 2) {
            this.popDirect = 0;
            this.visible = false;
        } else if (this.popDirect == 1) {
            this.popDirect = 0;
            this.visible = true;
        }
    }

    public void threadAction() {
        int step = 40;
        if (Math.abs(this.x - this.currentX) < step) {
            this.currentX = this.x;
        } else if (this.currentX < this.x) {
            this.currentX += step;
        } else if (this.currentX > this.x) {
            this.currentX -= step;
        }
        if (Math.abs(this.y - this.currentY) < step) {
            this.currentY = this.y;
        } else if (this.currentY < this.y) {
            this.currentY += step;
        } else if (this.currentY > this.y) {
            this.currentY -= step;
        }
    }

    public void setCurrentItem(int index) {
        if (index < 0 || index > this.tabItems.size() - 1) {
            return;
        }
        this.currentIndex = index;
        this.currentSubItem = (View)this.tabItems.elementAt(index);
    }

    public void paintSingleLine(Graphics g, int drawX, int drawY) {
        int dx = drawX + this.imgLeft.getWidth() + 3;
        int dy = drawY;
        g.setColor(this.fontColor);
        int i = this.startIndex;
        while (i < this.startIndex + this.itemNumPerPage) {
            if (i > this.tabItems.size() - 1) break;
            Image tmpImg = this.selectImg2;
            if (i == this.currentIndex) {
                tmpImg = this.selectImg1;
            }
            String str = (String)this.tabNames.elementAt(i);
            if (this.tabNames.size() == 1) {
                tmpImg = this.selectImg2;
                int tl = tmpImg.getWidth() - 10;
                int count = (this.width + this.imgLeft.getWidth() - (dx -= 2) - 3) / tl + 1;
                g.drawImage(tmpImg, dx - this.imgLeft.getWidth(), dy, 20);
                int j = 1;
                while (j < count) {
                    g.setClip(dx - this.imgLeft.getWidth() + j * tl, dy, tl, tmpImg.getHeight());
                    if (dx - this.imgLeft.getWidth() + j * tl - 5 + tmpImg.getWidth() > dx - this.imgLeft.getWidth() + this.width - 3 - this.imgRight.getHeight()) {
                        g.drawImage(tmpImg, dx - this.imgLeft.getWidth() + this.width - 3 - tmpImg.getWidth(), dy, 20);
                    } else {
                        g.drawImage(tmpImg, dx - this.imgLeft.getWidth() + j * tl - 5, dy, 20);
                    }
                    ++j;
                }
                g.setClip(0, 0, 240, 320);
                g.drawString(str, dx, dy + (this.itemTitleHeight - g.getFont().getHeight() >> 1), 20);
            } else {
                g.drawImage(tmpImg, dx, dy, 20);
                g.drawString(str, dx + (this.itemTitleWidth - g.getFont().stringWidth(str) >> 1), dy + (this.itemTitleHeight - g.getFont().getHeight() >> 1), 20);
            }
            dx += 2;
            if (i - this.startIndex >= this.itemNumPerPage - 1 || (dx += this.itemTitleWidth) > drawX + this.width) break;
            ++i;
        }
    }

    public void setShowImg(boolean isShow) {
        this.showImg = isShow;
    }

    public void paintMoreLine(Graphics g, int drawX, int drawY) {
        int startX;
        int dx = startX = drawX + this.imgLeft.getWidth() + 3;
        int dy = drawY;
        g.setColor(this.fontColor);
        int num = 0;
        int line = 1;
        int i = this.startIndex;
        while (i < this.tabItems.size()) {
            Image tmpImg = this.selectImg2;
            if (i == this.currentIndex) {
                tmpImg = this.selectImg1;
            }
            if (this.showImg) {
                g.drawImage(tmpImg, dx, dy, 20);
            }
            String str = (String)this.tabNames.elementAt(i);
            if (this.currentIndex == i && this.isFocus()) {
                g.setColor(0xFFFFFF);
            } else {
                g.setColor(0);
            }
            g.drawString(str, dx + (this.itemTitleWidth - g.getFont().stringWidth(str) >> 1), dy + (this.itemTitleHeight - g.getFont().getHeight() >> 1), 20);
            if (!this.showImg && i == this.currentIndex && this.isFocus()) {
                g.drawLine(dx + (this.itemTitleWidth - g.getFont().stringWidth(str) >> 1), dy + this.itemTitleHeight, dx + (this.itemTitleWidth - g.getFont().stringWidth(str) >> 1) + g.getFont().stringWidth(str), dy + this.itemTitleHeight);
            }
            dx += 2;
            dx += this.itemTitleWidth;
            if (++num >= this.itemNumPerPage) {
                dx = startX;
                dy += this.selectImg1.getHeight() + 2;
                ++line;
                num = 0;
            }
            if (line > this.lineNum) break;
            ++i;
        }
    }

    public void paint(Graphics g) {
        if (!this.visible) {
            return;
        }
        g.setFont(this.font);
        int drawX = this.x;
        int drawY = this.y;
        if (this.popDirect > 0) {
            drawX = this.currentX;
            drawY = this.currentY;
        }
        this.drawImage(g, this.img, drawX, drawY);
        if (this.lineNum == 1) {
            this.paintSingleLine(g, drawX, drawY);
        } else {
            this.paintMoreLine(g, drawX, drawY);
        }
        if (this.popDirect > 0) {
            g.translate(drawX, drawY);
        }
        int i = 0;
        while (i < this.items.size()) {
            View view = (View)this.items.elementAt(i);
            if (view != null) {
                view.paint(g);
            }
            ++i;
        }
        if (this.currentSubItem != null) {
            this.currentSubItem.paint(g);
        }
        if (this.popDirect > 0) {
            g.translate(-drawX, -drawY);
        }
        if (this.imgLeft != null && this.tabNames.size() > 1) {
            g.drawImage(this.imgLeft, drawX, drawY + (this.itemTitleHeight - this.imgLeft.getHeight() >> 1), 20);
        }
        if (this.imgRight != null && this.tabNames.size() > 1) {
            g.drawImage(this.imgRight, drawX + this.width - this.imgRight.getWidth(), drawY + (this.itemTitleHeight - this.imgLeft.getHeight() >> 1), 20);
        }
        if (this.leftButton != null) {
            this.leftButton.paint(g);
        }
        if (this.rightButton != null) {
            this.rightButton.paint(g);
        }
    }

    /*
     * WARNING - void declaration
     */
    public ViewEvent keyReleasedSingleLine(int keyCode) {
        void var2_2;
        ViewEvent sube;
        if (keyCode == 2) {
            if (this.currentIndex == this.startIndex) {
                --this.startIndex;
            }
            if (this.currentIndex > 0) {
                --this.currentIndex;
            }
            if (this.startIndex < 0) {
                this.startIndex = 0;
            }
            this.refreshTabView();
        } else if (keyCode == 5) {
            if (this.currentIndex < this.tabItems.size() - 1) {
                ++this.currentIndex;
            }
            if (this.currentIndex > this.startIndex + this.itemNumPerPage - 1) {
                ++this.startIndex;
            }
            this.refreshTabView();
        } else if (keyCode == 6 || keyCode == 1 ? (sube = this.currentSubItem.keyReleasedAction(keyCode)) != null : keyCode == 8 && (sube = this.currentSubItem.keyReleasedAction(keyCode)) != null) {
            return sube;
        }
        ViewEvent e = new ViewEvent();
        e.setView(this);
        e.setSource(this.currentSubItem);
        e.setKeyCode(keyCode);
        e.setDesc("tab");
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public ViewEvent keyReleasedMoreLine(int keyCode) {
        void var2_2;
        ViewEvent sube;
        if (keyCode == 2) {
            if (this.currentIndex == this.startIndex) {
                --this.startIndex;
            }
            if (this.currentIndex > 0) {
                --this.currentIndex;
            }
            if (this.startIndex < 0) {
                this.startIndex = 0;
            }
            this.refreshTabView();
        } else if (keyCode == 5) {
            if (this.currentIndex < this.tabItems.size() - 1) {
                ++this.currentIndex;
            }
            if (this.currentIndex > this.startIndex + this.itemNumPerPage * this.lineNum - 1) {
                ++this.startIndex;
            }
            this.refreshTabView();
        } else if (keyCode == 6 || keyCode == 1 ? (sube = this.currentSubItem.keyReleasedAction(keyCode)) != null : keyCode == 8 && (sube = this.currentSubItem.keyReleasedAction(keyCode)) != null) {
            return sube;
        }
        ViewEvent e = new ViewEvent();
        e.setView(this);
        e.setSource(this.currentSubItem);
        e.setKeyCode(keyCode);
        e.setDesc("tab");
        return var2_2;
    }

    public ViewEvent keyReleasedAction(int keyCode) {
        if (this.lineNum < 2) {
            return this.keyReleasedSingleLine(keyCode);
        }
        return this.keyReleasedMoreLine(keyCode);
    }

    public ViewEvent pointerDragged(int lastX, int lastY, int px, int py) {
        ++this.iCounter;
        if (this.iCounter > 9999) {
            this.iCounter = 0;
        }
        ViewEvent e = new ViewEvent();
        e.setView(this);
        if (this.iCounter % 2 == 0) {
            return e;
        }
        if (this.currentSubItem != null) {
            return this.currentSubItem.pointerDragged(lastX, lastY, px, py);
        }
        return e;
    }

    public ViewEvent pointerReleased(int px, int py) {
        ViewEvent e = new ViewEvent();
        int arrowWidth = 10;
        if (this.imgLeft != null) {
            arrowWidth = this.imgLeft.getWidth();
        }
        if (View.isPointInRect(px, py, this.x, this.y, arrowWidth + 3, this.itemTitleHeight)) {
            return this.keyReleasedAction(2);
        }
        if (View.isPointInRect(px, py, this.x + this.width - arrowWidth - 3, this.y, arrowWidth + 6, this.itemTitleHeight)) {
            return this.keyReleasedAction(5);
        }
        if (this.clickTableName(px, py)) {
            e.setKeyCode(2);
            e.setView(this);
            return e;
        }
        int i = 0;
        while (i < this.tabItems.size()) {
            View v = (View)this.tabItems.elementAt(i);
            if (i == this.currentIndex) {
                if (v.isPointMe(px, py)) {
                    return v.pointerReleased(px, py);
                }
                if (v.getLeftButton() != null) {
                    e.setView(v.getLeftButton());
                    e.setKeyCode(-6);
                    e.setSource(v.getLeftButton());
                    return e;
                }
                if (v.getRightButton() != null) {
                    e.setView(v.getRightButton());
                    e.setKeyCode(-7);
                    e.setSource(v.getRightButton());
                    return e;
                }
            }
            ++i;
        }
        return e;
    }

    public boolean isPointMe(int px, int py) {
        if (px >= this.x && py >= this.y && px - this.x <= this.width && py - this.y <= this.height) {
            return true;
        }
        int i = 0;
        while (i < this.tabItems.size()) {
            View v = (View)this.tabItems.elementAt(i);
            if (v.isPointMe(px, py)) {
                return true;
            }
            if (v.getLeftButton() != null && v.getLeftButton().isPointMe(px, py)) {
                return true;
            }
            if (v.getRightButton() != null && v.getRightButton().isPointMe(px, py)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean clickTableName(int px, int py) {
        int dx = this.x + this.imgLeft.getWidth() + 3;
        int dy = this.y;
        int i = this.startIndex;
        while (i < this.startIndex + this.itemNumPerPage) {
            if (i > this.tabItems.size() - 1) break;
            Image tmpImg = this.selectImg2;
            if (i == this.currentIndex) {
                tmpImg = this.selectImg1;
            }
            if (View.isPointInRect(px, py, dx, dy, tmpImg.getWidth(), tmpImg.getHeight())) {
                this.currentIndex = i;
                this.refreshTabView();
                return true;
            }
            dx += 2;
            if (i - this.startIndex >= this.itemNumPerPage - 1 || (dx += this.itemTitleWidth) > this.x + this.width) break;
            ++i;
        }
        return false;
    }

    public int getCurrentIndex() {
        return this.currentIndex;
    }

    public void setCurrentIndex(int currentIndex) {
        this.currentIndex = currentIndex;
    }

    public int itemSize() {
        return this.tabItems.size();
    }

    public int getStartIndex() {
        return this.startIndex;
    }

    public void setStartIndex(int startIndex) {
        this.startIndex = startIndex;
        if (startIndex > this.tabItems.size() - 1 - this.itemNumPerPage) {
            startIndex = this.tabItems.size() - 1 - this.itemNumPerPage;
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
    }
}

