/*
 * Decompiled with CFR 0.152.
 */
package com.canvas.view.item;

import com.canvas.view.View;
import javax.microedition.lcdui.Graphics;

public class TitleView
extends View {
    public byte labelMode = 0;
    public static final byte LABELMODE_RIGHT = 0;
    public static final byte LABELMODE_LEFT = 1;
    public boolean isTicker = true;
    private int iCounter = 0;

    public TitleView() {
        this.isPointeMe = false;
        this.type = 8;
    }

    public void setLabelMode(String mode) {
        if (mode.endsWith("LEFT") || mode.endsWith("left")) {
            this.labelMode = 1;
        }
    }

    public void setLabel(String label) {
        if (label == null) {
            return;
        }
        this.iCounter = 0;
        this.label = label.length() > 6 && !this.isTicker ? String.valueOf(label.substring(0, 6)) + "..." : label;
    }

    public void paint(Graphics g) {
        super.paint(g);
        if (this.label != null) {
            g.setColor(this.fontColor);
            g.setFont(this.font);
            if (this.isTicker) {
                this.tickerPaint(g);
            } else {
                int dx = this.x + this.width - this.font.stringWidth(this.label) - 4;
                if (this.labelMode == 1) {
                    dx = this.x + 2;
                }
                int dy = this.y + (this.height - this.font.getHeight() >> 1);
                if (this.labelMode == 1) {
                    g.drawString(this.label, dx, dy, 20);
                } else {
                    g.drawString(this.label, this.x + this.width - g.getFont().stringWidth(this.label), dy, 20);
                }
            }
        }
    }

    public void tickerPaint(Graphics g) {
        if (this.labelMode == 1) {
            this.tickerPaintLeft(g);
        } else {
            this.tickerPaintRight(g);
        }
    }

    public void tickerPaintLeft(Graphics g) {
        int dx = this.x + 2;
        int dy = this.y + (this.height - this.font.getHeight() >> 1);
        int drawWidth = this.width / 3 + 15;
        if (g.getFont().stringWidth(this.label) > drawWidth - 2) {
            ++this.iCounter;
            int drawX = dx;
            drawX = this.iCounter < 30 ? dx : dx + 30 - this.iCounter;
            int cx = g.getClipX();
            int cy = g.getClipY();
            int cw = g.getClipWidth();
            int ch = g.getClipHeight();
            g.setClip(dx, dy, 100, g.getFont().getHeight());
            g.drawString(this.label, drawX, dy, 20);
            g.setClip(cx, cy, cw, ch);
            if (this.iCounter > g.getFont().stringWidth(this.label) + 10) {
                this.iCounter = 0;
            }
        } else {
            g.drawString(this.label, dx, dy, 20);
        }
    }

    public void tickerPaintRight(Graphics g) {
        int dx = this.x + this.width - this.font.stringWidth(this.label);
        int dy = this.y + (this.height - this.font.getHeight() >> 1);
        int drawWidth = this.width / 3 + 15;
        if (g.getFont().stringWidth(this.label) > drawWidth) {
            ++this.iCounter;
            int drawX = dx = this.x + this.width - drawWidth;
            drawX = this.iCounter < 30 ? dx : dx + 30 - this.iCounter;
            int cx = g.getClipX();
            int cy = g.getClipY();
            int cw = g.getClipWidth();
            int ch = g.getClipHeight();
            g.setClip(dx, dy, drawWidth, g.getFont().getHeight());
            g.drawString(this.label, drawX, dy, 20);
            g.setClip(cx, cy, cw, ch);
            if (this.iCounter > g.getFont().stringWidth(this.label) + 10) {
                this.iCounter = 0;
            }
        } else {
            g.drawString(this.label, dx, dy, 20);
        }
    }
}

