/*
 * Decompiled with CFR 0.152.
 */
package com.file;

import com.canvas.TheCanvas;
import com.file.DownloadFile;
import com.file.File;
import com.file.FileManager;
import com.file.FileOperatException;
import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;
import javax.microedition.io.Connector;
import javax.microedition.io.HttpConnection;
import javax.microedition.io.file.FileConnection;

public class DownloadManager {
    public static final int MAX_LIST_SIZE = 32;
    public static final int RECEIVE_BUFFER_LENGTH = 64;
    public static final int MAX_TIPS_NAME_LENGTH = 18;
    public static final int WAIT_FOR_START = 2;
    public static long lastFileId;
    public static Vector downloadList;
    public static final String TEMP_DIR = "temp";
    public static String saveDir;
    private static HttpConnection conn;
    private static FileConnection dataFile;
    private static OutputStream dataOs;
    private static InputStream remoteIs;
    private static DownloadFile currentDfile;
    private static boolean downLoadSwitch;
    private static int startCount;

    static {
        downloadList = new Vector();
        dataFile = null;
        dataOs = null;
        remoteIs = null;
        downLoadSwitch = true;
        saveDir = FileManager.defaultStoreURL;
        if (saveDir != null) {
            try {
                if (!FileManager.isExist(String.valueOf(saveDir) + TEMP_DIR + "/")) {
                    FileManager.makeDir(saveDir, TEMP_DIR);
                }
                DownloadManager.loadDownloadList();
            }
            catch (Exception e) {
                saveDir = null;
            }
        }
    }

    public static void start() {
        if (!downLoadSwitch || saveDir == null) {
            return;
        }
        if (startCount < 2) {
            if (++startCount < 0) {
                startCount = 0;
            }
            return;
        }
        if (currentDfile == null && (currentDfile = DownloadManager.getCurrentDownloadFile()) != null && downLoadSwitch) {
            DownloadManager.download(currentDfile);
        }
    }

    public static void pause() {
        downLoadSwitch = false;
        DownloadManager.yield();
    }

    public static void resume() {
        downLoadSwitch = true;
    }

    public static void yield() {
        if (currentDfile != null) {
            currentDfile.setType((byte)2);
            currentDfile = null;
            DownloadManager.closeConnection();
        }
        startCount = 0;
    }

    public static String getCurrentPercent() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addDownloadFile(DownloadFile dfile, boolean checkUrl, boolean directDownload) throws FileOperatException {
        Vector vector = downloadList;
        synchronized (vector) {
            if (downloadList.size() < 32) {
                File[] files;
                String dfileName = null;
                if (checkUrl) {
                    int i = 0;
                    while (i < downloadList.size()) {
                        String oldUrl = ((DownloadFile)downloadList.elementAt(i)).getDownloadUrl();
                        oldUrl = oldUrl.substring(0, oldUrl.indexOf(63));
                        String newUrl = dfile.getDownloadUrl();
                        if (oldUrl.equals(newUrl = newUrl.substring(0, newUrl.indexOf(63)))) {
                            throw new FileOperatException("\u8be5\u4efb\u52a1\u5df2\u5728\u4e0b\u8f7d\u5217\u8868\u4e2d\u3002");
                        }
                        ++i;
                    }
                    dfileName = dfile.getFileName();
                    if (dfileName == null || dfileName.length() < 1) {
                        throw new FileOperatException("\u65e0\u6cd5\u6dfb\u52a0\u4efb\u52a1\uff01\u60a8\u8981\u4e0b\u8f7d\u7684\u8d44\u6e90\u4e0d\u5b58\u5728");
                    }
                }
                if (!directDownload && (files = FileManager.getSubFiles(new File(saveDir, null), (byte)2)) != null) {
                    int i = 0;
                    while (i < files.length) {
                        if (dfileName.equals(files[i].getFullName())) {
                            throw new FileOperatException("\u60a8\u8981\u4e0b\u8f7d\u7684\u6587\u4ef6 " + (dfileName.length() < 18 ? dfileName : String.valueOf(dfileName.substring(0, 18)) + "...") + " \u5df2\u5b58\u5728\uff0c\u662f\u5426\u518d\u4e0b\u8f7d\u4e00\u6b21 \uff1f", 1);
                        }
                        ++i;
                    }
                }
            } else {
                throw new FileOperatException("\u65e0\u6cd5\u6dfb\u52a0\u4efb\u52a1\uff01\u4e0b\u8f7d\u5217\u8868\u6700\u591a\u53ea\u80fd\u6709 32 \u4e2a\u4efb\u52a1");
            }
            DownloadManager.saveInfo(dfile);
            downloadList.addElement(dfile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DownloadFile[] getDisplayList() {
        DownloadFile[] list = null;
        Vector vector = downloadList;
        synchronized (vector) {
            if (downloadList.size() > 0) {
                list = new DownloadFile[downloadList.size()];
                int i = 0;
                while (i < downloadList.size()) {
                    list[i] = (DownloadFile)downloadList.elementAt(i);
                    ++i;
                }
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DownloadFile getCurrentDownloadFile() {
        DownloadFile df = null;
        Vector vector = downloadList;
        synchronized (vector) {
            if (downloadList.size() > 0) {
                int i = 0;
                while (i < downloadList.size()) {
                    df = (DownloadFile)downloadList.elementAt(i);
                    if (df.getType() != 3 && df.getType() != 4) {
                        df.setType((byte)1);
                        return df;
                    }
                    ++i;
                }
            }
        }
        return null;
    }

    private static void closeConnection() {
        try {
            if (dataOs != null) {
                dataOs.close();
                dataOs = null;
            }
            if (dataFile != null) {
                dataFile.close();
                dataFile = null;
            }
            if (remoteIs != null) {
                remoteIs.close();
                remoteIs = null;
            }
            if (conn != null) {
                conn.close();
                conn = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void download(DownloadFile dfile) {
        long dataLength;
        DownloadManager.closeConnection();
        String fileName = dfile.getFileName();
        try {
            conn = (HttpConnection)Connector.open((String)dfile.getDownloadUrl());
            System.out.println(".....................downloadUrl = " + dfile.getDownloadUrl());
            TheCanvas.addTestInfo(".....................downloadUrl = " + dfile.getDownloadUrl());
            if (dfile.getFileUrl() == null) {
                dataFile = FileManager.checkDuplicatName(saveDir, fileName, 0);
                String name = dataFile.getName();
                dataFile.rename(String.valueOf(name) + ".do");
                dfile.setFileUrl(String.valueOf(saveDir) + name);
                DownloadManager.saveInfo(dfile);
            } else {
                dataFile = FileManager.getConnection(dfile.getFileUrl());
            }
            dataLength = 0L;
            if (dataFile == null) {
                dfile.fail();
                return;
            }
            dataLength = dataFile.fileSize();
        }
        catch (Exception e) {
            if (currentDfile != null) {
                dfile.fail();
            }
            e.printStackTrace();
            return;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        {
            conn.setRequestProperty("Accept", "*/*");
            conn.setRequestProperty("RANGE", "bytes=" + dataLength + "-");
            System.out.println("................................befor get code.....................");
            TheCanvas.addTestInfo("................................befor get code.....................");
            int rspCode = conn.getResponseCode();
            if (currentDfile == null) return;
            if (!downLoadSwitch) {
                return;
            }
            System.out.println("................................code = " + rspCode);
            TheCanvas.addTestInfo("................................code = " + rspCode);
            if (rspCode != 200 && rspCode != 206 && rspCode != 302) {
                if (rspCode == 416 && dfile.getFileUrl() != null) {
                    DownloadManager.finished(dfile);
                    return;
                }
                dfile.fail();
                return;
            }
            if (rspCode == 302) {
                String newUrl = conn.getHeaderField("Location");
                System.out.println("................newUrl = " + newUrl);
                TheCanvas.addTestInfo("................newUrl = " + newUrl);
                conn.close();
                conn = (HttpConnection)Connector.open((String)newUrl);
                conn.setRequestProperty("Accept", "*/*");
                conn.setRequestProperty("RANGE", "bytes=" + dataLength + "-");
                int rspCode302 = conn.getResponseCode();
                System.out.println("................................rspCode302 = " + rspCode302);
                TheCanvas.addTestInfo("................................rspCode302 = " + rspCode302);
                if (rspCode302 != 200 && rspCode302 != 206) {
                    if (rspCode == 416 && dfile.getFileUrl() != null) {
                        DownloadManager.finished(dfile);
                        return;
                    }
                    dfile.fail();
                    return;
                }
            }
            System.out.println("................................after get code.....................");
            TheCanvas.addTestInfo("................................after get code.....................");
            String contentLength = conn.getHeaderField("Content-Length");
            if (currentDfile == null) return;
            if (!downLoadSwitch) {
                return;
            }
            String contentType = conn.getHeaderField("Content-Type");
            System.out.println(fileName);
            System.out.println("dfile.total length = " + dfile.getTotalSize());
            System.out.println("downloaded length = " + dataLength);
            System.out.println("new length = " + contentLength);
            System.out.println(contentType);
            TheCanvas.addTestInfo(fileName);
            TheCanvas.addTestInfo("dfile.total length = " + dfile.getTotalSize());
            TheCanvas.addTestInfo("downloaded length = " + dataLength);
            TheCanvas.addTestInfo("new length = " + contentLength);
            TheCanvas.addTestInfo(contentType);
            long downloadSize = Long.parseLong(contentLength);
            if (dataLength == 0L && dfile.getTotalSize() == 0L) {
                dfile.setTotalSize(downloadSize);
                DownloadManager.saveInfo(dfile);
            }
            dataOs = dataFile.openOutputStream(dataLength);
            remoteIs = conn.openInputStream();
            byte[] b = new byte[64];
            int length = -1;
            while ((length = remoteIs.read(b)) != -1) {
                dataOs.write(b, 0, length);
                dfile.currentSize += (long)length;
                if (currentDfile == null) return;
                if (downLoadSwitch) continue;
                return;
            }
            System.out.println("dataFile.fileSize() = " + dataFile.fileSize());
            TheCanvas.addTestInfo("dataFile.fileSize() = " + dataFile.fileSize());
            DownloadManager.finished(dfile);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void finished(DownloadFile dfile) {
        try {
            dataOs.close();
            dataOs = null;
            dataFile.close();
            dataFile = null;
            String fileName = dfile.getTempFileName(dfile.getFileUrl());
            FileManager.rename(dfile.getFileUrl(), fileName);
            FileManager.delFile(dfile.getInfoUrl());
            Vector vector = downloadList;
            synchronized (vector) {
                downloadList.removeElement(dfile);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            dfile.fail();
        }
        currentDfile = null;
    }

    public static void saveInfo(DownloadFile dfile) {
        FileConnection infoFile = null;
        OutputStream os = null;
        try {
            try {
                if (dfile.getInfoUrl() == null) {
                    infoFile = FileManager.makeFile(String.valueOf(saveDir) + TEMP_DIR + "/", String.valueOf(++lastFileId) + ".data");
                    dfile.setInfoUrl(String.valueOf(saveDir) + TEMP_DIR + "/" + lastFileId + ".data");
                } else {
                    infoFile = FileManager.openFile(dfile.getInfoUrl());
                }
                os = infoFile.openOutputStream();
                os.write(dfile.getSeriers());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        finally {
            try {
                if (infoFile != null) {
                    infoFile.close();
                }
                if (os != null) {
                    os.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadDownloadList() {
        System.out.println(".....................loadDownloadList()");
        Vector vector = downloadList;
        synchronized (vector) {
            File[] dfiles = FileManager.getSubFiles(new File(String.valueOf(saveDir) + TEMP_DIR + "/", null), (byte)2);
            if (dfiles != null) {
                int i = 0;
                while (i < dfiles.length) {
                    if (dfiles[i].getFullName().endsWith(".data")) {
                        FileConnection dfile = null;
                        FilterInputStream dis = null;
                        try {
                            try {
                                dfile = FileManager.getConnection(dfiles[i].getLocator());
                                dis = dfile.openDataInputStream();
                                DownloadFile newDfile = DownloadFile.createFromSeriers((DataInputStream)dis);
                                if (newDfile != null) {
                                    if (!newDfile.getInfoUrl().equals(dfiles[i].getLocator())) {
                                        newDfile.setInfoUrl(dfiles[i].getLocator());
                                    }
                                    DownloadManager.addDownloadFile(newDfile, false, true);
                                    DownloadManager.setLastFileId(dfiles[i].getName());
                                }
                            }
                            catch (FileOperatException e) {
                                e.printStackTrace();
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                        finally {
                            try {
                                if (dfile != null) {
                                    dfile.close();
                                }
                                if (dis != null) {
                                    dis.close();
                                }
                            }
                            catch (Exception exception) {}
                        }
                    }
                    ++i;
                }
            }
        }
    }

    private static void setLastFileId(String name) {
        try {
            long id = Long.parseLong(name);
            if (id > lastFileId) {
                lastFileId = id;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void start(DownloadFile dfile) {
        Vector vector = downloadList;
        synchronized (vector) {
            if (dfile.getType() == 1 || dfile.getType() == 2) {
                return;
            }
            dfile.setFailCount(0);
            dfile.setType((byte)2);
            DownloadManager.saveInfo(dfile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void pause(DownloadFile dfile) {
        Vector vector = downloadList;
        synchronized (vector) {
            if (dfile.getType() == 1 || dfile.getType() == 2) {
                if (dfile.getType() == 1) {
                    DownloadManager.yield();
                }
                dfile.setType((byte)3);
                DownloadManager.saveInfo(dfile);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void startAll() {
        Vector vector = downloadList;
        synchronized (vector) {
            if (downloadList.size() > 0) {
                int i = 0;
                while (i < downloadList.size()) {
                    DownloadManager.start((DownloadFile)downloadList.elementAt(i));
                    ++i;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void pauseAll() {
        Vector vector = downloadList;
        synchronized (vector) {
            if (downloadList.size() > 0) {
                int i = 0;
                while (i < downloadList.size()) {
                    DownloadManager.pause((DownloadFile)downloadList.elementAt(i));
                    ++i;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void delete(DownloadFile dfile) {
        Vector vector = downloadList;
        synchronized (vector) {
            if (dfile.getType() == 1) {
                DownloadManager.yield();
            }
            try {
                if (dfile.getFileUrl() != null && FileManager.isExist(dfile.getFileUrl())) {
                    FileManager.delFile(dfile.getFileUrl());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                FileManager.delFile(dfile.getInfoUrl());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            downloadList.removeElement(dfile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteAll() {
        Vector vector = downloadList;
        synchronized (vector) {
            DownloadManager.pauseAll();
            DownloadManager.pause();
            while (downloadList.size() > 0) {
                int i = 0;
                while (i < downloadList.size()) {
                    DownloadManager.delete((DownloadFile)downloadList.elementAt(i));
                    ++i;
                }
            }
        }
        DownloadManager.resume();
    }
}

