/*
 * Decompiled with CFR 0.152.
 */
package com.canvas.view;

import com.canvas.view.item.ButtonView;
import com.canvas.view.item.Dialog;
import com.canvas.view.until.Until;
import com.canvas.view.until.ViewEvent;
import com.res.Res;
import com.scene.Scene;
import com.thread.ThreadImpl;
import java.util.Vector;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class View
implements ThreadImpl {
    protected String name = "";
    protected String id = "0";
    protected String label = "";
    protected int x;
    protected int y;
    protected int currentX;
    protected int currentY;
    protected int width;
    protected int height;
    public Vector items;
    protected Image img;
    protected Object data = null;
    public View parent = null;
    protected View container = null;
    protected boolean focus = false;
    protected boolean visible = true;
    public boolean isSelected = false;
    protected View currentSub = null;
    protected int color = 0xEEEEFF;
    protected int fontColor = 0x111111;
    protected Font font = Res.UIFONT;
    protected int transparency = -1;
    protected ButtonView leftButton;
    protected ButtonView rightButton;
    protected boolean fillBG = true;
    public Dialog tips;
    public boolean imgLoaded = false;
    protected int viewType = 0;
    public static final int VIEWTYPE_NORMAR = 0;
    public static final int VIEWTYPE_FISHEYES = 1;
    public static final int VIEWTYPE_DECREMENT = 2;
    public static final int VIEWTYPE_INCREAS = 3;
    protected int type = 0;
    public static final int TYPE_FORM = 0;
    public static final int TYPE_LIST = 1;
    public static final int TYPE_BACKGROUD = 2;
    public static final int TYPE_BUTTON = 3;
    public static final int TYPE_PRGRESS = 4;
    public static final int TYPE_TEXT = 5;
    public static final int TYPE_STRINGITEM = 6;
    public static final int TYPE_IMAGEITEM = 7;
    public static final int TYPE_TITLE = 8;
    public static final int TYPE_DIALOG = 9;
    public static final int TYPE_INPUT = 10;
    public static final int TYPE_PAGENUMBER = 11;
    public static final int TYPE_IMAGELIST = 12;
    public static final int TYPE_TAB = 13;
    protected int imgFillType = 0;
    public static final int IMGFILLTYPE_NORMAR = 0;
    public static final int IMGFILLTYPE_EXTEND = 1;
    public static final int IMGFILLTYPE_CENTER = 2;
    private Scene scene;
    private boolean passableKey = true;
    public boolean isPointeMe = true;

    public View() {
        this.items = new Vector();
    }

    public void setScene(Scene scene) {
        this.scene = scene;
    }

    public Scene getScene() {
        return this.scene;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public int getTransparency() {
        return this.transparency;
    }

    public void setTransparency(int tr) {
        if (tr == -1) {
            return;
        }
        this.transparency = tr;
        this.img = Until.createAlphaImage(this.img, tr);
    }

    public void setFillBG(boolean fillBG) {
        this.fillBG = fillBG;
    }

    public boolean getFillBG() {
        return this.fillBG;
    }

    public void setFillBG(String fillBG) {
        this.fillBG = !fillBG.equalsIgnoreCase("false");
    }

    public void setType(int type) {
        this.type = type;
    }

    public int getType() {
        return this.type;
    }

    public int getColor() {
        return this.color;
    }

    public void setColor(int color) {
        this.color = color | this.transparency << 24;
    }

    public void setPassableKey(boolean psb) {
        this.passableKey = psb;
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public View getContainer() {
        return this.container;
    }

    public void setContainer(View container) {
        this.container = container;
    }

    public boolean isFocus() {
        return this.focus;
    }

    public void setFocus(boolean focus) {
        this.focus = focus;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public Object getData() {
        return this.data;
    }

    public void setData(Object data) {
        this.data = data;
    }

    public int getViewType() {
        return this.viewType;
    }

    public void setViewType(int viewType) {
        this.viewType = viewType;
    }

    public void setFontColor(int color) {
        this.fontColor = color;
    }

    public int getFontColor() {
        return this.fontColor;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public int getX() {
        return this.x;
    }

    public void setX(int x) {
        this.x = x;
    }

    public int getY() {
        return this.y;
    }

    public void setY(int y) {
        this.y = y;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public Image getImg() {
        return this.img;
    }

    public void setImg(Image img) {
        this.img = img;
    }

    public void setImg(String name) {
        Object obj = new Object();
        if (Res.imageTable.containsKey(name)) {
            obj = Res.imageTable.get(name);
        } else {
            System.out.println(String.valueOf(this.id) + "  setImg() no img name=" + name);
            obj = Res.imageTable.get(Res.DEFAULTIMG);
        }
        if (obj instanceof Image) {
            this.img = (Image)obj;
            this.setImg(this.img);
        }
    }

    public void setImgType(String type) {
        if (type.equalsIgnoreCase("EXTEND")) {
            this.imgFillType = 1;
            this.img = Until.transImage(this.img, this.width, this.height);
        } else {
            this.imgFillType = type.equalsIgnoreCase("CENTER") ? 2 : 0;
        }
    }

    public void setImgType(int type) {
        if (type == 1) {
            this.imgFillType = type;
            this.img = Until.transImage(this.img, this.width, this.height);
        } else {
            this.imgFillType = type == 2 ? 2 : 0;
        }
    }

    public void addItem(View view) {
        if (view == null) {
            return;
        }
        view.setContainer(this);
        this.items.addElement(view);
        if (this.items.size() == 1) {
            this.currentSub = view;
        }
    }

    public void setLeftButton(ButtonView bv) {
        this.leftButton = bv;
        if (bv != null) {
            this.leftButton.container = this;
        }
    }

    public void setRightButton(ButtonView bv) {
        this.rightButton = bv;
        if (bv != null) {
            this.rightButton.container = this;
        }
    }

    public ButtonView getLeftButton() {
        return this.leftButton;
    }

    public ButtonView getRightButton() {
        return this.rightButton;
    }

    public void setImageSize(int level) {
    }

    public void clear() {
        int i = 0;
        while (i < this.items.size()) {
            View v = (View)this.items.elementAt(i);
            v.clear();
            ++i;
        }
    }

    public int getCurrentX() {
        return this.currentX;
    }

    public void setCurrentX(int currentX) {
        this.currentX = currentX;
    }

    public int getCurrentY() {
        return this.currentY;
    }

    public void setCurrentY(int currentY) {
        this.currentY = currentY;
    }

    public void paint(Graphics g) {
        if (!this.visible) {
            return;
        }
        if (this.transparency == -1 && this.fillBG) {
            g.setColor(this.color);
            g.fillRect(this.x, this.y, this.width, this.height);
        }
        this.drawImage(g, this.img, this.x, this.y);
        int i = 0;
        while (i < this.items.size()) {
            View view = (View)this.items.elementAt(i);
            if (view != null) {
                view.paint(g);
            }
            ++i;
        }
        if (this.leftButton != null) {
            this.leftButton.paint(g);
        }
        if (this.rightButton != null) {
            this.rightButton.paint(g);
        }
        if (this.tips != null) {
            this.tips.paint(g);
        }
    }

    public void drawImage(Graphics g, Image img, int x, int y) {
        if (img == null) {
            return;
        }
        if (this.imgFillType == 2) {
            g.drawImage(img, x + (this.width - img.getWidth() >> 1), y + (this.height - img.getHeight() >> 1), 20);
        } else if (this.imgFillType == 1) {
            g.drawImage(img, x, y, 20);
        } else {
            g.drawImage(img, x, y, 20);
        }
    }

    public View getCurrentSub() {
        if (this.items.size() < 1) {
            return null;
        }
        if (this.currentSub == null) {
            return (View)this.items.elementAt(0);
        }
        return this.currentSub;
    }

    public void setCurrentSub(View currentSub) {
        this.currentSub = currentSub;
    }

    public ViewEvent keyPressedAction(int keyCode) {
        int i = 0;
        while (i < this.items.size()) {
            View view = (View)this.items.elementAt(i);
            if (view.isFocus()) {
                view.isSelected = true;
                return view.keyPressedAction(keyCode);
            }
            ++i;
        }
        return null;
    }

    public ViewEvent keyRepeatAction(int keyCode) {
        int i = 0;
        while (i < this.items.size()) {
            View view = (View)this.items.elementAt(i);
            if (view.isFocus()) {
                view.isSelected = true;
                return view.keyRepeatAction(keyCode);
            }
            ++i;
        }
        return null;
    }

    public void removeItem(View view) {
        if (view != null) {
            this.items.removeElement(view);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ViewEvent keyReleasedAction(int keyCode) {
        void var2_5;
        if (this.tips != null && this.tips.isVisible()) {
            return this.tips.keyReleasedAction(keyCode);
        }
        if (keyCode == -6 && this.passableKey) {
            if (this.leftButton != null) {
                if (this.leftButton.getButtonType() != 1) return this.leftButton.keyReleasedAction(keyCode);
                if (this.leftButton.isPopup()) {
                    this.leftButton.popin();
                } else {
                    this.leftButton.popout();
                }
            }
        } else if (keyCode == -7) {
            if (this.rightButton != null) {
                ViewEvent event = new ViewEvent();
                event.setKeyCode(keyCode);
                event.setSource(this.rightButton);
                event.setView(this);
                event.setDesc("back");
                return event;
            }
        } else if (keyCode == 8) {
            if (this.leftButton != null && this.leftButton.isPopup() && this.passableKey) {
                ViewEvent e = this.leftButton.keyReleasedAction(keyCode);
                e.setView(this);
                this.leftButton.popin();
                return e;
            }
        } else if ((keyCode == 6 || keyCode == 1) && this.leftButton != null && this.leftButton.getButtonType() == 1 && this.leftButton.isPopup()) {
            return this.leftButton.keyReleasedAction(keyCode);
        }
        if (this.leftButton != null && this.leftButton.isPopup()) {
            return null;
        }
        if (this.passableKey) {
            int i = 0;
            while (i < this.items.size()) {
                View view = (View)this.items.elementAt(i);
                if (view.isFocus()) {
                    view.isSelected = false;
                    return view.keyReleasedAction(keyCode);
                }
                ++i;
            }
        }
        ViewEvent e = new ViewEvent();
        e.setKeyCode(keyCode);
        e.setView(this);
        return var2_5;
    }

    public View copytoView(View view) {
        view.label = this.label;
        view.x = this.x;
        view.y = this.y;
        view.width = this.width;
        view.height = this.height;
        view.img = this.img;
        view.imgFillType = this.imgFillType;
        view.data = this.data;
        view.container = this.container;
        view.parent = this.parent;
        view.focus = this.focus;
        view.visible = this.visible;
        view.isSelected = this.isSelected;
        view.currentSub = this.currentSub;
        view.color = this.color;
        view.fontColor = this.fontColor;
        view.transparency = this.transparency;
        view.viewType = this.viewType;
        view.type = this.type;
        view.scene = this.scene;
        view.img = this.img;
        view.font = this.font;
        view.fillBG = this.fillBG;
        int i = 0;
        while (i < this.items.size()) {
            view.addItem((View)this.items.elementAt(i));
            ++i;
        }
        return view;
    }

    public boolean getActionResult() {
        return false;
    }

    public void setActionResult(boolean result) {
    }

    public void threadAction() {
    }

    public void popout() {
    }

    public void popin() {
    }

    public ViewEvent pointerDragged(int lastX, int lastY, int px, int py) {
        System.out.println("id=" + this.id);
        int i = 0;
        while (i < this.items.size()) {
            View v = (View)this.items.elementAt(i);
            if ((v.getType() == 5 || v.getType() == 1 || v.getType() == 13) && v.isPointMe(lastX, lastY) && v.isPointMe(px, py)) {
                return v.pointerDragged(lastX, lastY, px, py);
            }
            ++i;
        }
        return new ViewEvent();
    }

    public ViewEvent pointerReleased(int px, int py) {
        int i;
        if (this.leftButton != null && this.leftButton.isPointMe(px, py)) {
            return this.keyReleasedAction(-6);
        }
        if (this.rightButton != null && this.rightButton.isPointMe(px, py)) {
            return this.keyReleasedAction(-7);
        }
        if (this.tips != null && this.tips.isVisible() && this.tips.isPointMe(px, py)) {
            return this.tips.pointerReleased(px, py);
        }
        if (this.leftButton != null && this.leftButton.isPopup()) {
            i = 0;
            while (i < this.leftButton.items.size()) {
                ButtonView bv = (ButtonView)this.leftButton.items.elementAt(i);
                if (bv.isPointMe(px, py) && bv.isVisible()) {
                    this.leftButton.setCurrentSub(bv);
                    bv.setFocus(true);
                    this.leftButton.popin();
                    return bv.keyReleasedAction(8);
                }
                ++i;
            }
            this.leftButton.popin();
        }
        i = 0;
        while (i < this.items.size()) {
            View v = (View)this.items.elementAt(i);
            if (v.isPointeMe && v.isVisible() && v.isPointMe(px, py)) {
                return v.pointerReleased(px, py);
            }
            ++i;
        }
        if (!this.isPointMe(px, py)) {
            return null;
        }
        ViewEvent e = new ViewEvent();
        e.setKeyCode(8);
        e.setView(this);
        e.setSource(this.data);
        this.setFocus(true);
        if (this.parent != null) {
            this.parent.setCurrentSub(this);
        }
        return e;
    }

    public boolean isPointMe(int px, int py) {
        return px >= this.x && py >= this.y && px - this.x <= this.width && py - this.y <= this.height;
    }

    public static boolean isPointInRect(int px, int py, int x, int y, int width, int height) {
        return px >= x && py >= y && px - x <= width && py - y <= height;
    }
}

