/*
 * Decompiled with CFR 0.152.
 */
import java.util.Enumeration;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;

public class Dialog
extends Window {
    private int displayWindowWidth;
    private int displayWindowHeight;
    private int scrollableTop;
    private int scrollableHeight;
    private int Scroll;
    private int scrollOffset;
    private Vector text;
    private DialogConfig dialogConfig;

    public Dialog() {
        this.dialogConfig = null;
        this.displayWindowHeight = 0;
        this.displayWindowWidth = 0;
        this.scrollableTop = 0;
        this.scrollableHeight = 0;
        this.Scroll = 0;
        this.scrollOffset = 0;
    }

    public Dialog(DialogConfig dialogConfig) {
        this.setConfig(dialogConfig);
    }

    public void setDialogConfig(DialogConfig dialogConfig) {
        this.setConfig(dialogConfig);
        this.dialogConfig = dialogConfig;
        if (dialogConfig.text != null) {
            this.setText(dialogConfig.text);
        }
        this.updateDimensions();
    }

    public DialogConfig getDialogConfig() {
        return this.dialogConfig;
    }

    public String getText() {
        return this.dialogConfig.getText();
    }

    public synchronized void setText(String text) {
        this.dialogConfig.setText(text);
        this.updateDimensions();
        if (this.text != null) {
            this.text.removeAllElements();
        }
        this.text = this.dialogConfig.text_Font.wrap(text, this.displayWindowWidth - this.dialogConfig.item_xPos);
        this.scrollableHeight = this.text.size() * (this.dialogConfig.text_Font.getHeight() + this.dialogConfig.text_Font.getLeading());
        this.scrollOffset = 0;
    }

    public void resetTextPos() {
        this.scrollOffset = 0;
    }

    public void updateDimensions() {
        this.displayWindowHeight = this.dialogConfig.height - (this.dialogConfig.footer_Image != null ? this.dialogConfig.footer_Image.getHeight() : 0) - 4;
        int n = this.displayWindowHeight = this.displayWindowHeight > 0 ? this.displayWindowHeight : 1;
        if (this.dialogConfig.header_Image != null) {
            this.displayWindowHeight -= this.dialogConfig.header_Image.getHeight();
        } else if (this.dialogConfig.title != null) {
            this.displayWindowHeight -= this.dialogConfig.text_Font.getHeight();
        }
        this.displayWindowWidth = this.dialogConfig.width - this.dialogConfig.border.thickness * 3 - this.dialogConfig.scrollbar_Thickness;
        this.displayWindowWidth = this.displayWindowWidth > 0 ? this.displayWindowWidth : 1;
    }

    public void paintContent(Graphics g, int xItem, int yItem, int anchor) {
        int scrollTop = yItem;
        if (this.dialogConfig.autoScroll) {
            this.scrollOffset += this.dialogConfig.scroll_Rate;
            this.scrollOffset = this.scrollOffset < this.scrollableHeight - this.displayWindowHeight ? this.scrollOffset : this.scrollableHeight - this.displayWindowHeight;
        }
        g.setClip(xItem, yItem - 1, this.displayWindowWidth, this.displayWindowHeight - this.dialogConfig.text_Font.getHeight());
        yItem += this.dialogConfig.text_Font.drawString(g, this.text, xItem, yItem - this.scrollOffset, this.dialogConfig.height + this.dialogConfig.yPos, 20);
        g.setClip(this.dialogConfig.xPos + this.dialogConfig.border.thickness, this.dialogConfig.yPos + this.dialogConfig.border.thickness, this.dialogConfig.width - this.dialogConfig.border.thickness * 2, this.dialogConfig.height - this.dialogConfig.border.thickness * 2);
        if (this.dialogConfig.scrollbar_Thickness > 0) {
            this.drawScrollBar(g, scrollTop, this.dialogConfig.height - 1 - (this.dialogConfig.border.horizontal_Top_Image != null ? this.dialogConfig.border.horizontal_Top_Image.getHeight() : this.dialogConfig.border.thickness), this.scrollOffset * 100 / this.scrollableHeight, (this.scrollOffset + this.displayWindowHeight) * 100 / this.scrollableHeight);
        }
    }

    public void drawScrollBar(Graphics g, int top, int bottom, int topPct, int bottomPct) {
        if (topPct > 0 || bottomPct <= 100) {
            int right = this.dialogConfig.xPos + this.dialogConfig.width - 1 - (this.dialogConfig.border.vertical_Top_Image != null ? this.dialogConfig.border.vertical_Top_Image.getWidth() : this.dialogConfig.border.thickness);
            int height = bottom - top + this.dialogConfig.yPos;
            g.setColor(this.dialogConfig.scrollbar_Color);
            g.drawLine(right - this.dialogConfig.scrollbar_Thickness, top, right, top);
            g.drawLine(right - this.dialogConfig.scrollbar_Thickness, top, right - this.dialogConfig.scrollbar_Thickness, bottom + this.dialogConfig.yPos);
            g.drawLine(right - this.dialogConfig.scrollbar_Thickness, bottom + this.dialogConfig.yPos, right, bottom + this.dialogConfig.yPos);
            g.drawLine(right, top, right, bottom + this.dialogConfig.yPos);
            top += 2;
            g.setColor(this.dialogConfig.scrollball_Color);
            int sbTop = (height -= 2) * topPct / 100;
            int sbBottom = Math.min(height, Math.max(height * bottomPct / 100, sbTop + 1)) - 2;
            for (int i = 1; i < this.dialogConfig.scrollbar_Thickness; ++i) {
                g.drawLine(right - i, top + sbTop, right - i, top + sbBottom);
            }
        }
    }

    public void keyPressed(int gameCode, int keyCode) {
        if (gameCode == 1) {
            this.scrollOffset -= this.dialogConfig.scroll_Rate;
            this.scrollOffset = this.scrollOffset > 0 ? this.scrollOffset : 0;
        } else if (gameCode == 6) {
            if (this.displayWindowHeight < this.scrollableHeight) {
                this.scrollOffset += this.dialogConfig.scroll_Rate;
                this.scrollOffset = this.scrollOffset < this.scrollableHeight - this.displayWindowHeight ? this.scrollOffset : this.scrollableHeight - this.displayWindowHeight;
            }
        } else if (gameCode == 2 || gameCode == 5 || gameCode == 8) {
            // empty if block
        }
        Enumeration e = this.listeners.elements();
        while (e.hasMoreElements()) {
            WindowEventNotification listener = (WindowEventNotification)e.nextElement();
            listener.windowEvent(keyCode, keyCode);
        }
    }
}

