/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class MFont {
    private Image font;
    private int height;
    private int baseline;
    private int leading;
    private int space;
    private int border;
    private short[] offset;
    private boolean emea;
    private static final String DECENDERS = "gjpqy,;_|\u00e7\u00a1\u00bf";
    private static final int[] CRC_TABLE = new int[256];

    public MFont(String name, int color) {
        this(name, color, -1);
    }

    public MFont(String name, int mainColor, int borderColor) {
        try {
            InputStream in = this.getClass().getResourceAsStream("/" + name + ".mf");
            int reserved = in.read();
            in.read();
            in.read();
            in.read();
            this.height = in.read();
            this.emea = false;
            if (this.height - 100 > 0) {
                this.height -= 100;
                this.emea = true;
            }
            this.baseline = in.read();
            this.leading = 1;
            this.space = in.read();
            this.border = in.read();
            this.offset = new short[95 + (this.emea ? 11 : 0)];
            for (int i = 0; i < 95 + (this.emea ? 11 : 0); ++i) {
                int a = in.read();
                int b = in.read();
                this.offset[i] = (short)((a & 0xFF) << 8 | b & 0xFF);
            }
            int c = in.read();
            int d = in.read();
            int imageLength = (c & 0xFF) << 8 | d & 0xFF;
            int e = in.read();
            int f = in.read();
            int palleteChunk = (e & 0xFF) << 8 | f & 0xFF;
            int g = in.read();
            int h = in.read();
            int aabbccOffset = g == 255 && h == 255 ? -1 : (g & 0xFF) << 8 | h & 0xFF;
            int j = in.read();
            int k = in.read();
            int ddeeffOffset = (j & 0xFF) << 8 | k & 0xFF;
            DataInputStream din = new DataInputStream(in);
            byte[] imageData = new byte[imageLength];
            din.readFully(imageData);
            din.close();
            if (aabbccOffset > 0) {
                this.updatePalette(imageData, palleteChunk, aabbccOffset, mainColor, ddeeffOffset, borderColor);
            }
            this.font = Image.createImage((byte[])imageData, (int)0, (int)imageLength);
        }
        catch (Exception e) {
            throw new RuntimeException("MFont: " + name + " - " + e);
        }
    }

    public int stringWidth(String str) {
        if (str == null) {
            return 0;
        }
        char[] array = str.toCharArray();
        return this.substringWidth(array, 0, array.length);
    }

    public int substringWidth(String str, int offset, int len) {
        return this.substringWidth(str.substring(offset, offset + len).toCharArray(), 0, len);
    }

    public int substringWidth(char[] array, int offset, int len) {
        int width = 0;
        int stop = offset + len;
        for (int i = offset; i < stop; ++i) {
            width += this.charWidth(array[i]) - this.border;
        }
        return width;
    }

    public int charWidth(char ch) {
        if (ch > ' ' && ch < '\u0100') {
            if (ch >= '\u007f') {
                switch (ch) {
                    case '\u00e8': 
                    case '\u00e9': 
                    case '\u00ea': {
                        ch = (char)101;
                        break;
                    }
                    case '\u00c8': 
                    case '\u00c9': 
                    case '\u00ca': {
                        ch = (char)69;
                        break;
                    }
                    case '\u00e0': 
                    case '\u00e1': 
                    case '\u00e2': 
                    case '\u00e3': 
                    case '\u00e4': {
                        ch = (char)97;
                        break;
                    }
                    case '\u00c0': 
                    case '\u00c1': 
                    case '\u00c2': 
                    case '\u00c3': 
                    case '\u00c4': {
                        ch = (char)65;
                        break;
                    }
                    case '\u00f9': 
                    case '\u00fa': 
                    case '\u00fb': 
                    case '\u00fc': {
                        ch = (char)117;
                        break;
                    }
                    case '\u00d9': 
                    case '\u00da': 
                    case '\u00db': 
                    case '\u00dc': {
                        ch = (char)85;
                        break;
                    }
                    case '\u00f2': 
                    case '\u00f3': 
                    case '\u00f4': 
                    case '\u00f5': 
                    case '\u00f6': {
                        ch = (char)111;
                        break;
                    }
                    case '\u00d2': 
                    case '\u00d3': 
                    case '\u00d4': 
                    case '\u00d5': 
                    case '\u00d6': {
                        ch = (char)79;
                        break;
                    }
                    case '\u00ec': 
                    case '\u00ed': 
                    case '\u00ee': {
                        ch = (char)105;
                        break;
                    }
                    case '\u00cc': 
                    case '\u00cd': 
                    case '\u00ce': {
                        ch = (char)73;
                        break;
                    }
                    case '\u00f1': {
                        ch = (char)110;
                        break;
                    }
                    case '\u00d1': {
                        ch = (char)78;
                        break;
                    }
                    case '\u00df': {
                        ch = (char)127;
                        break;
                    }
                    case '\u00e7': {
                        ch = (char)128;
                        break;
                    }
                    case '\u00a1': {
                        ch = (char)129;
                        break;
                    }
                    case '\u00bf': {
                        ch = (char)130;
                        break;
                    }
                    default: {
                        ch = (char)46;
                    }
                }
            }
            return this.offset[ch - 33 + 1] - this.offset[ch - 33];
        }
        if (ch == ' ') {
            return this.space;
        }
        return 0;
    }

    public int getHeight() {
        return this.height;
    }

    public int getHeight(String str) {
        char[] array = str.toCharArray();
        return this.getHeight(array, 0, str.length());
    }

    public int getHeight(String str, int offset, int len) {
        return this.getHeight(str.substring(offset, offset + len).toCharArray(), 0, len);
    }

    public int getHeight(char[] array, int offset, int len) {
        int stop = offset + len;
        for (int i = offset; i < stop; ++i) {
            char ch = array[i];
            if (DECENDERS.indexOf(ch) == -1) continue;
            return this.height;
        }
        return this.baseline + 1;
    }

    public int getHeight(Vector v) {
        return (this.height + this.leading) * v.size();
    }

    public int getBaseline() {
        return this.baseline;
    }

    public int spaceWidth() {
        return this.space;
    }

    public int getLeading() {
        return this.leading;
    }

    public void setLeading(int leading) {
        this.leading = leading;
    }

    public int drawString(Graphics g, String str, int x, int y, int layout) {
        return this.drawSubstring(g, str, 0, str.length(), x, y, layout);
    }

    public int drawString(Graphics g, Vector stringList, int x, int y, int height, int layout) {
        int yPos = y;
        int lineHeight = this.height + this.leading;
        Enumeration e = stringList.elements();
        while (e.hasMoreElements()) {
            String str = (String)e.nextElement();
            if (yPos + lineHeight >= 0 && yPos < height) {
                this.drawSubstring(g, str.toCharArray(), 0, str.length(), x, yPos, layout);
            }
            yPos += lineHeight;
        }
        return yPos - y;
    }

    public int drawSubstring(Graphics g, String str, int offset, int len, int x, int y, int layout) {
        return this.drawSubstring(g, str.substring(offset, len).toCharArray(), 0, len - offset, x, y, layout);
    }

    public int drawSubstring(Graphics g, char[] array, int offset, int len, int x, int y, int layout) {
        int clipX = g.getClipX();
        int clipY = g.getClipY();
        int clipW = g.getClipWidth();
        int clipH = g.getClipHeight();
        if ((layout & 1) != 0) {
            x -= this.substringWidth(array, offset, len) / 2;
        } else if ((layout & 8) != 0) {
            x -= this.substringWidth(array, offset, len);
        }
        if ((layout & 0x20) != 0) {
            y -= this.getHeight(array, offset, len);
        } else if ((layout & 0x40) != 0) {
            y -= this.baseline;
        }
        int width = 0;
        int stop = offset + len;
        int accent = -1;
        int accentOffset = 0;
        for (int i = offset; i < stop; ++i) {
            int ch;
            int me = ch = array[i];
            accent = -1;
            accentOffset = 0;
            if (ch == 32) {
                x += this.space;
                width += this.space;
                continue;
            }
            if (ch <= 32 || ch >= 256) continue;
            if (ch >= 127) {
                switch (ch) {
                    case 232: {
                        ch = 101;
                        accent = 0;
                        accentOffset = 1;
                        break;
                    }
                    case 233: {
                        ch = 101;
                        accent = 1;
                        accentOffset = 1;
                        break;
                    }
                    case 234: {
                        ch = 101;
                        accent = 2;
                        accentOffset = 1;
                        break;
                    }
                    case 200: {
                        ch = 69;
                        accent = 0;
                        accentOffset = 1;
                        break;
                    }
                    case 201: {
                        ch = 69;
                        accent = 1;
                        accentOffset = 1;
                        break;
                    }
                    case 202: {
                        ch = 69;
                        accent = 2;
                        accentOffset = 1;
                        break;
                    }
                    case 224: {
                        ch = 97;
                        accent = 0;
                        accentOffset = 1;
                        break;
                    }
                    case 225: {
                        ch = 97;
                        accent = 1;
                        accentOffset = 1;
                        break;
                    }
                    case 226: {
                        ch = 97;
                        accent = 2;
                        accentOffset = 1;
                        break;
                    }
                    case 227: {
                        ch = 97;
                        accent = 3;
                        accentOffset = 1;
                        break;
                    }
                    case 228: {
                        ch = 97;
                        accent = 6;
                        accentOffset = 1;
                        break;
                    }
                    case 192: {
                        ch = 65;
                        accent = 0;
                        accentOffset = 1;
                        break;
                    }
                    case 193: {
                        ch = 65;
                        accent = 1;
                        accentOffset = 1;
                        break;
                    }
                    case 194: {
                        ch = 65;
                        accent = 2;
                        accentOffset = 1;
                        break;
                    }
                    case 195: {
                        ch = 65;
                        accent = 3;
                        accentOffset = 1;
                        break;
                    }
                    case 196: {
                        ch = 65;
                        accent = 6;
                        accentOffset = 1;
                        break;
                    }
                    case 249: {
                        ch = 117;
                        accent = 0;
                        accentOffset = 1;
                        break;
                    }
                    case 250: {
                        ch = 117;
                        accent = 1;
                        accentOffset = 1;
                        break;
                    }
                    case 251: {
                        ch = 117;
                        accent = 2;
                        accentOffset = 1;
                        break;
                    }
                    case 252: {
                        ch = 117;
                        accent = 6;
                        accentOffset = 1;
                        break;
                    }
                    case 217: {
                        ch = 85;
                        accent = 0;
                        accentOffset = 1;
                        break;
                    }
                    case 218: {
                        ch = 85;
                        accent = 1;
                        accentOffset = 1;
                        break;
                    }
                    case 219: {
                        ch = 85;
                        accent = 2;
                        accentOffset = 1;
                        break;
                    }
                    case 220: {
                        ch = 85;
                        accent = 6;
                        accentOffset = 1;
                        break;
                    }
                    case 242: {
                        ch = 111;
                        accent = 0;
                        accentOffset = 1;
                        break;
                    }
                    case 243: {
                        ch = 111;
                        accent = 1;
                        accentOffset = 1;
                        break;
                    }
                    case 244: {
                        ch = 111;
                        accent = 2;
                        accentOffset = 1;
                        break;
                    }
                    case 245: {
                        ch = 111;
                        accent = 3;
                        accentOffset = 1;
                        break;
                    }
                    case 246: {
                        ch = 111;
                        accent = 6;
                        accentOffset = 1;
                        break;
                    }
                    case 210: {
                        ch = 79;
                        accent = 0;
                        accentOffset = 1;
                        break;
                    }
                    case 211: {
                        ch = 79;
                        accent = 1;
                        accentOffset = 1;
                        break;
                    }
                    case 212: {
                        ch = 79;
                        accent = 2;
                        accentOffset = 1;
                        break;
                    }
                    case 213: {
                        ch = 79;
                        accent = 3;
                        accentOffset = 1;
                        break;
                    }
                    case 214: {
                        ch = 79;
                        accent = 6;
                        accentOffset = 1;
                        break;
                    }
                    case 236: {
                        ch = 105;
                        accent = 0;
                        accentOffset = -1;
                        break;
                    }
                    case 237: {
                        ch = 105;
                        accent = 1;
                        accentOffset = 0;
                        break;
                    }
                    case 238: {
                        ch = 105;
                        accent = 2;
                        accentOffset = -1;
                        break;
                    }
                    case 204: {
                        ch = 73;
                        accent = 0;
                        accentOffset = -1;
                        break;
                    }
                    case 205: {
                        ch = 73;
                        accent = 1;
                        accentOffset = 0;
                        break;
                    }
                    case 206: {
                        ch = 73;
                        accent = 2;
                        accentOffset = -1;
                        break;
                    }
                    case 241: {
                        ch = 110;
                        accent = 3;
                        accentOffset = 1;
                        break;
                    }
                    case 209: {
                        ch = 78;
                        accent = 3;
                        accentOffset = 1;
                    }
                    case 223: {
                        ch = 127;
                        break;
                    }
                    case 231: {
                        ch = 128;
                        break;
                    }
                    case 161: {
                        ch = 129;
                        break;
                    }
                    case 191: {
                        ch = 130;
                        break;
                    }
                    default: {
                        ch = 46;
                    }
                }
            }
            short xClip = this.offset[ch - 33];
            int xWidth = this.offset[ch - 33 + 1] - xClip;
            short xAccentClip = this.emea ? this.offset[98 + accent] : (short)0;
            int xAccentWidth = this.emea ? this.offset[98 + accent + 1] - xAccentClip : 0;
            g.setClip(clipX, clipY, clipW, clipH);
            if (ch == 105 && accent >= 0) {
                g.clipRect(x, y + 1, xWidth, this.height);
            } else {
                g.clipRect(x, y, xWidth, this.height);
            }
            g.drawImage(this.font, x - xClip, y, 20);
            if (accent >= 0) {
                g.setClip(clipX, clipY, clipW, clipH);
                int n = xAccentWidth = accent == 6 ? xAccentWidth + 1 : xAccentWidth;
                if (ch == 105 && accent >= 0) {
                    g.clipRect(x - 1, y - 1, xAccentWidth + accentOffset, this.height);
                } else {
                    g.clipRect(x, y - 1, xAccentWidth + accentOffset, this.height);
                }
                g.drawImage(this.font, x - xAccentClip + accentOffset, y - 1, 20);
            }
            x += xWidth - this.border;
            width += xWidth - this.border;
        }
        g.setClip(clipX, clipY, clipW, clipH);
        return width;
    }

    public int getHeightSlope(String str, int slope) {
        int strLength = str.length();
        return this.getHeight(str, 0, strLength) + slope * strLength;
    }

    public int drawStringSlope(Graphics g, String str, int x, int y, int layout, int slope) {
        return this.drawSubstringSlope(g, str, 0, str.length(), x, y, layout, slope);
    }

    public int drawSubstringSlope(Graphics g, String str, int offset, int len, int x, int y, int layout, int slope) {
        int clipX = g.getClipX();
        int clipY = g.getClipY();
        int clipW = g.getClipWidth();
        int clipH = g.getClipHeight();
        if ((layout & 1) != 0) {
            x -= this.substringWidth(str, offset, len) / 2;
        } else if ((layout & 8) != 0) {
            x -= this.substringWidth(str, offset, len);
        }
        if ((layout & 0x20) != 0) {
            y -= this.getHeight(str, offset, len);
        } else if ((layout & 0x40) != 0) {
            y -= this.baseline;
        }
        char[] array = str.substring(offset, offset + len).toCharArray();
        int width = 0;
        for (int i = 0; i < len; ++i) {
            char ch = array[i];
            if (ch == ' ') {
                x += this.space;
                width += this.space;
            } else if (ch > ' ' && ch < '\u007f') {
                short xClip = this.offset[ch - 33];
                int xWidth = this.offset[ch - 33 + 1] - xClip;
                g.setClip(clipX, clipY, clipW, clipH);
                g.clipRect(x, y, xWidth, this.height);
                g.drawImage(this.font, x - xClip, y, 20);
                x += xWidth - this.border;
                width += xWidth - this.border;
            }
            y += slope;
        }
        g.setClip(clipX, clipY, clipW, clipH);
        return width;
    }

    public int drawStringVRight(Graphics g, String str, int x, int y) {
        int clipX = g.getClipX();
        int clipY = g.getClipY();
        int clipW = g.getClipWidth();
        int clipH = g.getClipHeight();
        char[] array = str.toCharArray();
        int len = array.length;
        int height = 0;
        for (int i = 0; i < len; ++i) {
            char ch = array[i];
            if (ch == ' ') {
                y += this.space;
                height += this.space;
                continue;
            }
            if (ch <= ' ' || ch >= '\u007f') continue;
            short yClip = this.offset[ch - 33];
            int yWidth = this.offset[ch - 33 + 1] - yClip;
            g.setClip(clipX, clipY, clipW, clipH);
            g.clipRect(x, y, this.height, yWidth);
            g.drawImage(this.font, x, y - yClip, 20);
            y += yWidth - this.border;
            height += yWidth - this.border;
        }
        g.setClip(clipX, clipY, clipW, clipH);
        return height;
    }

    public int drawStringVLeft(Graphics g, String str, int x, int y) {
        int clipX = g.getClipX();
        int clipY = g.getClipY();
        int clipW = g.getClipWidth();
        int clipH = g.getClipHeight();
        int fontImgHeight = this.font.getHeight();
        char[] array = str.toCharArray();
        int len = array.length;
        int height = 0;
        for (int i = 0; i < len; ++i) {
            char ch = array[i];
            if (ch == ' ') {
                y -= this.space;
                height += this.space;
                continue;
            }
            if (ch <= ' ' || ch >= '\u007f') continue;
            int yClip = fontImgHeight - this.offset[ch - 33];
            int yWidth = this.offset[ch - 33 + 1] - this.offset[ch - 33];
            g.setClip(clipX, clipY, clipW, clipH);
            g.clipRect(x, y - yWidth, this.height, yWidth);
            g.drawImage(this.font, x, y - yClip, 20);
            y -= yWidth - this.border;
            height += yWidth - this.border;
        }
        g.setClip(clipX, clipY, clipW, clipH);
        return height;
    }

    public Vector wrap(String str, int width) {
        int strLength;
        Vector<String> result = new Vector<String>();
        int n = strLength = str == null ? 0 : str.length();
        if (strLength == 0) {
            return result;
        }
        char[] array = str.toCharArray();
        if (strLength < 64 && str.indexOf(10) == -1 && this.substringWidth(array, 0, strLength) <= width) {
            result.addElement(str);
            return result;
        }
        int charEnd = 0;
        block0: while (true) {
            int charIdx;
            int charStart = charEnd;
            int lineWidth = 0;
            int subStringLen = 1;
            while (true) {
                if ((charIdx = charStart + subStringLen - 1) >= strLength) {
                    if (charStart < strLength) {
                        result.addElement(new String(array, charStart, strLength - charStart));
                    }
                    return result;
                }
                char c = array[charIdx];
                lineWidth += this.charWidth(c);
                if (c == '\n') {
                    for (charEnd = charIdx + 1; charEnd < strLength && array[charEnd] == ' '; ++charEnd) {
                    }
                    result.addElement(new String(array, charStart, charIdx - charStart));
                    continue block0;
                }
                if (lineWidth >= width) break;
                ++subStringLen;
            }
            while (charIdx > charStart && array[charIdx] != ' ') {
                --charIdx;
            }
            if (array[charIdx] == ' ') {
                charEnd = charIdx + 1;
                result.addElement(new String(array, charStart, charIdx - charStart));
                continue;
            }
            charEnd = charEnd + subStringLen - 1;
            result.addElement(new String(array, charStart, charEnd - charStart));
        }
    }

    private void updatePalette(byte[] pngBytes, int palleteChunk, int aabbccOffset, int mainColor, int ddeeffOffset, int borderColor) {
        int chunkLength = (pngBytes[palleteChunk] & 0xFF) << 24 | (pngBytes[palleteChunk + 1] & 0xFF) << 16 | (pngBytes[palleteChunk + 2] & 0xFF) << 8 | pngBytes[palleteChunk + 3] & 0xFF;
        pngBytes[aabbccOffset] = (byte)(mainColor >> 16);
        pngBytes[aabbccOffset + 1] = (byte)(mainColor >> 8);
        pngBytes[aabbccOffset + 2] = (byte)mainColor;
        if (ddeeffOffset > 0 && borderColor >= 0) {
            pngBytes[ddeeffOffset] = (byte)(borderColor >> 16);
            pngBytes[ddeeffOffset + 1] = (byte)(borderColor >> 8);
            pngBytes[ddeeffOffset + 2] = (byte)borderColor;
        }
        int crc = this.crc(pngBytes, palleteChunk + 4, chunkLength + 4);
        int crcPos = palleteChunk + 8 + chunkLength;
        pngBytes[crcPos] = (byte)(crc >> 24);
        pngBytes[crcPos + 1] = (byte)(crc >> 16);
        pngBytes[crcPos + 2] = (byte)(crc >> 8);
        pngBytes[crcPos + 3] = (byte)crc;
    }

    private int crc(byte[] buf, int offset, int len) {
        int c = -1;
        while (--len >= 0) {
            c = CRC_TABLE[(c ^ buf[offset++]) & 0xFF] ^ c >>> 8;
        }
        return ~c;
    }

    static {
        for (int n = 0; n < 256; ++n) {
            int c = n;
            for (int k = 0; k < 8; ++k) {
                c = (c & 1) != 0 ? 0xEDB88320 ^ c >>> 1 : (c >>>= 1);
                MFont.CRC_TABLE[n] = c;
            }
        }
    }
}

