/*
 * Decompiled with CFR 0.152.
 */
package Juego;

import GameBelanova.Iniciar;
import Juego.Audio;
import Juego.Ayuda;
import Juego.Creditos;
import Juego.ElementoMapa;
import Juego.Mensajes;
import Juego.Opciones;
import Juego.VerNivel;
import Juego.VerPuntaje;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Menu
extends Canvas
implements CommandListener,
Runnable {
    private String[] opciones = new String[]{"Jugar", "Ver puntajes", "Instrucciones", "Configuraci\u00f3n", "Creditos", "Salir"};
    private int index = 0;
    private ElementoMapa menu;
    private Iniciar juego;
    private boolean musica = true;
    private ElementoMapa mano = null;
    private Thread hilo = null;
    private boolean iniciar;
    private int py = 40;
    private int pxi = 0;
    private Mensajes mensaje;
    private Audio audio;

    public Menu(Iniciar juego) {
        this.setFullScreenMode(true);
        this.setJuego(juego);
        this.setPy(105);
        String[] men = new String[]{"Esto es un mene", "saje de prueb", "Bien."};
        this.setMensaje(new Mensajes("/Imagenes/fondo/mensaje.PNG", "PRUEBA", men, 1));
        this.getMensaje().setPosicion(this.getWidth() / 2 - this.getMensaje().getWidth() / 2, this.getHeight() / 2 - this.getMensaje().getHeight() / 2);
    }

    public Menu(Iniciar juego, String[] opciones) {
        this.setOpciones(opciones);
        this.setFullScreenMode(true);
        this.setJuego(juego);
        this.setPy(this.getHeight() / this.getOpciones().length);
        this.setPy(105);
    }

    public Menu() {
        this.setFullScreenMode(true);
    }

    public void setOpciones(String[] opciones) {
        this.opciones = opciones;
    }

    protected void paint(Graphics g) {
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        Image ima = null;
        try {
            ima = Image.createImage((String)"/imagenes/fondos/fondoinicio.png");
            g.drawImage(ima, Math.abs(this.getWidth() / 2 - ima.getWidth() / 2), 0, 20);
            this.setPxi(46);
        }
        catch (Exception e) {
            this.setPxi(this.getWidth() / 2);
        }
        this.dibujarOpciones(g, this.getPxi());
    }

    public void dibujarOpciones(Graphics g, int x) {
        int y = 0;
        Font font = Font.getFont((int)32, (int)1, (int)8);
        g.setFont(font);
        g.setColor(255, 255, 255);
        for (int i = 0; i < this.getOpciones().length; ++i) {
            y = this.getPy() + i * 15;
            if (i == this.getIndex()) {
                g.setColor(246, 6, 13);
                try {
                    Image ima = null;
                    ima = Image.createImage((String)"/imagenes/fondos/flechita.png");
                    g.drawImage(ima, this.getPxi() - ima.getWidth() - 4, y + 2, 20);
                }
                catch (Exception e) {}
            } else {
                g.setColor(255, 255, 255);
            }
            g.drawString(this.getOpciones()[i], x, y, 20);
        }
    }

    protected void keyPressed(int tecla) {
        if ((tecla = this.getGameAction(tecla)) == 6) {
            if (this.getIndex() < this.getOpciones().length - 1) {
                this.setIndex(this.getIndex() + 1);
            } else {
                this.setIndex(0);
            }
        } else if (tecla == 1) {
            if (this.getIndex() > 0) {
                this.setIndex(this.getIndex() - 1);
            } else {
                this.setIndex(this.getOpciones().length - 1);
            }
        } else if (tecla == 8) {
            if (this.getOpciones()[this.getIndex()].equals("Jugar")) {
                this.getJuego().getDisplay().setCurrent((Displayable)new VerNivel(this));
            } else if (this.getOpciones()[this.getIndex()].equals("Creditos")) {
                this.getJuego().getDisplay().setCurrent((Displayable)new Creditos(this, 0));
            } else if (this.getOpciones()[this.getIndex()].equals("Continuar")) {
                this.getJuego().getRege().IniciarHilo();
                this.getJuego().getDisplay().setCurrent((Displayable)this.getJuego().getRege());
                if (this.getJuego().isMusica()) {
                    this.getJuego().getRege().getAudio().reproducirMusica();
                }
            }
            if (this.getOpciones()[this.getIndex()].equals("Ver puntajes")) {
                this.getJuego().getDisplay().setCurrent((Displayable)new VerPuntaje(this));
            } else if (this.getOpciones()[this.getIndex()].equals("Configuraci\u00f3n")) {
                this.getJuego().getDisplay().setCurrent((Displayable)new Opciones(this));
            } else if (this.getOpciones()[this.getIndex()].equals("Salir")) {
                try {
                    this.getJuego().getRege().getAudio().cerraMusica();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.getJuego().setRege(null);
                this.getJuego().salirApp();
            } else if (this.getOpciones()[this.getIndex()].equals("Instrucciones")) {
                this.getJuego().getDisplay().setCurrent((Displayable)new Ayuda(this));
            }
        }
        this.repaint();
    }

    public void run() {
        while (this.isIniciar()) {
            this.getMano().nextFrame();
            try {
                Thread.sleep(500L);
                this.repaint();
            }
            catch (Exception exception) {}
        }
    }

    public void commandAction(Command command, Displayable displayable) {
    }

    public String[] getOpciones() {
        return this.opciones;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public ElementoMapa getMenu() {
        return this.menu;
    }

    public void setMenu(ElementoMapa menu) {
        this.menu = menu;
    }

    public boolean isMusica() {
        return this.musica;
    }

    public void setMusica(boolean musica) {
        this.musica = musica;
    }

    public ElementoMapa getMano() {
        return this.mano;
    }

    public void setMano(ElementoMapa mano) {
        this.mano = mano;
    }

    public Thread getHilo() {
        return this.hilo;
    }

    public void setHilo(Thread hilo) {
        this.hilo = hilo;
    }

    public boolean isIniciar() {
        return this.iniciar;
    }

    public void setIniciar(boolean iniciar) {
        this.iniciar = iniciar;
    }

    public int getPy() {
        return this.py;
    }

    public void setPy(int py) {
        this.py = py;
    }

    public Iniciar getJuego() {
        return this.juego;
    }

    public void setJuego(Iniciar juego) {
        this.juego = juego;
    }

    public int getPxi() {
        return this.pxi;
    }

    public void setPxi(int pxi) {
        this.pxi = pxi;
    }

    public Mensajes getMensaje() {
        return this.mensaje;
    }

    public void setMensaje(Mensajes mensaje) {
        this.mensaje = mensaje;
    }

    public Audio getAudio() {
        return this.audio;
    }

    public void setAudio(Audio audio) {
        this.audio = audio;
    }
}

