/*
 * Decompiled with CFR 0.152.
 */
package Juego;

import GameBelanova.Iniciar;
import Juego.Menu;
import Utilitarios.Rms;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Teclas
extends Canvas
implements CommandListener {
    private String[] letras;
    private String palabra = "";
    private int pyt;
    private int pxt;
    private int index = 9;
    private int limite = 4;
    private static final int ESPACION = 15;
    private Command continuar;
    private Iniciar juego = null;
    private int puntaje = 0;
    private boolean derecha = true;
    private boolean izquierda = true;
    private Menu menu = null;

    public Teclas(Iniciar juego, int puntaje) {
        this.setJuego(juego);
        this.setPuntaje(puntaje);
        this.setLetras(new String[26]);
        int j = 65;
        for (int i = 0; i < 26; ++i) {
            char letra = (char)j;
            this.getLetras()[i] = new String("" + letra);
            ++j;
        }
        this.setContinuar(new Command("Continuar", 1, 8));
        this.setCommandListener(this);
        this.addCommand(this.getContinuar());
        this.setFullScreenMode(true);
        this.setPxt(-10);
        this.setPyt(this.getHeight() / 2);
    }

    public Teclas(Menu menu, int puntaje) {
        this.setJuego(this.getJuego());
        this.setPuntaje(puntaje);
        this.setLetras(new String[26]);
        int j = 65;
        for (int i = 0; i < 26; ++i) {
            char letra = (char)j;
            this.getLetras()[i] = new String("" + letra);
            ++j;
        }
        this.setContinuar(new Command("Continuar", 1, 8));
        this.setCommandListener(this);
        this.addCommand(this.getContinuar());
        this.setFullScreenMode(true);
        this.setPxt(-10);
        this.setPyt(this.getHeight() / 2);
        this.setMenu(menu);
    }

    protected void paint(Graphics g) {
        g.setColor(0);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        Font font = Font.getFont((int)32, (int)1, (int)8);
        g.setFont(font);
        g.setColor(255, 255, 255);
        try {
            Image ima = Image.createImage((String)"/imagenes/fondos/fondo.png");
            g.drawImage(ima, this.getWidth() / 2 - ima.getWidth() / 2, 0, 20);
        }
        catch (Exception e) {
            System.out.println(" error " + e);
        }
        int x = 0;
        for (int i = 0; i < this.getLetras().length; ++i) {
            x = this.getPxt() + i * this.getESPACION();
            if (x >= this.getWidth() / 2 && x <= this.getWidth() / 2 + g.getFont().stringWidth(this.getLetras()[0])) {
                this.setIndex(i);
                if (i == 0) {
                    this.setIzquierda(false);
                } else {
                    this.setIzquierda(true);
                }
                if (i == this.getLetras().length - 1) {
                    this.setDerecha(false);
                } else {
                    this.setDerecha(true);
                }
            }
            g.drawString(this.getLetras()[i], x, this.getPyt() + 12, 20);
        }
        g.setColor(242, 173, 13);
        g.drawString("" + this.getPuntaje(), this.getWidth() / 2 - font.stringWidth("" + this.getPuntaje()) / 2, 45, 20);
        g.drawString("Ingrese Nombre", this.getWidth() / 2 - font.stringWidth("Ingrese Nombre") / 2, 60, 20);
        g.drawRect(this.getWidth() / 2 + 2, this.getPyt() + 12, g.getFont().stringWidth(this.getLetras()[0]) + 2, font.getHeight());
        g.setColor(232, 82, 71);
        g.drawString(this.getPalabra(), this.getWidth() / 2 - font.stringWidth(this.getPalabra()) / 2, 78, 20);
        g.setColor(242, 173, 13);
        g.drawString("[2] para borrar", this.getWidth() / 2 - font.stringWidth("[2] para borrar") / 2, this.getHeight() - font.getHeight() * 2, 20);
        g.drawString("Continuar", Math.abs(this.getWidth() - font.stringWidth("Continuar")), this.getHeight() - font.getHeight(), 20);
    }

    protected void keyPressed(int tecla) {
        if ((tecla = this.getGameAction(tecla)) == 1) {
            try {
                this.setPalabra(this.getPalabra().substring(0, this.getPalabra().length() - 1));
            }
            catch (Exception e) {
                this.setPalabra("");
            }
        }
        if (tecla == 2) {
            if (this.isIzquierda()) {
                this.setPxt(this.getPxt() + Teclas.getESPACION());
                if (this.getIndex() >= 0) {
                    this.setIndex(this.getIndex() - 1);
                } else {
                    this.setIndex(0);
                }
            }
        } else if (tecla == 5) {
            if (this.isDerecha()) {
                this.setPxt(this.getPxt() - Teclas.getESPACION());
            }
        } else if (tecla == 8) {
            try {
                if (this.getPalabra().length() < this.getLimite()) {
                    this.setPalabra(this.getPalabra() + this.getLetras()[this.getIndex()]);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.repaint();
    }

    public void guardarPuntaje() {
        Rms rms = new Rms();
        rms.abreZona("puntajerege");
        if (rms.guardarCadena("" + this.getPuntaje() + "&" + this.getPalabra())) {
            // empty if block
        }
        rms.cierraZona();
    }

    public void commandAction(Command c, Displayable displayable) {
        if (this.getContinuar() == c) {
            this.guardarPuntaje();
            if (this.getMenu() != null) {
                this.getMenu().getJuego().getDisplay().setCurrent((Displayable)this.getMenu());
            } else if (this.getJuego() != null) {
                this.getJuego().getDisplay().setCurrent((Displayable)this.getJuego().getRege());
            }
        }
    }

    public String[] getLetras() {
        return this.letras;
    }

    public void setLetras(String[] letras) {
        this.letras = letras;
    }

    public int getPxt() {
        return this.pxt;
    }

    public void setPxt(int pxt) {
        this.pxt = pxt;
    }

    public String getPalabra() {
        return this.palabra;
    }

    public void setPalabra(String palabra) {
        this.palabra = palabra;
    }

    public int getPyt() {
        return this.pyt;
    }

    public void setPyt(int pyt) {
        this.pyt = pyt;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public int getLimite() {
        return this.limite;
    }

    public void setLimite(int limite) {
        this.limite = limite;
    }

    public static int getESPACION() {
        return 15;
    }

    public Command getContinuar() {
        return this.continuar;
    }

    public void setContinuar(Command continuar) {
        this.continuar = continuar;
    }

    public Iniciar getJuego() {
        return this.juego;
    }

    public void setJuego(Iniciar juego) {
        this.juego = juego;
    }

    public int getPuntaje() {
        return this.puntaje;
    }

    public void setPuntaje(int puntaje) {
        this.puntaje = puntaje;
    }

    public boolean isDerecha() {
        return this.derecha;
    }

    public void setDerecha(boolean derecha) {
        this.derecha = derecha;
    }

    public boolean isIzquierda() {
        return this.izquierda;
    }

    public void setIzquierda(boolean izquierda) {
        this.izquierda = izquierda;
    }

    public Menu getMenu() {
        return this.menu;
    }

    public void setMenu(Menu menu) {
        this.menu = menu;
    }
}

