/*
 * Decompiled with CFR 0.152.
 */
import com.mg.hkmj.MJConfig;
import com.mg.hkmj.MJGame;
import com.mg.hkmj.MJPlayer;
import com.mg.hkmj.PlayerInfo;
import com.mg.hkmj.ThinkingOrder;
import com.mg.lib.MGCanvas;
import com.mg.lib.network.MGNetwork;
import com.mg.netroom.GamePlayer;
import com.mg.netroom.GameRoom;
import com.mg.netroom.NetRoom;
import com.mg.tools.StringFunction;
import com.mg.ui.UIHelper;
import java.util.Hashtable;
import java.util.Vector;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.midlet.MIDlet;

public class GameDisplay
extends MGCanvas
implements GameConfig,
DisplayString,
DisplayConfig,
MJConfig {
    public GameResource res;
    long timer = 0L;
    int dlb = 0;
    public static final int[] mainGameImgList = new int[]{0, 8, 9, 10, 1, 2, 3, 4, 41, 5, 61, 45, 26, 48, 21, 14, 17, 20, 52, 24, 30, 33, 35, 31, 79, 81, 85, 86, 87, 83, 84, 76, 90, 91, 92, 93, 94};
    private int renderTick = 0;
    public int CONNECT_RANK_W = 4;
    public int CONNECT_RANK_H = 14;
    public int CONNECT_RANK_DY = 2;
    public int CONNECT_RANK_STEP = 5;
    private long lastR;
    private long lastS;
    private int SCount;
    private int RCount;
    private static final int NET_FLOW_W = 10;
    private static final int[] recordMarkUp = new int[]{2, 0, 20, 16435200, 0, 113, 0, 17, 16435200, 16435200, 224, 0, 24, 16435200, 0};
    public static final String[] buff = new String[1];
    public static final int RECORD_SHOW_Y = 40;
    public static final int RECORD_SHOW_H = 20;
    public char[] bufferRoomState = new char[4];
    public static int[] DIR_4_IMAGE = new int[]{30, 33, 35, 31};
    public static final int MENU_MAX_SHOW_ROW = 3;
    public static final int MENU_PADY = 3;
    public static final int[] markupDetailPos = new int[]{1, 1, 20, 16435200, 0, 217, 1, 24, 16435200, 0};

    public GameDisplay(MIDlet mIDlet) {
        super(mIDlet);
    }

    public void drawMGMenuButton(Graphics graphics, int n, Object object, int n2, int n3, int n4, boolean bl) {
    }

    public void drawLoadingBar(Graphics graphics) {
        graphics.setFont(GameResource.font);
        String string = this.res.iGameText[97];
        String string2 = this.res.iGameText[125].substring(0, 1);
        int n = GameDisplay.getStringWidth(string2, GameResource.font) * 4 + GameDisplay.getStringWidth(string, GameResource.font) + 4;
        int n2 = (239 - n >> 1) + 2;
        int n3 = 119;
        this.timer = System.currentTimeMillis();
        ++this.dlb;
        this.dlb %= 4;
        for (int j = 0; j < this.dlb; ++j) {
            string = string + string2;
        }
        GameDisplay.drawRoundString(graphics, string, n2, n3, 20, 0, 16435200);
    }

    public void mgKeyPressed(int n) {
    }

    public void initState(int n) {
        this.res.gameStateOld = this.res.gameState;
        this.res.isReady = false;
        this.res.frameCount = 0;
        this.res.frameCountDown = 0;
        this.res.isDraw = false;
        try {
            if (this.res.gameState == 7) {
                this.res.mgsound.stop();
            }
            MGCanvas.unloadAllImage();
            switch (n) {
                case 27: {
                    this.initNews("", true);
                    break;
                }
                case 25: {
                    this.initLoginMenu();
                    break;
                }
                case 28: {
                    this.initRanking();
                    break;
                }
                case 1: {
                    this.initGamePlay();
                    break;
                }
                case 2: {
                    this.initGameResult();
                    break;
                }
                case 5: {
                    this.initLogo();
                    break;
                }
                case 7: {
                    this.res.roomID = "-1";
                    this.res.mjGame = null;
                    this.initMainMenu();
                    break;
                }
                case 10: {
                    this.initIntroduction();
                    break;
                }
                case 11: {
                    this.initSetting();
                    break;
                }
                case 12: {
                    this.initCredit();
                    break;
                }
                case 13: {
                    this.initExitAlert();
                    break;
                }
                case 15: {
                    this.initBalance();
                    break;
                }
                case 16: {
                    this.initSeletePlayer();
                    break;
                }
                case 17: {
                    this.initGameResultDraw();
                    break;
                }
                case 18: {
                    this.initGamePause();
                    break;
                }
                case 19: {
                    this.initGameExitThanks();
                    break;
                }
                case 20: {
                    this.initDetailRecord();
                    break;
                }
                case 21: {
                    this.initCloseSound();
                    break;
                }
                case 22: {
                    this.initLobbyList();
                    break;
                }
                case 26: {
                    this.initCreateRoomOption();
                    break;
                }
                case 23: {
                    this.initCreateRoom();
                    break;
                }
                case 24: {
                    this.initRoomWaiting();
                    break;
                }
                case 29: {
                    this.initRoomPreview();
                    break;
                }
                case 30: {
                    this.initRankingMenu();
                    break;
                }
                case 31: {
                    this.initPressAnyKey();
                    break;
                }
                case 32: {
                    this.initTrialVersionNotify();
                }
            }
            this.res.backState = this.res.backErrorState;
            if (this.res.backErrorState == -1) {
                this.res.backState = this.res.gameState;
            }
            this.res.gameState = n;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        super.handleKey();
        this.res.isReady = true;
    }

    private void initRankingMenu() throws Exception {
        this.initMainMenu();
    }

    private void initRoomPreview() throws Exception {
        int[] nArray = new int[]{0, 8, 9, 10, 30, 33, 35, 31, 27, 64, 65, 66, 67, 68, 90, 91, 92, 93, 94};
        GameDisplay.loadImage(nArray);
    }

    public void initRanking() throws Exception {
        this.res.pageSize = this.res.displayTexts.length - 8 + 1;
        this.res.pageSize = 1;
        int[] nArray = new int[]{0, 27, 7, 59, 46, 47, 12, 30, 33, 35, 31, 34, 27, 29, 72, 73, 36, 77, 78, 41, 82};
        GameDisplay.loadImage(nArray);
    }

    public void initNews(String string, boolean bl) throws Exception {
        if (bl) {
            int[] nArray = new int[]{0, 27, 7, 59, 46, 47, 12, 69};
            GameDisplay.loadImage(nArray);
            this.res.netRoom.askForNews();
        }
        this.res.displayTexts = StringFunction.stringToDisplayArray(GameResource.font, string, 217);
        this.res.currentIndex = 0;
        this.res.pageSize = this.res.displayTexts.length - 8;
        if (this.res.pageSize < 1) {
            this.res.pageSize = 1;
        }
    }

    public void initCreateRoomOption() throws Exception {
        int[] nArray = new int[]{0, 27, 7, 59, 46, 47, 12, 30, 33, 35, 31, 34, 27, 29, 71, 64, 65, 66, 67, 68, 74, 36};
        GameDisplay.loadImage(nArray);
        this.res.roomPassword = "";
        this.res.newRoomOptionIdx = 5;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initLobbyList() throws Exception {
        int[] nArray = new int[]{0, 34, 27, 43, 44, 7, 64, 65, 66, 67, 68, 70};
        GameDisplay.loadImage(nArray);
        this.res.menuIndex = 0;
        Hashtable hashtable = this.res.htGameRoom;
        synchronized (hashtable) {
            this.res.htGameRoom.clear();
            this.res.vGameRoomKey.removeAllElements();
        }
        this.res.netRoom.requestRoom(this.res.roomRequestStart, this.res.roomRequestLen);
        UIHelper.clear();
    }

    public void initCreateRoom() throws Exception {
        this.res.inputScreen.removeCommand(this.res.okCMD);
        this.res.inputScreen.removeCommand(this.res.backCMD);
        this.res.inputScreen.addCommand(this.res.okCMD);
        this.res.inputScreen.addCommand(this.res.backCMD);
        this.res.inputScreen.setCommandListener((CommandListener)this.res.concept);
        GameMidlet.setDisplay((Displayable)this.res.inputScreen);
        this.res.isServer = true;
    }

    public void initRoomWaiting() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        this.res.networkState = 2;
        if (!this.res.isServer) {
            this.res.netRoom.joinRoom(this.res.roomID, this.res.roomPassword, "0");
        } else {
            stringBuffer.append("4");
            stringBuffer.append("&");
            stringBuffer.append("1002");
            stringBuffer.append("|");
            stringBuffer.append(this.res.currentPlayerType);
            stringBuffer.append("|");
            stringBuffer.append(NetRoom.encodeSpecialChar(this.res.roomName));
            stringBuffer.append("|");
            stringBuffer.append(MJGame.gameSeed);
            stringBuffer.append("|");
            stringBuffer.append(NetRoom.encodeSpecialChar(this.res.roomPassword));
            this.res.concept.requestSendGameData(stringBuffer.toString());
        }
        int[] nArray = new int[]{0, 30, 33, 35, 31, 27, 64, 65, 66, 67, 68, 90, 91, 92, 93, 94};
        GameDisplay.loadImage(nArray);
    }

    public void initBalance() throws Exception {
        int[] nArray = new int[]{0, 53, 12, 32, 28, 7, 29, 27, 34, 30, 33, 35, 31, 66, 68, 67, 90, 91, 92, 93, 94};
        GameDisplay.loadImage(nArray);
        this.res.menuIndex = 0;
    }

    public void initCredit() throws Exception {
        int[] nArray = new int[]{0, 27, 7, 55, 46, 47};
        GameDisplay.loadImage(nArray);
        this.res.displayTexts = StringFunction.stringToDisplayArray(GameResource.font, this.res.iGameText[69], 217);
        this.res.currentIndex = 0;
        this.res.pageSize = this.res.displayTexts.length - 8 + 1;
        if (this.res.pageSize < 1) {
            this.res.pageSize = 1;
        }
    }

    public void initExitAlert() throws Exception {
        int[] nArray = new int[]{0, 34, 29, 12};
        GameDisplay.loadImage(nArray);
        this.res.displayTexts = StringFunction.stringToDisplayArray(GameResource.font, this.res.iGameText[20], 217);
        this.res.currentIndex = 0;
        this.res.pageSize = this.res.displayTexts.length - 8 + 1;
        if (this.res.pageSize < 1) {
            this.res.pageSize = 1;
        }
    }

    public void initExitGamePlayAlert() throws Exception {
        int[] nArray = new int[]{0, 34, 29, 12};
        GameDisplay.loadImage(nArray);
        this.res.displayTexts = StringFunction.stringToDisplayArray(GameResource.font, this.res.iGameText[20], 217);
        this.res.currentIndex = 0;
        this.res.pageSize = this.res.displayTexts.length - 8 + 1;
        if (this.res.pageSize < 1) {
            this.res.pageSize = 1;
        }
    }

    public void initGameExitThanks() throws Exception {
        int[] nArray = new int[]{0, 27, 7, 46, 47};
        GameDisplay.loadImage(nArray);
        this.res.currentIndex = 0;
        this.res.pageSize = this.res.displayTexts.length - 8 + 1;
        if (this.res.pageSize < 1) {
            this.res.pageSize = 1;
        }
        this.res.frameCountDown = 10;
    }

    public void initDetailRecord() throws Exception {
        int[] nArray = new int[]{0, 27, 7, 42, 56, 46, 47};
        GameDisplay.loadImage(nArray);
        this.res.currentIndex = 0;
        this.res.frameCountDown = 10;
        int n = 11;
        GameResource.detailRecordList = new String[(32 + n) * 2];
        String[] stringArray = GameResource.detailRecordList;
        int[] nArray2 = this.res.playerRecord.totalData;
        int n2 = nArray2[5];
        if (n2 <= 0) {
            n2 = 1;
        }
        nArray2[13] = nArray2[6] * 100 / n2;
        nArray2[14] = nArray2[8] * 100 / n2;
        nArray2[15] = nArray2[11] * 100 / n2;
        nArray2[16] = nArray2[12] * 100 / n2;
        int n3 = 0;
        stringArray[n3++] = this.res.iGameText[106];
        stringArray[n3++] = this.res.playerInfo.nickname;
        stringArray[n3++] = this.res.iGameText[123];
        stringArray[n3++] = Integer.toString(nArray2[10]);
        stringArray[n3++] = this.res.iGameText[111];
        stringArray[n3++] = Integer.toString(nArray2[11]);
        stringArray[n3++] = this.res.iGameText[71];
        stringArray[n3++] = Integer.toString(nArray2[5]);
        stringArray[n3++] = this.res.iGameText[72];
        stringArray[n3++] = Integer.toString(nArray2[6]);
        stringArray[n3++] = this.res.iGameText[73];
        stringArray[n3++] = Integer.toString(nArray2[7]);
        stringArray[n3++] = this.res.iGameText[74];
        stringArray[n3++] = Integer.toString(nArray2[8]);
        stringArray[n3++] = this.res.iGameText[75];
        stringArray[n3++] = Integer.toString(nArray2[9]);
        stringArray[n3++] = this.res.iGameText[115];
        stringArray[n3++] = Integer.toString(nArray2[13]) + this.res.iGameText[141];
        stringArray[n3++] = this.res.iGameText[116];
        stringArray[n3++] = Integer.toString(nArray2[14]) + this.res.iGameText[141];
        stringArray[n3++] = this.res.iGameText[117];
        stringArray[n3++] = Integer.toString(nArray2[15]) + this.res.iGameText[141];
        int n4 = n3 / 2;
        for (int j = 0; j < 32; ++j) {
            stringArray[n3++] = MJGame.WO_INFO_NAME[j];
            stringArray[n3++] = Integer.toString(nArray2[17 + j]);
        }
        this.res.pageSize = GameResource.detailRecordList.length - 8 + 1;
        if (this.res.pageSize < 1) {
            this.res.pageSize = 1;
        }
        this.res.frameCountDown = 10;
    }

    public void initCloseSound() throws Exception {
        int[] nArray = new int[]{0, 34, 7, 42, 60, 46, 47, 29};
        GameDisplay.loadImage(nArray);
        this.res.currentIndex = 0;
        this.res.displayTexts = StringFunction.stringToDisplayArray(GameResource.font, this.res.iGameText[76], 217);
        this.res.pageSize = this.res.displayTexts.length - 8 + 1;
        if (this.res.pageSize < 1) {
            this.res.pageSize = 1;
        }
        this.res.frameCountDown = 15;
    }

    public void initGamePause() throws Exception {
        int[] nArray = new int[]{0, 12, 24, 32, 28, 18, 19, 13, 90, 91, 92, 93, 94};
        GameDisplay.loadImage(nArray);
        this.res.menuIndex = 0;
    }

    public void initGamePlay() throws Exception {
        int[] nArray = mainGameImgList;
        GameDisplay.loadImage(nArray);
        if (this.res.isNewGame) {
            if (this.res.mjGame != null) {
                this.res.mjGame.initGame(0, 0);
            } else {
                this.res.mjGame = new MJGame();
            }
            this.res.mjGame.initGame(0, 0);
            GameResource.genGameSeed();
            this.res.mjGame.gameTick();
            for (int j = 0; j < 4; ++j) {
                this.res.playersScore[j] = 1000;
                this.res.lastOffsetScore[j] = 0;
            }
            this.res.isNewGame = false;
        } else {
            this.res.mjGame.gameState = 0;
            GameResource.genGameSeed();
            this.res.mjGame.winPlayer = -1;
            this.res.mjGame.event = -1;
            this.res.mjGame.gameTick();
        }
    }

    public void initGameResult() throws Exception {
        int n;
        this.res.playerRecord.totalData[5] = this.res.playerRecord.totalData[5] + 1;
        int[] nArray = new int[]{0, 58, 7, 52, 1, 42, 6, 34, 22, 90, 91, 92, 93, 94};
        GameDisplay.loadImage(nArray);
        if (this.res.mjGame.gameResult == 1 || this.res.mjGame.gameResult == 2) {
            int n2;
            this.res.winPattern = this.res.mjGame.winScore(this.res.mjGame.winPlayer);
            this.res.winScore = 0;
            for (n = 0; n < this.res.winPattern.length; ++n) {
                this.res.winScore += MJGame.WO_INFO_SCORE[this.res.winPattern[n]];
            }
            if (this.res.winScore > MJGame.SCORE_MONEY.length - 1) {
                this.res.winScore = MJGame.SCORE_MONEY.length - 1;
            }
            if (this.res.mjGame.winPlayer == this.res.currentPlayerPos) {
                this.res.mgsound.play(12, 1, this.res.soundVol * 100 / 5);
                if (this.res.winScore == MJGame.SCORE_MONEY.length - 1) {
                    this.res.playerRecord.totalData[9] = this.res.playerRecord.totalData[9] + 1;
                }
                for (n = 0; n < this.res.winPattern.length; ++n) {
                    int n3 = n2 = 17 + this.res.winPattern[n];
                    this.res.playerRecord.totalData[n3] = this.res.playerRecord.totalData[n3] + 1;
                }
                this.res.playerRecord.totalData[6] = this.res.playerRecord.totalData[6] + 1;
                this.res.playerRecord.totalData[10] = this.res.playerRecord.totalData[10] + this.res.winScore;
                if (this.res.mjGame.loser < 0) {
                    this.res.playerRecord.totalData[11] = this.res.playerRecord.totalData[11] + 1;
                }
            } else {
                this.res.mgsound.play(6, 1, this.res.soundVol * 100 / 5);
                if (this.res.mjGame.loser == this.res.currentPlayerPos) {
                    this.res.playerRecord.totalData[8] = this.res.playerRecord.totalData[8] + 1;
                }
            }
            this.res.saveStat();
            if (this.res.mjGame.gameResult == 1) {
                for (n = 0; n < 4; ++n) {
                    this.res.lastOffsetScore[n] = 0;
                }
                this.res.lastOffsetScore[this.res.mjGame.loser] = -2 * MJGame.SCORE_MONEY[this.res.winScore];
                this.res.lastOffsetScore[this.res.mjGame.winPlayer] = 2 * MJGame.SCORE_MONEY[this.res.winScore];
            } else if (this.res.mjGame.gameResult == 2) {
                for (n = 0; n < 4; ++n) {
                    this.res.lastOffsetScore[n] = -1 * MJGame.SCORE_MONEY[this.res.winScore];
                }
                this.res.lastOffsetScore[this.res.mjGame.winPlayer] = MJGame.SCORE_MONEY[this.res.winScore] * 3;
            } else if (this.res.mjGame.gameResult == 3) {
                for (n = 0; n < 4; ++n) {
                    this.res.lastOffsetScore[n] = 0;
                }
            }
            for (n = 0; n < 4; ++n) {
                n2 = this.res.lastOffsetScore[n];
                int n4 = this.res.playersScore[n];
                this.res.playersScore[n] = n4 + n2;
            }
            this.res.maxPlayerScore = this.res.playersScore[0];
            this.res.minPlayerScore = this.res.playersScore[0];
            for (n = 1; n < 4; ++n) {
                if (this.res.playersScore[n] > this.res.maxPlayerScore) {
                    this.res.maxPlayerScore = this.res.playersScore[n];
                    continue;
                }
                if (this.res.playersScore[n] >= this.res.minPlayerScore) continue;
                this.res.minPlayerScore = this.res.playersScore[n];
            }
        } else {
            this.res.winPattern = null;
            for (n = 0; n < 4; ++n) {
                this.res.lastOffsetScore[n] = 0;
            }
        }
        GameDisplay gameDisplay = this;
        gameDisplay.res.genGameSeed();
        this.res.currentIndex = 0;
        for (n = 0; n < this.res.playerRecord.totalData.length; ++n) {
            if (this.res.playerRecord.totalData[n] <= 999999999) continue;
            this.res.playerRecord.totalData[n] = 999999999;
        }
    }

    public void initGameResultDraw() throws Exception {
        this.res.mgsound.play(6, 1, this.res.soundVol * 100 / 5);
        for (int j = 0; j < 4; ++j) {
            this.res.lastOffsetScore[j] = 0;
        }
        this.res.playerRecord.totalData[7] = this.res.playerRecord.totalData[7] + 1;
        this.res.playerRecord.totalData[5] = this.res.playerRecord.totalData[5] + 1;
        this.res.saveStat();
        int[] nArray = new int[]{0, 57, 34, 30, 33, 35, 31, 1, 52, 66, 68, 67};
        GameDisplay.loadImage(nArray);
    }

    public void initIntroduction() throws Exception {
        int[] nArray = new int[]{0, 27, 7, 59, 46, 47, 12};
        GameDisplay.loadImage(nArray);
        this.res.displayTexts = StringFunction.stringToDisplayArray(GameResource.font, this.res.iGameText[151], 217);
        this.res.currentIndex = 0;
        this.res.pageSize = this.res.displayTexts.length - 8 + 1;
        if (this.res.pageSize < 1) {
            this.res.pageSize = 1;
        }
    }

    public void initLogo() throws Exception {
        int[] nArray = new int[]{39};
        GameDisplay.loadImage(nArray);
    }

    public void initTrialVersionNotify() throws Exception {
        int[] nArray = new int[]{0, 36, 74, 7, 55, 46, 47};
        GameDisplay.loadImage(nArray);
        this.res.displayTexts = StringFunction.stringToDisplayArray(GameResource.font, this.res.iGameText[156], 217);
        this.res.currentIndex = 0;
        this.res.pageSize = this.res.displayTexts.length - 8 + 1;
        if (this.res.pageSize < 1) {
            this.res.pageSize = 1;
        }
    }

    public void initPressAnyKey() throws Exception {
        this.res.mgsound.play(8, 0, this.res.soundVol * 100 / 5);
        int[] nArray = new int[]{25, 36, 74, 75};
        GameDisplay.loadImage(nArray);
    }

    public void initLoginMenu() throws Exception {
        int[] nArray = new int[]{25, 36, 74, 75};
        GameDisplay.loadImage(nArray);
        this.res.menuIndex = 0;
    }

    public void initMainMenu() throws Exception {
        this.res.mgsound.play(8, 0, this.res.soundVol * 100 / 5);
        int[] nArray = new int[]{25, 36, 74, 75};
        GameDisplay.loadImage(nArray);
        this.res.menuIndex = 0;
    }

    public void initSeletePlayer() throws Exception {
        this.res.mgsound.play(7, 0, this.res.soundVol * 100 / 5);
        int[] nArray = new int[]{0, 23, 54, 12, 50, 7, 38, 34, 29, 32, 28, 22, 90, 91, 92, 93, 94, 89, 88, 36, 74};
        GameDisplay.loadImage(nArray);
        this.res.currentIndex = 0;
        this.res.menuIndex = 0;
        this.res.selectedPlayer = 1;
        this.res.players[0] = 0;
    }

    public void initSetting() throws Exception {
        this.res.currentIndex = 0;
        int[] nArray = new int[]{0, 60, 7, 22, 27, 12};
        GameDisplay.loadImage(nArray);
        this.res.currentIndex = 0;
        this.res.settingIDString = this.res.iGameText[127] + " " + this.res.netRoom.playerID;
    }

    public void drawTitleMessage(Graphics graphics, String string) {
        GameDisplay.fillRect(graphics, 0, 0, 240, 23, 0);
        GameDisplay.drawString(graphics, string, 120, 1, 17, 16435200);
    }

    public void drawCanvas(Graphics graphics) {
        try {
            this.res.isDraw = true;
            this.drawCanvasCore(graphics);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.res.isDraw = false;
    }

    public void drawCanvasCore(Graphics graphics) {
        ++this.renderTick;
        graphics.setFont(GameResource.font);
        if (this.res.isReady) {
            switch (this.res.gameState) {
                case 1: {
                    this.drawMJGame(graphics);
                    if (!this.res.showPlayName) break;
                    this.drawWaitState(graphics);
                    break;
                }
                case 2: {
                    this.drawMJGameResult(graphics);
                    break;
                }
                case 5: {
                    this.drawLogo(graphics);
                    break;
                }
                case 26: {
                    this.drawCreateRoomOption(graphics);
                    break;
                }
                case 28: {
                    this.drawTopRanking(graphics);
                    break;
                }
                case 25: {
                    this.drawLoginMenu(graphics);
                    if (!this.res.isLogin) break;
                    String string = this.res.iGameText[125];
                    this.drawMessage(graphics, string.substring(0, this.renderTick % (string.length() - 1) + 1), 0, 1, 239);
                    break;
                }
                case 30: {
                    this.drawMenu(graphics, this.res.rankingString);
                    break;
                }
                case 7: {
                    this.drawMainMenu(graphics);
                    break;
                }
                case 27: {
                    this.drawNews(graphics);
                    break;
                }
                case 10: {
                    this.drawIntroduction(graphics);
                    break;
                }
                case 11: {
                    this.drawSetting(graphics);
                    break;
                }
                case 12: {
                    this.drawCredit(graphics);
                    break;
                }
                case 13: {
                    this.drawExitAlert(graphics);
                    break;
                }
                case 14: {
                    this.drawExitAlert(graphics);
                    break;
                }
                case 15: {
                    this.drawBalance(graphics);
                    break;
                }
                case 16: {
                    this.drawSeletePlayer(graphics);
                    break;
                }
                case 17: {
                    this.drawGameResultDraw(graphics);
                    break;
                }
                case 18: {
                    this.drawGamePause(graphics);
                    break;
                }
                case 19: {
                    this.drawGameExitThanks(graphics);
                    break;
                }
                case 20: {
                    this.drawDetailRecord(graphics);
                    break;
                }
                case 21: {
                    this.drawCloseSound(graphics);
                    break;
                }
                case 29: {
                    this.drawRoomPreviewPage(graphics);
                    break;
                }
                case 22: {
                    this.drawLobbyList(graphics);
                    this.drawNetworkFlow(graphics, 0, 0);
                    break;
                }
                case 24: {
                    this.drawRoomWaiting(graphics);
                    this.drawNetworkFlow(graphics, 0, 0);
                    break;
                }
                case 31: {
                    this.drawPressAnyKey(graphics);
                    break;
                }
                case 32: {
                    this.drawTrialVersionNotify(graphics);
                }
            }
            GameDisplay.resetClip(graphics);
        } else {
            this.drawLoadingBar(graphics);
        }
        if (this.res.networkError) {
            this.drawMessage(graphics, this.res.errorMessageLine, this.res.networkErrorCount, 15);
        }
        if (this.res.hasGlobalMessage) {
            this.drawMessage(graphics, this.res.globalMessage, this.res.globalMessageCount, 40);
        }
        if (this.res.hasServerMessage) {
            this.drawMessage(graphics, this.res.serverMessageDisplay, this.res.serverMessageCount, 40);
        }
    }

    public void drawRoomPreviewPage(Graphics graphics) {
        GameDisplay.drawImage(graphics, images[0], 0, 0, 20);
        this.drawRoomPreview(graphics);
        this.drawButton(graphics, 1);
        if ((this.renderTick >> 2 & 1) == 0) {
            GameDisplay.drawRoundString(graphics, this.res.iGameText[142], 1, 260, 36, 0, 0xFFFFFF);
        }
    }

    private void drawRoomPreview(Graphics graphics) {
        int n = 25;
        int n2 = 260 - n - Math.max(21, GameDisplay.getImageHeight(images[27])) - 4;
        int n3 = 240;
        GameRoom gameRoom = (GameRoom)this.res.htGameRoom.get(this.res.roomID);
        if (gameRoom == null) {
            GameDisplay.drawString(graphics, this.res.iGameText[97], n3 / 2, n + n2 / 2, 17, 16435200);
        } else {
            int n4;
            for (n4 = 0; n4 < gameRoom.player.length; ++n4) {
                this.drawRoomPlayer(graphics, n4, gameRoom.player[n4], gameRoom.playerType[n4], 0, n + n2 * n4 / gameRoom.player.length, n3, n2 / gameRoom.player.length - 1);
            }
            GameDisplay.fillRect(graphics, 0, n + n2, n3, 2, 16435200);
            n4 = 21 - GameDisplay.getImageHeight(images[64]) >> 1;
            int n5 = gameRoom.passwordLock ? 64 : 65;
            String string = GameResource.trimString(gameRoom.roomName, GameResource.font, n3 * 2 / 3);
            GameDisplay.drawString(graphics, string, n3 / 2, 4, 17, 0xFFFFFF);
            int n6 = GameDisplay.getStringWidth(string, GameResource.font);
            GameDisplay.drawImage(graphics, images[n5], (n3 - n6 >> 1) - 4, 4, 24);
        }
    }

    private void drawRoomPlayer(Graphics graphics, int n, String string, char c2, int n2, int n3, int n4, int n5) {
        Image image = images[DIR_4_IMAGE[n]];
        int n6 = GameDisplay.getImageWidth(image);
        int n7 = GameDisplay.getImageHeight(image);
        switch (c2) {
            case '0': 
            case '1': {
                int n8;
                Object object;
                GamePlayer gamePlayer;
                if (string.equals(this.res.playerInfo.playerID)) {
                    GameDisplay.fillRect(graphics, n2, n3, n4, n5, 8264732);
                    GameDisplay.drawRect(graphics, n2, n3, n4 - 1, n5 - 1, 0);
                    GameDisplay.drawImage(graphics, images[66], n2 + n4 - 1, n3 + 1, 24);
                }
                if ((gamePlayer = (GamePlayer)this.res.htGamePlayer.get(string)) == null || gamePlayer.ranking.length() == 0) {
                    GameDisplay.drawString(graphics, this.res.iGameText[97], n2 + n4 / 2, n3, 17, 16435200);
                    break;
                }
                String string2 = GameResource.trimString(gamePlayer.nickname, GameResource.font, n4 / 2);
                String string3 = GameResource.trimString(gamePlayer.location, GameResource.font, n4 / 2);
                int n9 = 0;
                if (gamePlayer.playerPhotoIndex > 0 && (object = images[gamePlayer.playerPhotoIndex + 90]) != null) {
                    n9 = GameDisplay.getImageWidth(object);
                    n8 = GameDisplay.getImageHeight(object);
                    GameDisplay.drawImage(graphics, object, n2 + n6 + 3, n3, 20);
                }
                GameDisplay.drawString(graphics, string2, n2 + n6 + 6 + n9, n3 + 1, 20, 16435200);
                GameDisplay.drawString(graphics, string3, n2 + n6 + 6 + n9, n3 + n5 - 1, 36, 16435200);
                this.drawConnectRank(graphics, gamePlayer.colorState, gamePlayer.connectRank, n2, n3 + n5 - this.CONNECT_RANK_H);
                object = gamePlayer.ranking;
                n8 = GameDisplay.getStringWidth((String)object, GameResource.font);
                GameDisplay.drawRoundString(graphics, (String)object, n2 + n4 - 2, n3 + n5 - 2, 40, 16435200, 0);
                GameDisplay.drawString(graphics, this.res.iGameText[145], n2 + n4 - 2 - n8 - 3, n3 + n5 - 2, 40, 16435200);
                break;
            }
            case '9': {
                GameDisplay.drawString(graphics, this.res.iGameText[91], n2 + n4 / 2, n3, 17, 16435200);
                break;
            }
            case '7': 
            case '8': {
                GameDisplay.drawString(graphics, this.res.iGameText[98], n2 + n4 / 2, n3, 17, 16435200);
            }
        }
        GameDisplay.drawImage(graphics, image, n2 + 2, n3 + 2, 20);
    }

    public void drawConnectRank(Graphics graphics, int n, int n2, int n3, int n4) {
        int n5 = n2 * this.CONNECT_RANK_STEP / 100;
        for (int j = 0; j < this.CONNECT_RANK_STEP; ++j) {
            int n6 = this.CONNECT_RANK_H - (this.CONNECT_RANK_STEP - j) * this.CONNECT_RANK_DY;
            int n7 = n4 + this.CONNECT_RANK_H - n6;
            if (n5 >= j) {
                GameDisplay.fillRect(graphics, n3, n7, this.CONNECT_RANK_W, n6, n);
                GameDisplay.drawRect(graphics, n3, n7, this.CONNECT_RANK_W - 1, n6 - 1, 0);
            } else {
                GameDisplay.fillRect(graphics, n3, n7, this.CONNECT_RANK_W, n6, 0);
            }
            n3 += this.CONNECT_RANK_W;
        }
    }

    private void drawRoomBox(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        GameDisplay.fillRect(graphics, n, n2, n3, n4, n5);
        GameDisplay.drawRect(graphics, n, n2, n3 - 1, n4 - 1, 9131033);
    }

    public void drawNetworkFlow(Graphics graphics, int n, int n2) {
        boolean bl;
        boolean bl2 = bl = this.lastR == MGNetwork.receiveByte && this.lastS == MGNetwork.sendByte;
        if (!bl) {
            if (this.lastR != MGNetwork.receiveByte) {
                this.RCount = 10;
            }
            if (this.lastS != MGNetwork.sendByte) {
                this.SCount = 10;
            }
        }
        this.lastR = MGNetwork.receiveByte;
        this.lastS = MGNetwork.sendByte;
        if (this.SCount > 0 && this.RCount > 0) {
            GameDisplay.fillRect(graphics, n, n2, 12, 4, 0);
            GameDisplay.fillRect(graphics, n + 1, n2 + 1, this.SCount, 1, 0xFF0000);
            GameDisplay.fillRect(graphics, n + 1, n2 + 2, this.RCount, 1, 65280);
            if (this.SCount > 0) {
                --this.SCount;
            }
            if (this.RCount > 0) {
                --this.RCount;
            }
        }
    }

    private void drawTopRanking(Graphics graphics) {
        GameDisplay.drawImage(graphics, images[0], 0, 0, 20);
        if (this.res.topMarkType.equals("0")) {
            this.drawTitle(graphics, 10);
        } else {
            this.drawTitle(graphics, 11);
        }
        String[] stringArray = this.res.topRankRecord;
        String[] stringArray2 = this.res.topRankRecordIcon;
        if (stringArray.length == 0) {
            this.drawLoading(graphics);
        } else {
            int n;
            int n2;
            UIHelper.setDrawRegion(0, 41, 226, 140);
            UIHelper.drawRecord(graphics, stringArray, this.res.curRankShowIndex, 3, 42, recordMarkUp, null);
            int n3 = UIHelper.h / 42;
            int n4 = UIHelper.y;
            int n5 = recordMarkUp[10];
            int n6 = recordMarkUp[0];
            for (n2 = 0; n2 < n3 && (n = this.res.curRankShowIndex + n2) < stringArray2.length; ++n2) {
                String string = stringArray2[n];
                this.drawRankIcon(graphics, n5, n4 + 21, string);
                this.drawMarkIcon(graphics, n6, n4, this.res.topRankRecordMark[n]);
                n4 += 42;
            }
            n2 = 181;
            UIHelper.setDrawRegion(0, n2, 226, 42);
            graphics.setColor(0);
            GameDisplay.fillRect(graphics, 0, n2, 226, 42);
            GameDisplay.drawRect(graphics, 0, n2, 225, 41);
            UIHelper.drawRecord(graphics, this.res.topRankRecordMe, 0, 3, 42, recordMarkUp, null);
            this.drawRankIcon(graphics, n5, UIHelper.y + 21, this.res.topRankRecordMeIcon);
            this.drawMarkIcon(graphics, n6, UIHelper.y, this.res.topRankRecordMeMark);
            GameDisplay.drawImage(graphics, images[36], 232, n2 + 21, 6);
        }
        this.drawScrollBar(graphics, this.res.curRankShowIndex, this.res.topRankRecord.length / 3, 42, 140, 36);
        this.drawBottomBar(graphics);
        this.drawButton(graphics, 1);
    }

    private void drawMarkIcon(Graphics graphics, int n, int n2, String string) {
        int n3 = string.length();
        Image image = images[41];
        GameDisplay.drawImage(graphics, images[82], n, n2, 20);
        n += 10;
        n2 += 3;
        n += (4 - n3) * 8 >> 1;
        for (int j = 0; j < n3; ++j) {
            int n4 = string.charAt(j) - 48;
            GameDisplay.drawClipImage(graphics, image, n, n2, 7 * n4, 0, 7, 11);
            n += 8;
        }
        GameDisplay.resetClip(graphics);
    }

    private void drawBottomBar(Graphics graphics) {
        GameDisplay.fillRect(graphics, 0, 229, 260, 1, 0x888888);
    }

    public void drawRankIcon(Graphics graphics, int n, int n2, String string) {
        String string2 = string;
        block4: for (int j = 0; j < string2.length(); ++j) {
            switch (string2.charAt(j)) {
                case '1': {
                    GameDisplay.drawImage(graphics, images[77], n, n2, 24);
                    n -= GameDisplay.getImageWidth(images[77]);
                    continue block4;
                }
                case '2': {
                    GameDisplay.drawImage(graphics, images[78], n, n2, 24);
                    n -= GameDisplay.getImageWidth(images[78]);
                    continue block4;
                }
                default: {
                    n -= GameDisplay.getImageWidth(images[77]);
                }
            }
        }
    }

    public void drawMessage(Graphics graphics, String string, int n, int n2, int n3) {
        GameDisplay.buff[0] = string;
        this.drawMessage(graphics, buff, n, n2, n3);
    }

    public void drawMessage(Graphics graphics, String string, int n, int n2) {
        GameDisplay.buff[0] = string;
        this.drawMessage(graphics, buff, n, n2, 130);
    }

    public void drawMessage(Graphics graphics, String[] stringArray, int n, int n2) {
        this.drawMessage(graphics, stringArray, n, n2, 130);
    }

    public void drawMessage(Graphics graphics, String[] stringArray, int n, int n2, int n3) {
        GameDisplay.resetClip(graphics);
        int n4 = 22;
        int n5 = stringArray.length;
        int n6 = n4 * n5 + 4;
        int n7 = n3 - (n6 >> 1);
        GameDisplay.fillRect(graphics, 0, n7 - 1, 240, n6 + 2, 8264732);
        GameDisplay.fillRect(graphics, 0, n7, 240, n6, 0);
        GameDisplay.fillRect(graphics, 0, n7 + 1, 240 * n / n2, n6 - 2, 8264732);
        for (int j = 0; j < n5; ++j) {
            GameDisplay.drawString(graphics, stringArray[j], 120, n7 + j * n4 + 2, 17, 16435200);
        }
    }

    private void drawNews(Graphics graphics) {
        this.drawAlertPage(graphics, 7);
        this.drawBottomBar(graphics);
        this.drawButton(graphics, 1);
        Image image = this.res.advImage;
        if (image != null) {
            GameDisplay.drawImage(graphics, image, 120, 0, 17);
        }
    }

    public void drawCreateRoomOption(Graphics graphics) {
        int n;
        int n2;
        int n3;
        GameDisplay.drawImage(graphics, images[0], 0, 0, 20);
        this.drawTitle(graphics, 9);
        int n4 = 22;
        int n5 = Math.max(n4, GameDisplay.getImageHeight(images[30]));
        int n6 = n5 - 21 >> 1;
        int n7 = this.res.newRoomOption.length;
        int n8 = n5 * n7;
        int n9 = (260 - n8 - 29 - 20 >> 1) + 20;
        int n10 = 120 + GameDisplay.getImageWidth(images[66]);
        int n11 = n10 - GameDisplay.getImageWidth(images[36]) * 4;
        int n12 = GameDisplay.getImageWidth(images[66]);
        block10: for (n3 = 0; n3 < this.res.newRoomOption.length; ++n3) {
            n2 = n9 + n5 * n3;
            if (n3 == this.res.newRoomOptionIdx) {
                GameDisplay.fillRect(graphics, 0, n2, 240, n4, 0);
                GameDisplay.drawRect(graphics, 0, n2, 239, n4 - 1, 8264732);
            }
            switch (n3) {
                case 0: 
                case 1: 
                case 2: 
                case 3: {
                    n = 0;
                    switch (this.res.roomPlayerType[n3]) {
                        case 0: {
                            n = 66;
                            break;
                        }
                        case 2: {
                            n = 67;
                            break;
                        }
                        case 1: {
                            n = 68;
                        }
                    }
                    int n13 = n10;
                    this.drawPlayerType(graphics, n13 + 2, n2 + n6, this.res.roomPlayerType[n3]);
                    GameDisplay.drawImage(graphics, images[n], n13 - 2, n2 + n4 / 2, 10);
                    if (n3 == this.res.newRoomOptionIdx) {
                        GameDisplay.drawImage(graphics, images[36], n13 - 2 - 4 - n12, n2 + n5 / 2, 10);
                        GameDisplay.drawImage(graphics, images[74], 236, n2 + n5 / 2, 10);
                    }
                    GameDisplay.drawRoundString(graphics, this.res.newRoomOption[n3], n11, n2 + n6, 24, 0, 16435200);
                    continue block10;
                }
                case 4: {
                    String string;
                    int n14 = 0;
                    if (this.res.roomPassword.length() == 0) {
                        string = this.res.iGameText[89];
                        n14 = 65;
                    } else {
                        string = this.res.iGameText[90];
                        n14 = 64;
                    }
                    GameDisplay.drawImage(graphics, images[n14], n10 - 2, n2 + (n5 >> 1), 10);
                    GameDisplay.drawRoundString(graphics, string, n10 + 2, n2 + n6, 20, 0, 16435200);
                    GameDisplay.drawRoundString(graphics, this.res.newRoomOption[n3], n11, n2 + n6, 24, 0, 16435200);
                    continue block10;
                }
                case 5: {
                    GameDisplay.drawRoundString(graphics, this.res.newRoomOption[n3], 120, n2 + n6, 17, 0, 16435200);
                    continue block10;
                }
                default: {
                    GameDisplay.drawString(graphics, this.res.newRoomOption[n3], n10 - 2, n2 + n6, 24, 16435200);
                }
            }
        }
        n3 = 21;
        n2 = 223;
        n = n3 - GameDisplay.getImageHeight(images[68]) >> 1;
        this.drawBottomBar(graphics);
        this.drawButton(graphics, 0);
        this.drawButton(graphics, 1);
    }

    private void drawPlayerType(Graphics graphics, int n, int n2, int n3) {
        String string = "";
        switch (n3) {
            case 0: {
                string = this.res.iGameText[93];
                break;
            }
            case 1: {
                string = this.res.iGameText[91];
                break;
            }
            case 2: {
                string = this.res.iGameText[92];
            }
        }
        GameDisplay.drawRoundString(graphics, string, n, n2, 20, 0, 16435200);
    }

    public int getMaxLobbyLine() {
        return 10;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawLobbyList(Graphics graphics) {
        GameDisplay.drawImage(graphics, images[0], 0, 0, 20);
        this.drawTitle(graphics, 8);
        if (this.res.menuIndex != this.res.vGameRoomKey.size()) {
            GameDisplay.drawRoundString(graphics, this.res.menuIndex + 1 + "/" + this.res.vGameRoomKey.size(), 236, 40, 40, 0, 16435200);
        }
        Hashtable hashtable = this.res.htGameRoom;
        synchronized (hashtable) {
            int n = this.getMaxLobbyLine();
            int n2 = 40;
            int n3 = Math.max(this.res.menuIndex - n / 2, 0);
            int n4 = this.res.vGameRoomKey.size() - n3;
            boolean bl = false;
            if (n4 > n) {
                n4 = n;
            } else {
                bl = true;
            }
            int n5 = n3 + n4;
            boolean bl2 = this.res.menuIndex == this.res.vGameRoomKey.size();
            boolean bl3 = this.res.menuIndex == 0;
            int n6 = Math.max(GameDisplay.getImageWidth(images[64]), GameDisplay.getImageWidth(images[65]));
            int n7 = 20 - GameDisplay.getImageHeight(images[68]) >> 1;
            int n8 = -1;
            while (n3 < n5) {
                if (n3 == this.res.menuIndex) {
                    GameDisplay.fillRect(graphics, 0, n2, 232, 20, 0);
                    GameDisplay.drawRect(graphics, 0, n2, 232, 20, 8264732);
                }
                Object e2 = this.res.vGameRoomKey.elementAt(n3);
                GameRoom gameRoom = (GameRoom)this.res.htGameRoom.get(e2);
                String string = gameRoom.roomName;
                if (string.length() == 0) {
                    string = this.res.iGameText[104];
                }
                string = GameResource.trimString(string, GameResource.font, 116);
                GameDisplay.drawString(graphics, string, 230, n2 + n8, 24, 16435200);
                this.drawRoomState(graphics, 1, n2 + n7, gameRoom.passwordLock, gameRoom.playerType);
                n2 += 20;
                ++n3;
            }
            this.drawScrollBar(graphics, this.res.menuIndex, this.res.vGameRoomKey.size() + 1, 187);
            if (this.res.vGameRoomKey.size() == this.res.menuIndex) {
                GameDisplay.fillRect(graphics, 0, n2, 232, 20, 0);
                GameDisplay.drawRect(graphics, 0, n2, 232, 20, 8264732);
            }
            if (bl) {
                GameDisplay.drawRoundString(graphics, this.res.iGameText[88], 1, n2 + n8, 0, 16435200, 0);
            }
            if (n2 + 40 < 231) {
                GameDisplay.drawString(graphics, this.res.iGameText[154], 1, n2 + 20 + n8, 0, 16435200);
            }
        }
        this.drawBottomBar(graphics);
        this.drawButton(graphics, 0);
        this.drawButton(graphics, 1);
        GameDisplay.drawRoundString(graphics, this.res.roomNumberString, 120, 260, 33, 0, 16435200);
    }

    public void drawRoomState(Graphics graphics, int n, int n2, boolean bl, int[] nArray) {
        if (nArray.length != this.bufferRoomState.length) {
            this.bufferRoomState = new char[nArray.length];
        }
        block5: for (int j = 0; j < nArray.length; ++j) {
            switch (nArray[j]) {
                case 0: {
                    this.bufferRoomState[j] = 48;
                    continue block5;
                }
                case 1: {
                    this.bufferRoomState[j] = 57;
                    continue block5;
                }
                case 2: {
                    this.bufferRoomState[j] = 55;
                }
            }
        }
        this.drawRoomState(graphics, n, n2, bl, this.bufferRoomState);
    }

    public void drawRoomState(Graphics graphics, int n, int n2, boolean bl, char[] cArray) {
        int n3 = bl ? 64 : 65;
        GameDisplay.drawImage(graphics, images[n3], n, n2, 0);
        int n4 = GameDisplay.getImageWidth(images[n3]);
        n += n4 * 3 / 2;
        ++n2;
        int n5 = GameDisplay.getImageWidth(images[66]);
        for (int j = 0; j < cArray.length; ++j) {
            switch (cArray[j]) {
                case '0': 
                case '1': {
                    GameDisplay.drawImage(graphics, images[66], n, n2, 0);
                    break;
                }
                case '7': 
                case '8': {
                    GameDisplay.drawImage(graphics, images[67], n, n2, 0);
                    break;
                }
                case '9': {
                    GameDisplay.drawImage(graphics, images[68], n, n2, 0);
                }
            }
            n += n5;
        }
    }

    void drawRoomWaiting(Graphics graphics) {
        GameDisplay.drawImage(graphics, images[0], 0, 0, 20);
        String string = this.res.iGameText[97];
        this.drawRoomPreview(graphics);
        this.drawButton(graphics, 1);
    }

    private void drawWaitState(Graphics graphics) {
        GameRoom gameRoom = (GameRoom)this.res.htGameRoom.get(this.res.roomID);
        if (gameRoom == null) {
            return;
        }
        int n = this.res.currentPlayerPos;
        int n2 = 21;
        this.drawPlayerInfo(graphics, gameRoom.playerType[n], gameRoom.player[n], 120, 240 - n2);
        n = (n + 1) % 4;
        this.drawPlayerInfo(graphics, gameRoom.playerType[n], gameRoom.player[n], 205, 156);
        n = (n + 1) % 4;
        this.drawPlayerInfo(graphics, gameRoom.playerType[n], gameRoom.player[n], 120, 70);
        n = (n + 1) % 4;
        this.drawPlayerInfo(graphics, gameRoom.playerType[n], gameRoom.player[n], 35, 156);
    }

    public void drawMyDirection(Graphics graphics) {
        GameDisplay.drawImage(graphics, images[DIR_4_IMAGE[this.getWindPos(this.res.currentPlayerPos)]], 176, 205, 0);
    }

    public int getWindPos(int n) {
        return (n + 4 - this.res.mjGame.gameStarter) % 4;
    }

    private int charColor(char c2) {
        switch (c2) {
            case '0': 
            case '1': {
                return 0xFFFFFF;
            }
            case '7': 
            case '8': {
                return 0xAAFFAA;
            }
            case '9': {
                return 0xAAAAFF;
            }
        }
        return 0xFFFFFF;
    }

    private void drawPlayerInfo(Graphics graphics, char c2, String string, int n, int n2) {
        int n3 = 17;
        switch (c2) {
            case '0': 
            case '1': {
                GamePlayer gamePlayer = (GamePlayer)this.res.htGamePlayer.get(string);
                if (gamePlayer != null) {
                    this.drawBoxString(graphics, n, n2, GameResource.trimString(gamePlayer.nickname, GameResource.font, 80), this.charColor(c2), 50);
                    this.drawFaceBG(graphics, gamePlayer.playerPhotoIndex, n - 25, n2 -= 53);
                    break;
                }
                this.drawBoxString(graphics, n, n2, this.res.iGameText[97], this.charColor(c2), 50);
                break;
            }
            case '7': 
            case '8': {
                this.drawBoxString(graphics, n, n2, this.res.iGameText[98], this.charColor(c2), 50);
                break;
            }
            case '9': {
                this.drawBoxString(graphics, n, n2, this.res.iGameText[91], this.charColor(c2), 50);
            }
        }
    }

    public void drawBoxString(Graphics graphics, int n, int n2, String string, int n3, int n4) {
        int n5 = Math.max(n4, GameDisplay.getStringWidth(string, graphics.getFont()));
        int n6 = 21;
        GameDisplay.fillRect(graphics, n - n5 / 2 - 2, n2 - 2, n5 + 4, n6 + 4, 8264732);
        GameDisplay.fillRect(graphics, n - n5 / 2 - 1, n2 - 1, n5 + 2, n6 + 2, 0);
        GameDisplay.drawString(graphics, string, n, n2, 17, n3);
    }

    void drawIntroduction(Graphics graphics) {
        this.drawAlertPage(graphics, 0);
        this.drawBottomBar(graphics);
        this.drawButton(graphics, 1);
    }

    void drawLogo(Graphics graphics) {
        GameDisplay.fillRect(graphics, 0, 0, 240, 260, 0xFFFFFF);
        GameDisplay.drawImage(graphics, images[39], 120, 130, 3);
    }

    void drawTrialVersionNotify(Graphics graphics) {
        GameDisplay.drawImage(graphics, images[0], 0, 0, 20);
        this.res.displayTexts = null;
        this.res.displayTexts = StringFunction.stringToDisplayArray(GameResource.font, this.res.iGameText[156], 217);
        this.res.displayTexts[this.res.displayTexts.length - 1] = this.res.remainTime <= 0 ? this.res.iGameText[157] : this.res.displayTexts[this.res.displayTexts.length - 1] + Integer.toString(this.res.remainTime) + this.res.iGameText[158];
        int n = this.res.currentIndex + 8;
        UIHelper.setDrawRegion(9, 9, 227, 187);
        graphics.setColor(16435200);
        UIHelper.drawText(graphics, this.res.displayTexts, this.res.currentIndex, 22, 20, null);
        GameDisplay.resetClip(graphics);
        this.drawBottomBar(graphics);
        if (this.res.remainTime <= 0) {
            GameDisplay.drawRoundString(graphics, this.res.iGameText[161], 0, 260, 36, 0, 16435200);
        } else {
            GameDisplay.drawRoundString(graphics, this.res.iGameText[159], 0, 260, 36, 0, 16435200);
        }
        GameDisplay.drawRoundString(graphics, this.res.iGameText[160], 240, 260, 40, 0, 16435200);
    }

    void drawLoginMenu(Graphics graphics) {
        this.drawMenu(graphics, this.res.loginString);
    }

    void drawPressAnyKey(Graphics graphics) {
        GameDisplay.drawImage(graphics, images[25], 0, 0, 20);
        if (this.res.frameCount / 2 % 3 != 1) {
            GameDisplay.drawRoundString(graphics, this.res.iGameText[155], 120, 209, 17, 16435200, 0);
        }
    }

    void drawMainMenu(Graphics graphics) {
        this.drawMenu(graphics, this.res.menuString);
    }

    void drawMenu(Graphics graphics, String[] stringArray) {
        GameDisplay.drawImage(graphics, images[25], 0, 0, 20);
        this.drawMainMenuCore(graphics, stringArray, this.res.menuIndex);
    }

    private void drawMainMenuCore(Graphics graphics, String[] stringArray, int n) {
        String[] stringArray2 = stringArray;
        int n2 = 22;
        int n3 = (Math.min(stringArray2.length, 3) + 1) * n2;
        int n4 = n2 - 21 >> 1;
        int n5 = 0;
        int n6 = 231 - n3 - 3 - n5;
        graphics.setColor(0);
        GameDisplay.fillRect(graphics, 0, n6, 240, n3);
        GameDisplay.fillRect(graphics, 0, n6, 240, 1, 16435200);
        GameDisplay.fillRect(graphics, 0, n6 + n3, 240, 1, 16435200);
        int n7 = n6 + (n2 >> 1);
        int n8 = n;
        int n9 = n8 - 1;
        if (n8 == stringArray2.length - 1) {
            n9 = n8 - 2;
        }
        if (n9 < 0) {
            n9 = 0;
        }
        int n10 = Math.min(n9 + 3, stringArray2.length);
        graphics.setColor(8264732);
        int n11 = n7 + (n8 - n9) * n2;
        GameDisplay.fillRect(graphics, 0, n11 - 1, 240, n2 + 2);
        int n12 = 120;
        graphics.setColor(16435200);
        for (int j = n9; j < n10; ++j) {
            String string = stringArray[j];
            GameDisplay.drawString(graphics, string, n12, n7, 17);
            n7 += n2;
        }
    }

    public void drawMJGame(Graphics graphics) {
        block63: {
            block62: {
                this.drawMJGameBG(graphics);
                this.drawMyDirection(graphics);
                int n = 0;
                if (this.res.mjGame.throwCardLength > 96) {
                    n = this.res.mjGame.throwCardLength - 96;
                }
                int n2 = 0;
                int n3 = 0;
                int n4 = 0;
                while (n < this.res.mjGame.throwCardLength) {
                    n2 = n4 / 12;
                    n3 = n4 % 12;
                    this.drawThrowCardCenter(graphics, 48 + n3 * 12, 40 + n2 * 16, this.res.mjGame.throwedCard[n]);
                    ++n4;
                    ++n;
                }
                this.drawMJGamePlayer3(graphics, this.res.mjGame.mjPlayers[(this.res.currentPlayerPos + 2) % 4]);
                this.drawMJGamePlayer2(graphics, this.res.mjGame.mjPlayers[(this.res.currentPlayerPos + 1) % 4]);
                this.drawMJGamePlayer4(graphics, this.res.mjGame.mjPlayers[(this.res.currentPlayerPos + 3) % 4]);
                this.drawMJGamePlayer1(graphics, this.res.mjGame.mjPlayers[(this.res.currentPlayerPos + 0) % 4]);
                this.drawQuickMessage(graphics);
                if (this.res.mjGame.event == -1) break block62;
                GameDisplay.resetClip(graphics);
                n4 = 0;
                int n5 = -1;
                if (this.res.frameCount % 2 == 1) {
                    n4 = 48;
                }
                switch (this.res.mjGame.event) {
                    case 0: {
                        n5 = 48;
                        break;
                    }
                    case 1: {
                        n5 = 45;
                        break;
                    }
                    case 2: {
                        n5 = 26;
                        break;
                    }
                    case 3: {
                        n5 = 61;
                    }
                }
                if (n5 == -1) break block63;
                int n6 = (4 - this.res.currentPlayerPos + this.res.mjGame.eventPlayer) % 4;
                int n7 = 21;
                int n8 = 93;
                int n9 = 78;
                int n10 = 0;
                int n11 = 0;
                int n12 = 25;
                switch (n6) {
                    case 0: {
                        n8 -= 24;
                        n9 = 260 - n12 - n7 - 50;
                        n10 = 50;
                        break;
                    }
                    case 2: {
                        n8 -= 24;
                        n9 = n12;
                        n10 = 50;
                        break;
                    }
                    case 1: {
                        n8 = 240 - n12 - 50;
                        n11 = 50 + n7 + 2;
                        n10 = 1;
                        break;
                    }
                    case 3: {
                        n8 = 20;
                        n11 = 50 + n7 + 2;
                        n10 = 1;
                    }
                }
                if (this.res.mjGame.eventPlayer >= 0) {
                    this.drawFaceBG(graphics, this.res.players[n6], n8, n9);
                }
                int n13 = n9 + n11;
                int n14 = n8 + n10;
                GameDisplay.drawClipImage(graphics, images[n5], n14, n13, n4, 0, 48, 48);
                GameDisplay.resetClip(graphics);
                if (this.res.mjGame.eventPlayer < 0) break block63;
                String string = this.res.getPlayername(this.res.mjGame.eventPlayer);
                this.drawBoxString(graphics, n8 + 25, n9 + 50, GameResource.trimString(string, GameResource.font, 80), 0xFFFFFF, 50);
                break block63;
            }
            if (this.res.mjGame.reply == -2 && this.res.mjGame.processingThinkingOrder != null && this.res.mjGame.processingThinkingOrder.size() > this.res.mjGame.replyThinkingIndex && this.res.mjGame.replyThinkingIndex >= 0) {
                int n;
                int n15;
                int n16;
                Vector[] vectorArray = new Vector[4];
                for (int j = 0; j < 4; ++j) {
                    vectorArray[j] = new Vector();
                }
                ThinkingOrder thinkingOrder = (ThinkingOrder)this.res.mjGame.processingThinkingOrder.elementAt(this.res.mjGame.replyThinkingIndex);
                int n17 = -1;
                switch (thinkingOrder.iActionIndex) {
                    case 0: 
                    case 1: 
                    case 2: {
                        n17 = 1;
                        break;
                    }
                    case 3: {
                        n17 = 0;
                        break;
                    }
                    case 4: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 13: 
                    case 14: 
                    case 15: {
                        n17 = 2;
                        break;
                    }
                    case 5: 
                    case 16: 
                    case 20: {
                        n17 = 3;
                    }
                }
                block37: for (n16 = 0; n16 < this.res.mjGame.processingThinkingOrder.size(); ++n16) {
                    short s = ((ThinkingOrder)this.res.mjGame.processingThinkingOrder.elementAt((int)n16)).iActionIndex;
                    switch (s) {
                        case 0: 
                        case 1: 
                        case 2: {
                            vectorArray[1].addElement(new Integer(n16));
                            continue block37;
                        }
                        case 3: {
                            vectorArray[0].addElement(new Integer(n16));
                            continue block37;
                        }
                        case 4: 
                        case 7: 
                        case 8: 
                        case 9: 
                        case 10: 
                        case 11: 
                        case 12: 
                        case 13: 
                        case 14: 
                        case 15: {
                            vectorArray[2].addElement(new Integer(n16));
                            continue block37;
                        }
                        case 5: 
                        case 16: 
                        case 20: {
                            vectorArray[3].addElement(new Integer(n16));
                        }
                    }
                }
                n16 = 0;
                int[] nArray = new int[3];
                if (thinkingOrder.iIndexPlayer != this.res.currentPlayerPos) {
                    return;
                }
                int n18 = -1;
                switch (thinkingOrder.iActionIndex) {
                    case 0: {
                        n16 = 0;
                        n18 = 2;
                        nArray[0] = thinkingOrder.iRefCard - 8;
                        nArray[1] = nArray[0] + 4;
                        nArray[2] = nArray[0] + 8;
                        break;
                    }
                    case 1: {
                        n16 = 0;
                        n18 = 1;
                        nArray[0] = thinkingOrder.iRefCard - 4;
                        nArray[1] = nArray[0] + 4;
                        nArray[2] = nArray[0] + 8;
                        break;
                    }
                    case 2: {
                        n16 = 0;
                        n18 = 0;
                        nArray[0] = thinkingOrder.iRefCard;
                        nArray[1] = nArray[0] + 4;
                        nArray[2] = nArray[0] + 8;
                        break;
                    }
                    case 3: {
                        n16 = 40;
                        n18 = 0;
                        nArray[0] = thinkingOrder.iRefCard;
                        nArray[1] = nArray[0];
                        nArray[2] = nArray[0];
                        break;
                    }
                    case 4: {
                        n18 = 0;
                        n16 = 80;
                        nArray = new int[]{thinkingOrder.iRefCard, nArray[0], nArray[0], nArray[0]};
                        break;
                    }
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 13: 
                    case 14: 
                    case 15: {
                        n18 = 0;
                        n16 = 80;
                        nArray = new int[]{thinkingOrder.iRefCard - 144, nArray[0], nArray[0], nArray[0]};
                        break;
                    }
                    case 5: 
                    case 16: {
                        n18 = 1;
                        nArray[0] = -1;
                        nArray[1] = thinkingOrder.iRefCard;
                        nArray[2] = -1;
                        n16 = 120;
                        break;
                    }
                    case 20: {
                        nArray = new int[]{};
                        n16 = 120;
                        break;
                    }
                    case 21: {
                        if (this.res.mjGame.isCancelGetCardAction) {
                            return;
                        }
                        n16 = 160;
                    }
                }
                GameDisplay.resetClip(graphics);
                if (thinkingOrder.iIndexPlayer != this.res.currentPlayerPos) {
                    return;
                }
                if (n16 >= 0) {
                    GameDisplay.fillRoundRect(graphics, 64, 67, 111, 135, 2, 2, 0, 8264732);
                    GameDisplay.drawRect(graphics, 77, 71, 84, 30, 1, 1, 0);
                    GameDisplay.fillRect(graphics, 78, 72, 82, 28, 0x444444);
                    n15 = 104;
                    for (n = 0; n < 4; ++n) {
                        int n19 = 45;
                        if (n == 0) {
                            n19 = 17;
                        } else if (n == 1) {
                            n19 = 20;
                        } else if (n == 2) {
                            n19 = 14;
                        } else if (n == 3) {
                            n19 = 21;
                        }
                        GameDisplay.drawImage(graphics, images[n19], 92, n15, 0);
                        if (vectorArray[n].size() > 0) {
                            if (n == n17) {
                                GameDisplay.drawRoundString(graphics, this.res.iGameText[31], 67, n15 + 1, 0, 16435200, 0);
                                GameDisplay.drawRoundString(graphics, this.res.iGameText[32], 148, n15 + 1, 0, 16435200, 0);
                            }
                        } else {
                            GameDisplay.drawImage(graphics, images[5], 92, n15, 0);
                        }
                        n15 += 23;
                    }
                }
                n15 = 93;
                if (nArray.length == 4) {
                    n15 = 85;
                }
                for (n = 0; n < nArray.length; ++n) {
                    if (nArray[n] >= 0) {
                        this.drawP1HoldCard(graphics, n15, 72, nArray[n]);
                        if (n == n18) {
                            GameDisplay.drawRect(graphics, n15, 72, 17, 27, 1, 1, 0xFF0000);
                        }
                    }
                    n15 += 17;
                }
                for (n = 0; n < 4; ++n) {
                    vectorArray[n].removeAllElements();
                }
            }
        }
    }

    void drawMJGameBG(Graphics graphics) {
        GameDisplay.drawImage(graphics, images[0], 0, 0, 20);
        int n = 0;
        boolean bl = false;
        switch (this.res.mjGame.gameWind) {
            case 0: {
                n = 30;
                break;
            }
            case 1: {
                n = 33;
                break;
            }
            case 2: {
                n = 35;
                break;
            }
            case 3: {
                n = 31;
            }
        }
        int n2 = GameDisplay.getImageWidth(images[n]);
        int n3 = GameDisplay.getImageWidth(images[79]);
        n3 /= 5;
        Image image = images[81];
        int n4 = GameDisplay.getImageWidth(image);
        int n5 = GameDisplay.getImageHeight(image);
        int n6 = n4;
        int n7 = 4;
        int n8 = 24;
        int n9 = (n3 + 1) * 2 + n6 + n8 + n7 * 5;
        int n10 = 240 - n9 + n2 >> 1;
        int n11 = GameDisplay.getImageHeight(images[n]);
        int n12 = Math.max(Math.max(21, n11), n5) + 4;
        int n13 = 231 - n11 - n12 - 4;
        GameDisplay.fillRect(graphics, n10, n13, n9, n12, 0);
        GameDisplay.drawRect(graphics, n10, n13, n9, n12, 8264732);
        GameDisplay.drawImage(graphics, images[n], n10 - 2, n13 + n12 / 2, 10);
        int n14 = n10 + n7;
        int n15 = GameDisplay.getImageHeight(images[79]);
        int n16 = n12 - n15 >> 1;
        GameDisplay.drawClipImage(graphics, images[79], n14, n13 + n16, this.res.mjGame.gameStarter * n3, 0, n3, n15);
        GameDisplay.drawClipImage(graphics, images[79], n14 += n3 + 1, n13 + n16, 4 * n3, 0, n3, n15);
        GameDisplay.resetClip(graphics);
        GameDisplay.drawImage(graphics, image, n14 += n3 + 1 + n7 * 2, n13 + (n12 - n5) / 2, 20);
        int n17 = GameDisplay.getImageHeight(images[41]);
        int n18 = (n12 - n17) / 2;
        GameDisplay.drawClipImage(graphics, images[41], n14 += n4 + 1, n13 + n18, 70, 0, 7, 11);
        this.drawTableDig(graphics, n14 += n7, n13 + n18, 144 - this.res.mjGame.nextCard);
        GameDisplay.resetClip(graphics);
        this.drawFlower(graphics, this.res.currentPlayerPos, 41, 209);
        GameDisplay.resetClip(graphics);
    }

    void drawMJGamePlayer1(Graphics graphics, MJPlayer mJPlayer) {
        int n;
        int n2;
        int n3 = -1;
        int n4 = 0;
        int n5 = 0;
        int n6 = 231;
        for (n2 = 0; n2 < mJPlayer.cardPatternIndex.size(); ++n2) {
            n3 = (Integer)mJPlayer.cardPatternIndex.elementAt(n2);
            for (n = 0; n < 3; ++n) {
                this.drawThrowCard(graphics, n5, n6, mJPlayer.cardShow[n4]);
                ++n4;
                n5 += 17;
            }
            if (n3 != 2) continue;
            this.drawThrowCard(graphics, n5 + -33, n6 + -8, mJPlayer.cardShow[n4]);
            ++n4;
        }
        ++n5;
        if (this.res.mjGame.winPlayer != mJPlayer.position) {
            n2 = -1;
            if (mJPlayer.holdingLength % 3 == 2) {
                n2 = this.res.mjGame.replyCardIndex;
            }
            n = 0;
            for (n4 = 0; n4 < mJPlayer.holdingLength - 1; ++n4) {
                n = n2 == n4 ? -4 : 0;
                this.drawP1HoldCard(graphics, n5, n6 + n, mJPlayer.cardHolding[mJPlayer.cardDisplayHolding[n4]]);
                n5 += 17;
            }
            if (mJPlayer.holdingLength % 3 == 2) {
                ++n5;
            }
            n = n2 == n4 ? -4 : 0;
            this.drawP1HoldCard(graphics, n5, n6 + n, mJPlayer.cardHolding[mJPlayer.cardDisplayHolding[n4]]);
        } else {
            for (n4 = 0; n4 < mJPlayer.holdingLength; ++n4) {
                this.drawThrowCard(graphics, n5, n6, mJPlayer.cardHolding[n4]);
                n5 += 17;
            }
        }
    }

    void drawMJGamePlayer2(Graphics graphics, MJPlayer mJPlayer) {
        int n = -1;
        int n2 = 0;
        int n3 = 238;
        for (int j = 0; j < mJPlayer.cardPatternIndex.size(); ++j) {
            n = (Integer)mJPlayer.cardPatternIndex.elementAt(j);
            int n4 = 0;
            if (n2 == 0) {
                n3 = n3 - 21 + 2;
                this.drawThrowCard2(graphics, 214, n3, mJPlayer.cardShow[n2], true);
                ++n2;
                n4 = 1;
            }
            while (n4 < 3) {
                n3 = n3 - 21 + 6;
                this.drawThrowCard2(graphics, 214, n3, mJPlayer.cardShow[n2], false);
                ++n2;
                ++n4;
            }
            if (n != 2) continue;
            this.drawThrowCard2(graphics, 213, n3 + 14, mJPlayer.cardShow[n2], true);
            ++n2;
        }
        if (this.res.mjGame.winPlayer != mJPlayer.position) {
            if (mJPlayer.cardPatternIndex.size() == 0) {
                n3 -= 14;
            }
            GameDisplay.drawClipImage(graphics, images[52], 219, n3 -= 27, 12, 0, 12, 27);
            for (n2 = 1; n2 < mJPlayer.holdingLength - 1; ++n2) {
                GameDisplay.drawClipImage(graphics, images[52], 219, n3 -= 10, 12, 0, 12, 10);
            }
            if (mJPlayer.holdingLength % 3 == 2) {
                n3 = n3 - 13 + 1;
                GameDisplay.drawClipImage(graphics, images[52], 219, n3, 12, 0, 12, 13);
            } else if (mJPlayer.holdingLength > 1) {
                n3 = n3 - 10 + 1;
                GameDisplay.drawClipImage(graphics, images[52], 219, n3, 12, 0, 12, 10);
            }
            GameDisplay.resetClip(graphics);
        } else {
            for (n2 = 0; n2 < mJPlayer.holdingLength; ++n2) {
                this.drawThrowCard2(graphics, 214, n3 -= 15, mJPlayer.cardHolding[n2], false);
            }
        }
    }

    void drawMJGamePlayer3(Graphics graphics, MJPlayer mJPlayer) {
        int n = -1;
        int n2 = 0;
        int n3 = 223;
        int n4 = 0;
        for (int j = 0; j < mJPlayer.cardPatternIndex.size(); ++j) {
            n = (Integer)mJPlayer.cardPatternIndex.elementAt(j);
            for (int k = 0; k < 3; ++k) {
                this.drawThrowCard3(graphics, n3, n4, mJPlayer.cardShow[n2]);
                ++n2;
                n3 -= 17;
            }
            if (n != 2) continue;
            this.drawThrowCard3(graphics, n3 + 33, n4 + -8, mJPlayer.cardShow[n2]);
            ++n2;
        }
        n3 += -2;
        if (this.res.mjGame.winPlayer != mJPlayer.position) {
            for (n2 = 0; n2 < mJPlayer.holdingLength - 1; ++n2) {
                GameDisplay.drawClipImage(graphics, images[52], n3, n4, 41, 0, 17, 27);
                n3 -= 17;
            }
            if (mJPlayer.holdingLength % 3 == 2) {
                n3 += -2;
            }
            GameDisplay.drawClipImage(graphics, images[52], n3, n4, 41, 0, 17, 27);
            GameDisplay.resetClip(graphics);
        } else {
            for (n2 = 0; n2 < mJPlayer.holdingLength; ++n2) {
                this.drawThrowCard3(graphics, n3, n4, mJPlayer.cardHolding[n2]);
                n3 -= 17;
            }
        }
    }

    void drawMJGamePlayer4(Graphics graphics, MJPlayer mJPlayer) {
        int n = -1;
        int n2 = 0;
        int n3 = 23;
        for (int j = 0; j < mJPlayer.cardPatternIndex.size(); ++j) {
            n = (Integer)mJPlayer.cardPatternIndex.elementAt(j);
            int n4 = 0;
            for (n4 = 0; n4 < 3; ++n4) {
                if (j == mJPlayer.cardPatternIndex.size() - 1 && n4 == 2) {
                    this.drawThrowCard4(graphics, 4, n3, mJPlayer.cardShow[n2], true);
                    n3 = n3 + 21 - 2;
                    ++n2;
                    continue;
                }
                this.drawThrowCard4(graphics, 4, n3, mJPlayer.cardShow[n2], false);
                n3 = n3 + 21 - 6;
                ++n2;
            }
            if (n != 2) continue;
            this.drawThrowCard4(graphics, 5, n3 + -36, mJPlayer.cardShow[n2], true);
            ++n2;
        }
        if (this.res.mjGame.winPlayer != mJPlayer.position) {
            n3 = mJPlayer.cardPatternIndex.size() > 0 ? (n3 -= 7) : (n3 += 14);
            for (n2 = 0; n2 < mJPlayer.holdingLength - 2; ++n2) {
                GameDisplay.drawClipImage(graphics, images[52], 6, n3, 0, 0, 12, 10);
                n3 += 10;
            }
            if (mJPlayer.holdingLength % 3 == 2) {
                GameDisplay.drawClipImage(graphics, images[52], 6, n3, 0, 0, 12, 13);
                n3 += 13;
            } else if (mJPlayer.holdingLength > 1) {
                GameDisplay.drawClipImage(graphics, images[52], 6, n3, 0, 0, 12, 10);
                n3 += 10;
            }
            GameDisplay.drawClipImage(graphics, images[52], 6, n3, 0, 0, 12, 27);
            GameDisplay.resetClip(graphics);
        } else {
            for (n2 = 0; n2 < mJPlayer.holdingLength; ++n2) {
                this.drawThrowCard4(graphics, 4, n3, mJPlayer.cardHolding[n2], true);
                n3 += 15;
            }
        }
    }

    void drawMJGameResult(Graphics graphics) {
        int n;
        int n2;
        int n3;
        int n4;
        GameDisplay.drawImage(graphics, images[0], 0, 0, 20);
        this.drawTitle(graphics, 1);
        int n5 = 1;
        int n6 = 52;
        MJPlayer mJPlayer = this.res.mjGame.mjPlayers[this.res.mjGame.winPlayer];
        int n7 = 0;
        block4: for (n4 = 0; n4 < mJPlayer.cardPatternIndex.size(); ++n4) {
            n3 = (Integer)mJPlayer.cardPatternIndex.elementAt(n4);
            switch (n3) {
                case 0: 
                case 1: {
                    for (n2 = 0; n2 < 3; ++n2) {
                        this.drawThrowCard(graphics, n5, n6, mJPlayer.cardShow[n7]);
                        n5 += 17;
                        ++n7;
                    }
                    continue block4;
                }
                case 2: {
                    for (n2 = 0; n2 < 3; ++n2) {
                        this.drawThrowCard(graphics, n5, n6, mJPlayer.cardShow[n7]);
                        n5 += 17;
                        ++n7;
                    }
                    this.drawThrowCard(graphics, n5 + -33, n6 + -8, mJPlayer.cardShow[n7]);
                    ++n7;
                }
            }
        }
        while (n7 < mJPlayer.showLength) {
            this.drawThrowCard(graphics, n5, n6, mJPlayer.cardShow[n7]);
            n5 += 17;
            ++n7;
        }
        n5 = 6;
        n6 = 89;
        n4 = 60;
        n3 = 180;
        for (n2 = 0; n2 < this.res.winPattern.length; ++n2) {
            n = (n2 & 1) == 0 ? n4 : n3;
            int n8 = (n2 >> 1) * 22 + n6;
            GameDisplay.drawRoundString(graphics, MJGame.WO_INFO_NAME[this.res.winPattern[n2]], n, n8, 17, 0, 16435200);
            if (n8 >= 159) break;
        }
        n5 = 0;
        n6 = 180;
        n2 = this.res.mjGame.winPlayer;
        n = this.res.players[n2];
        PlayerInfo playerInfo = this.res.playerInfos[n];
        this.drawFace(graphics, n, n5, n6, false);
        GameDisplay.drawString(graphics, GameResource.trimString(this.res.getPlayername(this.res.mjGame.winPlayer), GameResource.font, 120), n5 + 50, n6 + 4 + 21, 0, 16435200);
        String string = this.res.iGameText[35] + this.res.winScore;
        GameDisplay.drawString(graphics, string, 238, n6 + 1, 24, 16435200);
        GameDisplay.drawRoundString(graphics, this.res.iGameText[150] + this.res.lastOffsetScore[n2], 238, n6 + 50 - 21 - 1, 24, 0, 16435200);
        this.drawBottomBar(graphics);
        this.drawButton(graphics, 0);
    }

    void drawP1HoldCard(Graphics graphics, int n, int n2, int n3) {
        int n4 = (n3 >>= 2) / 9;
        int n5 = n3 % 9;
        GameDisplay.drawClipImage(graphics, images[52], n, n2, 24, 0, 17, 27);
        GameDisplay.drawClipImage(graphics, images[1], n + 0, n2 + 5, n5 * 17, n4 * 21, 17, 21);
        GameDisplay.resetClip(graphics);
    }

    void drawResultScore(Graphics graphics, int n, int n2, int n3, boolean bl) {
        for (int j = n; j >= 0; j /= 10) {
            int n4 = j % 10;
            GameDisplay.drawClipImage(graphics, images[42], n2 - 7, n3, 7 * n4, 0, 7, 9);
            n2 -= 7;
            if (j < 10) break;
        }
        GameDisplay.resetClip(graphics);
        if (bl) {
            GameDisplay.drawImage(graphics, images[6], n2 - 7, n3, 0);
        }
    }

    void drawSeletePlayer(Graphics graphics) {
        int n;
        int n2;
        int n3;
        String string;
        GameDisplay.drawImage(graphics, images[0], 0, 0, 20);
        this.drawTitle(graphics, 4);
        GameDisplay.drawImage(graphics, images[88], 0, 61, 20);
        int n4 = this.res.menuIndex + this.res.currentIndex;
        if (n4 > 0) {
            string = images[89];
            n3 = GameDisplay.getImageWidth((Image)string);
            n2 = GameDisplay.getImageHeight((Image)string);
            n = this.res.playerInfos.length - 1;
            GameDisplay.drawClipImage(graphics, (Image)string, 95, 37, n3 * (n4 - 1) / n, 0, n3 / n, n2);
            GameDisplay.resetClip(graphics);
        }
        string = "";
        string = n4 == 0 ? GameResource.trimString(this.res.playerInfo.nickname, GameResource.font, 120) : this.res.playerInfos[n4].stringMessage1;
        GameDisplay.drawString(graphics, string, 15, 140, 20, 16435200);
        GameDisplay.drawImage(graphics, images[n4 + 90], 17, 76, 20);
        n3 = 4;
        n2 = 240 / n3;
        n = n2 - 50 >> 1;
        int n5 = 54;
        block0: for (int j = 0; j < n3; ++j) {
            int n6 = this.res.currentIndex + j;
            int n7 = n2 * j + n;
            this.drawFace(graphics, n6, n7, 170, this.res.menuIndex == j);
            for (int k = 0; k < this.res.selectedPlayer; ++k) {
                if (this.res.players[k] != n6) continue;
                Image image = images[k == 0 ? 32 : 28];
                GameDisplay.drawImage(graphics, image, n7, 220, 6);
                continue block0;
            }
        }
        if ((this.renderTick >> 1 & 1) == 0) {
            if (this.res.currentIndex > 0) {
                GameDisplay.drawImage(graphics, images[36], 0, 195, 6);
            }
            if (this.res.currentIndex + 4 < this.res.playerInfos.length) {
                GameDisplay.drawImage(graphics, images[74], 240, 195, 10);
            }
        }
        this.drawBottomBar(graphics);
        this.drawButton(graphics, 0);
        this.drawButton(graphics, 2);
    }

    public int getSettingColor(int n, int n2) {
        if (n == n2) {
            return 0xFFFFFF;
        }
        return 16435200;
    }

    void drawSetting(Graphics graphics) {
        GameDisplay.drawImage(graphics, images[0], 0, 0, 20);
        int n = 110;
        int n2 = this.getSettingColor(this.res.currentIndex, 0);
        GameDisplay.drawRoundString(graphics, this.res.iGameText[30], n, 90, 24, 0, n2);
        switch (this.res.soundVol) {
            case 5: {
                GameDisplay.fillRect(graphics, 181, 78, 12, 25, 13784064);
            }
            case 4: {
                GameDisplay.fillRect(graphics, 168, 81, 12, 22, 16150016);
            }
            case 3: {
                GameDisplay.fillRect(graphics, 155, 84, 12, 19, 16746762);
            }
            case 2: {
                GameDisplay.fillRect(graphics, 142, 87, 12, 16, 16754504);
            }
            case 1: {
                GameDisplay.fillRect(graphics, 129, 90, 12, 13, 16761472);
            }
        }
        GameDisplay.drawRect(graphics, 181, 78, 12, 25, 1, 1, 16435200);
        GameDisplay.drawRect(graphics, 168, 81, 12, 22, 1, 1, 16435200);
        GameDisplay.drawRect(graphics, 155, 84, 12, 19, 1, 1, 16435200);
        GameDisplay.drawRect(graphics, 142, 87, 12, 16, 1, 1, 16435200);
        GameDisplay.drawRect(graphics, 129, 90, 12, 13, 1, 1, 16435200);
        n2 = this.getSettingColor(this.res.currentIndex, 1);
        GameDisplay.drawRoundString(graphics, this.res.iGameText[106], n, 117, 24, 0, n2);
        GameDisplay.drawRoundString(graphics, GameResource.trimString(this.res.playerInfo.nickname, GameResource.font, 109), 129, 117, 20, 0, 16435200);
        this.drawTitle(graphics, 2);
        this.drawBottomBar(graphics);
        this.drawButton(graphics, 1);
    }

    void drawTableDig(Graphics graphics, int n, int n2, int n3) {
        int n4 = n3 / 100;
        int n5 = n3 % 100 / 10;
        int n6 = n3 % 10;
        if (n4 > 0) {
            GameDisplay.drawClipImage(graphics, images[41], n, n2, 7 * n4, 0, 7, 11);
        }
        n = n + 7 + 1;
        if (n4 > 0 || n5 > 0) {
            GameDisplay.drawClipImage(graphics, images[41], n, n2, 7 * n5, 0, 7, 11);
        }
        n = n + 7 + 1;
        GameDisplay.drawClipImage(graphics, images[41], n, n2, 7 * n6, 0, 7, 11);
        GameDisplay.resetClip(graphics);
    }

    void drawThrowCardCenter(Graphics graphics, int n, int n2, int n3) {
        boolean bl = false;
        if (n3 >= 200) {
            bl = true;
            n3 %= 200;
        }
        int n4 = (n3 >>= 2) / 9;
        int n5 = n3 % 9;
        GameDisplay.drawImage(graphics, images[84], n, n2, 20);
        GameDisplay.drawClipImage(graphics, images[83], n, n2, 12 * n5, 16 * n4, 12, 16);
        GameDisplay.resetClip(graphics);
        if (bl) {
            GameDisplay.drawImage(graphics, images[76], n, n2, 20);
        }
    }

    void drawThrowCard(Graphics graphics, int n, int n2, int n3) {
        boolean bl = false;
        if (n3 >= 200) {
            bl = true;
            n3 %= 200;
        }
        int n4 = (n3 >>= 2) / 9;
        int n5 = n3 % 9;
        GameDisplay.drawClipImage(graphics, images[52], n, n2, 58, 0, 17, 27);
        GameDisplay.drawClipImage(graphics, images[1], n + 0, n2 + 0, n5 * 17, n4 * 21, 17, 21);
        GameDisplay.resetClip(graphics);
        if (bl) {
            GameDisplay.drawImage(graphics, images[76], n, n2, 20);
        }
        GameDisplay.resetClip(graphics);
    }

    void drawThrowCard2(Graphics graphics, int n, int n2, int n3, boolean bl) {
        int n4 = (n3 >>= 2) / 9;
        int n5 = n3 % 9;
        int n6 = 21;
        if (!bl) {
            n6 = 15;
        }
        GameDisplay.drawClipImage(graphics, images[52], n, n2, 75, 6, 22, n6);
        GameDisplay.drawClipImage(graphics, images[2], n + 0, n2 + 0, n4 * 22, (8 - n5) * 14, 22, 14);
        GameDisplay.resetClip(graphics);
    }

    void drawThrowCard3(Graphics graphics, int n, int n2, int n3) {
        int n4 = 3 - (n3 >>= 2) / 9;
        int n5 = 8 - n3 % 9;
        GameDisplay.drawClipImage(graphics, images[52], n, n2, 58, 0, 17, 27);
        GameDisplay.drawClipImage(graphics, images[3], n + 0, n2 + 0, n5 * 17, n4 * 21, 17, 21);
        GameDisplay.resetClip(graphics);
    }

    void drawThrowCard4(Graphics graphics, int n, int n2, int n3, boolean bl) {
        int n4 = 3 - (n3 >>= 2) / 9;
        int n5 = 8 - n3 % 9;
        int n6 = 21;
        if (!bl) {
            n6 = 15;
        }
        GameDisplay.drawClipImage(graphics, images[52], n, n2, 75, 6, 22, n6);
        GameDisplay.drawClipImage(graphics, images[4], n + 0, n2 + 0, n4 * 22, (8 - n5) * 14, 22, 14);
        GameDisplay.resetClip(graphics);
    }

    void drawTitle(Graphics graphics, int n) {
        int n2 = -1;
        int n3 = 120;
        boolean bl = false;
        int n4 = 3;
        switch (n) {
            case 8: {
                n2 = 70;
                break;
            }
            case 9: {
                n2 = 71;
                break;
            }
            case 10: {
                n2 = 72;
                break;
            }
            case 11: {
                n2 = 73;
                break;
            }
            case 7: {
                n2 = 69;
                break;
            }
            case 0: {
                n2 = 59;
                break;
            }
            case 1: {
                n2 = 58;
                break;
            }
            case 2: {
                n2 = 60;
                break;
            }
            case 3: {
                n2 = 55;
                break;
            }
            case 4: {
                n2 = 54;
                break;
            }
            case 5: {
                n2 = 56;
                break;
            }
            case 6: {
                n2 = 53;
            }
        }
        if (n2 != -1) {
            GameDisplay.drawImage(graphics, images[n2], n3, n4, 17);
        }
    }

    void drawBalance(Graphics graphics) {
        GameDisplay.drawImage(graphics, images[0], 0, 0, 20);
        this.drawTitle(graphics, 6);
        int n = GameDisplay.getImageHeight(images[53]) + 5;
        int n2 = 260 - n - 21 - 4;
        int n3 = 240;
        int n4 = n2 / 4;
        this.drawBalancePlayer(graphics, 0, 0, n, n3, n4);
        this.drawBalancePlayer(graphics, 1, 0, n + n4, n3, n4);
        this.drawBalancePlayer(graphics, 2, 0, n + 2 * n4, n3, n4);
        this.drawBalancePlayer(graphics, 3, 0, n + 3 * n4, n3, n4);
        this.drawBottomBar(graphics);
        this.drawButton(graphics, 0);
    }

    void drawBalancePlayer(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        this.drawPlayerHeader(graphics, n, n2, n3, n4, n5);
        int n6 = this.res.players[n];
        int n7 = this.res.playersScore[n];
        int n8 = this.res.lastOffsetScore[n];
        String string = Integer.toString(n7);
        GameDisplay.drawString(graphics, string, n2 + 240 - 5, n3 + n5 - 21, 24, 16435200);
        string = "";
        string = n8 >= 0 ? this.res.iGameText[152] + n8 : this.res.iGameText[153] + -1 * n8;
        GameDisplay.drawString(graphics, string, n2 + 5, n3 + n5 - 21, 20, 16435200);
    }

    void drawBigFaceWithName(Graphics graphics, int n, int n2, int n3) {
        GameDisplay.drawImage(graphics, images[n + 90], n2, n3 + 21, 0);
        if (n == 0) {
            this.drawBigTabString(graphics, GameResource.trimString(this.res.playerInfo.nickname, GameResource.font, 120), n2, n3, 0, 0xFFFFFF);
        } else {
            this.drawBigTabString(graphics, this.res.playerInfos[n].stringName, n2, n3, 0, 0xFFFFFF);
        }
    }

    void drawBigTabString(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        this.drawBigTabString(graphics, this.res.iGameText[n], n2, n3, n4, n5);
    }

    void drawBigTabString(Graphics graphics, String string, int n, int n2, int n3, int n4) {
        GameDisplay.drawRoundString(graphics, string, n, n2, 20, n3, n4);
    }

    void drawBox(Graphics graphics, int n, int n2, int n3, int n4) {
        this.drawBoxOutSide(graphics, n, n2, n3, n4);
        GameDisplay.fillRect(graphics, n + 5, n2 + 5, n3 - 10, n4 - 10, 0xFFFFFF);
    }

    void drawBoxOutSide(Graphics graphics, int n, int n2, int n3, int n4) {
        GameDisplay.drawRect(graphics, n, n2, n3, n4, 1, 1, 0);
        GameDisplay.drawRect(graphics, n + 1, n2 + 1, n3 - 2, n4 - 2, 1, 1, 0x7A7A7A);
        GameDisplay.drawRect(graphics, n + 2, n2 + 2, n3 - 4, n4 - 4, 1, 1, 0xFFFFFF);
        GameDisplay.drawRect(graphics, n + 3, n2 + 3, n3 - 6, n4 - 6, 1, 1, 0xA9A9A9);
        GameDisplay.drawRect(graphics, n + 4, n2 + 4, n3 - 8, n4 - 8, 1, 1, 0xA9A9A9);
    }

    void drawButton(Graphics graphics, int n) {
        switch (n) {
            case 0: {
                GameDisplay.drawImage(graphics, images[34], 0, 260, 36);
                break;
            }
            case 1: {
                GameDisplay.drawImage(graphics, images[27], 240, 260, 40);
                break;
            }
            case 2: {
                GameDisplay.drawImage(graphics, images[29], 240, 260, 40);
            }
        }
    }

    void drawCredit(Graphics graphics) {
        this.drawAlertPage(graphics, 3);
        this.drawBottomBar(graphics);
        this.drawButton(graphics, 1);
    }

    void drawDetailRecord(Graphics graphics) {
        block3: {
            block2: {
                GameDisplay.drawImage(graphics, images[0], 0, 0, 20);
                int n = this.res.currentIndex + 8;
                int n2 = 21 - graphics.getFont().getBaselinePosition() >> 1;
                int n3 = 6;
                if (GameResource.detailRecordList == null) break block2;
                if (GameResource.detailRecordList.length != 0) break block3;
            }
            this.drawLoading(graphics);
        }
        UIHelper.setDrawRegion(9, 41, 217, 187);
        UIHelper.drawRecord(graphics, GameResource.detailRecordList, this.res.currentIndex, 2, 21, markupDetailPos, null);
        this.drawScrollBar(graphics, this.res.currentIndex, GameResource.detailRecordList.length / 2, 21);
        this.drawTitle(graphics, 5);
        GameDisplay.resetClip(graphics);
        this.drawBottomBar(graphics);
        this.drawButton(graphics, 1);
    }

    public void drawLoading(Graphics graphics) {
        this.drawLoadingBar(graphics);
    }

    void drawFaceBG(Graphics graphics, int n, int n2, int n3) {
        GameDisplay.drawImage(graphics, images[n + 90], n2, n3, 0);
    }

    void drawFace(Graphics graphics, int n, int n2, int n3, boolean bl) {
        GameDisplay.drawImage(graphics, images[n + 90], n2, n3, 0);
        if (bl) {
            int n4 = GameDisplay.getImageWidth(images[23]) - GameDisplay.getImageWidth(images[n + 90]) >> 1;
            int n5 = GameDisplay.getImageHeight(images[23]) - GameDisplay.getImageHeight(images[n + 90]) >> 1;
            GameDisplay.drawImage(graphics, images[23], n2 - n4, n3 - n5, 0);
        }
    }

    void drawFlower(Graphics graphics, int n, int n2, int n3) {
        MJPlayer mJPlayer = this.res.mjGame.mjPlayers[n];
        if (mJPlayer.flowerLength > 0) {
            int n4 = 0;
            int n5 = 0;
            int n6 = 13;
            int n7 = 18;
            int n8 = 13;
            int n9 = 0;
            for (int j = 0; j < mJPlayer.flowerLength; ++j) {
                int n10 = mJPlayer.cardFlower[j] - 136;
                GameDisplay.drawClipImage(graphics, images[24], n2, n3, n4 + n8 * n10, n5 + n9 * n10, n6, n7);
                n2 += n8;
                n3 += n9;
            }
            GameDisplay.resetClip(graphics);
        }
    }

    void drawExitAlert(Graphics graphics) {
        GameDisplay.drawImage(graphics, images[0], 0, 0, 20);
        GameDisplay.drawString(graphics, this.res.iGameText[20], 120, 120, 17, 16435200);
        this.drawBottomBar(graphics);
        this.drawButton(graphics, 0);
        this.drawButton(graphics, 2);
    }

    void drawCloseSound(Graphics graphics) {
        GameDisplay.drawImage(graphics, images[0], 0, 0, 20);
        GameDisplay.drawString(graphics, this.res.iGameText[76], 120, 120, 17, 16435200);
        this.drawBottomBar(graphics);
        this.drawButton(graphics, 0);
        this.drawButton(graphics, 2);
    }

    void drawGameResultDraw(Graphics graphics) {
        GameDisplay.drawImage(graphics, images[0], 0, 0, 20);
        GameDisplay.drawImage(graphics, images[57], 120, 0, 17);
        int n = 26;
        int n2 = 260 - n - 21 - 4;
        int n3 = 240;
        for (int j = 0; j < 4; ++j) {
            this.drawGameResultDrawPlayer(graphics, j, 0, n + n2 * j / 4, n3, n2 / 4);
        }
        GameDisplay.resetClip(graphics);
        this.drawBottomBar(graphics);
        this.drawButton(graphics, 0);
    }

    public int getPausecolor(int n) {
        if (this.res.menuIndex == n) {
            return 16435200;
        }
        return 8264732;
    }

    void drawGamePause(Graphics graphics) {
        GameDisplay.drawImage(graphics, images[0], 0, 0, 20);
        this.drawGamePausePlayer(graphics, 0, 0, 0);
        this.drawGamePausePlayer(graphics, 1, 0, 57);
        this.drawGamePausePlayer(graphics, 2, 0, 114);
        this.drawGamePausePlayer(graphics, 3, 0, 171);
        int n = 80;
        for (int j = 0; j < 3; ++j) {
            graphics.setColor(this.getPausecolor(j));
            int n2 = n * j + n / 2;
            int n3 = 0;
            switch (j) {
                case 0: {
                    n3 = 13;
                    break;
                }
                case 1: {
                    n3 = 19;
                    break;
                }
                case 2: {
                    n3 = 18;
                }
            }
            int n4 = GameDisplay.getImageWidth(images[n3]);
            int n5 = GameDisplay.getImageHeight(images[n3]);
            GameDisplay.fillRect(graphics, n2 - n4 / 2 + 2, 230, n4 - 4, n5 - 4);
            GameDisplay.drawImage(graphics, images[n3], n2, 228, 17);
        }
    }

    void drawGameExitThanks(Graphics graphics) {
        GameDisplay.drawImage(graphics, images[0], 0, 0, 20);
        GameDisplay.drawString(graphics, this.res.iGameText[33], 120, 120, 17, 16435200);
        this.drawBottomBar(graphics);
    }

    void drawAlertPage(Graphics graphics, int n) {
        GameDisplay.drawImage(graphics, images[0], 0, 0, 20);
        int n2 = this.res.currentIndex + 8;
        UIHelper.setDrawRegion(9, 41, 227, 187);
        graphics.setColor(16435200);
        UIHelper.drawText(graphics, this.res.displayTexts, this.res.currentIndex, 22, 20, null);
        this.drawScrollBar(graphics, this.res.currentIndex, this.res.displayTexts.length, 22, 187, 36);
        this.drawTitle(graphics, n);
        GameDisplay.resetClip(graphics);
    }

    public void drawScrollBar(Graphics graphics, int n, int n2, int n3) {
        this.drawScrollBar(graphics, n, n2, n3, 187, 36);
    }

    public void drawScrollBar(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        UIHelper.setDrawRegion(234, n5, 6, n4);
        UIHelper.drawScrollBar(graphics, n2, n, n3, 0, 9131033, 0xFFFFCC, 0xFFFFCC, false, 10);
    }

    void drawGamePausePlayer(Graphics graphics, int n, int n2, int n3) {
        int n4 = this.res.players[n];
        GameDisplay.drawImage(graphics, images[n4 + 90], 0, n3, 20);
        int n5 = this.res.playersScore[n];
        String string = GameResource.trimString(this.res.getPlayername(n), GameResource.font, 120);
        GameDisplay.drawString(graphics, string, n2 + 50 + 5, n3 + 2, 20, 16435200);
        String string2 = Integer.toString(n5);
        GameDisplay.drawString(graphics, string2, 240 - n2 - 4, n3 + 4, 24, 16435200);
        this.drawFlower(graphics, n, n2 + 50 + 5, n3 + 50 - GameDisplay.getImageHeight(images[24]));
    }

    public void drawPlayerHeader(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        Image image = images[DIR_4_IMAGE[this.getWindPos(n)]];
        int n6 = GameDisplay.getImageWidth(image);
        int n7 = GameDisplay.getImageHeight(image);
        if (n == this.res.currentPlayerPos) {
            GameDisplay.fillRect(graphics, n2, n3, n4, n5, 8264732);
            GameDisplay.drawRect(graphics, n2, n3, n4 - 1, n5 - 1, 0);
        }
        GameDisplay.drawImage(graphics, image, n2 + 2, n3 + 2, 20);
        int n8 = this.res.getPlayerTypeImg(n);
        GameDisplay.drawImage(graphics, images[n8], n2 + n4 - 1, n3, 24);
        String string = GameResource.trimString(this.res.getPlayername(n), GameResource.font, n4 / 2);
        GameDisplay.drawString(graphics, string, n2 + n6 + 6, n3 + 1, 20, 16435200);
    }

    void drawGameResultDrawPlayer(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        int n6;
        this.drawPlayerHeader(graphics, n, n2, n3, n4, n5);
        MJPlayer mJPlayer = this.res.mjGame.mjPlayers[n];
        n3 = n3 + n5 - 27;
        n2 += 5;
        int n7 = 0;
        for (n6 = 0; n6 < mJPlayer.cardPatternIndex.size(); ++n6) {
            int n8 = (Integer)mJPlayer.cardPatternIndex.elementAt(n6);
            for (int j = 0; j < 3; ++j) {
                this.drawThrowCard(graphics, n2, n3, mJPlayer.cardShow[n7]);
                ++n7;
                n2 += 17;
            }
            if (n8 != 2) continue;
            this.drawThrowCard(graphics, n2 + -33, n3 + -8, mJPlayer.cardShow[n7]);
            ++n7;
        }
        ++n2;
        for (n6 = 0; n6 < mJPlayer.holdingLength; ++n6) {
            this.drawThrowCard(graphics, n2, n3, mJPlayer.cardHolding[n6]);
            n2 += 17;
        }
        GameDisplay.resetClip(graphics);
    }

    void initErrorState(int n) {
        this.res.isReady = false;
        try {
            MGCanvas.unloadAllImage();
            switch (n) {
                case 14: {
                    this.initExitGamePlayAlert();
                    break;
                }
                case 18: {
                    this.initGamePause();
                }
            }
            this.res.backErrorState = this.res.gameState;
            this.res.gameState = n;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.res.isReady = true;
    }

    void backGameState() {
        this.res.isReady = false;
        while (this.res.isDraw) {
            this.res.customSleep(50);
        }
        int[] nArray = mainGameImgList;
        try {
            GameDisplay.loadImage(nArray);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.res.gameState = 1;
        this.res.isReady = true;
    }

    public void drawQuickMessage(Graphics graphics) {
        if (this.res.playerHoldTime >= 40) {
            int n = (this.res.playerIndex + 1 + this.res.currentPlayerPos) % 4;
            int n2 = this.res.messageIndex;
            int n3 = this.res.players[n];
            String string = "";
            switch (n2) {
                case 0: {
                    string = this.res.playerInfos[n3].stringMessage1;
                    break;
                }
                case 1: {
                    string = this.res.playerInfos[n3].stringMessage2;
                }
            }
            switch (this.res.playerIndex) {
                case 0: {
                    this.drawMessageWithBox1(graphics, n3, string, n);
                    break;
                }
                case 1: {
                    this.drawMessageWithBox2(graphics, n3, string, n);
                    break;
                }
                case 2: {
                    this.drawMessageWithBox3(graphics, n3, string, n);
                }
            }
        }
    }

    public void drawMessageWithBox2(Graphics graphics, int n, String string, int n2) {
        this.drawMessageBoxPhoto(graphics, this.res.playerInfos[n].imageFaceIndex, 0, 0, 0xFFF0F0, 0xFF0000);
        this.drawMessageBoxMessage(graphics, string, 42, 8, 0xFFF0F0, 0xFF0000, 0x860000);
        this.drawMessageBoxName(graphics, GameResource.trimString(this.res.getPlayername(n2), GameResource.font, 80), 0, 46, 0xFFF0F0, 0xFF0000, 0x860000);
    }

    public void drawMessageWithBox1(Graphics graphics, int n, String string, int n2) {
        this.drawMessageBoxPhoto(graphics, this.res.playerInfos[n].imageFaceIndex, 198, 45, 8264732, 0xFFFFFF);
        this.drawMessageBoxMessage(graphics, string, 127, 91, 8264732, 0xFFFFFF, 16435200);
        this.drawMessageBoxName(graphics, GameResource.trimString(this.res.getPlayername(n2), GameResource.font, 80), 118, 54, 8264732, 0xFFFFFF, 16435200);
    }

    public void drawMessageWithBox3(Graphics graphics, int n, String string, int n2) {
        this.drawMessageBoxPhoto(graphics, this.res.playerInfos[n].imageFaceIndex, 0, 109, 16772572, 15288064);
        this.drawMessageBoxMessage(graphics, string, 0, 155, 16772572, 15288064, 8407808);
        this.drawMessageBoxName(graphics, GameResource.trimString(this.res.getPlayername(n2), GameResource.font, 80), 42, 118, 16772572, 15288064, 8407808);
    }

    public void drawMessageBoxPhoto(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        GameDisplay.fillRoundRect(graphics, n2, n3, 42, 46, 4, 4, n4);
        GameDisplay.drawRoundRect(graphics, n2 + 1, n3 + 1, 40, 44, 4, 4, 1, 1, n5);
        GameDisplay.drawImage(graphics, images[n + 90], n2 + 21, n3 + 23, 3);
    }

    public void drawMessageBoxMessage(Graphics graphics, String string, int n, int n2, int n3, int n4, int n5) {
        GameDisplay.fillRoundRect(graphics, n, n2, 113, 29, 4, 4, n3);
        GameDisplay.drawRoundRect(graphics, n + 1, n2 + 1, 111, 27, 4, 4, 1, 1, n4);
        GameDisplay.drawString(graphics, string, n + 56, n2 + 4, 17, n5);
    }

    public void drawMessageBoxName(Graphics graphics, String string, int n, int n2, int n3, int n4, int n5) {
        GameDisplay.fillRoundRect(graphics, n, n2, 80, 27, 4, 4, n3);
        GameDisplay.drawRoundRect(graphics, n + 1, n2 + 1, 78, 25, 4, 4, 1, 1, n4);
        GameDisplay.drawString(graphics, string, n + 40, n2 + 3, 17, n5);
    }

    public String[] breakStringToDisplayArrayFullScreen(String string) {
        return StringFunction.stringToDisplayArray(GameResource.font, string, 240);
    }

    public String[] breakStringToDisplayArray(String string) {
        return StringFunction.stringToDisplayArray(GameResource.font, string, 227);
    }

    public void canvasPaused() {
        this.res.mgsound.stop();
        GameMidlet.isPaused = true;
    }

    public void canvasResumed() {
        GameMidlet.isPaused = false;
    }

    public void loadImage() {
    }
}

