/*
 * Decompiled with CFR 0.152.
 */
package com.mg.lib;

import com.mg.lib.MGConfig;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.midlet.MIDlet;

public abstract class MGCanvas
extends Canvas
implements Runnable,
MGConfig {
    public static Font F_TITLE = Font.getFont((int)64, (int)1, (int)16);
    public static Font F_NORMAL = Font.getFont((int)32, (int)0, (int)0);
    public static Font F_SMALL = Font.getFont((int)32, (int)0, (int)8);
    public boolean isLoading = false;
    public static final int GAME_WIDTH = 240;
    public static final int GAME_HEIGHT = 260;
    public static int REAL_WIDTH = 240;
    public static int REAL_HEIGHT = 260;
    private static MIDlet midlet = null;
    public static Image[] images = null;
    private static boolean isQuit = false;
    public boolean up;
    public boolean down;
    public boolean left;
    public boolean right;
    public boolean fire;
    public boolean pUp;
    public boolean pDown;
    public boolean pLeft;
    public boolean pRight;
    public boolean pFire;
    public boolean softL;
    public boolean softR;
    public boolean scheduleKey = false;
    public int schKeyIdx;
    public int rawKeyPressedCode = -1;
    public int rawKeyReleasedCode = -1;
    private static int command_message_color = 0xFFFFFF;
    private static int command_messageoutline_color = 0;
    private static int[][] masterImgData = null;
    private static byte[] buffer = null;
    private static boolean isInitedBuffer = false;
    public static final int CRC32_POLYNOMIAL = -306674912;
    private static int[] CRCTable = null;
    static ByteArrayOutputStream BIS = new ByteArrayOutputStream();
    public static int stringYOff = 0;
    public boolean isPaused = false;

    public MGCanvas() {
        this.constructor();
    }

    public MGCanvas(MIDlet mIDlet) {
        midlet = mIDlet;
        this.constructor();
    }

    private void constructor() {
        this.setFullScreenMode(true);
        REAL_WIDTH = this.getWidth();
        REAL_HEIGHT = this.getHeight();
    }

    public static void destroy() {
        isQuit = true;
    }

    public static boolean isQuit() {
        return isQuit;
    }

    private int convertKeyCode(int n) {
        switch (n) {
            case 48: {
                return 0;
            }
            case 49: {
                return 1;
            }
            case 50: {
                return 2;
            }
            case 51: {
                return 3;
            }
            case 52: {
                return 4;
            }
            case 53: {
                return 6;
            }
            case 54: {
                return 5;
            }
            case 55: {
                return 7;
            }
            case 56: {
                return 8;
            }
            case 57: {
                return 9;
            }
            case 42: {
                return 19;
            }
            case 35: {
                return 20;
            }
            case -6: {
                return 21;
            }
            case -7: {
                return 22;
            }
            case -5: {
                return 23;
            }
        }
        try {
            int n2 = this.getGameAction(n);
            switch (n2) {
                case 1: {
                    return 14;
                }
                case 6: {
                    return 15;
                }
                case 2: {
                    return 16;
                }
                case 5: {
                    return 17;
                }
                case 8: {
                    return 18;
                }
                case 9: {
                    return 10;
                }
                case 10: {
                    return 11;
                }
                case 11: {
                    return 12;
                }
                case 12: {
                    return 13;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return -1;
    }

    public final void keyPressed(int n) {
        this.rawKeyPressedCode = n;
        if (this.isLoading) {
            return;
        }
        this.schKeyIdx = this.convertKeyCode(n);
        this.up = this.schKeyIdx == 2 || this.schKeyIdx == 14;
        this.down = this.schKeyIdx == 8 || this.schKeyIdx == 15;
        this.left = this.schKeyIdx == 4 || this.schKeyIdx == 16;
        this.right = this.schKeyIdx == 5 || this.schKeyIdx == 17;
        this.fire = this.schKeyIdx == 6 || this.schKeyIdx == 18 || this.schKeyIdx == 23;
        this.softL = this.schKeyIdx == 21;
        boolean bl = this.softR = this.schKeyIdx == 22;
        if (this.up) {
            this.pUp = true;
        } else if (this.down) {
            this.pDown = true;
        } else if (this.left) {
            this.pLeft = true;
        } else if (this.right) {
            this.pRight = true;
        } else if (this.fire) {
            this.pFire = true;
        }
        this.scheduleKey = true;
    }

    public final void keyReleased(int n) {
        this.rawKeyReleasedCode = n;
        if (this.isLoading) {
            return;
        }
        this.schKeyIdx = this.convertKeyCode(n);
        this.up = this.schKeyIdx == 2 || this.schKeyIdx == 14;
        this.down = this.schKeyIdx == 8 || this.schKeyIdx == 15;
        this.left = this.schKeyIdx == 4 || this.schKeyIdx == 16;
        this.right = this.schKeyIdx == 5 || this.schKeyIdx == 17;
        this.fire = this.schKeyIdx == 6 || this.schKeyIdx == 18 || this.schKeyIdx == 23;
        this.softL = this.schKeyIdx == 21;
        boolean bl = this.softR = this.schKeyIdx == 22;
        if (this.up) {
            this.pUp = false;
        } else if (this.down) {
            this.pDown = false;
        } else if (this.left) {
            this.pLeft = false;
        } else if (this.right) {
            this.pRight = false;
        } else if (this.fire) {
            this.pFire = false;
        }
    }

    public void loadImageThread() {
        this.isLoading = true;
        new Thread(this).start();
    }

    public void run() {
        this.loadImage();
        this.isLoading = false;
    }

    public abstract void loadImage();

    public abstract void drawCanvas(Graphics var1);

    public void repaintCanvas() {
        this.repaint();
    }

    public void paint(Graphics graphics) {
        int n = REAL_WIDTH - 240 >> 1;
        int n2 = REAL_HEIGHT - 260 >> 1;
        graphics.translate(n, n2);
        this.drawCanvas(graphics);
        graphics.translate(-n, -n2);
        graphics.setColor(0);
        graphics.setClip(0, 0, REAL_WIDTH, REAL_HEIGHT);
        if (n2 > 0) {
            MGCanvas.fillRect(graphics, 0, 0, REAL_WIDTH, n2);
            MGCanvas.fillRect(graphics, 0, n2 + 260, REAL_WIDTH, n2);
        }
        if (n > 0) {
            MGCanvas.fillRect(graphics, 0, n2, n, 260);
            MGCanvas.fillRect(graphics, n + 240, n2, n, 260);
        }
    }

    public static void vibrate(int n) {
        try {
            Display.getDisplay((MIDlet)midlet).vibrate(n);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void initCommandListener() {
    }

    public static void drawMGCommandOK(Graphics graphics, Image image, String string, boolean bl) {
        MGCanvas.drawMGCommand(graphics, image, string, true, bl);
    }

    public static void drawMGCommandCancel(Graphics graphics, Image image, String string, boolean bl) {
        MGCanvas.drawMGCommand(graphics, image, string, false, bl);
    }

    public static void drawMGCommand(Graphics graphics, Image image, String string, boolean bl, boolean bl2) {
        graphics.setFont(F_SMALL);
        if (bl) {
            if (image != null) {
                MGCanvas.drawImage(graphics, image, 1, 259, 36);
            } else if (bl2 && string != null) {
                MGCanvas.drawRoundString(graphics, string, 1, 259, 36, command_messageoutline_color, command_message_color);
            }
        } else if (image != null) {
            MGCanvas.drawImage(graphics, image, 239, 259, 40);
        } else if (bl2 && string != null) {
            MGCanvas.drawRoundString(graphics, string, 239, 259, 40, command_messageoutline_color, command_message_color);
        }
    }

    public void commandAction(Command command, Displayable displayable) {
    }

    public static void initBuffer(String string) {
        try {
            int n;
            int n2;
            int n3 = 0;
            InputStream inputStream = new Object().getClass().getResourceAsStream(string);
            int n4 = MGCanvas.getSpecUnitData(inputStream);
            images = new Image[n4];
            masterImgData = new int[n4][2];
            for (n2 = 0; n2 < n4; ++n2) {
                MGCanvas.masterImgData[n2][0] = MGCanvas.getSpecUnitData(inputStream);
                MGCanvas.masterImgData[n2][1] = n3 += MGCanvas.getSpecUnitData(inputStream);
            }
            buffer = new byte[n3];
            for (n2 = 0; n2 < n3 && (n = inputStream.read(buffer, n2, n3 - n2)) > 0; n2 += n) {
            }
            for (n = 0; n < n4; ++n) {
                MGCanvas.images[n] = null;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void setImageFile(String string) {
        isInitedBuffer = true;
        MGCanvas.initBuffer(string.substring(6));
    }

    public static void loadImage(int n) throws Exception, Error {
        if (!isInitedBuffer) {
            throw new Exception("Please set Image file list first.");
        }
        if (images[n] == null) {
            MGCanvas.images[n] = Image.createImage((byte[])buffer, (int)MGCanvas.getImageBufferOffset(n), (int)MGCanvas.getImageBufferLen(n));
        }
    }

    private static void buildCRCTable() {
        CRCTable = new int[256];
        for (int j = 0; j < 256; ++j) {
            int n = j;
            for (int k = 0; k < 8; ++k) {
                if ((n & 1) != 0) {
                    n = 0xEDB88320 ^ n >>> 1;
                    continue;
                }
                n >>>= 1;
            }
            MGCanvas.CRCTable[j] = n;
        }
    }

    public static int crc32(byte[] byArray, int n, int n2) {
        if (CRCTable == null) {
            MGCanvas.buildCRCTable();
        }
        int n3 = 0;
        n3 ^= 0xFFFFFFFF;
        int n4 = n2;
        int n5 = n;
        while (--n4 >= 0) {
            n3 = CRCTable[(n3 ^ byArray[n5++]) & 0xFF] ^ n3 >>> 8;
        }
        return ~n3;
    }

    public static void loadImage(int[] nArray) throws Exception, Error {
        int n;
        for (n = 0; n < images.length; ++n) {
            boolean bl = true;
            if (images[n] == null) continue;
            for (int j = 0; j < nArray.length; ++j) {
                if (n != nArray[j]) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            MGCanvas.images[n] = null;
        }
        for (n = 0; n < nArray.length; ++n) {
            if (images[nArray[n]] != null) continue;
            MGCanvas.loadImage(nArray[n]);
        }
        CRCTable = null;
    }

    public static void unloadImage(int n) {
        MGCanvas.images[n] = null;
    }

    public static void unloadImage(int[] nArray) {
        for (int j = 0; j < nArray.length; ++j) {
            MGCanvas.unloadImage(nArray[j]);
        }
    }

    public static void unloadAllImage() {
        for (int j = 0; j < images.length; ++j) {
            MGCanvas.unloadImage(j);
        }
    }

    private static int getImageBufferOffset(int n) {
        if (n > 0) {
            return masterImgData[n - 1][1];
        }
        return 0;
    }

    private static int getImageBufferLen(int n) {
        if (n > 0) {
            return masterImgData[n][1] - masterImgData[n - 1][1];
        }
        return masterImgData[n][1];
    }

    public static int getSpecUnitData(InputStream inputStream) {
        int n = 0;
        try {
            int n2 = inputStream.read();
            int n3 = inputStream.read();
            int n4 = inputStream.read();
            n = n2 | n3 << 8 | n4 << 16;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return n;
    }

    public static byte[] readFile(String string) throws IOException {
        InputStream inputStream = new Object().getClass().getResourceAsStream(string);
        BIS.reset();
        int n = 0;
        while ((n = inputStream.read()) != -1) {
            BIS.write(n);
        }
        inputStream.close();
        byte[] byArray = BIS.toByteArray();
        return byArray;
    }

    public final void keyRepeated(int n) {
    }

    public final void pointerPressed(int n, int n2) {
    }

    public final void pointerReleased(int n, int n2) {
    }

    public final void pointerDragged(int n, int n2) {
    }

    public static void setTranslate(Graphics graphics, int n, int n2) {
        int n3 = n - graphics.getTranslateX();
        int n4 = n2 - graphics.getTranslateY();
        graphics.translate(n3, n4);
    }

    public static void fillPaternRect(Graphics graphics, int n, int n2, int n3, int n4, int n5, int[][] nArray) {
        for (int j = 0; j < nArray.length; ++j) {
            MGCanvas.drawRect(graphics, n, n2, n3, n4, nArray[j][1], nArray[j][2], nArray[j][0]);
            n3 -= nArray[j][1] * 2;
            n += nArray[j][1];
            n4 -= nArray[j][2] * 2;
            n2 += nArray[j][2];
        }
        graphics.setColor(n5);
        graphics.fillRect(n, n2, n3, n4);
    }

    public static void fillRect(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        graphics.setColor(n5);
        graphics.fillRect(n, n2, n3, n4);
    }

    public static void fillRect(Graphics graphics, int n, int n2, int n3, int n4) {
        graphics.fillRect(n, n2, n3, n4);
    }

    public static void drawRect(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        graphics.setColor(n7);
        graphics.fillRect(n, n2, n5, n4);
        graphics.fillRect(n + n3 - n5, n2, n5, n4);
        graphics.fillRect(n += n5, n2, n3 -= n5 * 2, n6);
        graphics.fillRect(n, n2 + n4 - n6, n3, n6);
    }

    public static void drawRect(Graphics graphics, int n, int n2, int n3, int n4) {
        graphics.drawRect(n, n2, n3, n4);
    }

    public static void drawRect(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        graphics.setColor(n5);
        graphics.drawRect(n, n2, n3, n4);
    }

    public static void drawLine(Graphics graphics, int n, int n2, int n3, int n4) {
        graphics.drawLine(n, n2, n3, n4);
    }

    public static void drawLine(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        graphics.setColor(n5);
        graphics.drawLine(n, n2, n3, n4);
    }

    public static void fillPaternRoundRect(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, int n7, int[][] nArray) {
        for (int j = 0; j < nArray.length; ++j) {
            MGCanvas.fillRoundRect(graphics, n, n2, n3, n4, n5, n6, nArray[j][0]);
            n3 -= nArray[j][1] * 2;
            n += nArray[j][1];
            n4 -= nArray[j][2] * 2;
            n2 += nArray[j][2];
        }
        MGCanvas.fillRoundRect(graphics, n, n2, n3, n4, n5, n6, n7);
    }

    public static void fillRoundRect(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        graphics.setColor(n7);
        graphics.fillRoundRect(n, n2, n3, n4, n5, n6);
    }

    public static void fillRoundRect(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        MGCanvas.fillRoundRect(graphics, n, n2, n3, n4, n5, n6, n8);
        MGCanvas.fillRoundRect(graphics, n + 2, n2 + 2, n3 - 4, n4 - 4, n5, n6, n7);
    }

    public static void drawRoundRect(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        graphics.setColor(n9);
        graphics.drawRoundRect(n, n2, n3 - 1, n4 - 1, n5, n6);
    }

    public static void setStringYOffset(int n) {
        stringYOff = n;
    }

    public static void drawString(Graphics graphics, String string, int n, int n2, int n3, int n4) {
        graphics.setColor(n4);
        if ((n3 & 0x20) != 0) {
            graphics.drawString(string, n, n2, n3);
        } else {
            graphics.drawString(string, n, n2 + stringYOff, n3);
        }
    }

    public static void drawString(Graphics graphics, String string, int n, int n2, int n3) {
        if ((n3 & 0x20) != 0) {
            graphics.drawString(string, n, n2, n3);
        } else {
            graphics.drawString(string, n, n2 + stringYOff, n3);
        }
    }

    public static void drawRoundString(Graphics graphics, String string, int n, int n2, int n3, int n4, int n5) {
        graphics.setColor(n4);
        MGCanvas.drawString(graphics, string, n - 1, n2, n3);
        MGCanvas.drawString(graphics, string, n - 1, n2 - 1, n3);
        MGCanvas.drawString(graphics, string, n - 1, n2 + 1, n3);
        MGCanvas.drawString(graphics, string, n + 1, n2, n3);
        MGCanvas.drawString(graphics, string, n + 1, n2 + 1, n3);
        MGCanvas.drawString(graphics, string, n + 1, n2 - 1, n3);
        MGCanvas.drawString(graphics, string, n, n2 - 1, n3);
        MGCanvas.drawString(graphics, string, n, n2 + 1, n3);
        MGCanvas.drawString(graphics, string, n, n2, n3, n5);
    }

    public static void drawClipString(Graphics graphics, String string, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        graphics.setClip(n3, n4, n5, n6);
        MGCanvas.drawString(graphics, string, n, n2, n7, n8);
        MGCanvas.resetClip(graphics);
    }

    public static void drawImage(Graphics graphics, Image image, int n, int n2, int n3) {
        graphics.drawImage(image, n, n2, n3);
    }

    public static void drawClipImage(Graphics graphics, Image image, int n, int n2, int n3, int n4, int n5, int n6) {
        graphics.setClip(n, n2, n5, n6);
        graphics.drawImage(image, n - n3, n2 - n4, 20);
    }

    public static void resetClip(Graphics graphics) {
        graphics.setClip(0, 0, 240, 260);
    }

    public static void setClip(Graphics graphics, int n, int n2, int n3, int n4) {
        graphics.setClip(n, n2, n3, n4);
    }

    public boolean handleKey() {
        if (this.scheduleKey) {
            this.scheduleKey = false;
            return true;
        }
        return false;
    }

    public static int getImageWidth(Image image) {
        return image.getWidth();
    }

    public static int getImageHeight(Image image) {
        return image.getHeight();
    }

    public static int getStringWidth(String string, Font font) {
        return font.stringWidth(string);
    }

    public static int getCharWidth(char c2, Font font) {
        return font.charWidth(c2);
    }

    public static int getStringHeight(Font font) {
        return font.getHeight();
    }

    public final void hideNotify() {
        super.hideNotify();
        if (!this.isPaused) {
            this.isPaused = true;
            this.canvasPaused();
        }
    }

    public final void showNotify() {
        super.showNotify();
        if (this.isPaused) {
            this.isPaused = false;
            this.canvasResumed();
        }
    }

    public abstract void canvasPaused();

    public abstract void canvasResumed();
}

