/*
 * Decompiled with CFR 0.152.
 */
package com.mg.lib.cam;

import com.mg.lib.cam.CapturedImage;
import com.mg.lib.cam.ImageOp;
import com.mg.tools.StringFunction;
import java.io.IOException;
import javax.microedition.lcdui.Image;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import javax.microedition.media.control.VideoControl;

public class MGCamera {
    public static final boolean DEBUG = false;
    public static final String DEFAULT_ENCODE = System.getProperty("video.snapshot.encodings");
    public static final String SUPPORT_CAPTURE = System.getProperty("supports.video.capture");
    public static String[] supportEncodings = new String[0];
    public static boolean supportCapture = false;
    public static final String ENCODE_FORMAT = "png";
    public static final String ENCODE_RGB_INT = "ARGB";
    public static final String ENCODE_RGB = "RGB";
    public static final String ENCODE_RGBS = "RGB_SHORT";
    public static final String ENCODE_RGBB = "RGB_BYTE";
    public static final int CAM_FRONT = 0;
    public static final int CAM_BACK = 1;
    public static final int CAM_IMG = 2;
    public static final int CAM_ANY = 3;
    public Player videoPlayer;
    public VideoControl videoControl;
    public boolean lastInitDisplayMode = false;
    public int cameraDeviceIdx;
    public int colorBit = 1;
    public boolean initSuccess = false;
    public boolean noRightToUse = false;
    public static String[] RGB_FORMAT;
    public static int[] RGB_FORMAT_BIT;
    public static String[] cameraDeviceStr;
    public int[] dataBuffer = new int[10];
    public int[] dataResult = new int[10];

    public void initCamera(int n) {
        if (n >= 0 && n < cameraDeviceStr.length) {
            this.createPlayer(cameraDeviceStr[n]);
        }
        if (this.videoPlayer != null) {
            this.cameraDeviceIdx = n;
        } else {
            this.cameraDeviceIdx = 0;
            while (this.videoPlayer == null && this.cameraDeviceIdx < cameraDeviceStr.length) {
                this.createPlayer(cameraDeviceStr[this.cameraDeviceIdx]);
                ++this.cameraDeviceIdx;
            }
            this.cameraDeviceIdx = this.videoPlayer == null ? -1 : --this.cameraDeviceIdx;
        }
    }

    public boolean initSuccess() {
        return this.videoPlayer != null;
    }

    public boolean createPlayer(String string) {
        if (this.noRightToUse) {
            return false;
        }
        try {
            this.videoPlayer = Manager.createPlayer((String)string);
            this.videoPlayer.realize();
            this.videoControl = (VideoControl)this.videoPlayer.getControl("VideoControl");
            this.videoControl.setVisible(false);
        }
        catch (IOException iOException) {
        }
        catch (MediaException mediaException) {
        }
        catch (SecurityException securityException) {
            this.noRightToUse = true;
            this.initSuccess = false;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.videoPlayer != null;
    }

    public void setFullColorAlt(int n) {
        if (n < 1) {
            n = 1;
        }
        if (n > 3) {
            n = 3;
        }
        this.colorBit = n;
    }

    public CapturedImage capture(String string, int n, int n2, boolean bl) {
        int n3;
        if (this.noRightToUse || !this.initSuccess() || !this.isReady()) {
            return null;
        }
        if (string == null) {
            string = ENCODE_FORMAT;
        }
        String string2 = MGCamera.getEncodeString(string, n, n2);
        byte[] byArray = null;
        byArray = this.capture(string2);
        if (byArray != null) {
            return new CapturedImage(string, n, n2, byArray);
        }
        if (!bl) {
            return null;
        }
        byArray = this.capture(null);
        if (byArray == null) {
            return null;
        }
        Image image = Image.createImage((byte[])byArray, (int)0, (int)byArray.length);
        int n4 = image.getWidth();
        int n5 = n4 * (n3 = image.getHeight());
        if (n5 > this.dataBuffer.length) {
            this.dataBuffer = new int[n5];
        }
        if (n * n2 > this.dataResult.length) {
            this.dataResult = new int[n * n2];
        }
        int[] nArray = this.dataBuffer;
        image.getRGB(nArray, 0, n4, 0, 0, n4, n3);
        if (n4 != n || n3 != n2) {
            nArray = ImageOp.resizeARGBImage(nArray, n4, n3, n, n2, true, this.dataResult);
        }
        return new CapturedImage(ENCODE_RGB_INT, n, n2, nArray);
    }

    public static String bitFormat(int n) {
        for (int j = 0; j < RGB_FORMAT_BIT.length; ++j) {
            if (RGB_FORMAT_BIT[j] != n) continue;
            return RGB_FORMAT[j];
        }
        return "UNKNOWN";
    }

    public int aspectRatio() {
        return this.videoControl.getSourceWidth() * 1000 / this.videoControl.getDisplayHeight();
    }

    public String getAltFormat() {
        return RGB_FORMAT[this.colorBit];
    }

    public byte[] capture(String string) {
        try {
            byte[] byArray = this.videoControl.getSnapshot(string);
            return byArray;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String getEncodeString(String string, int n, int n2) {
        if (string == null) {
            string = ENCODE_FORMAT;
        }
        return "encoding=" + string + "&width=" + n + "&height=" + n2;
    }

    public Object prepareCamera(int n, int n2, int n3, int n4, Object object) {
        Object object2 = null;
        if (this.videoPlayer == null) {
            return null;
        }
        try {
            if (!this.lastInitDisplayMode) {
                object2 = object != null ? this.videoControl.initDisplayMode(1, object) : this.videoControl.initDisplayMode(0, null);
            }
            this.videoControl.setDisplayLocation(n, n2);
            this.videoControl.setDisplaySize(n3, n4);
            this.videoPlayer.start();
            this.videoControl.setVisible(false);
            this.initSuccess = true;
            this.lastInitDisplayMode = true;
        }
        catch (Exception exception) {
            this.initSuccess = false;
            this.lastInitDisplayMode = false;
        }
        return object2;
    }

    public boolean isReady() {
        return this.initSuccess;
    }

    public void stopCamera() {
        try {
            if (this.videoPlayer != null) {
                this.videoPlayer.stop();
                this.videoPlayer.deallocate();
                this.videoPlayer.close();
            }
        }
        catch (MediaException mediaException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.videoPlayer = null;
        this.videoControl = null;
        this.lastInitDisplayMode = false;
    }

    public void initAndPrepare(int n, int n2, int n3, int n4, int n5, Object object) {
        if (!this.initSuccess() || this.videoControl == null || this.videoPlayer == null) {
            this.initCamera(n);
            if (this.initSuccess()) {
                this.prepareCamera(n2, n3, n4, n5, object);
            }
        }
    }

    static {
        if (DEFAULT_ENCODE != null) {
            supportEncodings = StringFunction.split(DEFAULT_ENCODE, " ");
        }
        if (SUPPORT_CAPTURE != null) {
            supportCapture = SUPPORT_CAPTURE.toLowerCase().equals("true");
        }
        RGB_FORMAT = new String[]{ENCODE_RGBB, ENCODE_RGBS, ENCODE_RGB};
        RGB_FORMAT_BIT = new int[]{1, 2, 3};
        cameraDeviceStr = new String[]{"capture://devcam1", "capture://devcam0", "capture://image", "capture://video"};
    }
}

