/**
 * Created by IntelliJ IDEA.
 * User: bhawkins
 * Date: Jul 14, 2003
 * Time: 11:40:33 PM
 * To change this template use Options | File Templates.
 */

package com.bejeweled2_j2me;

import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.Graphics;

class AnimatedImage extends GameObject
{

    // Image strip(s)
    private Image image;

    // Origin
    private int imageX, imageY;

    // Difference between frames
    private int deltaX, deltaY;

    // Time difference
    private long startTime, deltaTime;

    // Frame information
    private byte numFrames, frame;

    // Loop or stop when done
    private boolean isLooped;

    /**
     * Initialize.
     *
     * @param image strip(s)
     * @param x origin to render frame
     * @param y origin to render frame
     * @param imageWd individual frame
     * @param imageHt individual frame
     * @param numFrames in animation
     * @param imageX starting coordinate
     * @param imageY starting coordinate
     * @param deltaX to next frame
     * @param deltaY to next frame
     * @param deltaTime between frames
     * @param isLooped true to loop, false to stop animating after last frame
     */
    AnimatedImage(Image image,
                  int x, int y,
                  int imageWd, int imageHt,
                  byte numFrames,
                  int imageX, int imageY,
                  int deltaX, int deltaY, long deltaTime,
                  boolean isLooped) {
        this.image = image;
        this.imageX = imageX;
        this.imageY = imageY;
        this.deltaX = deltaX;
        this.deltaY = deltaY;
        this.numFrames = numFrames;
        this.deltaTime = deltaTime;
        this.isLooped = isLooped;

        setBounds(x, y, imageWd, imageHt);
    }

    /**
     * Check if a non-looped animation is done animating.
     *
     * @return true if animation is over (always false for looping animation)
     */
    boolean isDone() {
        return(frame >= numFrames);
    }

    /**
     * Handles one iteration of the game loop. Used for animation and timed
     * events. Default does nothing.
     *
     * @param   now     current time as milliseconds since unix epoch.
     */
    public void heartbeat(long now) {
        super.heartbeat(now);
        if(isLooped) {
            frame = (byte)(((now - startTime) / deltaTime) % numFrames);
        } else {
            frame = (byte)Math.min((int)((now - startTime) / deltaTime), numFrames);
        }
    }

    /**
     * Resets the object to its initial state. Default does nothing.
     */
    public void reset() {
        super.reset();
        frame = 0;
        startTime = System.currentTimeMillis();
    }

    /**
     * Instructs the object to draw itself onto the drawing surface. This
     * surface may be either an offscreen buffer or direct to the screen.
     * The provided <tt>Graphics</tt> reference will automatically be linked
     * to the appropriate surface. <i>Required for all game objects</i>.
     *
     * @param   gc      graphics context used for drawing.
     */
    public void draw(Graphics gc) {
        int drawFrame = Math.min(frame, numFrames - 1);
        gameEngine.drawClippedImage(gc, image, x, y, wd, ht,
            imageX + (drawFrame * deltaX), imageY + (drawFrame * deltaY));
    }


}
