/*
 *     Copyright (c)2001-2003 DemiVision, LLC. All Rights Reserved.
 *
 * The information contained herein is the CONFIDENTIAL and PROPRIETARY
 *                  information of DemiVision, LLC.
 */

package com.bejeweled2_j2me;

import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;

/**
 * <tt>BaseScreen</tt> is the parent class for all <i>Dioskilos</i> application
 * screens. It defines all lifecycle and event handling methods for the screen.
 * BaseScreens automatically have access to a convenience reference for both
 * <tt>Dialog</tt> and the <tt>GameEngine</tt>. All BaseScreen instances are
 * managed by the GameEngine. Developers can extend their own custom versions
 * of BaseScreen for application specific functionality. However, custom screens
 * will not be managed by the GameEngine. Custom screens must be children of an
 * existing <i>Dioskilos</i> screen (most commonly the <tt>GameScreen</tt>) and
 * must be managed by the developer. BaseScreen is an abstract class, {@link
 * getDisplayable()} must be defined by the developer.
 *
 * @see         Dialog
 * @see         GameEngine
 * @see         GameScreen
 *
 * @author      Barry Sohl
 * @version     0.9.5
 */
abstract class BaseScreen extends GameObject implements /*CommandListener,*/ DialogListener
{
    /* Constants */

    // Screen login modes

    /** Login mode for screens where login is not applicable. */
    public static final byte LOGIN_NA = -1;

    // Colors

    /** Color of screen backgrounds as defined in external properties. */
    public static int COLOR_BGND = -1;

    /** Color of screen and dialog text as defined in external properties. */
    public static int COLOR_TEXT;

    /** Color of screen title bar text as defined in external properties. */
    public static int COLOR_TITLE_TEXT;

    /** Color of screen title and progress bars as defined in external properties. */
    public static int COLOR_TITLE_BAR;

    /** Color of widget lines as defined in external properties. */
    public static int COLOR_LINE;

    /* Data Fields */

    /** Convenience reference to global <tt>Dialog</tt> instance. */
    protected static Dialog dlg;


    /**
     * Default constructor saves convenience references. Reads external properties.
     */
    BaseScreen()
    {
        dlg = Dialog.getInstance();

        // Populate simulated constants from properties (only once)
        if ( COLOR_BGND < 0 )
        {
            COLOR_BGND       = 16777215;
            COLOR_TEXT       = 0;
            COLOR_TITLE_TEXT = 0;
            COLOR_TITLE_BAR  = 11184810;
            COLOR_LINE       = 0;
        }
    }

    /**
     * Returns a reference to the <tt>Displayable</tt> object that should be
     * given focus for the current screen.
     *
     * @return  reference to current <tt>Displayable</tt> object.
     */
    public abstract Displayable getDisplayable();

    /**
     * Returns the height of the display area available for drawing. The returned
     * value takes into account devices that have a lower command bar that cannot
     * be removed. In this case, the value will be less than the full height of
     * the <tt>Canvas</tt>.
     *
     * @return  height in pixels of screen area available for drawing.
     */
    protected int getDisplayHeight()
    {
        return ht;
    }

    /**
     * Sets the screen mode for screens in which screen specific mode information
     * is relevant. Not all screens use this additional mode information.
     *
     * @param   mode    type code for screen specific mode information.
     */
    public void setScreenMode( byte mode )
    {
    }

    /**
     * Called back by <tt>Dialog</tt> when a dialog has been dismissed. Allows
     * any <tt>BaseScreen</tt> to handle dialog events.
     *
     * @param   result  resulting command type code.
     */
    public void dialogDismissed( byte result )
    {}

    /**
     * Called back by <tt>DialogCanvas</tt> when a dialog event occurs. Allows
     * any <tt>BaseScreen</tt> to handle dialog canvas events.
     *
     * @param type of event, see <tt>DialogCanvas</tt>
     * @param index of dialog item that generated event
     */
    public void dialogEvent(byte type, int index)
    {}

    /* GameObject */

    /**
     * Instructs object to draw itself into the drawing surface. This
     * surface may be either an offscreen buffer or direct to the screen.
     * Not all screens are required to manually draw.
     *
     * @param   gc  graphics context used for drawing.
     */
    public void draw( Graphics gc )
    {}
}

/**/
