/*
 *    Copyright (c)2001-2003 Jamdat Mobile, Inc. All Rights Reserved.
 *
 * The information contained herein is the CONFIDENTIAL and PROPRIETARY
 *                 information of Jamdat Mobile, Inc.
 */

package com.bejeweled2_j2me;

import javax.microedition.rms.RecordStoreException;
import java.io.IOException;

/**
 * BejeweledMIDlet is the main application shell, which uses the
 * com.dioskilos_j2me package to run the Bejeweled game within a
 * J2ME MIDlet. No custom functionality is required. Only
 * registerScreens() is overidden in order to hook in the custom
 * Bejeweled GameScreen.
 *
 * @author      DemiVision: Barry Sohl
 * @version     0.8.0
 */
public final class BejeweledMIDlet extends DioskilosMIDlet
{
    /**
     * Registers the default versions of all system screens except for
     * the GameScreen. In this case, the custom Bejeweled version of the
     * GameScreen (GameBoard) is registered.
     *
     * @throws  IOException if error occurs registering screen.
     */
    protected void registerScreens() throws IOException
    {
        gameEngine.registerScreen( GameEngine.SCREEN_MAIN, new MainScreen() );
        gameEngine.registerScreen( GameEngine.SCREEN_SETTINGS, new SettingsScreen() );
        gameEngine.registerScreen( GameEngine.SCREEN_GAME, new GameBoard() );
        gameEngine.registerScreen( GameEngine.SCREEN_GAME_MODE, new GameModeScreen() );
    }

    /**
     * Update high score.
     */
    protected void postload() {
        MainScreen mainScreen = (MainScreen)
            gameEngine.getScreenInstance(GameEngine.SCREEN_MAIN);
        SettingsScreen settingsScreen = (SettingsScreen)
            gameEngine.getScreenInstance(GameEngine.SCREEN_SETTINGS);
        mainScreen.setHighScore(settingsScreen.getHighScore());
    }

}
