/**
 * Created by IntelliJ IDEA.
 * User: bhawkins
 * Date: Jul 17, 2003
 * Time: 1:30:05 PM
 * To change this template use Options | File Templates.
 */

package com.bejeweled2_j2me;

import javax.microedition.lcdui.*;
import java.io.IOException;

class DialogCanvas extends Canvas
{

    // Dialog types.
    public static final int TEXT       = 0;
    //public static final int PROGRESS   = 1;
    public static final int LIST       = 2;
    public static final int CHECKLIST  = 3;

    // Even types.
    public static final int NONINDEXED      = -1;
    public static final byte OFF            = 0;
    public static final byte ON             = 1;
    public static final byte HIGHLIGHTED    = 2;
    public static final byte SELECTED       = 3;

    // Maximum value for progress bar.
    public static final byte PROGRESS_MAX = 10;

    // Time between frame advances for animated gem image.
    private static final int GEM_FRAME_TIME = 60;

    // Height of progress bar.
    private static final int PROGRESS_METER_HEIGHT = 7;

    // Convenient reference to game engine singleton instance.
    private static GameEngine gameEngine;

    // Standard dialog images.
    private static Image menuImage;
    private static Image logoImage;
    private static Image backgroundImage;
    private static Image bulletImage;
    private static Image checkImage;
    private static Image vodaImage;
    
    // Type of this dialog instance.
    private int type;

    // Current command listener for this dialog, used to send command actions.
    private CommandListener cmdListener;

    // Current dialog listener for this dialog, handles extra event responses.
    private BaseScreen dialogListener;

    // Currently selected item index if this is a list or checklist.
    private int selectedIndex;

    // Common dialog elements.
    private TextElement title;
    private ImageElement titleImage;

    // Text dialog elements.
    private TextElement text;

    // List and checklist elements.
    private ImageElement listImages[];
    private TextElement listText[];

    public static Image softKeysImage = null;
    public static Image startSoftkey = null;
    public static Image getSoftkey = null;
    public static Image exitSoftkey = null;
    
    Dialog mDialog;
    BaseScreen mSettingsScreen;

    /**
     * Initialize common data used by all dialog instances.
     *
     * @throws IOException if image reading fails
     */
    static void init() throws IOException {
        gameEngine = GameEngine.getInstance();
        menuImage = gameEngine.loadImage(StringTable.FILE_MENU_BACKGROUND, true);
        if (gameEngine.isDemo()) {
            logoImage = gameEngine.loadImage("logo-demo.png", true);
        }
        else {
            logoImage = gameEngine.loadImage("logo.png", true);
        }
        backgroundImage = gameEngine.loadImage(StringTable.FILE_DIALOG_BACKGROUND, false);
        bulletImage = gameEngine.loadImage(StringTable.FILE_LIST_BULLET, false);
        checkImage = gameEngine.loadImage(StringTable.FILE_CHECK_BULLET, false);
        Gem.loadGemStrip();
        softKeysImage = gameEngine.loadImage(StringTable.FILE_SOFT_KEYS, true);
        
        exitSoftkey = gameEngine.loadImage("exit.png", true);
        startSoftkey = gameEngine.loadImage("start.png", true);
        getSoftkey = gameEngine.loadImage("get.png", true);
            
        if (Build.VODAFONE) {
            try {
                vodaImage = Image.createImage(Build.VODAFONE_BACKGROUND);
            }
            catch (Exception ex) { }
        }
    }

    /**
     * Reference to background image used for all dialogs.
     *
     * @return valid full canvas image
     */
    static Image getBackgroundImage() {
        return(backgroundImage);
    }

    /**
     * Get rectangle describing primary text area of dialog background image.
     *
     * @return int[4] { x, y, width, height }
     */
    static int[] getTextRect() {
        return(DeviceSpecific.DLG_TEXT_RECT);
    }

    DialogCanvas(Dialog mDialog, int type, String title)
    {
        this(type, title);
        this.mDialog = mDialog;
        if (mDialog != null && mDialog.curType >= mDialog.DLG_VODA_START_EXIT) 
        {
            if (text != null)
            {
                text.setOffsetY(DeviceSpecific.VODAFONE_Y_OFFSET);
            }
            if (this.title != null)
            {
                this.title.x = DeviceSpecific.DLG_TEXT_RECT[0];
                this.title.setOffsetY(DeviceSpecific.VODAFONE_Y_OFFSET);
            }
        }
    }

    DialogCanvas(BaseScreen mSettingsScreen, int type, String title)
    {
        this(type, title);
        this.mSettingsScreen = mSettingsScreen;
    }
    /**
     * Create a new dialog instance.
     *
     * @param type of dialog (TEXT, PROGRESS, LIST, CHECKLIST)
     * @param title string, may be null
     */
    DialogCanvas(int type, String title) {
        setFullScreenMode(true);
        this.type = type;

        int gemSize = Gem.size();
        int titleX = DeviceSpecific.DLG_TEXT_RECT[0] + gemSize + 4;
        int titleY =
            ((DeviceSpecific.DLG_TEXT_RECT[1] - GameEngine.FONT_TITLE.getHeight()) / 2) - 2;
        this.title = new TextElement(
            this, GameEngine.FONT_TITLE,
            (title != null) ? title.toUpperCase() : null, false, titleX, titleY, getWidth() - titleX,
            GameEngine.FONT_TITLE.getHeight());
        titleImage = new ImageElement(this,
            DeviceSpecific.DLG_TEXT_RECT[0] + 2, ((DeviceSpecific.DLG_TEXT_RECT[1] - gemSize) / 2), gemSize, gemSize);
        titleImage.setImageAsGem(getBackgroundImage(), 2 * type);

        switch(type) {
            case TEXT:
                text = new TextElement(this, GameEngine.FONT_PLAIN, null, true,
                    DeviceSpecific.DLG_TEXT_RECT[0], DeviceSpecific.DLG_TEXT_RECT[1],
                    DeviceSpecific.DLG_TEXT_RECT[2], DeviceSpecific.DLG_TEXT_RECT[3]-2);
                //text.setOffsetY(-GameEngine.FONT_PLAIN.getHeight()+15);
                break;
            case LIST:
            case CHECKLIST:
                break;
        }
    }

    /**
     * Get the current selected index if this is a list or checklist.
     *
     * @return [0,number of list items) or 0 if not list or checklist
     */
    int getSelectedIndex() {
        return (selectedIndex);
    }

    /**
     * Get the state of a checklist item.
     * WARNING: For performance reasons, this assumes type is checklist and
     * index is valid.
     *
     * @param index of item in checklist
     * @return true if checked, false if unchecked
     */
    boolean getCheckState(int index) {
        return(listImages[index].getFrame() == 1);
    }

    /**
     * Change the state of a checklist item.
     * WARNING: For performance reasons, this assumes type is checklist and
     * index is valid.
     *
     * @param index of item in checklist
     * @param state true to check, false to uncheck
     */
    void setCheckState(int index, boolean state) {
        listImages[index].setFrame(state ? 1 : 0);
    }

    /**
     * Change the title of this dialog.
     *
     * @param title string, may be null
     */
    void setDialogTitle(String title) {
        this.title.setText((title != null) ? title.toUpperCase() : null);
    }

    /**
     * Change the text of this dialog. Applies only to TEXT and PROGRESS.
     *
     * @param text string, will be automatically word wrapped
     */
    void setText(String text) {
        switch(type) {
            case TEXT:
                this.text.setText(text);
                break;
        }
    }
    
    
    void setList(String listItems[], boolean listValues[]) {
        setList(listItems, listValues, 0);
    }


    /**
     * Change the items in a LIST or CHECKLIST.
     *
     * @param listItems array of strings with item names, may be null
     * @param listValues array of values (true for checked, false for
     *          unchecked) that must match the length of listItems,
     *          unless type is LIST in which case this is ignored and
     *          should therefore be null
     */
    void setList(String listItems[], boolean listValues[], int yOffset) {
        switch(type) {
            case LIST:
            case CHECKLIST:
                break;
            default:
                return;
        }
        if((listItems == null) || (listItems.length == 0)) {
            listImages = null;
            listText = null;
            return;
        }

        boolean isChecklist = (type == CHECKLIST);
        Image listImage = bulletImage;
        if(isChecklist) {
            listImage = checkImage;
        }

        listImages = new ImageElement[listItems.length];
        listText = new TextElement[listItems.length];

        int imgWd = listImage.getWidth();
        int imgHt = listImage.getHeight();
        if(isChecklist) {
            imgWd /= 2;
        }

        int textHt = DeviceSpecific.LIST_HEIGHT;
        int itemHt = DeviceSpecific.LIST_SPACING;
        int imgOffset = (itemHt - imgHt) / 2;
        int textOffset = (itemHt - textHt) / 2;

        for(int index = 0; index < listItems.length; ++index) {
            listImages[index] = new ImageElement(
                this, DeviceSpecific.DLG_TEXT_RECT[0], 
                DeviceSpecific.DLG_TEXT_RECT[1] + yOffset + (itemHt * index) +
                imgOffset, imgWd, imgHt);
            listImages[index].setImage(listImage, isChecklist ? 2 : 0, 0, 0,
                isChecklist ? (listImage.getWidth() / 2) : 0, 0);
            if(isChecklist && listValues[index]) {
                listImages[index].setFrame(1);
            }
            
            String item = listItems[index].trim();

            listText[index] = new TextElement(this,
                GameEngine.FONT_PLAIN, item, false, DeviceSpecific.DLG_TEXT_RECT[0] + imgWd + 1,
                DeviceSpecific.DLG_TEXT_RECT[1] + yOffset + (itemHt * index) + textOffset,
                DeviceSpecific.DLG_TEXT_RECT[2] - imgWd - 1, textHt);
        }
        listImages[0].select();
        listText[0].select();
        selectedIndex = 0;
    }

    /**
     * Draw using current state.
     *
     * @param gc graphics context to render to
     */
    protected void paint(Graphics gc) {
        gc.setClip(0 ,0, DeviceSpecific.WIDTH, DeviceSpecific.HEIGHT);
        gc.fillRect(0, 0, DeviceSpecific.WIDTH, DeviceSpecific.HEIGHT);

        int sw = DeviceSpecific.SOFTKEY_WIDTH;
        int sh = DeviceSpecific.SOFTKEY_HEIGHT;
        int x = gc.getClipX();
        int y = gc.getClipY();
        int wd = gc.getClipWidth();
        int ht = gc.getClipHeight();

        if (mDialog != null && mDialog.curType == mDialog.DLG_MAIN_MENU)
        {
            String score = Integer.toString(
                ((MainScreen)gameEngine.getScreenInstance(
                    GameEngine.SCREEN_MAIN)).getHighScore());
            gc.drawImage(menuImage, 0, 0, GameEngine.TOP_LEFT);
            gc.drawImage(logoImage, 0, 0, GameEngine.TOP_LEFT);
            gc.setColor(0xffffff);
            gc.setFont(gameEngine.FONT_PLAIN);
            gc.drawString(StringTable.HIGH_SCORE, 
                DeviceSpecific.HIGHSCORE_X, DeviceSpecific.HIGHSCORE_Y,
                GameEngine.TOP_LEFT);
            gc.drawString(score, 
                DeviceSpecific.WIDTH - DeviceSpecific.HIGHSCORE_X, DeviceSpecific.HIGHSCORE_Y,
                GameEngine.TOP_RIGHT);
        }
        else if (Build.VODAFONE && mDialog != null && mDialog.curType >= mDialog.DLG_VODA_START_EXIT) {
            gc.drawImage(vodaImage, 0, 0, GameEngine.TOP_LEFT);
            title.paint(gc, x, y, wd, ht);
        }
        else {
            gc.drawImage(backgroundImage, 0, 0, GameEngine.TOP_LEFT);
            title.paint(gc, x, y, wd, ht);
            titleImage.paint(gc, x, y, wd, ht);
        }

        switch(type) {
            case TEXT:
                text.paint(gc, x, y, wd, ht);
                break;
            case LIST:
            case CHECKLIST:
                if(listImages != null) {
                    for(int index = 0; index < listImages.length; ++index) {
                        listImages[index].paint(gc, x, y, wd, ht);
                    }
                }
                if(listText != null) {
                    for(int index = 0; index < listText.length; ++index) {
                        listText[index].paint(gc, x, y, wd, ht);
                    }
                }
                break;
        }
        if(type == DialogCanvas.LIST)
        {
            if(softKeysImage != null)
            {
                if(mDialog != null && mDialog.curType == mDialog.DLG_MAIN_MENU)
                {
                    gc.setClip(0, gameEngine.ht - sh, sw, sh);
                    gc.drawImage(softKeysImage, -4*sw, gameEngine.ht-sh, GameEngine.TOP_LEFT);
                    gc.setClip(0, gameEngine.ht - sh, gameEngine.wd, sh);
                    gc.drawImage(exitSoftkey, gameEngine.wd, gameEngine.ht, GameEngine.BOTTOM_RIGHT);
                }
                else 
                {
                    gc.setClip(0, gameEngine.ht - sh, sw, sh);
                    gc.drawImage(softKeysImage, 0, gameEngine.ht-sh, GameEngine.TOP_LEFT);
                    gc.setClip(gameEngine.wd-sw, gameEngine.ht - sh, sw, sh);
                    gc.drawImage(softKeysImage, gameEngine.wd - 6 * sw, gameEngine.ht-sh, GameEngine.TOP_LEFT);
                }
            }
        }else if(type == DialogCanvas.TEXT)
        {
            if(softKeysImage != null)
            {
                if(mDialog != null)
                {
                    if(mDialog.curType == mDialog.DLG_YESNO)
                    {
                        gc.setClip(0, gameEngine.ht - sh, sw, sh);
                        gc.drawImage(softKeysImage, -6*sw, gameEngine.ht-sh, GameEngine.TOP_LEFT);
                        gc.setClip(gameEngine.wd-sw, gameEngine.ht - sh, sw, sh);
                        gc.drawImage(softKeysImage, gameEngine.wd - 8 * sw, gameEngine.ht-sh, GameEngine.TOP_LEFT);
                    } else if(mDialog.curType == mDialog.DLG_OKCANCEL)
                    {
                        gc.setClip(0, gameEngine.ht - sh, sw, sh);
                        gc.drawImage(softKeysImage, -4*sw, gameEngine.ht-sh, GameEngine.TOP_LEFT);
                        gc.setClip(gameEngine.wd-sw, gameEngine.ht - sh, sw, sh);
                        gc.drawImage(softKeysImage, gameEngine.wd - 4 * sw, gameEngine.ht-sh, GameEngine.TOP_LEFT);
                    } else if(mDialog.curType == mDialog.DLG_OK)
                    {
                        gc.setClip(0, gameEngine.ht - sh, sw, sh);
                        gc.drawImage(softKeysImage, -4*sw, gameEngine.ht-sh, GameEngine.TOP_LEFT);
                        gc.setClip(gameEngine.wd-sw, gameEngine.ht - sh, sw, sh);
                        gc.setColor(0x000000);
                        gc.fillRect(gameEngine.wd-sw, gameEngine.ht - sh, sw, sh);
                    } else if(mDialog.curType == mDialog.DLG_VODA_START_EXIT)
                    {
                        gc.setColor(0x000000);
                        gc.fillRect(0, gameEngine.ht - sh, gameEngine.wd, sh);
                        gc.setClip(0, gameEngine.ht - sh, gameEngine.wd, sh);
                        gc.drawImage(startSoftkey, 0, gameEngine.ht, GameEngine.BOTTOM_LEFT);
                        gc.drawImage(exitSoftkey, gameEngine.wd, gameEngine.ht, GameEngine.BOTTOM_RIGHT);
                    } else if(mDialog.curType == mDialog.DLG_VODA_GET_EXIT)
                    {
                        gc.setColor(0x000000);
                        gc.fillRect(0, gameEngine.ht - sh, gameEngine.wd, sh);
                        gc.setClip(0, gameEngine.ht - sh, gameEngine.wd, sh);
                        gc.drawImage(getSoftkey, 0, gameEngine.ht, GameEngine.BOTTOM_LEFT);
                        gc.drawImage(exitSoftkey, gameEngine.wd, gameEngine.ht, GameEngine.BOTTOM_RIGHT);
                    } else if(mDialog.curType == mDialog.DLG_VODA_GET_BACK)
                    {
                        gc.setColor(0x000000);
                        gc.fillRect(0, gameEngine.ht - sh, gameEngine.wd, sh);
                        gc.setClip(0, gameEngine.ht - sh, gameEngine.wd, sh);
                        gc.drawImage(getSoftkey, 0, gameEngine.ht, GameEngine.BOTTOM_LEFT);
                        gc.setClip(gameEngine.wd-sw, gameEngine.ht - sh, sw, sh);
                        gc.drawImage(softKeysImage, gameEngine.wd - 6 * sw, gameEngine.ht-sh, GameEngine.TOP_LEFT);
                    }
                }
            }

        } else if(type == DialogCanvas.CHECKLIST)
        {
            if(softKeysImage != null)
            {
                gc.setClip(0, gameEngine.ht - sh, sw, sh);
                gc.drawImage(softKeysImage, -0*sw, gameEngine.ht-sh, GameEngine.TOP_LEFT);
                gc.setClip(gameEngine.wd-sw, gameEngine.ht - sh, sw, sh);
                gc.drawImage(softKeysImage, gameEngine.wd - 6 * sw, gameEngine.ht- sh, GameEngine.TOP_LEFT);
            }
        }

    }

    /**
     * Handle key presses based on type.
     *
     * @param keyCode MIDP key value
     */
    protected void keyPressed(int keyCode) {
        
        if (Build.DEBUG) 
        {
            System.out.println("DialogCanvas. keyCode = " + keyCode + " = " + getKeyName(keyCode) + " = " + 
                getGameAction(keyCode));
        }

        if(keyCode == DeviceSpecific.KEY_CODE_SOFT1)
        {
            if(type == DialogCanvas.LIST)
            {
                if(mDialog != null)
                {
                    mDialog.commandAction(mDialog.okCmd, this);
                }
                else 
                {
                    listSelect();
                    postDialogEvent(SELECTED, selectedIndex);
                }
            } 
            else if(type == DialogCanvas.TEXT)
            {
                if(mDialog != null)
                {
                    if(mDialog.curType == mDialog.DLG_OK || 
                        mDialog.curType == mDialog.DLG_OKCANCEL ||
                        mDialog.curType >= mDialog.DLG_VODA_START_EXIT)
                    {
                        mDialog.commandAction(mDialog.okCmd, this);
                    } 
                    else if(mDialog.curType == mDialog.DLG_YESNO)
                    {
                        if(mDialog.fromExit)
                        {
                            gameEngine.exit();
                        }else{
                        mDialog.commandAction(mDialog.yesCmd, this);
                        }
                    }
                }
            } 
            else if(type == DialogCanvas.CHECKLIST)
            {
                if(mSettingsScreen != null)
                {
                    if((listText != null) && (listText.length > 0)) {
                        checkToggle();
                        postDialogEvent(
                                getCheckState(selectedIndex) ? ON : OFF,
                                selectedIndex);
                    }
                }
            }
            return;
        } else if(keyCode == DeviceSpecific.KEY_CODE_SOFT2)
        {
            if(mDialog != null)
            {
                mDialog.fromExit=false;
            }
            if(type == DialogCanvas.LIST)
            {
                if(mDialog != null)
                {
                    mDialog.commandAction(mDialog.backCmd, this);
                }
                else if(cmdListener != null) 
                {
                    cmdListener.commandAction(new Command("", Command.BACK, 0), this);
                }
            } else if(type == DialogCanvas.CHECKLIST)
            {
                if(mSettingsScreen != null && mSettingsScreen instanceof CommandListener)
                {
                    ((CommandListener)mSettingsScreen).commandAction(new Command("", Command.BACK, 0), this);
                }
            } else if(type == DialogCanvas.TEXT)
            {
                if(mDialog.curType == mDialog.DLG_OKCANCEL)
                {
                    mDialog.commandAction(mDialog.cancelCmd, this);
                } else if(mDialog.curType == mDialog.DLG_YESNO)
                {
                    mDialog.commandAction(mDialog.noCmd, this);
                } else if (mDialog.curType >= mDialog.DLG_VODA_START_EXIT)
                {
                    mDialog.commandAction(mDialog.cancelCmd, this);
                }
            }

            return;
        }

        if(keyCode == DeviceSpecific.KEY_CODE_SOFT1 || keyCode == DeviceSpecific.KEY_CODE_SOFT2)
        {
            return;
        }

        keyCode = gameEngine.translateKey(keyCode);
        if(keyCode != 0) {
            switch(type) {
                case TEXT:
                    switch(getGameAction(keyCode)) {
                        case Canvas.UP:
                            text.lineUp();
                            break;
                        case Canvas.DOWN:
                            text.lineDown();
                            break;
                        case Canvas.FIRE:
                            if(mDialog != null)
                            {
                                mDialog.commandAction(mDialog.okCmd, this);
                            }
                            break;
                    }
                    break;
                case LIST:
                case CHECKLIST:
                    if((listText != null) && (listText.length > 0)) {
                        switch(getGameAction(keyCode)) {
                            
                            case Canvas.FIRE:
                                switch(type) {
                                    case LIST:
                                        if(mDialog != null)
                                        {
                                            mDialog.commandAction(mDialog.okCmd, this);
                                        }
                                        else 
                                        {
                                            listSelect();
                                            postDialogEvent(SELECTED, selectedIndex);
                                        }
                                        break;
                                    case CHECKLIST:
                                        checkToggle();
                                        postDialogEvent(
                                                getCheckState(selectedIndex) ? ON : OFF,
                                                selectedIndex);
                                        break;
                                }
                                break;
                            case Canvas.UP:
                            case Canvas.LEFT:
                                setSelected(selectedIndex - 1);
                                postDialogEvent(HIGHLIGHTED, selectedIndex);
                                break;
                            case Canvas.DOWN:
                            case Canvas.RIGHT:
                                setSelected(selectedIndex + 1);
                                postDialogEvent(HIGHLIGHTED, selectedIndex);
                                break;
                        }
                    }
                    break;
            }
        }
    }

    /**
     * Post a dialog event, but only if someone is listening.
     *
     * @param type of event to post
     * @param index of item that generated the event
     */
    void postDialogEvent(final byte type, final int index) {
        if(dialogListener != null) {
            dialogListener.dialogEvent(type, index);
        }
    }

    /**
     * Called just prior to making dialog visible.
     */
    protected void showNotify() {
        super.showNotify();
        if(titleImage != null) {
            titleImage.animate(GEM_FRAME_TIME);
        }
    }

    /**
     * Called just prior to hiding the dialog.
     */
    protected void hideNotify() {
        super.hideNotify();
        if(titleImage != null) {
            titleImage.stop();
        }
    }

    /**
     * Record command listener before passing to super class.
     *
     * @param commandListener responds to command actions
     */
    public void setCommandListener(CommandListener commandListener) {
        super.setCommandListener(commandListener);
        cmdListener = commandListener;
    }

    /**
     * Set the current dialog listener.
     *
     * @param dialogListener instance that responds to dialog events, may
     *          be null if no listener is desired
     */
    public void setDialogListener(BaseScreen dialogListener) {
        this.dialogListener = dialogListener;
    }

    /**
     * Send List.SELECT_COMMAND to command listener.
     */
    private void listSelect() {
        if(cmdListener != null) {
            cmdListener.commandAction(List.SELECT_COMMAND, this);
        }
    }

    /**
     * Toggle the check state of the currently selected item.
     * Only valid if type is CHECKLIST.
     */
    private void checkToggle() {
        listImages[selectedIndex].setFrame(
            listImages[selectedIndex].getFrame() + 1);
    }

    /**
     * Change index of currently selected item. Previously selected item
     * will be deselected. NOTE: Check state is NOT affected by this call.
     *
     * @param index of new item, will be wrapped to [0,list length)
     */
    public void setSelected(int index) {
        if(index < 0) {
            index = listText.length - 1;
        } else {
            index %= listText.length;
        }
        if(selectedIndex != index) {
            listImages[selectedIndex].deselect();
            listText[selectedIndex].deselect();
            selectedIndex = index;
            listImages[selectedIndex].select();
            listText[selectedIndex].select();
        }
    }

}
