/**
 * Created by IntelliJ IDEA.
 * User: bhawkins
 * Date: Jul 17, 2003
 * Time: 7:41:01 PM
 * To change this template use Options | File Templates.
 */

package com.bejeweled2_j2me;

import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Image;

class ImageElement extends GuiElement implements Runnable
{

    // Image to render, may be separated into frames for animation.
    private Image image;

    // Number of frame if this is an animated image, zero for static image.
    private int numberOfFrames;

    // Current frame to render.
    private int frame;

    // Amount of time between frame advances if automated animation is used.
    private int frameTime;

    // Origin of first animation frame in image.
    private int srcX, srcY;

    // Change in frame origin per frame in image.
    private int deltaX, deltaY;

    // Reference to thread used for animating an image.
    private Thread animationThread;

    // Current selection status for this image.
    private boolean isSelected;

    // HACK: This is a special type of image element for gem rendering.
    private Image gemBackground;

    // HACK: Gem index.
    private int gemIndex;

    /**
     * Create a new image element. Nothing is rendered until a valid image
     * is set in setImage.
     *
     * @param canvas this element interacts with and renders to
     * @param x origin
     * @param y origin
     * @param wd width
     * @param ht height
     */
    ImageElement(Canvas canvas, int x, int y, int wd, int ht) {
        super(canvas, x, y, wd, ht);
    }

    /**
     * Switch to a new image. Animations are set to frame zero to start.
     *
     * @param image to render, may be a collection of animation frames
     * @param numberOfFrames if animated, zero for static
     * @param srcX origin of first animation frame in image
     * @param srcY origin of first animation frame in image
     * @param deltaX change in frame origin per frame in image
     * @param deltaY change in frame origin per frame in image
     */
    void setImage(Image image, int numberOfFrames,
                  int srcX, int srcY, int deltaX, int deltaY) {
        this.image = image;
        this.numberOfFrames = numberOfFrames;
        frame = 0;
        frameTime = 0;
        this.srcX = srcX;
        this.srcY = srcY;
        this.deltaX = deltaX;
        this.deltaY = deltaY;
        repaint();
    }

    /**
     * Set the current image to a gem.
     *
     * @param index of the gem to display
     */
    void setImageAsGem(Image background, int index)
    {
        gemBackground = background;
        gemIndex = index;
        this.numberOfFrames = 8;
        frame = 0;
        frameTime = 0;
    }

    /**
     * Get the current frame number.
     *
     * @return [0,numberOfFrames)
     */
    int getFrame() {
        return(frame);
    }

    /**
     * Change current frame.
     *
     * @param frame [0,numberOfFrames)
     */
    void setFrame(int frame) {
        if((frame % numberOfFrames) != this.frame) {
            this.frame = frame % numberOfFrames;
            repaint();
        }
    }

    /**
     * Mark this text as selected.
     */
    void select() {
        isSelected = true;
        repaint();
    }

    /**
     * Mark this text as unselected.
     */
    void deselect() {
        isSelected = false;
        repaint();
    }

    /**
     * Start automated looping animation.
     *
     * @param frameTime time between frame advances
     */
    void animate(int frameTime) {
        stop();
        this.frameTime = frameTime;
        animationThread = new Thread(this);
        animationThread.start();
    }

    /**
     * End current automated animation if there is one, no effect if none.
     */
    void stop() {
        frameTime = 0;
        if(animationThread != null) {
            try {
                animationThread.join();
            } catch(InterruptedException e) {
                Thread.yield();
            }
            animationThread = null;
        }
    }

    /**
     * Render image at current frame and, if selected, selection background.
     *
     * @param gc graphics context to render to
     */
    void draw(Graphics gc) {
        if(isSelected) {
            gc.setColor(TextElement.SELECTED_BACKGROUND_COLOR);
            gc.fillRect(x, y, wd, ht);
        }
        if(gemBackground != null) {
            Gem.draw(null, gc, gemBackground, x, y, gemIndex, frame);
        } else {
            gc.clipRect(x, y, wd, ht);
            gc.drawImage(image,
                x - (srcX + (frame * deltaX)),
                y - (srcY + (frame * deltaY)),
                GameEngine.TOP_LEFT);
        }
    }

    /**
     * Animation loop run in separate thread for updating animations.
     */
    public void run() {
        while(frameTime > 0) {
            setFrame(frame + 1);
            try {
                Thread.sleep(frameTime);
            } catch(InterruptedException e) {
                Thread.yield();
            }
        }
    }

}
