/**
 * Created by IntelliJ IDEA.
 * User: bhawkins
 * Date: Aug 21, 2003
 * Time: 10:47:02 AM
 */

package com.bejeweled2_j2me;

import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.Graphics;
import java.io.*;
import java.util.Hashtable;
import java.util.Vector;
import java.util.Enumeration;

class CustomFont
{

    // Wrapper.
    public static void drawString(Font font, Graphics gc, String str,
                                  int x, int y, int anchor) {
        gc.setFont(font);
        gc.drawString(str, x, y, anchor);
    }

    // Wrapper.
    public static void drawSubstring(Font font, Graphics gc, String str,
                                     int offset, int len, int x, int y,
                                     int anchor) {
        gc.setFont(font);
        gc.drawSubstring(str, offset, len, x, y, anchor);
    }

}

public class StringTable
{

    // Non-localized strings.
    public static final char   VERSION_PLACEHOLDER          = '';
    public static final char   LIBRARY_PLACEHOLDER          = '';
    public static final String EMPTY                        = "";
    public static final String SPACE                        = " ";
    public static final String NEW_LINE                     = "\n";
    public static final String I730_WORKAROUND              = " \n";
    public static final String TRUE                         = "true";
    public static final String YES                          = "yes";
    public static final String ERR_APP_PREFIX               = "'";
    public static final String ERR_APP_SUFFIX               = "'... ";
    public static final String EMPTY_SCORE                  = "0000000";
    public static final String BUILD_PAD                    = "0000";
    public static final String VERSION_DELIM                = ".";
    public final static String MIDI_MIME_TYPE               = "audio/midi";
    public final static String MIDI_URI_PREFIX              = "file:/";
    public final static String MIDI_SPRINT_PREFIX           = "resource:";
    public static final String MIDI_SAMSUNG_PREFIX          = "/";
    public final static String MIDI_FILE_ROOT               = Build.FILE_ROOT;
    public final static String MIDI_FILE_PREFIX             = "snd";
    public final static String MIDI_FILE_SUFFIX             = ".mid";
    public static final String RECORD_STORE                 = "bejeweled2_rms";
    public static final String FILE_ROOT                    = Build.FILE_ROOT;
    public static final String FILE_CREDITS                 = "credits.txt";
    public static final String FILE_HELP                    = "help.txt";
    public static final String FILE_DIALOG_BACKGROUND       = "dlg.png";
    public static final String FILE_MENU_BACKGROUND         = "menu.png";
    public static final String FILE_DIALOG_BUTTONS          = "btn.png";
    public static final String FILE_DEMO_BACKGROUND         = "demo.png";
    public static final String FILE_DEMO_BUTTONS            = "dbtn.png";
    public static final String FILE_GEM_STRIP               = "gem.png";
    public static final String FILE_DIALOG_LOGO             = "dlglogo.png";
    public static final String FILE_LIST_BULLET             = "bullet.png";
    public static final String FILE_CHECK_BULLET            = "check.png";
    public static final String FILE_FONT                    = "font.png";
    public static final String FILE_SCORE_FONT              = "sfnt.png";
    public static final String FILE_SIDEBAR_LEFT            = "sbl.png";
    public static final String FILE_SIDEBAR_RIGHT           = "sbr.png";
    public static final String FILE_PAUSE_SOFTKEY            = "pause.png";
    public static final String FILE_EXIT_SOFTKEY            = "exit.png";
    public static final String FILE_BONUS_ANIMATIONS        = "bonus.png";
    public final static String FILE_TITLE                   = "title.png";
    public static final String FILE_SKULL                   = "skull.png";

    //all softkeys
    public static final String FILE_SOFT_KEYS               = "softkeys.png";

    public static final String PROP_VERSION                 = "MIDlet-Version";
    public static final String PROP_HELP_LIST               = "Menu-Help";
    public static final String PROP_APP_NAME                = "App-Name";
    public static final String PROP_DEMO_MESSAGE            = "Demo-Message";
    public static final String PROP_BUY_URI                 = "Demo-Buy-URI";
    public static final String PROP_BAR_TIME                = "Bar-Time";
    public static final String PROP_BAR_BOUNDS              = "Bar-Bounds";
    public static final String PROP_DEMO                    = "Demo";
    public static final String PROP_FRAME_RATE              = "Frame-Rate";
    public static final String DBG_SEPARATOR                = ": ";
    public static final String DBG_DS1                      = "D.S.1";
    public static final String DBG_DR1                      = "D.R.1";
    public static final String DBG_DMPA1                    = "DM.PA.1: ";
    public static final String DBG_DMDA1                    = "DM.DA.1: ";
    public static final String DBG_SSD1                     = "SS.D.1: ";
    public static final String DBG_SSCA1                    = "SS.CA.1";
    public static final String DBG_GEGTR1                   = "GE.GTR.1";
    public static final String DBG_GELM1                    = "GE.LM.1";
    public static final String DBG_GEPM1                    = "GE.PM.1";
    public static final String DBG_GESM1                    = "GE.SM.1";
    public static final String DBG_GEE1                     = "GE.E.1";
    public static final String DBG_GER1                     = "GE.R.1";

    // Localized strings.
    public static String READY            ;
    public static String NO_MOVES         ;
    public static String GAME_OVER        ;
    public static String SCORE_TITLE      ;
    public static String SCORE_TEXT       ;
    public static String SCORE_MATCHES    ;
    public static String SCORE_CASCADES   ;
    public static String SCORE_LONGEST    ;
    public static String ERROR_TITLE      ;
    public static String WAIT_TITLE       ;
    public static String SUPPORT_TITLE    ;
    public static String LOADING          ;
    public static String RMS_FAILURE     ;
    public static String VERSION_PREFIX   ;
    public static String LIBRARY_PREFIX   ;
    public static String OK_SOFTKEY       ;
    public static String CANCEL_SOFTKEY   ;
    public static String YES_SOFTKEY      ;
    public static String NO_SOFTKEY       ;
    public static String SELECT_SOFTKEY   ;
    public static String BACK_SOFTKEY     ;
    public static String HELP_SOFTKEY     ;
    public static String EXIT_SOFTKEY     ;
    public static String BUY_SOFTKEY      ;
    public static String SAVE_SOFTKEY     ;
    public static String RESET_SOFTKEY    ;
    public static String RESET_MESSAGE    ;
    public static String HELP_TITLE       ;
    public static String START_FAILURE    ;
    public static String EXIT_TITLE       ;
    public static String EXIT_MESSAGE     ;
    public static String EXIT_CONFIRM       ;
    public static String CREDITS_TITLE    ;
    public static String DEMO_OVER        ;
    public static String OPTION_HINT      ;
    public static String OPTION_SOUND     ;
    public static String OPTION_VIBRATE   ;
    public static String OPTION_FUNLIGHTS ;
    public static String OPTION_TITLE     ;
    public static String PAUSE_RESUME     ;
    public static String PAUSE_OPTION;
    public static String PAUSE_HELP       ;
    public static String PAUSE_EXIT       ;
    public static String PAUSE_TITLE      ;
    public static String PAUSE_SOFTKEY    ;
    public static String GAME_MODE           ;
    public static String VODAFONE_TRIAL      ;
    public static String VODAFONE_PLAY       ;
    public static String VODAFONE_TRIAL_DESC ;
    public static String VODAFONE_TRIAL_OVER ;
    public static String VODAFONE_UNAVAIL    ;
    public static String VODAFONE_GET_GAME   ;
    public static String VODAFONE_DOWNLOAD;
    public static String VODAFONE_RESTART;
    public static String PLAY;
    public static String ERASE_RECORDS;
    public static String NORMAL;
    public static String ADVANCED;
    public static String EXPERT;
    public static String HIGH_SCORE;
    
    static {
        setLocale("en");
    }
    
    /**
     * Singleton instance of string table for entire application.
     */
    private static StringTable INSTANCE;

    /**
     * String table text file name.
     */
    private static final String FILENAME = "strings.txt";

    /**
     * Assignment character used in string table text file.
     */
    private static final char ASSIGNMENT = '=';

    /**
     * End of line (a.k.a. the end of the value string) character used in
     * string table text file.
     */
    private static final char END_OF_LINE = '\n';

    /**
     * Character found in value string that should be replaced with a space.
     */
    private static final char SPACE_PLACEHOLDER = '_';

    /**
     * Character found in value string that should be replaced with a new line
     * character.
     */
    private static final char EOL_PLACEHOLDER = '|';

    /**
     * Key to string mapping.
     */
    private final Hashtable map = new Hashtable();

    public static String microeditionLocale = "en";
    
    /**
     * Construct string lookup table.
     *
     * @param filename of string lookup text file
     */
    private StringTable(String filename) {
        try {
            DataInputStream stream = new DataInputStream(getResource(filename, true));

            boolean more = true;
            while(more) {
                try {
                    String key = readTo(stream, ASSIGNMENT, false);
                    String string = readTo(stream, END_OF_LINE, true);
                    map.put(key, string);
                    Thread.yield();         // Allow loading display some time.
                } catch(EOFException exception) {
                    more = false;
                }
            }

            stream.close();
        } catch(IOException exception) {
            exception.printStackTrace();
        }
    }

    /**
     * Get resource data file as input stream.
     *
     * @param filename of resource without path, FILE_ROOT is assumed to contain path
     * @param isLocalized if true attempts to prepend locale to filename
     * @return input stream from file
     */
    public static InputStream getResource(String filename, boolean isLocalized) {
        InputStream in = null;
        if(isLocalized) {
            in = filename.getClass().getResourceAsStream(
                FILE_ROOT + getLocale() + filename);
        }
        if(in == null) {
            in = filename.getClass().getResourceAsStream(FILE_ROOT + filename);
        }
        return in;
    }

    /**
     * Get the locale prefix for this phone.
     *
     * @return locale code to prefix resource requests with
     */
    public static String getLocale() {
        String locale = "";

        try {
            locale = microeditionLocale;
            locale = locale.substring(0, 2);
            if(locale.equals("en")) {
                locale = "";
            } else {
                locale += "-";
            }
        } catch(Exception exception) {
            locale = "";
        }

        return locale;
    }

    /**
     * Load and parse string lookup text file.
     */
    public static void initialize() {
        if(INSTANCE == null) {
            INSTANCE = new StringTable(FILENAME);
        }
    }

    public static void setLocale(String locale) {
        microeditionLocale = locale;
        INSTANCE = new StringTable(FILENAME);
        
        READY            = lookup("READY");
        NO_MOVES         = lookup("NO_MOVES");
        GAME_OVER        = lookup("GAME_OVER");
        SCORE_TITLE      = lookup("SCORE_TITLE");
        SCORE_TEXT       = lookup("SCORE_TEXT");
        SCORE_MATCHES    = lookup("SCORE_MATCHES");
        SCORE_CASCADES   = lookup("SCORE_CASCADES");
        SCORE_LONGEST    = lookup("SCORE_LONGEST");
        ERROR_TITLE      = lookup("ERROR_TITLE");
        WAIT_TITLE       = lookup("WAIT_TITLE");
        SUPPORT_TITLE    = lookup("SUPPORT_TITLE");
        LOADING          = lookup("LOADING");
        RMS_FAILURE     = lookup("RMS_FAILURE");
        VERSION_PREFIX   = lookup("VERSION_PREFIX");
        LIBRARY_PREFIX   = lookup("LIBRARY_PREFIX");
        OK_SOFTKEY       = lookup("OK_SOFTKEY");
        CANCEL_SOFTKEY   = lookup("CANCEL_SOFTKEY");
        YES_SOFTKEY      = lookup("YES_SOFTKEY");
        NO_SOFTKEY       = lookup("NO_SOFTKEY");
        SELECT_SOFTKEY   = lookup("SELECT_SOFTKEY");
        BACK_SOFTKEY     = lookup("BACK_SOFTKEY");
        HELP_SOFTKEY     = lookup("HELP_SOFTKEY");
        EXIT_SOFTKEY     = lookup("EXIT_SOFTKEY");
        BUY_SOFTKEY      = lookup("BUY_SOFTKEY");
        SAVE_SOFTKEY     = lookup("SAVE_SOFTKEY");
        RESET_SOFTKEY    = lookup("RESET_SOFTKEY");
        RESET_MESSAGE    = lookup("RESET_MESSAGE");
        HELP_TITLE       = lookup("HELP_TITLE");
        START_FAILURE    = lookup("START_FAILURE");
        EXIT_TITLE       = lookup("EXIT_TITLE");
        EXIT_MESSAGE     = lookup("EXIT_MESSAGE");
        EXIT_CONFIRM        = lookup("EXIT_CONFIRM");
        CREDITS_TITLE    = lookup("CREDITS_TITLE");
        DEMO_OVER        = lookup("DEMO_OVER");
        OPTION_HINT      = lookup("OPTION_HINT");
        OPTION_SOUND     = lookup("OPTION_SOUND");
        OPTION_VIBRATE   = lookup("OPTION_VIBRATE");
        OPTION_FUNLIGHTS = lookup("OPTION_FUNLIGHTS");
        OPTION_TITLE     = lookup("OPTION_TITLE");
        PAUSE_RESUME     = lookup("PAUSE_RESUME");
        PAUSE_OPTION     = lookup("PAUSE_OPTION");
        PAUSE_HELP       = lookup("PAUSE_HELP");
        PAUSE_EXIT       = lookup("PAUSE_EXIT");
        PAUSE_TITLE      = lookup("PAUSE_TITLE");
        PAUSE_SOFTKEY    = lookup("PAUSE_SOFTKEY");
        GAME_MODE           = lookup("GAME_MODE");
        VODAFONE_TRIAL      = lookup("VODAFONE_TRIAL");
        VODAFONE_PLAY       = lookup("VODAFONE_PLAY");
        VODAFONE_TRIAL_DESC = lookup("VODAFONE_TRIAL_DESC");
        VODAFONE_TRIAL_OVER = lookup("VODAFONE_TRIAL_OVER");
        VODAFONE_UNAVAIL    = lookup("VODAFONE_UNAVAIL");
        VODAFONE_GET_GAME   = lookup("VODAFONE_GET_GAME");
        VODAFONE_DOWNLOAD   = lookup("VODAFONE_DOWNLOAD");
        VODAFONE_RESTART    = lookup("RESTART_TITLE");
        PLAY                = lookup("PLAY");
        ERASE_RECORDS       = lookup("ERASE_RECORDS");
        NORMAL              = lookup("NORMAL");
        ADVANCED            = lookup("ADVANCED");
        EXPERT              = lookup("EXPERT");
        HIGH_SCORE          = lookup("HIGH_SCORE");
    }

    /**
     * Lookup a string value by key string in the global table.
     *
     * @param key string to use as lookup key
     * @return corresponding string or null if key is not in table
     */
    public static String lookup(String key) {
        if (key == null) {
            return null;
        }
        initialize();
        return (String) (INSTANCE.map.get(key));
    }

    /**
     * Read input stream until the delimiter character or EOF is encountered.
     *
     * @param input stream containing text
     * @param delimiter character to stop at
     * @param isFormatted if true, space and new line placeholders are
     *          converted to spaces and new line characters
     * @return string resulting from read, without delimiter character at the
     *          end
     * @throws IOException if reading fails, including EOF
     */
    private String readTo(DataInput input, char delimiter, boolean isFormatted)
        throws IOException
    {
        StringBuffer buffer = new StringBuffer();

        char next = readUnicode(input);
        while(next != delimiter) {
            buffer.append(next);
            next = readUnicode(input);
        }

        String fullString = buffer.toString();
        String trimString = (fullString != null) ? fullString.trim() : null;
        if(isFormatted && (trimString != null)) {
            return(trimString.replace(SPACE_PLACEHOLDER, ' ').replace(EOL_PLACEHOLDER, '\n'));
        }
        return(trimString);
    }

    /**
     * Read a character from an ASCII text file and convert it to a J2ME
     * unicode character.
     *
     * @param input stream to read from
     * @return next character in stream converted to unicode character
     * @throws IOException if reading fails, including EOF
     */
    public static char readUnicode(DataInput input) throws IOException {
        int value = (int) (input.readByte());
        if(value < 0) {
            value += 256;
        }
        return ((char) value);
    }

}
