/**
 * Created by IntelliJ IDEA.
 * User: bhawkins
 * Date: Jul 17, 2003
 * Time: 1:53:21 PM
 * To change this template use Options | File Templates.
 */

package com.bejeweled2_j2me;

import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Font;

class TextElement extends GuiElement
{

    // Color of unselected text. (0xRRGGBB where R,G, and B [0x00-0xFF])
    private static final int NORMAL_TEXT_COLOR = 0xFFFFFF;

    // Color of selected text. (0xRRGGBB where R,G, and B [0x00-0xFF])
    private static final int SELECTED_TEXT_COLOR = 0x000000;

    // Color to render behind selected text. (0xRRGGBB where R,G, and B [0x00-0xFF])
    public static final int SELECTED_BACKGROUND_COLOR = 0xF981DD;

    // Color of indicator to show there is additional text.
    private static final int SCROLL_INDICATOR_COLOR = 0xF981DD;

    // Color of shadow of indicator to show there is additional text.
    private static final int SCROLL_INDICATOR_SHADOW_COLOR = 0x000000;

    // Size of indicator to show there is additional text.
    private static final int SCROLL_INDICATOR_SIZE = 8;

    // Offset from edge of indicator to show there is additional text.
    private static final int SCROLL_INDICATOR_OFFSET = 2;

    // Font for this text.
    private Font font;

    // Current text.
    private String text;

    // Does this control have scroll indicators to show there is
    // more text available.
    private boolean hasScrollIndicators;

    // Y fudge factor for handling device specific problems.
    private int yOffset;

    // Starting line to render from.
    private int line;

    // Total line count for wrapped text.
    private int numberOfLines;

    // Total number of lines that can be displayed.
    private int numberOfLinesDisplayed;

    // Current selection status for this text.
    private boolean isSelected;

    /**
     * Create a new text element.
     *
     * @param canvas this element interacts with and renders to
     * @param font to render with, must NOT be null
     * @param text to render, can be null (in which case no text renders)
     * @param x origin
     * @param y origin
     * @param wd width
     * @param ht height
     */
    TextElement(Canvas canvas, Font font, String text,
                boolean hasScrollIndicators, int x, int y, int wd, int ht) {
        super(canvas, x, y, wd, ht);
        this.font = font;
        if(text != null) {
            setText(text);
        }
        this.hasScrollIndicators = hasScrollIndicators;
        numberOfLinesDisplayed = ht / font.getHeight();
    }

    /**
     * Change text to display.
     *
     * @param text new text, can be null
     */
    void setText(String text) {
        if(text != null) {
            this.text = Dialog.wordWrap(text, font, wd - 14); // changed 2 to 14 By JAMDAT India
        } else {
            this.text = null;
        }
        line = 0;
        updateNumberOfLines();
        repaint();
    }

    /**
     * Fudge factor for device specific problems.
     *
     * @param offset +/- number of pixels to adjust string drawing by
     */
    void setOffsetY(int offset) {
        yOffset = offset;
    }

    /**
     * Mark this text as selected.
     */
    void select() {
        isSelected = true;
        repaint();
    }

    /**
     * Mark this text as unselected.
     */
    void deselect() {
        isSelected = false;
        repaint();
    }

    /**
     * Move the starting line to render up one line. Stops at the top.
     */
    void lineUp() {
        line = Math.max(0, line - 1);
        repaint();
    }

    /**
     * Move the starting line to render down one line. Stops at the bottom.
     */
    void lineDown() {
        line = Math.min(numberOfLines - (ht / font.getHeight()), line + 1);
        repaint();
    }

    /**
     * Render word wrapped text and, if selected, selection background.
     *
     * @param gc graphics context to render to
     */
    void draw(Graphics gc) {
        if(isSelected) {
            gc.setColor(SELECTED_BACKGROUND_COLOR);
            gc.fillRect(x, y, wd, ht);
            gc.setColor(SELECTED_TEXT_COLOR);
        } else {
            gc.setColor(NORMAL_TEXT_COLOR);
        }
        if(numberOfLines > 0) {
            int line = this.line;
            int y = this.y;
            int startIndex = 0, endIndex = 0;
            while((y + font.getHeight() <= this.y + ht) && (endIndex != -1)) {
                endIndex = text.indexOf(Dialog.NEW_LINE, startIndex + 1);

                // Ignore lines up to starting line.
                if(line > 0) {
                    --line;
                } else {
                    String subtext = (endIndex == -1) ?
                        text.substring(startIndex) :
                        text.substring(startIndex, endIndex);
                    if(subtext.length() > 0 && subtext.charAt(0) == Dialog.NEW_LINE) {
                        subtext = subtext.substring(1);
                    }
                    CustomFont.drawString(font, gc, subtext,
                        x + 1, y + yOffset, GameEngine.TOP_LEFT);
                    y += font.getHeight();
                }

                startIndex = endIndex;
            }

            if(hasScrollIndicators) {
                drawScrollIndicators(gc);
            }
        }
    }

    /**
     * Draw scroll indicators if there is text that is not visible.
     * @param gc
     */
    private void drawScrollIndicators(Graphics gc) {
        int offset = SCROLL_INDICATOR_OFFSET;
        int size = SCROLL_INDICATOR_SIZE;
        int x = this.x + wd - offset - (size / 2);
        if(line > 0) {
            gc.setColor(SCROLL_INDICATOR_SHADOW_COLOR);
            drawArrow(gc, x - 2, y + offset - 1, size, size);
            gc.setColor(SCROLL_INDICATOR_COLOR);
            drawArrow(gc, x, y + offset, size, size);
        }
        if((line + numberOfLinesDisplayed) < numberOfLines) {
            gc.setColor(SCROLL_INDICATOR_SHADOW_COLOR);
            drawArrow(gc, x - 2, y + ht - offset + 1, size, -size);
            gc.setColor(SCROLL_INDICATOR_COLOR);
            drawArrow(gc, x, y + ht - offset, size, -size);
        }
    }

    /**
     * Draw a vertical arrow.
     *
     * @param gc
     * @param x origin (middle of arrow)
     * @param y origin (point of arrow)
     * @param width of arrow at widest part
     * @param height of arrow
     */
    private void drawArrow(Graphics gc, int x, int y, int width, int height) {
        int currentHeight = Math.abs(height);
        for(int offsetY = 0; offsetY < currentHeight; ++offsetY) {
            int currentWidth = ((width * ((offsetY / 2) * 2)) / currentHeight) + 1;
            int currentX = x - (currentWidth / 2);
            int currentY = (height > 0) ? (y + offsetY) : (y - offsetY);
            gc.drawLine(currentX, currentY, currentX + currentWidth, currentY);
        }
    }

    /**
     * Compute the number of lines in the current text.
     */
    private void updateNumberOfLines() {
        numberOfLines = 0;
        if(text != null) {
            int index = 0;
            while(index != -1) {
                ++numberOfLines;
                index = text.indexOf(Dialog.NEW_LINE, index + 1);
            }
        }
    }

}
