package shell;

import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.Graphics;
import shell.core.App;
import shell.core.Scene;
import shell.core.Visual;
import shell.core.Device;
import shell.core.ImageFont;

public class BuyScene extends Scene implements Layout {
    
    public static final int MODE_PRE_DEMO = 0;
    public static final int MODE_BROWSE = 1;
    public static final int MODE_POST_DEMO = 2;
    
    public static boolean autoBuy = false;
    
    private Image backgroundImage;
    private MenuItem[] itemInfo;
    private int currentMenuItem;
    
    private Visual currentGameImage;
    private Visual[] currentDescription;
    private Visual[] nag;
    private Visual infoBox;
    private Visual left, right;
    private int nagFlashTime;
    private int leftCountdown;
    private int rightCountdown;
    
    private ImageFont font;
    private ImageFont normalFont;
    private ImageFont selectFont;
    
    private int mode = MODE_BROWSE;
    
    
    public BuyScene(Image backgroundImage, MenuItem[] itemInfo, int currentMenuItem) {
        this.backgroundImage = backgroundImage;
        this.itemInfo = itemInfo;
        this.currentMenuItem = currentMenuItem;
    }
    
    
    // Must be called before load()
    public void setMode(int mode) {
        this.mode = mode;
    }
    
    
    public void load() {
        if (autoBuy) {
            autoBuy = false;
            App.launchBrowser(itemInfo[currentMenuItem].link);
        }
        if (backgroundImage != null) {
            setBackground(backgroundImage);
        }
        else {
            setBackground(App.createImage("background.png"));
        }
        
        font = new ImageFont("message-font");
        
        // Nag
        Image nagBackground = App.createImage("buy-flasher.png");
        String[] wrappedText = font.wordWrapText(Local.BUY2, nagBackground.getWidth() - 10);
        nag = new Visual[wrappedText.length + 1];
        nag[0] = new Visual(nagBackground, Device.WIDTH / 2, Layout.BUY_NAG_Y);
        nag[0].setAnchor(Graphics.HCENTER | Graphics.TOP);
        for (int i = 0; i < wrappedText.length; i++) {
            int y = Layout.BUY_NAG_TEXT_Y + i * Layout.BUY_NAG_TEXT_DY;
            Image image = font.renderText(wrappedText[i]);
            nag[i + 1] = new Visual(image, Device.WIDTH/2, y);
            nag[i + 1].setAnchor(Graphics.HCENTER | Graphics.TOP);
        }
        
        currentDescription = new Visual[wrappedText.length];
        int y = INFO_DESCRIPTION_Y;
        if (wrappedText.length > 1) {
            y -= INFO_DESCRIPTION_DY/2;
        }
        for (int i = 0; i < wrappedText.length; i++) {
            Image image = font.renderText(wrappedText[i]);
            currentDescription[i] = new Visual(image, Device.WIDTH/2, y);
            currentDescription[i].setAnchor(Graphics.HCENTER | Graphics.VCENTER);
            add(currentDescription[i]);
            y += INFO_DESCRIPTION_DY;
        }
        
        
        // Info box
        infoBox = new Visual("buy-info-box.png", Device.WIDTH/2, INFO_BOX_Y);
        infoBox.setAnchor(Graphics.HCENTER | Graphics.TOP);
        add(infoBox);
        
        // Softkeys
        normalFont = new ImageFont("softkey-font");
        selectFont = new ImageFont("softkey-select-font");
        
        // Game info
        showGame(currentMenuItem);
        
        // Arrows
        if (mode == MODE_BROWSE) {
            Image arrowImages = App.createImage("arrows.png");
            left = new Visual(arrowImages, 2, 2, ARROW_HSPACE, SCREENSHOT_Y);
            left.setAnchor(Graphics.LEFT | Graphics.VCENTER);
            add(left);
            right = new Visual(arrowImages, 2, 2, Device.WIDTH - ARROW_HSPACE, SCREENSHOT_Y);
            right.setAnchor(Graphics.RIGHT | Graphics.VCENTER);
            right.setFrame(2);
            add(right);
        }
        else {
            left = null;
            right = null;
        }
        
        //if (App.isSceneStackEmpty()) {
        //    setSoftKey2(ImageFont.createButton(Local.EXIT, normalFont, selectFont));
        //}
        //else {
            setSoftKey2(ImageFont.createButton(Local.BACK, normalFont, selectFont));
        //}
    }
    
    
    public void showGame(int index) {
        currentMenuItem = index;
        
        remove(currentGameImage);
        if (currentDescription != null) {
            for (int i = 0; i < currentDescription.length; i++) {
                remove(currentDescription[i]);
            }
            currentDescription = null;
        }
        for (int i = 0; i < nag.length; i++) {
            remove(nag[i]);
        }
        
        boolean isFreeStuff = "free".equals(itemInfo[currentMenuItem].key);
        
        Image image = App.createImage(itemInfo[currentMenuItem].imageResource);
        if (image == App.getBrokenImage()) {
            image = App.createImage("/screens/not_available.png");
        }
        
        if (isFreeStuff) {
            image = makeFreeStuffImage(image, itemInfo[currentMenuItem].description);
        }
        
        currentGameImage = new Visual(image,
            Device.WIDTH/2, SCREENSHOT_Y);
        currentGameImage.setAnchor(Graphics.HCENTER | Graphics.VCENTER);
        add(currentGameImage);
        
        if (isFreeStuff) {
            infoBox.setVisible(false);
            currentGameImage.setY(currentGameImage.getY() + infoBox.getHeight() / 2);
        }
        else {
            infoBox.setVisible(true);
            String[] wrappedText = font.wordWrapText(itemInfo[currentMenuItem].description, 
                Device.WIDTH - Device.WIDTH / 10);
            currentDescription = new Visual[wrappedText.length];
            int y = INFO_DESCRIPTION_Y;
            if (wrappedText.length > 1) {
                y -= INFO_DESCRIPTION_DY/2;
            }
            for (int i = 0; i < wrappedText.length; i++) {
                image = font.renderText(wrappedText[i]);
                currentDescription[i] = new Visual(image, Device.WIDTH/2, y);
                currentDescription[i].setAnchor(Graphics.HCENTER | Graphics.VCENTER);
                add(currentDescription[i]);
                y += INFO_DESCRIPTION_DY;
            }
        
            // Nag text
            for (int i = 0; i < nag.length; i++) {
                add(nag[i]);
            }
            nagFlashTime = 0;
        }
        
        if (mode == MODE_PRE_DEMO) {
            setSoftKey1(ImageFont.createButton(Local.PLAY, normalFont, selectFont));
        }
        else if (isFreeStuff) {
            setSoftKey1(ImageFont.createButton(Local.OK, normalFont, selectFont));
        }
        else {
            setSoftKey1(ImageFont.createButton(Local.BUY, normalFont, selectFont));
        }
    }
    
    public void update(int elapsedTime) {
        // Nag flash
        nagFlashTime += elapsedTime;
        if (nagFlashTime >= 1000) {
            nagFlashTime %= 1000;
        }
        for (int i = 0; i < nag.length; i++) {
            nag[i].setVisible(nagFlashTime >= 250);
        }
        
        // Left & Right highlight
        if (left != null && leftCountdown > 0) {
            leftCountdown -= elapsedTime;
            if (leftCountdown <= 0) {
                left.setFrame(0);
            }
        }
        if (right != null && rightCountdown > 0) {
            rightCountdown -= elapsedTime;
            if (rightCountdown <= 0) {
                right.setFrame(2);
            }
        }
        
        if (App.isPressed(App.VK_SOFT1)) {
            setSoftKey1Highlight(true);
            if (mode == MODE_PRE_DEMO) {
                playGame();
            }
            else {
                App.launchBrowser(itemInfo[currentMenuItem].link);
            }
        }
        else if (App.isPressed(App.VK_OK) || App.isPressed(App.VK_5)) {
            App.launchBrowser(itemInfo[currentMenuItem].link);
        }
        else if (App.isPressed(App.VK_SOFT2)) {
            setSoftKey2Highlight(true);
            if (App.isSceneStackEmpty()) {
                App.setScene(new GameSelectScene());
            }
            else {
                App.popScene();
            }
        }
        else if (mode == MODE_BROWSE) {
            if (App.isPressed(App.VK_LEFT) || App.isPressed(App.VK_4)) {
                while (true) {
                    currentMenuItem--;
                    if (currentMenuItem < 0) {
                        currentMenuItem = itemInfo.length - 1;
                    }
                    if (itemInfo[currentMenuItem].type == MenuItem.TYPE_ALT_ITEM ||
                        itemInfo[currentMenuItem].type == MenuItem.TYPE_DEMO)
                    {
                        break;
                    }
                }
                showGame(currentMenuItem);
                if (left != null) {
                    left.setFrame(1);
                    leftCountdown = 250;
                }
            }
            else if (App.isPressed(App.VK_RIGHT) || App.isPressed(App.VK_6)) {
                while (true) {
                    currentMenuItem++;
                    if (currentMenuItem >= itemInfo.length) {
                        currentMenuItem = 0;
                    }
                    if (itemInfo[currentMenuItem].type == MenuItem.TYPE_ALT_ITEM ||
                        itemInfo[currentMenuItem].type == MenuItem.TYPE_DEMO)
                    {
                        break;
                    }
                }
                showGame(currentMenuItem);
                if (right != null) {
                    right.setFrame(3);
                    rightCountdown = 250;
                }
            }
        }
    }
    
    private void playGame() {
        BuyScene buyScene = new BuyScene(null, itemInfo, currentMenuItem);
        buyScene.setMode(MODE_POST_DEMO);
        
        if (currentMenuItem == 0) {
            tetris.localString.gameLang = Local.getLanguage();
            shell.core.Main.setGame(new tetris.bluelava(), buyScene);
        }
        else if (currentMenuItem == 1) {
            sims2.SimsCanvas.setLanguage(Local.getLanguage());
            shell.core.Main.setGame(new sims2.SimsApp(), buyScene);
        }
        else {
            com.bejeweled2_j2me.StringTable.setLocale(Local.getLanguage());
            shell.core.Main.setGame(new com.bejeweled2_j2me.BejeweledMIDlet(), buyScene);
            //App.setScene(new Splash("__placeholder.png", buyScene, Splash.NO_TIMEOUT, true));
        }  
    }
    
    private Image makeFreeStuffImage(Image image, String description) {
        ImageFont font = new ImageFont("free-font");
        
        Image newImage = Image.createImage(image.getWidth(), image.getHeight());
        Graphics g = newImage.getGraphics();
        g.drawImage(image, 0, 0, Graphics.TOP | Graphics.LEFT);
        
        String[] text = font.wordWrapText(description, FREE_TEXT_WIDTH);
        int y = FREE_DESCRIPTION_Y - (text.length * FREE_TEXT_DY) / 2;
        for (int i = 0; i < text.length; i++) {
            font.draw(g, text[i], (image.getWidth() - font.getWidth(text[i])) / 2, y);
            y += FREE_TEXT_DY;
        }
        
        text = font.wordWrapText(Local.GETIT, FREE_TEXT_WIDTH);
        y = FREE_GET_IT_Y - (text.length * FREE_TEXT_DY) / 2;
        for (int i = 0; i < text.length; i++) {
            font.draw(g, text[i], (image.getWidth() - font.getWidth(text[i])) / 2, y);
            y += FREE_TEXT_DY;
        }
        
        return newImage;
    }
}
