package shell;

import javax.microedition.lcdui.Image;

import shell.core.App;
import shell.core.ImageFont;
import shell.core.Scene;
import shell.core.Visual;

public class LanguageSelectScene extends Scene implements Layout {
    
    public static final String[] LANGUAGE_NAMES = {
        "English", "Fran\u00e7ais", "Italiano", "Deutsch", "Espa\u00f1ol"
    };
    
    public static final String[] LANGUAGE_CODES = {
        "en", "fr", "it", "de", "es"
    };
    
    private static final int NUM_LANGUAGES = LANGUAGE_CODES.length;
    
    private Visual[] flags;
    private Visual[] names;
    private int language;
    private ImageFont normalFont;
    private ImageFont selectFont;
    
    public void load() {
        setBackground(0x000000);
        
        normalFont = new ImageFont("softkey-font");
        selectFont = new ImageFont("softkey-select-font");
        
        Image flagImages = App.createImage("flags.png");
        flags = new Visual[NUM_LANGUAGES];
        names = new Visual[NUM_LANGUAGES];
        
        int y = FLAG_Y;
        for (int i = 0; i < NUM_LANGUAGES; i++) {
            flags[i] = new Visual(flagImages, 2, NUM_LANGUAGES, FLAG_X, y);
            flags[i].setFrame(i*2);
            names[i] = ImageFont.createButton(LANGUAGE_NAMES[i], normalFont, selectFont);
            names[i].setLocation(FLAG_NAME_X, y + FLAG_NAME_Y_OFFSET);
            
            add(flags[i]);
            add(names[i]);
            y += FLAG_DY;
        }
        
        int index = 0;
        String locale = App.getProperty("microedition.locale");
        for (int i = 0; i < LANGUAGE_CODES.length; i++) {
            if (LANGUAGE_CODES[i].equals(locale)) {
                index = i;
                break;
            }
        }
        setLanguage(index);
    }
    
    
    public void unload() {
        super.unload();
        flags = null;
        names = null;
        normalFont = null;
        selectFont = null;
    }
    
    
    private void setLanguage(int lang) {
        names[language].setFrame(0);
        flags[language].setFrame(language*2);
        
        this.language = lang;
        Local.setLanguage(LANGUAGE_CODES[language]);
        setSoftKey1(ImageFont.createButton(Local.OK, normalFont, selectFont));
        setSoftKey2(ImageFont.createButton(Local.EXIT, normalFont, selectFont));
        
        names[language].setFrame(1);
        flags[language].setFrame(language*2 + 1);
    }
        
    
    public void update(int elapsedTime) {
        
        if (App.isPressed(App.VK_OK) || App.isPressed(App.VK_SOFT1) || 
            App.isPressed(App.VK_5))
        {
            setSoftKey1Highlight(true);
            go();
        }
        else if (App.isPressed(App.VK_SOFT2)) {
            setSoftKey2Highlight(true);
            App.exit();
        }
        else if (App.isPressed(App.VK_UP) || App.isPressed(App.VK_2)) {
            setLanguage((language + NUM_LANGUAGES - 1) % NUM_LANGUAGES);
        }
        else if (App.isPressed(App.VK_DOWN) || App.isPressed(App.VK_8)) {
            setLanguage((language + 1) % NUM_LANGUAGES);
        }
    }
    
    private void go() {
        Scene lastScene;
        
        // Default for "show.navigation.splash" is "true"
        if (!"false".equals(App.getProperty("show.navigation.splash"))) {
            lastScene = new NavigationScene();
        }
        else {
            lastScene = new GameSelectScene();
        }
        
        Scene eaLogoScene = new Splash("ealogo.png", lastScene, 3000, false);
        
        App.setScene(eaLogoScene);
    }
        
}

