package shell;

import shell.core.Device;

/**
    Layout information for all scenes
*/
public interface Layout {
    
    //
    // LanguageSelect
    //
    
    public static final int FLAG_X = (Device.WIDTH - 110) / 2;
    public static final int FLAG_Y = (Device.HEIGHT - 190) / 2;
    public static final int FLAG_DY = 40;
    public static final int FLAG_NAME_X = FLAG_X + 60;
    public static final int FLAG_NAME_Y_OFFSET = 10;
   
    //
    // GameSelect
    //
    
    public static final int TOOLBAR_BUTTON_X = 106;
    public static final int TOOLBAR_BUTTON_Y = 5;
    public static final int TOOLBAR_BUTTON_DX = 46;
    public static final int TOOLBAR_LABEL_Y = 38;
    
    public static final int ALT_ITEM_WIDTH = 232;
    public static final int ALT_ITEM_HEIGHT = 21;
    public static final int ALT_ITEM_X = (Device.WIDTH - ALT_ITEM_WIDTH) / 2;
    public static final int ALT_ITEM_DY = ALT_ITEM_HEIGHT - 1;
    public static final int ALT_ITEMS_BOTTOM = 293;
    public static final int ALT_ITEMS_PER_PAGE = 4;
    
    //
    // Buy
    //
    
    public static final int ARROW_HSPACE = 1;
    public static final int SCREENSHOT_Y = 124;
    public static final int INFO_BOX_Y = 250;
    public static final int INFO_DESCRIPTION_Y = INFO_BOX_Y + 23;
    public static final int INFO_DESCRIPTION_DY = 20;
    public static final int BUY_NAG_Y = 110;
    public static final int BUY_NAG_TEXT_Y = BUY_NAG_Y + 7;
    public static final int BUY_NAG_TEXT_DY = 20;
    
    //
    // Free Stuff
    //
    
    public static final int FREE_DESCRIPTION_Y = 46;
    public static final int FREE_GET_IT_Y = 212;
    public static final int FREE_TEXT_WIDTH = 160;
    public static final int FREE_TEXT_DY = 20;


    //
    // Help
    //
    
    public static final int HELP_Y = 7;
    public static final int HELP_DY = 14;
}
