package shell;

import shell.core.App;
import shell.core.Visual;
import shell.core.ImageFont;
import shell.core.Device;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class MenuItem {
    
    public static final int BORDER_COLOR = 0x000000;
    
    public static final int TYPE_DEMO = 0;
    public static final int TYPE_ALT_ITEM = 1;
    public static final int TYPE_LINK = 2;
    public static final int TYPE_SCENE = 3;
    
    public int type;
    
    public String key;
    public String title;
    public String subtitle;
    public String description;
    public String imageResource;
    public String link;
    
    
    public MenuItem(String key, String title, String subtitle, 
        String description, String imageResource,
        String link)
    {
        this.key = key;
        this.title = title;
        this.subtitle = subtitle;
        this.description = description;
        this.imageResource = "/screens/" + imageResource;
        this.link = link;
        
        if (imageResource != null) {
            this.type = TYPE_ALT_ITEM;
        }
        else {
            this.type = TYPE_LINK;
        }
    }
    
    
    public Visual createButton(ImageFont normalFont, ImageFont selectFont,
        ImageFont subtitleFont, ImageFont subtitleSelectFont,
        int w, int h) 
    {
        int x = 5;
        int y = 0;
        int subtitleY = y + 5;
        int width = w;
        int height = h * 2;
        
        Image renderedButton = Image.createImage(width, height);
        Graphics g = renderedButton.getGraphics();
        
        // Background
        if (normalFont.getBackgroundColor() >= 0) {
            g.setColor(normalFont.getBackgroundColor());
            g.fillRect(1, 1, w-2, h-2);
        }
        if (selectFont.getBackgroundColor() >= 0) {
            g.setColor(selectFont.getBackgroundColor());
            g.fillRect(1, h+1, w-2, h-2);
        }
        
        // Text
        normalFont.draw(g, title, x, y);
        selectFont.draw(g, title, x, h + y);
        if (subtitle != null && subtitle.length() > 0) {
            x += normalFont.getWidth(title) + normalFont.getWidth(' ');
            subtitleFont.draw(g, subtitle, x, subtitleY);
            subtitleSelectFont.draw(g, subtitle, x, h + subtitleY);
        }
        
        // Border
        g.setColor(BORDER_COLOR);
        g.drawRect(0, 0, w-1, h-1);
        g.drawRect(0, h, w-1, h-1);
        
        return new Visual(renderedButton, 1, 2, 0, 0);
    }
    
    
    public static MenuItem[] getAll() {
        
        // Get count of menu items
        int count = 0;
        while (true) {
            String name = getProperty("menu" + (count+1));
            if (name == null) {
                break;
            }
            count++;
        }
        count += Device.GAMES.length;
        count++; // "Help"
        MenuItem[] items = new MenuItem[count];
        
        // Help
        items[count - 1] = new MenuItem("help", 
            Local.HELP, null, null, null, null);
        items[count - 1].type = TYPE_SCENE;
        
        // Create MenuItems for main games
        for (int i = 0; i < Device.GAMES.length; i++) {
            Local.GameDescription game = (Local.GameDescription)Local.GAMES.get(Device.GAMES[i]);
            items[i] = new MenuItem(
                Device.GAMES[i],
                game.name,
                null,
                game.description_short,
                Device.GAMES[i] + ".png",
                getProperty(Device.GAMES[i] + ".link"));
            items[i].type = TYPE_DEMO;
        }
        
        // Read all JAD attributes for extra menu items
        for (int i = Device.GAMES.length; i < count - 1; i++) {
            int index = i - Device.GAMES.length + 1;
            String propertyName = "menu" + index;
            String key = getProperty(propertyName);
            if ("www".equals(key)) {
                items[i] = new MenuItem(
                    key,
                    getProperty(propertyName + ".title"),
                    null,
                    null,
                    null,
                    getProperty(propertyName + ".link"));
            }
            else {
                Local.GameDescription game = (Local.GameDescription)Local.GAMES.get(key);
                if (game == null) {
                    System.out.println("No such game: " + key);
                }
                else {
                    items[i] = new MenuItem(
                        key,
                        game.name,
                        null,
                        game.description_short,
                        key + ".png",
                        getProperty(propertyName + ".link"));
                }
            }
        }
        
        return items;
    }
    
    private static String getProperty(String propertyName) {
        String value = App.getProperty(propertyName + "." + Local.getLanguage());
        if (value == null) {
            value = App.getProperty(propertyName);
        }
        return value;
    }
}
