package shell;

import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.Graphics;

import shell.core.App;
import shell.core.Device;
import shell.core.ImageFont;
import shell.core.Scene;
import shell.core.Visual;

public class NavigationScene extends Scene implements Layout {
    
    
    public void load() {
        setBackground(0x000000);
        
        Visual buttons = new Visual("navigation.png", Device.WIDTH/2, Device.HEIGHT/2);
        buttons.setAnchor(Graphics.HCENTER | Graphics.VCENTER);
        add(buttons);
        
        ImageFont font = new ImageFont("softkey-font");
        Image image = font.renderText(Local.CONTINUE);
        Visual text = new Visual(image, Device.WIDTH/2, Device.HEIGHT - 30);
        text.setAnchor(Graphics.HCENTER | Graphics.TOP);
        add(text);
        
        Visual header = new Visual(font.renderText(Local.NAVIGATION), Device.WIDTH/2, 10);
        header.setAnchor(Graphics.HCENTER | Graphics.TOP);
        add(header);
        
        ImageFont helpFont = new ImageFont("help-font");
        Visual left = new Visual(helpFont.renderText(Local.LEFT), 
            buttons.getScreenX() - 5, 
            buttons.getScreenY() + buttons.getHeight()/2);
        left.setAnchor(Graphics.VCENTER | Graphics.RIGHT);
        add(left);
        
        Visual right = new Visual(helpFont.renderText(Local.RIGHT), 
            buttons.getScreenX() + buttons.getWidth() + 5, 
            buttons.getScreenY() + buttons.getHeight()/2);
        right.setAnchor(Graphics.VCENTER | Graphics.LEFT);
        add(right);
        
        Visual up = new Visual(helpFont.renderText(Local.UP), 
            buttons.getScreenX() + buttons.getWidth()/2, 
            buttons.getScreenY());
        up.setAnchor(Graphics.HCENTER | Graphics.BOTTOM);
        add(up);
        
        Visual down = new Visual(helpFont.renderText(Local.DOWN), 
            buttons.getScreenX() + buttons.getWidth()/2, 
            buttons.getScreenY() + buttons.getHeight());
        down.setAnchor(Graphics.HCENTER | Graphics.TOP);
        add(down);
    }
    
    
    public void update(int elapsedTime) {
        if (App.isPressed(App.VK_OK) || App.isPressed(App.VK_5)) {
            App.setScene(new GameSelectScene());
        }
    }
        
}

