package shell;

import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import shell.core.App;
import shell.core.Scene;
import shell.core.Visual;
import shell.core.Device;

public class Splash extends Scene {
    
    public static final int NO_TIMEOUT = -1;
    
    private final String imageResource;
    private final Scene nextScene;
    private final int timeout;
    private final boolean allowKeyInterrupt;

    private int time;
    
    public Splash(String imageResource, Scene nextScene, int timeout, boolean allowKeyInterrupt) {
        this.imageResource = imageResource;
        this.nextScene = nextScene;
        this.timeout = timeout;
        this.allowKeyInterrupt = allowKeyInterrupt;
    }
    
    
    public void load() {
        Image image = App.createImage(imageResource);
        if (image.getWidth() == Device.WIDTH && image.getHeight() == Device.HEIGHT) { 
            setBackground(image);
        }
        else {
            setBackground(0x000000);
            
            Visual splash = new Visual(image, Device.WIDTH/2, Device.HEIGHT/2);
            splash.setAnchor(Graphics.HCENTER | Graphics.VCENTER);
            add(splash);
        }
        time = 0;
    }
    
    
    public void update(int elapsedTime) {
        
        time += elapsedTime;
        
        if (timeout != NO_TIMEOUT && time >= timeout) {
            App.setScene(nextScene);
        }
        else if (allowKeyInterrupt) {
            if (App.isPressed(App.VK_OK) || App.isPressed(App.VK_5)) {
                App.setScene(nextScene);
            }
        }
    }
}

