package shell.core;

import javax.microedition.lcdui.Graphics;

/**
    Device-specific values for screen dimensions, positioning and key codes.
*/
public interface Device {
    
    public static final int WIDTH = 240;
    public static final int HEIGHT = 320;
    
    public static final String[] GAMES = { "tetris", "sims2", "bejeweled" };
    
    // Convenience constants for changing softkey placement
    // Note: when swapping visual placement of softkeys, swap key codes too (below)
    public static final boolean SOFT1_ON_LEFT = true;
    public static final int SOFT_HOFFSET = 8;
    public static final int SOFT_VOFFSET = 0;
    
    
    // Public softkey constants
    public static final int SOFT1_X = SOFT1_ON_LEFT ? SOFT_HOFFSET : WIDTH - SOFT_HOFFSET;
    public static final int SOFT1_Y = HEIGHT + SOFT_VOFFSET - 1;
    public static final int SOFT1_ANCHOR = Graphics.BOTTOM | 
        (SOFT1_ON_LEFT ? Graphics.LEFT : Graphics.RIGHT);
    
    public static final int SOFT2_X = (!SOFT1_ON_LEFT) ? SOFT_HOFFSET : WIDTH - SOFT_HOFFSET;
    public static final int SOFT2_Y = HEIGHT + SOFT_VOFFSET - 1;
    public static final int SOFT2_ANCHOR = Graphics.BOTTOM | 
        ((!SOFT1_ON_LEFT) ? Graphics.LEFT : Graphics.RIGHT);
    
    
    //
    // Device-specific key codes
    //
    
    public static final int KEY_CODE_OK = -5;
    public static final int KEY_CODE_SOFT1 = -6;
    public static final int KEY_CODE_SOFT2 = -7;
    public static final int KEY_CODE_UP = -1;
    public static final int KEY_CODE_DOWN = -2;
    public static final int KEY_CODE_LEFT = -3;
    public static final int KEY_CODE_RIGHT = -4;
    
}