package sims2;

/* Copyright Ideaworks3D Ltd. 2005 */



import java.util.Enumeration;
import java.util.Vector;
import javax.microedition.lcdui.*;


//import com.ideaworks3d.debug.Debug;

public class Dialogue
{
	/**
	 * Basic constructor that just adds text to  a field to be drawn
	 *
	 * @param text
	 */
	public Dialogue(String text)
	{
		m_UseBack = true;
		m_UseSelect = true;
		//Debug.println("new dialog", //Debug.CHAN_UI);
//		SetDefaultValues();
		SetType(DialogueStyles.GRAPHIC_BOX);
		InitText(text);

	} // end basic string constructor

	public Dialogue(String text, boolean useBack, boolean useSelect)
	{
		m_UseBack = useBack;
		m_UseSelect = useSelect;
		//Debug.println("new dialog", //Debug.CHAN_UI);
//		SetDefaultValues();
		SetType(DialogueStyles.GRAPHIC_BOX);
		InitText(text);

	} // end basic string constructor

	public Dialogue(Vector options, int type, int displayFlags, int startOption, boolean useBack, boolean useSelect)
	{
		this(options, null, (String)null, null, type, displayFlags, startOption, useBack, useSelect);
	}

	public Dialogue(Vector options, Vector disabledOptions, int type, int displayFlags, int startOption, boolean useBack, boolean useSelect)
	{
		this(options, disabledOptions, (String)null, null, type, displayFlags, startOption, useBack, useSelect);
	}

	public Dialogue(Vector options, Vector disabledOptions, String title, Image image, int type, int displayFlags, int startOption, boolean useBack, boolean useSelect)
	{
		m_selectionState = startOption;
		m_UseBack = useBack;
		m_UseSelect = useSelect;
		//Debug.println("new selection dialog: " + options.size() + " (image=" + image + " title=" + title + ")", //Debug.CHAN_UI);

		SetDefaultValues();

		// Add title as an option
		boolean hasTitle = false;

		if (title != null)
		{
			hasTitle = true;
			options.insertElementAt(title, 0);
		}

		// Add options to textlines
		m_textLines = new Vector();
		Vector allTextElements = new Vector();
		Enumeration optionsE = options.elements();
		int optionNum = 0;

		while (optionsE.hasMoreElements())
		{
			String curOpt = (String)optionsE.nextElement();
			FormatString(curOpt, m_width);

			Enumeration textElemEnum = m_textLines.elements();
			while (textElemEnum.hasMoreElements())
			{
				allTextElements.addElement(textElemEnum.nextElement());
				m_lineToOption.addElement(new Integer(optionNum - (hasTitle ? 1 : 0)));

				if (hasTitle && (optionNum == 0))
				{
					m_NumTitleRows++;
				}
			}

			optionNum++;
		}

		m_textLines = allTextElements;
		m_NumOptions = options.size() - (hasTitle ? 1 : 0);

		int updatedSelection = m_selectionState;

		// get the first available option
		do
		{
			if ( (disabledOptions == null) ||
				 !disabledOptions.contains(new Integer(updatedSelection) ) )
			{
				break;
			}

			updatedSelection++;

			if (updatedSelection >= m_NumOptions)
			{
				updatedSelection = 0;
			}

		} while (updatedSelection != m_selectionState);

		m_selectionState = updatedSelection;

		SetType(type);
		m_buttonType = BUTTONS_SELECTION;
		m_isModal = true;
		m_x = m_borderSpacing;
		m_y = m_borderSpacing;

		m_image = image;
		m_imageActive = image != null;

		m_disabledOptions = disabledOptions;
		m_displayFlags = displayFlags;

		AutoSize();

	}

	/**
	 * Short constructor that uses Style defaults for spacing and BG colors
	 *
	 * @param phrase
	 * @param drawBox
	 * @param xPos
	 * @param yPos
	 */
	public Dialogue(String phrase, boolean drawBox, int xPos, int yPos, int displayFlags)
	{
		this( (String)null, phrase, drawBox, xPos, yPos, SKUConsts.ISO_VIEW_WIDTH, 0,
						Style.DIALOGUE_SPACER, Style.DIALOGUE_BORDER_SPACER,
						Style.DIALOGUE_MAIN_TEXT_COLOR, Style.LIST_COLOR_BG, displayFlags, true, true);
	}

	/**
	 * Short constructor that uses Style defaults for spacing
	 *
	 * @param phrase
	 * @param drawBox
	 * @param xPos
	 * @param yPos
	 * @param textColor
	 */
	public Dialogue(String phrase, boolean drawBox, int xPos, int yPos, int textColor, int displayFlags)
	{
		this( (String)null, phrase, drawBox, xPos, yPos, SKUConsts.ISO_VIEW_WIDTH, 0,
						Style.DIALOGUE_SPACER, Style.DIALOGUE_BORDER_SPACER, textColor,
						Style.LIST_COLOR_BG, displayFlags, true, true);
	}

	/**
	 * Major Constructor so the box (visible/invisible) can be completely customized
	 * @param imageName
	 * @param phrase
	 * @param drawBox
	 * @param xPos
	 * @param yPos
	 * @param width
	 * @param height
	 * @param lineSpacing
	 * @param borderSpacing
	 * @param textColor
	 * @param bgColor
	 * @param useBack TODO
	 * @param useSelect TODO
	 */
	public Dialogue(String imageName, String phrase, boolean drawBox, int xPos, int yPos, int width,
					int height, int lineSpacing, int borderSpacing, int textColor, int bgColor, int displayFlags, boolean useBack, boolean useSelect)
	{
		m_UseBack = useBack;
		m_UseSelect = useSelect;
		//Debug.println("new custom dialog: " + phrase + " [x=" + xPos + " y=" + yPos + " h=" + height + " w=" + width + "]", //Debug.CHAN_UI);
//		m_characterName = imageName;
		m_phrase = phrase;
		if (height != 0)
			m_autoSize = false;
		m_x = xPos;
		m_y = yPos;
		m_width = width;
		m_height = height;
		m_textColor = textColor;
		m_font = DIALOGUE_FONT;

		// set up box specific defaults
		m_bgColor = bgColor;
		m_lineSpacing = lineSpacing;
		m_borderSpacing = borderSpacing;
		m_imageName = imageName;
		m_displayFlags = displayFlags;

		if (drawBox)
		{
			m_BoxType = DialogueStyles.GRAPHIC_BOX;
		}

		DoLayout();

		// change the x position if the horizontal center is set
		if ( (displayFlags & Graphics.HCENTER) != 0)
		{
			m_textX = (m_width / 2);
		}
		else
		{
			m_textX = m_x;
		}

		return;

	} // end major constructor

	public static void LoadStaticImages()
	{
		if (s_imagesLoaded)
			return;

		s_ArrowImages = new ImageStrip(34795, 0, false);
		s_DialogueImages = new ImageStrip(34796, 0, false);

		s_imagesLoaded = true;
	}

	/**
	 * Create a new modal dialgue with the given button type and set it
	 * as the current static dialogue;
	 */
	public static Dialogue CreateModalDialogue(String message, int buttonType)
	{
		Dialogue dialog = new Dialogue(message);
		dialog.m_buttonType = buttonType;
		dialog.m_isModal = true;
		dialog.InitText(message);
		SetStaticDialogue(dialog, -1);
		return dialog;
	}

	/**
	 * Create a new modal dialgue with the given button type and set it
	 * as the current static dialogue;
	 * @param useBack TODO
	 * @param useSelect TODO
	 */
	public static Dialogue CreateModalDialogue(String message, int buttonType, int boxType, boolean useBack, boolean useSelect)
	{
		Dialogue dialog = new Dialogue(message, useBack, useSelect);
		dialog.m_buttonType = buttonType;
		dialog.m_isModal = true;
		dialog.SetType(boxType);
		dialog.InitText(message);
		SetStaticDialogue(dialog, -1);
		return dialog;
	}


	/**
	 * Display a dialogue (subsequent calls will interrupt this)
	 *
	 * @param dialogue The dialogue to display
	 * @param ttl How many milliseconds to keep dialog in screen. -1 means forever
	 */
	public static void SetStaticDialogue(Dialogue d, int ttl)
	{
		//Debug.println("SetStaticDialogue: " + d.m_phrase + " [" + ttl + "]", //Debug.CHAN_UI);
		s_dialogue = d;
		if (ttl == -1)
			s_dialogueCloseTime = -1;
		else
			s_dialogueCloseTime = System.currentTimeMillis() + ttl;
		s_dialogueActive = true;
	}

	// Just the paint function.
	public static void PaintStaticDialogue(Graphics g)
	{
		// Draw visible
		if (s_dialogueActive)
		{
			s_dialogue.Paint(g);
		}
	}

	/** Paints the static dialogue */
	public static void UpdateStaticDialogue(/*Graphics g*/)
	{
//		if (s_ErrorDialogue != null)
//		{
//			if (Dialogue.s_dialogue != s_ErrorDialogue)
//			{
//				s_PreviousDialogue = s_dialogue;
//				SetStaticDialogue(s_ErrorDialogue, -1);
//			}
//		}

	    // Recalculate visibility
		if (s_dialogueActive && s_dialogueCloseTime != -1)
			s_dialogueActive = (System.currentTimeMillis() < s_dialogueCloseTime);

		// Draw visible
		if (s_dialogueActive)
		{
			if (s_dialogue.m_firstFrame)
				s_dialogue.m_firstFrame = false;
			else
				s_dialogue.Update();
//			s_dialogue.Paint(g);
		}
//		else if (s_ErrorDialogue != null)
//		{
//			//Debug.println("done dialogue");
//			s_ErrorDialogue = null;
//			if (s_PreviousDialogue != null)
//				SetStaticDialogue(s_PreviousDialogue, -1);
//		}
	}

	/**
	 * Automaitcally set size and position of the dialog
	 */
	public void AutoSize()
	{
		m_width = 2 * m_borderSpacing;
		int border = m_width;

		if (m_image != null)
		{
			border += m_image.getWidth();
		}

		for (int i = 0; i < m_textLines.size(); i++)
		{
			int width = m_font.stringWidth(m_textLines.elementAt(i).toString()) + border;

			if (m_width < width)
			{
				m_width = width;
			}
		}

		int imageHeight;

		if (m_image != null)
			imageHeight = (2 * m_borderSpacing) + m_image.getHeight();
		else
			imageHeight = (2 * m_borderSpacing);

		int height = (m_textLines.size() * (m_font.getHeight() + m_lineSpacing)) + (2 * m_borderSpacing) +4;
		height-=1;
		//#ifdef LINE_SPACING_FIX
//# 		height-=1;;
		//#endif

		// add image height
		switch (m_buttonType)
		{
			case BUTTONS_YESNO:
			case BUTTONS_CONFIRM:
				height += s_ArrowImages.GetHeight(ARROW_IMAGE_BUTTON_TICK);
				break;

			default:
				break;
		}

		if (height < imageHeight)
			height = imageHeight;

		if (m_height > height)
			m_height = height;

		m_x = SKUConsts.SCREEN_HALF_WIDTH - m_width / 2;
		m_y = (SKUConsts.SCREEN_HALF_HEIGHT - m_height / 2);

		if ( (SimsApp.s_MIDlet.m_CurrGameState == GameDefines.GAME_MODE_RUN_GAME) ||
			 (SimsApp.s_MIDlet.m_CurrGameState == GameDefines.GAME_MODE_OBJECT_DIALOG) )
		{
			m_y -= BUFFER_FOR_NEED_BAR;
		}

		// make sure we don't go above a certain point on the screen
		if (m_y < 0)
		{
			m_y = MIN_Y_POS;
		}

		// change the x position if the horizontal center is set
		if ( (m_displayFlags & Graphics.HCENTER) != 0)
		{
			if (m_BoxType != DialogueStyles.NO_BOX)
			{
				m_textX = (m_width / 2);
			}
			else
			{
				m_textX = SKUConsts.SCREEN_HALF_WIDTH;
			}
		}
		else
		{
			m_textX = m_x;
		}

		m_dirty = true;
	}

	/**
	 * Set the dialog position.
	 */
	public void Move(int x, int y)
	{
		m_x = x;
		m_y = y;
	}

	/**
	 * Get the slection that was made my the user.
	 * For YesNo dialogs this returns 1 for "yes", 0 for "no"
	 * For selection dialogs it returns the index into the vector
	 * or options.
	 */
	public int GetSelection()
	{
		if (m_selectionMade)
		{
			switch (m_buttonType)
			{
			case BUTTONS_SELECTION:
				int row = m_selectionState;
				return row;

			case BUTTONS_YESNO:
				return m_yesnoState ? 1 : 0;

			case BUTTONS_CONFIRM:
				return 1;
			}
		}
		return -1;
	}

	/**
	 * Set the dialog text and preform layout.
	 */
	public void InitText(String text)
	{
		m_phrase = text;
		SetDefaultValues();
		DoLayout();
		AutoSize();
		m_dirty = true;
	}

	/**
	 * Set the dialog text and preform layout.
	 */
	public void SetText(String text)
	{
		m_phrase = text;
		DoLayout();
		m_dirty = true;
	}

	/**
	 * Format the dialog text according to the current width.
	 * If the dialog is autosizable then the height will also be set,
	 * otherwise if the height of the dialog is too small it will become
	 * scrollable.
	 */
	public void DoLayout()
	{
		// a little error checking
		if (m_phrase == null)
		{
			//Debug.assertPrintln(false, "No string for this dialog");
		}

		// calculate text width
		m_imageActive = false;
	    int	text_width = m_width - (2 * m_borderSpacing);

		if (m_imageName != null && m_imageName.length() > 0 )
		{
			m_image = Utility.loadImage(m_imageName, false);


//			if (m_image == null)
				/*Debug.println("error loading image: " + m_imageName, Debug.CHAN_UI);
				 *
				 */
		}

		if (m_image != null)
		{
			m_imageActive = true;
			m_width += m_image.getWidth();
		}

		// calculate text height
		int new_height = FormatString(m_phrase, text_width);

		// add image height
		switch (m_buttonType)
		{
		case BUTTONS_YESNO:
		case BUTTONS_CONFIRM:
			new_height += s_ArrowImages.GetHeight(ARROW_IMAGE_BUTTON_TICK);
			break;

		case BUTTONS_NONE:
		case BUTTONS_SELECTION:
		default:
			break;
		}

		// resize or make scrollable
		if (m_autoSize)
		{
			if (new_height <= Dialogue.DIALOGUE_MAX_HEIGHT)
			{
				m_height = new_height;
			}
		    else
			{
				m_height = Dialogue.DIALOGUE_MAX_HEIGHT;
				m_isScrollable = true;
			}
		}

		if (m_height < new_height)
		{
			m_isScrollable = true;
		}

		//Debug.println("Dialog: DoLayout: lines=" + m_textLines.size() + " height=" + m_height + " width=" + m_width, //Debug.CHAN_UI);
		m_renderedImage = null;
	}

	/**
	 * Sets the default values that are used by the dialogue system
	 */
	public void SetDefaultValues()
	{
		m_x = 0;
		m_y = 0;
		m_autoSize = true;
		m_dirty = true;
		m_renderedImage = null;
		m_lineSpacing = Style.DIALOGUE_SPACER;
		m_width = Dialogue.DIALOGUE_MAX_WIDTH;
		m_height = Dialogue.DIALOGUE_MAX_HEIGHT;
		m_textColor = Style.DIALOGUE_TEXT_COLOR;
		m_font = DIALOGUE_FONT;
		return;

	} // end setDefaultValues

	public void DisableOption(int optionIndex)
	{
		m_disabledOptions.addElement(new Integer(optionIndex) );
	}

	/**
	 * Paint the text to the screen
	 *
	 * @param g the graphics object to paint with.
	 */
	public void Paint(Graphics g)
	{
		// if there is no box, then we draw directly to the screen
		if (m_BoxType != DialogueStyles.NO_BOX)
		{
			//#if FONT_FIX
//# //			if (m_dirty)
//# //			{
//# 				if (m_renderedImage == null)
//# 				{
//# 					m_renderedImage = Image.createImage(m_width, m_height);
//# 					g.drawImage(m_renderedImage, m_x, m_y, Graphics.TOP | Graphics.LEFT);
//# 				}
//#
//# 				g.translate( m_x, m_y );
//# 				Render(g);
//# 				g.translate( -m_x, -m_y );
//# 				m_dirty = false;
//# //			}
//#
//# 			//System.out.println("Image Render");
//# 			//g.drawImage(m_renderedImage, m_x, m_y, Graphics.TOP | Graphics.LEFT);
			//#else
			if (m_dirty)
			{
				if (m_renderedImage == null)
				{
					m_renderedImage = Image.createImage(m_width, m_height);
				}

				Render(m_renderedImage.getGraphics());
				m_dirty = false;
			}

			g.drawImage(m_renderedImage, m_x, m_y, Graphics.TOP | Graphics.LEFT);
			//#endif
		}
		else
		{
			Render(g);
		}
	}

	private void SetType(int type)
	{
		m_BoxType = type;

		switch (type)
		{
		case DialogueStyles.GRAPHIC_BOX:
			// set up box specific defaults
			m_borderSpacing = s_DialogueImages.GetHeight(0);
			m_bgColor = Style.DIALOG_COLOR_BG;
			break;

		case DialogueStyles.NO_BORDER_BOX:
			// This is still using a box so it will draw the text as if an invisible box surrounds it
			m_x = m_borderSpacing;
			m_y = m_borderSpacing;
			m_bgColor = Style.LIST_COLOR_BG;
			m_width = SKUConsts.SCREEN_WIDTH - (2 * m_borderSpacing);
			m_height = SKUConsts.SCREEN_HEIGHT - (2 * m_borderSpacing);
			break;

		default:
			m_bgColor = Style.LIST_COLOR_BG;
			break;
		}
	}

	/**
	 * Update the state of the dialog based on key inputs.
	 * This should only ever be called on the current static dialog.
	 */
	private void Update()
	{
		if (!m_isModal)
			return;

		SimsCanvas canvas = SimsCanvas.s_Canvas;
		int updatedSelection = m_selectionState;
		int numLines = (m_buttonType == BUTTONS_SELECTION) ? m_NumOptions : m_textLines.size();

		// First move an invalid selection.
		if (m_buttonType == BUTTONS_SELECTION)
		{
			if( m_disabledOptions != null &&
				m_disabledOptions.contains( new Integer(updatedSelection) ))
			{
				do
				{
					// Try the next entry.
					updatedSelection++;

					// Wrap.
					if (updatedSelection >= numLines)
						updatedSelection = 0;

				} while(m_disabledOptions.contains( new Integer(updatedSelection) ) &&
						updatedSelection != m_selectionState);

				m_dirty = true;
			}
		}

		// handle up/down
		if (canvas.getKeyPressed(SimsCanvas.UP) )
		{
			//Debug.println("Dialog: up", //Debug.CHAN_UI);

			if (m_isScrollable && m_scrollPosition > 0)
			{
				m_scrollPosition--;
				m_dirty = true;
			}

			if (m_buttonType == BUTTONS_SELECTION)
			{
				do
				{
					updatedSelection--;

					if (updatedSelection < 0)
					{
						updatedSelection = (numLines - 1);
					}

					if ( (m_disabledOptions == null) ||
						 !m_disabledOptions.contains(new Integer(updatedSelection) ) )
					{
						break;
					}

				} while (updatedSelection != m_selectionState);

				m_dirty = true;
			}
		}
		else if (canvas.getKeyPressed(SimsCanvas.DOWN) )
		{
			//Debug.println("Dialog: down", //Debug.CHAN_UI);

			if (m_isScrollable && m_scrollPosition < numLines)
			{
				m_scrollPosition++;
				m_dirty = true;
			}

			if (m_buttonType == BUTTONS_SELECTION)
			{
				do
				{
					updatedSelection++;

					if (updatedSelection >= numLines)
					{
						updatedSelection = 0;
					}

					if ( (m_disabledOptions == null) ||
						 !m_disabledOptions.contains(new Integer(updatedSelection) ) )
					{
						break;
					}

				} while (updatedSelection != m_selectionState);

				m_dirty = true;
			}
		}

		if (updatedSelection != m_selectionState)
		{
			m_prevSelectionState = m_selectionState;
			m_selectionState = updatedSelection;
		}

		// handle button inputs
		switch (m_buttonType)
		{
		case BUTTONS_YESNO:
			//if (!m_yesnoState)
			{
				if (canvas.getKeyPressed(SimsCanvas.RIGHT) )
				{
					m_yesnoState = false;
					m_dirty = true;
				}
			}
			//else
			{
				if (canvas.getKeyPressed(SimsCanvas.LEFT) )
				{
					m_yesnoState = true;
					m_dirty = true;
				}
			}
			// deliberate lack for "break" here
		case BUTTONS_SELECTION:
		case BUTTONS_CONFIRM:
		case BUTTONS_NONE:
			if ( (canvas.getKeyPressed(SimsCanvas.FIRE) ) ||
				 (canvas.getKeyPressed(SimsCanvas.ACCEPT) ) ||
				 (canvas.getKeyPressed(SimsCanvas.BACK) ) )
			{
				if( (!canvas.getKeyPressed(SimsCanvas.BACK) || m_UseBack) &&
					(!canvas.getKeyPressed(SimsCanvas.ACCEPT) || m_UseSelect) &&
					(!canvas.getKeyPressed(SimsCanvas.FIRE) || m_UseSelect) )
				{
					s_dialogueActive = false;

					if (!canvas.getKeyPressed(SimsCanvas.BACK) )
					{
						m_selectionMade = true;
					}
				}
			}
			break;
		}
	}

	private void RenderBox(Graphics g, int x, int y)
	{
		int border_size = s_DialogueImages.GetHeight(0);
		g.setColor(m_bgColor);
		g.fillRect(x + border_size, y+border_size, m_width-2*border_size, m_height-2*border_size);

		// draw sides
		int n_top_tiles = (m_width - border_size) / border_size;
		int n_side_tiles = (m_height - border_size) / border_size;
		int xPos = x + border_size;
		int yPos = y + border_size;
		int right = y + m_height - border_size;
		int bottom = x + m_width - border_size;
		for (int i = 0; i < n_top_tiles; i++)
		{
			s_DialogueImages.Draw(g, 1, xPos, y, true, Graphics.TOP | Graphics.LEFT);
			s_DialogueImages.Draw(g, 6, xPos, right, true, Graphics.TOP | Graphics.LEFT);
			xPos += border_size;
		}

		for (int i = 0; i < n_side_tiles; i++)
		{
			s_DialogueImages.Draw(g, 3, x, yPos, true, Graphics.TOP | Graphics.LEFT);
			s_DialogueImages.Draw(g, 4, bottom, yPos, true, Graphics.TOP | Graphics.LEFT);
			yPos += border_size;
		}

		// draw corners
		s_DialogueImages.Draw(g, 0, x, y, true, Graphics.TOP | Graphics.LEFT);
		s_DialogueImages.Draw(g, 2,  x + m_width - border_size, y, true, Graphics.TOP | Graphics.LEFT);
		s_DialogueImages.Draw(g, 5, x, y + m_height - border_size, true, Graphics.TOP | Graphics.LEFT);
		s_DialogueImages.Draw(g, 7, x + m_width - border_size, y + m_height - border_size, true, Graphics.TOP | Graphics.LEFT);

	}

	/**
	 * Render the dialog box to the graphics context.
	 */
    private void Render(Graphics g)
	{
		int x = m_x;
		int y = m_y;
		long start;

		if (m_BoxType != DialogueStyles.NO_BOX)
		{
//			if (//Debug.ENABLED)
//			{
//				start = System.currentTimeMillis();
//			}

			x = 0;
			y = 0;
		}

	  	int textX = x + m_borderSpacing;
	  	int textY = y + m_borderSpacing;

		if (m_BoxType == DialogueStyles.GRAPHIC_BOX)
		{
			RenderBox(g, x, y);
		}
		else if (m_BoxType == DialogueStyles.GRAPHIC_BOX)
		{
			g.setColor(m_bgColor);
			g.fillRect(x, y, m_width, m_height);
			g.setColor(m_textColor);
			g.drawRect(x, y, m_width, m_height);
		}
		else if (m_BoxType == DialogueStyles.NO_BORDER_BOX)
		{
			g.setColor(m_bgColor);
			g.fillRect(x, y, m_width, m_height);
		}

		if (m_imageActive)
		{
			g.drawImage(m_image, textX, textY, Graphics.TOP | Graphics.LEFT);
			textX += m_image.getWidth();
		}

		g.setFont(m_font);


		//test
		//g.drawString(m_textLines.elementAt(0).toString(), 0, yPos, m_displayFlags);
		//g.setColor(0x000000);
		//g.drawString("This is the string that never ends", 0, 10, 0);

		g.setColor(m_textColor);
		int fontHeight = m_font.getHeight();
		fontHeight-=1;
		//#ifdef LINE_SPACING_FIX
//# 		fontHeight-=1;;
		//#endif

		// how many text lines can we fit in the dialog
		int text_height = (m_height - 2*m_borderSpacing);

		// draw buttons, if any.
		int right = x + m_width - BUTTON_BORDER;
		int bottom = y + m_height - BUTTON_BORDER;
		int left = x + BUTTON_BORDER;
		int top = y + BUTTON_BORDER;
		boolean has_buttons = false;
		int button_height = s_ArrowImages.GetHeight(ARROW_IMAGE_BUTTON_TICK_HIGHLIGHT);

		switch (m_buttonType)
		{
		case BUTTONS_NONE:
			break;

		case BUTTONS_CONFIRM:
			s_ArrowImages.Draw(g, ARROW_IMAGE_BUTTON_TICK_HIGHLIGHT, left, bottom - button_height, false, 0);
			text_height -= button_height;
			has_buttons = true;
			break;

		case BUTTONS_YESNO:
			int right_image;
			int left_image;
			if (m_yesnoState)
			{
				right_image = ARROW_IMAGE_BUTTON_CROSS;
				left_image = ARROW_IMAGE_BUTTON_TICK_HIGHLIGHT;
			}
			else
			{
				right_image = ARROW_IMAGE_BUTTON_CROSS_HIGHLIGHT;
				left_image = ARROW_IMAGE_BUTTON_TICK;
			}

			s_ArrowImages.Draw(g, right_image, right - s_ArrowImages.GetHeight(right_image), bottom - button_height, false, 0);
			s_ArrowImages.Draw(g, left_image, left, bottom - button_height, false, 0);

			text_height -= button_height;
			has_buttons = true;
			break;

		case BUTTONS_SELECTION:
			g.setColor(Colors.BLUE);
			break;

		default:
			//Debug.println("bad buttonType: " + m_buttonType);
		}

		// handle scolling
		if (!m_isScrollable && m_textLines.size() * fontHeight + 2 * m_lineSpacing > m_height)
			m_isScrollable = true;

		int first_line = 0;
		int lines = text_height / (fontHeight + m_lineSpacing);

		// calculate scroll offset
		if (m_isScrollable)
		{
			int maxScroll = m_textLines.size() - lines;
			if (m_scrollPosition > maxScroll)
				m_scrollPosition = maxScroll;
			if (m_scrollPosition < 0)
				m_scrollPosition = 0;
			first_line = m_scrollPosition;

			// paint scroll arrows
			int arrow_h = s_ArrowImages.GetHeight(ARROW_IMAGE_DOWN_ARROW) - 1;
			//#ifdef LARGE
			arrow_h -= 1;
			//#elif Nextel
//# 			arrow_h -= 5;
//# 			top -= 5;
			//#endif
			int arrow_w = s_ArrowImages.GetWidth(ARROW_IMAGE_DOWN_ARROW);
			//int numLines = (m_buttonType == BUTTONS_SELECTION) ? m_NumOptions : m_textLines.size();

            int arrowYOffset = (m_BoxType != DialogueStyles.NO_BOX) ? -2 : 5;
			s_ArrowImages.Draw(g,
					(m_scrollPosition < maxScroll) ? ARROW_IMAGE_DOWN_ARROW : ARROW_IMAGE_DOWN_ARROW_HOLLOW,
					x + m_width/2 - arrow_w/2, bottom - arrow_h + arrowYOffset, true, 0);
			s_ArrowImages.Draw(g,
					(m_scrollPosition > 0) ? ARROW_IMAGE_UP_ARROW : ARROW_IMAGE_UP_ARROW_HOLLOW,
					x + m_width/2 - arrow_w/2, top, true, 0);

			text_height -= arrow_h;
			textY += arrow_h;
			if (!has_buttons)
				text_height -= arrow_h;
		}

		////Debug.println("Dialog: drawing maxlines: " + lines + " height=" + m_height + " fontheight=" + fontHeight + " border=" + m_borderSpacing + " drawable=" + (m_height - 2*m_borderSpacing), //Debug.CHAN_UI);

		if ( (m_displayFlags & Graphics.HCENTER) != 0)
		{
			textX = m_textX;
		}



		// draw the text lines
		for (int row = first_line; row < m_textLines.size() && row - first_line < lines; row++)
		{
			int yPos = textY + ((row - m_scrollPosition) * (fontHeight + m_lineSpacing));

			if (m_textColor != Colors.BLACK)
			{
				g.setColor(Colors.BLACK);
				g.drawString(m_textLines.elementAt(row).toString(), (textX + GameDefines.DROP_SHADOW_OFFSET),
								(yPos + GameDefines.DROP_SHADOW_OFFSET), m_displayFlags);
			}

			if (row < m_NumTitleRows)
			{
				g.setColor(m_textColor);
			}
			else if ( (m_buttonType == BUTTONS_SELECTION) &&
					  ( ( (Integer)m_lineToOption.elementAt(row) ).intValue() == m_selectionState) &&
					  ( (m_disabledOptions == null) ||
					    (!m_disabledOptions.contains(new Integer(m_selectionState) ) ) ) )
			{
				g.setColor(Style.LIST_COLOR_TEXT_SELECTED);
			}
			else if ( (m_buttonType == BUTTONS_SELECTION) &&
					  (m_disabledOptions != null) &&
					  (m_disabledOptions.contains(m_lineToOption.elementAt(row) ) ) )
			{
				g.setColor(Style.LIST_COLOR_TEXT_DISABLED);
			}
			else
			{
				g.setColor(m_textColor);
			}

			g.drawString(m_textLines.elementAt(row).toString(), textX, yPos, m_displayFlags);
		}

		g.setColor(Colors.BLUE);

		if ( //Debug.ENABLED &&
			 (m_BoxType != DialogueStyles.NO_BOX))
		{
			//Debug.println("Dialogue: Render " + (System.currentTimeMillis() - start), //Debug.CHAN_UI);
		}

	} // end Render

	/**
	 * Formats the string for display and returns the required height of
	 * the dialog.
	 *
	 * @param s the string to format
	 * @param width of the dialog.
	 * @return the new required height for the dialogue.
	 */
	private int FormatString(String s, int width)
	{
		StringBuffer tempString = new StringBuffer("");
		m_textLines.removeAllElements();
		int font_height = m_font.getHeight();
		font_height-=1;
		//#ifdef LINE_SPACING_FIX
//# 		font_height-=1;;
		//#endif
		int new_height = (2 * m_borderSpacing) + font_height + m_lineSpacing;

		// If wrapping not required
		if (m_font.stringWidth(s) < width)
		{
			m_textLines.addElement(s);
			return new_height;
		}

		// Encode text to protect French wrapping
		s = Utility.ProcessStringAgainstWrappingForFrench(s, true);

		Vector words = Utility.TokenizeString(s, ' ');
		for (int i = 0; i < words.size(); i++)
		{
			Object elem = words.elementAt(i);
			if (elem == null)
			{
				// Get string from current line processed (but decode against French wrapping)
				String newString = Utility.ProcessStringAgainstWrappingForFrench(tempString.toString(), false);
				m_textLines.addElement(newString);
				new_height += font_height + m_lineSpacing;
				tempString.delete(0, tempString.length());
				continue;
			}

			String word = (String) elem;

			if ( !word.equals("\n ") &&
				 (m_font.stringWidth(tempString.toString() + word) < width) )
			{
				tempString.append(word);
			}
			else
			{
				// Get string from current line processed (but decode against French wrapping)
				String newString = Utility.ProcessStringAgainstWrappingForFrench(tempString.toString(), false);
				m_textLines.addElement(newString);
				new_height += font_height + m_lineSpacing;
				tempString.delete(0, tempString.length());

				if (!word.equals("\n ") )
				{
					tempString.append(word);
				}
			}
		}

		// Get string from current line processed (but decode against French wrapping)
		String newString = Utility.ProcessStringAgainstWrappingForFrench(tempString.toString(), false);
		m_textLines.addElement(newString);
		return new_height;

	} // end formatString

	public final static int ARROW_IMAGE_POINTER = 0;
	public final static int ARROW_IMAGE_OBJ_POINTER = 1;
	public final static int ARROW_IMAGE_OBJ_POINTER_HOLLOW = 2;
	public final static int ARROW_IMAGE_UP_ARROW_HOLLOW = 3;
	public final static int ARROW_IMAGE_DOWN_ARROW_HOLLOW = 4;
	public final static int ARROW_IMAGE_LEFT_ARROW_HOLLOW = 5;
	public final static int ARROW_IMAGE_RIGHT_ARROW_HOLLOW = 6;
	public final static int ARROW_IMAGE_UP_ARROW = 7;
	public final static int ARROW_IMAGE_DOWN_ARROW = 8;
	public final static int ARROW_IMAGE_LEFT_ARROW = 9;
	public final static int ARROW_IMAGE_RIGHT_ARROW = 10;
	public final static int ARROW_IMAGE_BUTTON_TICK = 11;
	public final static int ARROW_IMAGE_BUTTON_TICK_HIGHLIGHT = 12;
	public final static int ARROW_IMAGE_BUTTON_CROSS = 13;
	public final static int ARROW_IMAGE_BUTTON_CROSS_HIGHLIGHT = 14;

	public static final Font FONT_MONO_SMALL =
		Font.getFont(Font.FACE_MONOSPACE, Font.STYLE_PLAIN, Font.SIZE_SMALL);
	public static final Font FONT_MONO_MEDIUM =
		Font.getFont(Font.FACE_MONOSPACE, Font.STYLE_PLAIN, Font.SIZE_MEDIUM);

	public static final Font FONT_PROP_SMALL =
		Font.getFont(Font.FACE_PROPORTIONAL, Font.STYLE_PLAIN, Font.SIZE_SMALL);
	public static final Font FONT_PROP_MEDIUM	=
		Font.getFont(Font.FACE_PROPORTIONAL, Font.STYLE_PLAIN, Font.SIZE_MEDIUM);

	public static final Font FONT_SYS_SMALL =
		Font.getFont(Font.FACE_SYSTEM, Font.STYLE_PLAIN, Font.SIZE_SMALL);
	public static final Font FONT_SYS_MEDIUM =
		Font.getFont(Font.FACE_SYSTEM, Font.STYLE_PLAIN, Font.SIZE_MEDIUM);

	// Font sets
	public static final Font START_MENU_FONT = Dialogue.FONT_PROP_SMALL;

	//#ifdef LARGE
		//#ifdef Samsung
//# 			public static final Font DIALOGUE_FONT = Dialogue.FONT_PROP_MEDIUM;
		//#else
		public static final Font DIALOGUE_FONT = Dialogue.FONT_PROP_SMALL;
		//#endif
	//#else
//# 	public static final Font DIALOGUE_FONT = Dialogue.FONT_PROP_SMALL;
	//#endif


//	public static final Font START_MENU_FONT =
//		(SKUConsts.SCREEN_WIDTH < 200) ? Dialogue.FONT_PROP_MEDIUM : Dialogue.FONT_PROP_SMALL;
//
//	public static final Font DIALOGUE_FONT =
//		(SKUConsts.SCREEN_WIDTH < 200) ? Dialogue.FONT_PROP_MEDIUM : Dialogue.FONT_PROP_SMALL;

	public static final int 	BUTTONS_NONE      = 0;
	public static final int 	BUTTONS_CONFIRM   = 1;
	public static final int 	BUTTONS_YESNO     = 2;
	public static final int 	BUTTONS_SELECTION = 3;

	public static final int 	DIALOGUE_MAX_WIDTH = (int)(SKUConsts.SCREEN_WIDTH * 0.8);
	/** Maximum height of a dialog */
	public static final int 	DIALOGUE_MAX_HEIGHT = (int)(SKUConsts.SCREEN_HEIGHT * 0.7);

	private static final int 	BUFFER_FOR_NEED_BAR = (43 / 2);
	private static final int 	MIN_Y_POS 			= 8;
	private static final int 	BUTTON_BORDER 		= 6;

	// All used to govern the statically held dialogue
	/** Maximum width of a dialog */
	public static Dialogue 		s_dialogue;
	public static boolean 		s_dialogueActive;

	// common images
	public static boolean 		s_imagesLoaded;
	public static ImageStrip 	s_ArrowImages;

	private static ImageStrip 	s_DialogueImages;
	private static long 		s_dialogueCloseTime;

	public String 	m_imageName;
	public Font 	m_font;
	public boolean 	m_isModal;
	public boolean 	m_dirty = true;
	public boolean 	m_autoSize = true;
	public int 		m_x;
	public int 		m_y;
	public int 		m_textX;
	public int 		m_width;
	public int 		m_height;
	public int 		m_textColor;
	public int 		m_bgColor;
	public int 		m_imageGuId;
	public int 		m_lineSpacing;
	public int 		m_buttonType;
	public int 		m_selectionState;
	public int		m_prevSelectionState;
	public Vector 	m_textLines = new Vector();

	private Vector 	m_disabledOptions;
	private Vector 	m_lineToOption = new Vector();	/** Map text line to option */
	private Image 	m_image;
	private Image 	m_renderedImage;
	private String 	m_phrase = "";
	private boolean m_isScrollable;
	private boolean m_yesnoState;
	private boolean m_selectionMade;
	private boolean m_imageActive;
	private boolean m_firstFrame = true;
	private boolean m_UseBack;
	private boolean m_UseSelect;
	private int		m_BoxType;
	private int 	m_scrollPosition;
	private int 	m_NumOptions;
	private int 	m_NumTitleRows;
	private int 	m_borderSpacing;
	private int 	m_displayFlags = (Graphics.TOP | Graphics.LEFT);
}
