package sims2;



/* Copyright Ideaworks3D Ltd. 2005 */







//import java.io.IOException;

import java.util.Enumeration;

import java.util.Hashtable;

import java.util.Vector;



import javax.microedition.lcdui.Font;

import javax.microedition.lcdui.Graphics;





//import com.ideaworks3d.debug.Debug;





/**

 * A "do all" class for the isometric world.

 * Refactor when it gets too big to understand.

 */

public class House extends IsoMap

{



	/** Static constructor to create singleton */

	public static final void CreateLot(int guid, int lotNum, int layoutGuid, MapTileSet tileset/*, BlockUi blockui*/)

	{

		//Debug.println("Initialising Lot...", //Debug.CHAN_CORE);

		s_LotSingleton = new House(guid, lotNum, layoutGuid, /*stateGuid,*/ tileset/*, blockui.GetPlayerSimInfo()*/);

		//Debug.println("Finished initialising Lot", //Debug.CHAN_CORE);

	}



	/*public static void LoadResources()

	{

		// Load the house data.

		Utility.readGlobalDataChunk("/global_data/house_data");



		// Load the objects data.

		Utility.readGlobalDataChunk("/global_data/objects_data");

	}*/



	// Replaced by generic global resource code.

//	private static Vector s_HouseData;

//	private static Vector s_ObjectsData;

//	private static Vector s_HouseFiles;

//	private static Vector s_ObjectsFiles;



	/** Constructor (private to prevent non-singleton construction)

	 * @throws IOException*/

	private House(int guid, int lotNum, int layout_guid, /*int state_guid,*/ MapTileSet tileset/*, SimInfo player*/)

	{

		// Load the IsoMap data and hand on.

		super(guid, tileset, lotNum);



		m_LotNum = lotNum;



		m_Guid = guid;

		m_LayoutGuid = layout_guid;



		// Acquire render buffer

		//Debug.println("Aquiring render buffer", //Debug.CHAN_CORE);

		acquire(SKUConsts.ISO_VIEW_WIDTH / 8, SKUConsts.ISO_VIEW_HEIGHT / 8);



		// Initialise data members

		//Debug.println("Setting internal state", //Debug.CHAN_CORE);

		m_ScrollX = 0;

		m_ScrollY = 0;

		m_Items = new Hashtable();

//START:itemsPositions#

		itemsPositions = new Object[MAX_MAP_DIMENSION][MAX_MAP_DIMENSION];

//END



		// Set default control method

		m_trackToPointerNotPlayer = false;



		// initialize the arrow sprite objects

		//Debug.println("Loading ui gfx", //Debug.CHAN_CORE);

		LoadArrows();



		// Load the scripted objects

		LoadScriptedObjects();



		//Debug.println("Done lot construction", //Debug.CHAN_CORE);

	}



	/**

	 * Add an EdithObject to the Lot

	 * @param eObject EdithObject object to add

	 */

	public boolean AddObject(EdithObject eObject)

	{

		int[] topPos = eObject.GetTopPos();

		int[] size = eObject.GetDimensions();

		//Debug.println("adding object: ", //Debug.CHAN_EDITH_OBJECT);

		eObject.PrintInfo();



		// HACK HACK HACK, painting shouldn't really occupy the wall they

		// hang on.

		// if it is not a painting and  the tile isn't free exit

		if (!CanGo(eObject, topPos[0], topPos[1], true) )

		{

			//Debug.println("tile isn't free for object placement: " + eObject.m_GuId, //Debug.CHAN_CORE);

			return false;

		}



		// HACK HACK HACK: now check for portals

		// (moved this here, as other objects need to be able to walk through portals)

		if (eObject.m_InstanceId != 16)

			for (int x = 0; x < size[0]; x++)

				for (int y = 0; y < size[1]; y++)

					if (isPortal(topPos[0]+x, topPos[1]+y))

					{

						//Debug.println("tried to place object on portal: " + eObject.m_GuId, //Debug.CHAN_CORE);

						return false;

					}



		for (int x = 0; x < size[0]; x++)

			for (int y = 0; y < size[1]; y++)

				itemsPositions[topPos[0]+x][topPos[1]+y] = eObject;



		// add the object to the world

		m_Items.put(new Integer(eObject.m_GuId), eObject);



		// Add to iso world

		if (DISPLAY_OBJECTS)

			eObject.AddToMap(this);



		// perhaps we should remove this, as all objects will need to be added to the map!

		if (eObject instanceof SimObject)

		{

			SimObject o = (SimObject)eObject;

			if (o.m_IsPlayer)

			{

				SimsApp.s_MIDlet.m_PlayerSim = o;



				// Move centre of view initially to player location

				CentreOnObject(SimsApp.s_MIDlet.m_PlayerSim);

			}

		}



		return true;



	} // end AddObject



	/**

	 * Remove an EdithObject from the Lot

	 *

	 * @param eObject

	 *          ItemObject object to remove

     * @return true iff object was found and removed from world

	 */

	public boolean RemoveObject(final EdithObject eObject)

	{

		int[] topPos = eObject.GetTopPos();

		int[] size = eObject.GetDimensions();

//		long start = System.currentTimeMillis();



		// clear all the collision slots

		// TODO: optimise this loop.

		for (int x = 0; x < size[0]; x++)

		{

			for (int y = 0; y < size[1]; y++)

			{

//START:IGNORE:debug print 1#

				//Debug.assertPrintln(itemsPositions[topPos[0]+x][topPos[1]+y] == eObject, "invalid collition data at: " + (topPos[0]+x) + ":" + (topPos[1]+y));

//END

				itemsPositions[topPos[0]+x][topPos[1]+y] = null;

			}

		}



		if (m_Items.remove(new Integer(eObject.m_GuId)) == null)

		{

			//Debug.println("attempt to remove unknown object: " + eObject.m_name, //Debug.CHAN_CORE);

			return false;

		}



		if (DISPLAY_OBJECTS)

		{

			eObject.RemoveFromMap(this);

		}

		return true;



	} // end removeItem



	/**

	 * Move an EdithObject on the Lot

	 *

	 * @param eObject

	 *          EdithObject to move

	 * @param oldX

	 *          old x

	 * @param oldY

	 *          old y

	 * @param overwrite

	 *          true if you want to overwrite an existing ItemObject that stays in the

	 *          new position

	 * @return true if the movement was done

	 */

	public boolean MoveObject(EdithObject eObject, int oldX, int oldY, boolean overwrite) // int oldZ,

	{

		Object[][] tempPositions;



		tempPositions = itemsPositions;



		boolean wasNull = (tempPositions[oldX][oldY] == null);



		tempPositions[oldX][oldY] = null;



		if (!wasNull)

		{

			if (overwrite != true)

			{

				if (tempPositions[eObject.GetXPos()][eObject.GetYPos()] == null)

				{

					tempPositions[eObject.GetXPos()][eObject.GetYPos()] = eObject;

					return true;

				}

				else

				{

					return false;

				}

			}

			else

			{

				tempPositions[eObject.GetXPos()][eObject.GetYPos()] = eObject;

			}



			return true;

		}

		else

		{

			return false;

		}



	} // end moveItem



	/**

	 * If there is a ItemObject in the x, y, z position of the Lot it returns its

	 * name. Return null if there is no item.

	 *

	 * @param x

	 *          x

	 * @param y

	 *          y

	 * @param z

	 *          z

	 * @return ItemObject name

	 */

	public EdithObject IsItem(int x, int y)

	{

		EdithObject eObject = (EdithObject)itemsPositions[x][y];

		return eObject;

	} // end isItem



	public void Draw(Graphics g)

	{

		// Draw isomap

		DrawTileMap(g);



		// draw the arrows

		RenderArrows(g);



		DrawDebugInfo(g);

	}



	private void DrawTileMap(Graphics g)

	{

		int MIN_SCROLL = 4;



		Enumeration enumeration;		// Used to process characters and items

		EdithObject curObject;	// Current object being drawn



		int[] worldPos;			// Position of current object



		// Render the tile map

		long start = 0;

		/*if (Debug.ENABLED)

		    start = System.currentTimeMillis();

*/

		if (m_firstFrame)

		{

			m_firstFrame = false;

			moveTo(m_ScrollX, m_ScrollY);

//START:IGNORE:debug print 2#

			//Debug.println("inital moveTo took " + (System.currentTimeMillis() - start) + "ms", //Debug.CHAN_CORE);

//END

		}

		else if (Math.abs(m_ScrollX-m_LastScrollX)>MIN_SCROLL || Math.abs(m_ScrollY-m_LastScrollY)>MIN_SCROLL)

		{

			scrollTo(m_ScrollX, m_ScrollY);

			m_LastScrollX = m_ScrollX;

			m_LastScrollY = m_ScrollY;

		}



		paint(g/*, SKUConsts.ISO_VIEW_X_POS, SKUConsts.ISO_VIEW_Y_POS*/);



		//if (Debug.ENABLED)

			//m_LastRenderTime = (int)(System.currentTimeMillis() - start);



		// Render the items

		enumeration = m_Items.elements();

		while (enumeration.hasMoreElements())

		{

			curObject = (EdithObject)enumeration.nextElement();



			// Only the player sim has these effects, so only do this with it

			// and not when it is at work

//			if (curObject instanceof SimObject)

			if ( (curObject == SimsApp.s_MIDlet.m_PlayerSim) &&

				 ( (SimsApp.s_MIDlet.m_GameFlags & GameDefines.GAME_FLAG_MASK_PLAYER_WORKING) == 0) )

			{

				// Convert to world position

				worldPos = Utility.GridToWorldCoords(curObject.GetXPos(), curObject.GetYPos());



				// Convert to screen position

				worldPos[0] -= m_ScrollX;

				worldPos[1] -= m_ScrollY;



				// Render

				((SimObject)curObject).DrawSimEffects(worldPos[0], worldPos[1], g);

			}

		}



		// Draw selection cursor if there's no highlight

		if(m_selectedObject == null)

		{

			final boolean EXACT_POSITIONING = false;

			int xPos;

			int yPos;



			if (EXACT_POSITIONING)

			{

				// Determine screen position of this grid pos

				int[] gridPos = GetScreenCenterGridPos();

				worldPos = Utility.GridToWorldCoords(gridPos[0], gridPos[1]);



				// Draw selection cursor here

				xPos = worldPos[0] - m_ScrollX;

				yPos = worldPos[1] - m_ScrollY + EdithObject.BIAS;

			}

			else

			{

				xPos = SKUConsts.ISO_VIEW_HALF_WIDTH;

				yPos = SKUConsts.ISO_VIEW_HALF_HEIGHT;

			}



			Dialogue.s_ArrowImages.Draw(g, Dialogue.ARROW_IMAGE_POINTER, xPos, yPos, false, 0);

		}

	}



	private void DrawDebugInfo(Graphics g)

	{

		int debugDrawY = 10;	// Position to draw next string



		// Render grid location

		if (GameDefines.DEBUG_COORDINATES)

		{

			int[] gridLoc = GetScreenCenterGridPos();

			String gridLocStr = "(" + gridLoc[0] + "," + gridLoc[1] + ")";



			g.setColor(0xffff0000);

			g.drawString(gridLocStr, SKUConsts.SCREEN_WIDTH - 10, debugDrawY,

							Graphics.TOP | Graphics.RIGHT);

			debugDrawY += g.getFont().getHeight();

		}



		// Render path finding information (disabled for now)

		/*if (false)

		{

			int[] gridLoc = GetScreenCenterGridPos();



			String sectorStr;

			try

			{

				sectorStr = String.valueOf(getSector(gridLoc[0],  gridLoc[1]));

			}

			catch (Exception ex)

			{

				sectorStr = "(can't)";

			}

			g.drawString(sectorStr, SKUConsts.SCREEN_WIDTH - 10, 30,

							Graphics.TOP | Graphics.RIGHT);



			try

			{

				Node node = Node.CreatePortalNode(null, gridLoc[0], gridLoc[1]);



					astar.Node[] succ = node.createSuccessors();



					sectorStr = "";

					for (int i = 0;  i < succ.length; i++)

					{

						sectorStr += ((PortalNode)succ[i]).GetId() + ",";

					}





				byte[] portals = getPortals(getSector( gridLoc[0],  gridLoc[1]));



				sectorStr = "";

				for (int i = 0;  i < portals.length; i++)

				{

					sectorStr += portals[i] + ",";

				}

			}

			catch (Exception ex)

			{

				sectorStr = "(can't)";

			}

			g.drawString(sectorStr, SKUConsts.SCREEN_WIDTH - 10, 50,

							Graphics.TOP | Graphics.RIGHT);

		}*/

	}



	/**

	 * Determin whether or not an object if placable at the given location.

	 * @return true if there is nothing stopping the object being placed.

	 */

	private boolean CanGo(final EdithObject eObject, int xPos, int yPos, boolean freeSpace)

	{

//		//Debug.println("CanGo: Checking " + xPos + ", " + yPos);



//START:IGNORE:CanGo#

		int[] size = null;

		if(eObject != null)

			size = eObject.GetDimensions();

		else

			size = new int[] {1, 1};

//END



		for (int x = 0; x < size[0]; x++)

		{

			for (int y = 0; y < size[1]; y++)

			{

				if (IsSpaceOccupied(xPos+x, yPos+y))

				{

					if(!freeSpace)

					{

						// //Debug.println("CanGo: returning false");

						return false;

					}

					else if(!FreeLocation(xPos+x, yPos+y))

					{

						return false;

					}



				}

			}

		}

//		//Debug.println("CanGo: returning true");

		return true;



	} // end canGo



	private boolean FreeLocation(int xPos, int yPos)

	{

		EdithObject eObject = IsItem(xPos, yPos);

		if(eObject instanceof SimObject)

		{

			int[] emptyCell = FindNearestEmptyCell(xPos, yPos, eObject);

			((SimObject) eObject).SetXPos(emptyCell[0]);

			((SimObject) eObject).SetYPos(emptyCell[1]);

			return MoveObject(eObject,  xPos, yPos, false);

		}



		return false;

	}



	/**

	 * Returns the closest empty cell to the start position

	 *

	 * @param startPos	Grid position to start looking

	 * @return					Nearest empty cell position (can be this one)

	 */

	public int[] FindNearestEmptyCell(int startX, int startY, EdithObject eObject)

	{

		java.util.Vector toExplore;		// Cells that we want to examine

		java.util.Hashtable explored;	// Cells that have been explored (avoid duplication)



		Integer currentCell;			// Points to an empty cell, if found



		// Initialise search variables

		toExplore = new java.util.Vector();

		explored = new java.util.Hashtable();



		// If the start position is one the board then add it to the exploration list

		if (IsSpaceInWorld(startX, startY))

			toExplore.addElement(new Integer((startX << 16) + startY));



		// While we haven't found an empty cell and there are still cells to explore

		while (true)

		{

			//Debug.debugAssert(toExplore.size() > 0);



			// Get first unexplored cell

			do

			{

				currentCell = ((Integer)toExplore.elementAt(0));

				toExplore.removeElementAt(0);

			} while(explored.get(currentCell) != null);



			int currentXY = currentCell.intValue();

			int currentX = currentXY >> 16;

			int currentY = currentXY & 0xffff;



			// If this cell is empty

			if (CanGo(eObject, currentX, currentY, false))

			{

				// return empty cell

				return new int [] { currentX, currentY };

			}

			else // Current cell not empty

			{

				// Determine children

				if (IsSpaceInWorld(currentX-1, currentY))

					toExplore.addElement(new Integer (currentXY - 0x10000));

				if (IsSpaceInWorld(currentX+1, currentY))

					toExplore.addElement(new Integer (currentXY + 0x10000));

				if (IsSpaceInWorld(currentX, currentY-1))

					toExplore.addElement(new Integer (currentXY - 0x1));

				if (IsSpaceInWorld(currentX, currentY+1))

					toExplore.addElement(new Integer (currentXY + 0x1));



				// Add cell to explored list

				explored.put(currentCell, currentCell);

			}

		}

	} // end findNearestEmptyCell



	/**

	 * Takes a tile point in the world and returns the name of the object at that point

	 * It returns null if there is no object

	 *

	 * @param x - world X position

	 * @param y - world Y position

	 *

	 * @return String - name of object or null if no object is at the tile

	 */

	public EdithObject ObjectAtGridPos(int x, int y)

	{

		if (!IsSpaceInWorld(x, y))

			return null;



	    EdithObject	eObject = IsItem(x, y);

		return eObject;

	} // end objectAtGridPos



	/**

	 * Update the state of the board

	 *

	 * @param millis	Time elapsed since last update

	 */

	public final void Update(final int millis)

	{

		UpdateKeyHandling(millis);

		UpdateToolTip(millis);

		UpdateSelectionToolTip(millis);



		// Track to pointer if flag enabled

		if (!m_trackToPointerNotPlayer)

		{

			CentreOnObject(SimsApp.s_MIDlet.m_PlayerSim);

		}

	}



	/**

	 * Update the key handling

	 *

	 * @param millis	Time elapsed since last update

	 */

	private final void UpdateKeyHandling(final int millis)

	{

		boolean inputEnabled = true;	// True if input is enabled and should be processed

		boolean inputEnabled2;			// True if input is enabled and should be processed

		// Disable input inwhen the player is in autopilot

		// or when menus are open.

		if (/*(keys.GetUIMenus().IsInUse() &&

			keys.GetUIMenus().IsControllable()) || */Dialogue.s_dialogueActive)

		{

			inputEnabled = false;

		}



		// Continue only if input is enabled

		if (inputEnabled)

		{

				inputEnabled2 = true;



			// If not a generic key press

//START:not a generic key press#

			if (true/*!GenericKeyHandling(millis)*/)

			{

				if (!inputEnabled2)

				{

					m_trackToPointerNotPlayer = false;

				}



				ExploreModeKeyHandling(millis);



				// Update auto-selection

				if ( (AUTO_SELECTION) &&

					 ( (SimsApp.s_MIDlet.m_GameFlags & GameDefines.GAME_FLAG_MASK_PLAYER_WORKING) == 0) )

				{

					ExploreModeAutoSelection();

				}

			}

//END

		}



	}	// end UpdateKeyHandling()



	/**

	 *  Draw the tool tip

	 *

	 * @param	g	Graphic context to render to

	 */

	public final void DrawToolTip(final Graphics g)

	{

		// Hold a selection on a character name for a while

		if (m_selectedObject == null)

			return;



		// Draw name

		g.setFont(Dialogue.DIALOGUE_FONT);



		if (itemSelected)

		{

			int[] itemScreenPos = GetItemScreenPos(m_selectedObject);



			if (itemScreenPos != null)

			{

				if (GameDefines.SOFT_KEY_TOOL_TIP)

				{

					// Draw with drop shadow

//					String text = Utility.nameCapitaliseString(m_selectedObject.m_name);

					String text = (m_selectedObject.m_name);

					g.setFont(Dialogue.FONT_PROP_SMALL);



					g.setColor(Colors.BLACK);

					g.drawString(text,

							GameDefines.SOFT_KEY_TEXT_X_OFFSET + GameDefines.DROP_SHADOW_OFFSET,

							GameDefines.SOFT_KEY_TEXT_Y_OFFSET + GameDefines.DROP_SHADOW_OFFSET,

							Graphics.TOP | Graphics.LEFT);

					g.setColor(Colors.YELLOW);

					g.drawString(text,

							GameDefines.SOFT_KEY_TEXT_X_OFFSET,

							GameDefines.SOFT_KEY_TEXT_Y_OFFSET,

							Graphics.TOP | Graphics.LEFT);

				}

				else

				{

					// Draw with drop shadow

//					String text = Utility.nameCapitaliseString(m_selectedObject.m_name);

					String text = (m_selectedObject.m_name);

					g.setColor(Colors.BLACK);

					g.drawString(text,

							itemScreenPos[0] + GameDefines.DROP_SHADOW_OFFSET,

							itemScreenPos[1]-15 + GameDefines.DROP_SHADOW_OFFSET,

							Graphics.BOTTOM | Graphics.HCENTER);

					g.setColor(Colors.WHITE);

					g.drawString(text,

							itemScreenPos[0],

							itemScreenPos[1]-15,

							Graphics.BOTTOM | Graphics.HCENTER);

				}



				Dialogue.s_ArrowImages.Draw(g, Dialogue.ARROW_IMAGE_OBJ_POINTER,

							itemScreenPos[0],

							itemScreenPos[1] + (distanceArrowMoved/* - OBJECT_ARROW_OFFSET*/),

							false, Graphics.BOTTOM | Graphics.HCENTER);

			}

		}

		else

		{

			int drawX =

				SKUConsts.ISO_VIEW_X_POS + SKUConsts.ISO_VIEW_HALF_WIDTH + m_PointerOffsetX;

			int drawY =

				SKUConsts.ISO_VIEW_Y_POS + SKUConsts.ISO_VIEW_HALF_HEIGHT + m_PointerOffsetX;

			g.drawString(m_selectedObject.m_name, drawX, drawY, Graphics.TOP | Graphics.HCENTER);

		}

	}



	/**

	 *  Update the state of the plumb-bob selection

	 *

	 * @param	millis	Milliseconds to update for

	 */

	private final void UpdateToolTip(final int millis)

	{

		// Do the animation calculations once

		int  motionDirection = arrowMovingDown ? -1:1;

		int motionVelocity = (motionDirection * OBJECT_ARROW_MAX_MOVE_Y_PER_SEC * millis) / 1000;



		// now update the distance moved

		distanceArrowMoved += motionVelocity;



		// if the object pointer has reached the apex of the motion, change direction

		if ( Math.abs(distanceArrowMoved) >= OBJECT_ARROW_MAX_MOVE_Y )

		{

			arrowMovingDown = !arrowMovingDown;

			int maxBound = OBJECT_ARROW_MAX_MOVE_Y - 1;

			distanceArrowMoved = Math.max(-maxBound, Math.min(maxBound, distanceArrowMoved));

		}

	}



	/**

	 *  Update the state of the plumb-bob selection

	 *

	 * @param	millis	Milliseconds to update for

	 */

	private final void UpdateSelectionToolTip(final int millis)

	{

		// Hold a selection on a character name for a while

		if (m_selectedObject != null)

		{

			// Check if name still present on screen

			if (System.currentTimeMillis() > (selectedNameTime + selectedNameTimer) )

			{

				m_selectedObject = null;

				selectedNameTimer = 0;

				itemSelected = false;

			}

		}

	}



	/**

	 * handle any key presses for explore mode

	 * (using direction relative to screen approach)

	 *

	 * @param millis	Time elapsed since last update

	 */

	private void ExploreModeKeyHandling(final int millis)

	{

		int dX = 0;					// Delta movement of pointer in x direction

		int dY = 0;					// Delta movement of pointer in y direction

		int newVelocity;			// Temporary variable in deciding velocity

		int acceleration;			// Acceleration of pointer this frame

		boolean trackToPlayer = false;

//		boolean update = true;

		SimsCanvas keys;			// Object that knows about key presses



		// Get reference to key handler

		keys = SimsCanvas.s_Canvas;



		// reset the arrows to the dark colors

//		m_UpArrow.setImage(m_InactiveArrow, m_InactiveArrow.getWidth(), m_InactiveArrow.getHeight());

//		m_DownArrow.setImage(m_InactiveArrow, m_InactiveArrow.getWidth(), m_InactiveArrow.getHeight());

//		m_RightArrow.setImage(m_InactiveArrow, m_InactiveArrow.getWidth(), m_InactiveArrow.getHeight());

//		m_LeftArrow.setImage(m_InactiveArrow, m_InactiveArrow.getWidth(), m_InactiveArrow.getHeight());



		int pressed = SimsCanvas.PRESSED | SimsCanvas.HELD;

		if((keys.getActionState(SimsCanvas.FIRE) == SimsCanvas.PRESSED) ||

			(keys.getActionState(SimsCanvas.ACCEPT) == SimsCanvas.PRESSED))

		{

			if (ObjectSelectionKeyHandling(millis))

			{

				// Already handled

//				update = false;

			}

			else if ( m_trackToPointerNotPlayer &&

					  (!SimsApp.s_MIDlet.m_PlayerSim.IsWalking()) &&

					  ((SimsApp.s_MIDlet.m_GameFlags & GameDefines.GAME_FLAG_MASK_PLAYER_BUSY) == 0))

			{

				int[] gridPos = GetScreenCenterGridPos();

				SimsApp.s_MIDlet.m_PlayerSim.AddWalkToAction(gridPos[0], gridPos[1]);

				trackToPlayer = false;

			}

		}



		// Determine how pointer should be affected.

		/*else if ((keys.getActionState(SimsCanvas.UP) & pressed) != 0)

		{

			dY = -1;

			m_UpArrow.setImage(m_ActiveArrow, m_ActiveArrow.getWidth(), m_ActiveArrow.getHeight() );

//			m_IsoMapY -= 4;

		}

		else if ((keys.getActionState(SimsCanvas.DOWN) & pressed) != 0)

		{

			dY = 1;

			m_DownArrow.setImage(m_ActiveArrow, m_ActiveArrow.getWidth(), m_ActiveArrow.getHeight() );

//			m_IsoMapY += 4;

		}

		else if ((keys.getActionState(SimsCanvas.LEFT) & pressed) != 0)

		{

			dX = -1;

			m_LeftArrow.setImage(m_ActiveArrow, m_ActiveArrow.getWidth(), m_ActiveArrow.getHeight() );

		}

		else if ((keys.getActionState(SimsCanvas.RIGHT) & pressed) != 0)

		{

			dX = 1;

			m_RightArrow.setImage(m_ActiveArrow, m_ActiveArrow.getWidth(), m_ActiveArrow.getHeight() );

		}*/

	  	// if the player selected the point, and another action isn't in process,

	  	// track to the player and move to the new position



		// Determine how pointer should be affected.

		else

		{

			if ((keys.getActionState(SimsCanvas.UP) & pressed) != 0)

			{

				dY = -1;

			}

			if ((keys.getActionState(SimsCanvas.DOWN) & pressed) != 0)

			{

				dY = 1;

			}

			if ((keys.getActionState(SimsCanvas.LEFT) & pressed) != 0)

			{

				dX = -1;

			}

			if ((keys.getActionState(SimsCanvas.RIGHT) & pressed) != 0)

			{

				dX = 1;

			}

		}



		// Set scroll arrows

		SetArrows(dX,dY);



		// Determine pointer acceleration.

		// If speed is zero then accelerate to minimum speed.

		// Else accelerate at normal rate.

		acceleration = ((m_PointerVelX != 0) || (m_PointerVelY != 0)) ?

							POINTER_ACCEL_PER_FRAME :

							MIN_POINTER_MOVE_PER_FRAME;



		// Accelerate cursor in required directions

		// (notice that speed is snapped to zero when key is released)

		dX *= acceleration;

		newVelocity = m_PointerVelX + dX;

		if (Math.abs(newVelocity) > Math.abs(m_PointerVelX))

		{

			m_PointerVelX = newVelocity;

		}

		else

		{

			m_PointerVelX = dX;

		}



		dY *= acceleration;

		newVelocity = m_PointerVelY + dY;

		if (Math.abs(newVelocity) > Math.abs(m_PointerVelY))

		{

			m_PointerVelY = newVelocity;

		}

		else

		{

			m_PointerVelY = dY;

		}



		// 	Limit velocity

		m_PointerVelX = Math.max(-MAX_POINTER_MOVE_PER_FRAME,

						Math.min(MAX_POINTER_MOVE_PER_FRAME, m_PointerVelX));



		m_PointerVelY = Math.max(-MAX_POINTER_MOVE_PER_FRAME,

						Math.min(MAX_POINTER_MOVE_PER_FRAME, m_PointerVelY));



		// Move cursor

		if (m_PointerVelX != 0 || m_PointerVelY != 0)

		{

			int[] gridPos = Utility.WorldToGridCoords(m_ScrollX + SKUConsts.ISO_VIEW_HALF_WIDTH + m_PointerVelX, m_ScrollY + SKUConsts.ISO_VIEW_HALF_HEIGHT + m_PointerVelY);



			if (IsSpaceInWorld(gridPos[0], gridPos[1]))

			{

				m_ScrollX += m_PointerVelX;

				m_ScrollY += m_PointerVelY;

			}

		}



		if (trackToPlayer)

		{

			m_trackToPointerNotPlayer = false;

		}

		else

		{

			m_trackToPointerNotPlayer = true;

		}



		return;



	} // end keyHandlingExplore



	private void ExploreModeAutoSelection()

	{

		EdithObject toSelect = null;	// Object to auto-select

		EdithObject softSelect = null;	// Object to auto-select



		// Determine grid location at centre of screen.

		int[] curGridPos = GetScreenCenterGridPos();



		int cursorX = m_ScrollX + SKUConsts.ISO_VIEW_HALF_WIDTH;

		int cursorY = m_ScrollY + SKUConsts.ISO_VIEW_HALF_HEIGHT;

		final int soft = 8;



		// Determine world coordinates of this grid location.

		// Multiply y by 2 so that x and y are on same scaling.

		int[] curWorldPos = Utility.GridToWorldCoords(curGridPos[0], curGridPos[1]);

		curWorldPos[0] = SKUConsts.ISO_VIEW_HALF_WIDTH + m_ScrollX;

		curWorldPos[1] = SKUConsts.ISO_VIEW_HALF_HEIGHT + m_ScrollY;

		curWorldPos[1] <<= 1;



		// Create list of grid locations to search

		// (this is not 100% generic, but much smaller code)

		final byte[][] searchOffsets =

		{

				{2, 2},

				{2, 1}, {1, 2},

				{1,1}, {2,0}, {0,2},

				{1,0}, {0,1},

				{0,0}, {1,-1}, {-1,1},

				{-1,0}, {0,-1},

				{-1,-1}

		};



		// Search list of grid locations to search

		// until an object is found, or there are no

		// more to search

		for (int index=0; (toSelect == null) && (index < searchOffsets.length); index++)

		{

			int gridx = searchOffsets[index][0] + curGridPos[0];

			int gridy = searchOffsets[index][1] + curGridPos[1];



			// Manually check extents to avoid problems when the player scrolls to the very edges of the map

			if (gridx<0 || gridy<0 || gridx>=itemsPositions.length || gridy>=itemsPositions[0].length)

				continue;



			// If there is an object here

			EdithObject objectHere = null;



			if (IsSpaceInWorld(gridx, gridy) )

				objectHere = IsItem(gridx, gridy);



			if ((objectHere != null) && (objectHere != SimsApp.s_MIDlet.m_PlayerSim) && (objectHere.m_Billboard != null))

			{

				Billboard b = objectHere.m_Billboard;

				int w = b.width;

				int h = b.height;

		        int xmin = b.x-(b.mirror ? w-b.anchor_x : b.anchor_x);

		        int ymin = b.y-(b.anchor_y);

		        if (cursorX >= xmin && cursorX <= xmin+w && cursorY >= ymin && cursorY <= ymin+h)

		        {

					toSelect = objectHere;

					break;

		        }

		        if (softSelect==null)

		        {

			        w += soft<<1;

			        h += soft<<1;

			        cursorX += soft;

			        cursorY += soft;

			        if (cursorX >= xmin && cursorX <= xmin+w && cursorY >= ymin && cursorY <= ymin+h)

			        {

			        	softSelect = objectHere;

			        }

		        }

			}

		}



		if (toSelect==null)

			toSelect = softSelect;



		// Select object if found

		if (toSelect != null)

		{

			MoveSelection(toSelect);

		}



	}



	/**

	 * Handle object selection

	 *

	 * @return		True if an object selection was handled, false if nothing handled.

	 */

	private boolean ObjectSelectionKeyHandling(final int millis)

	{

		boolean handled = false;



		// Get reference to key handler

//		SimsCanvas keys = SimsCanvas.s_Canvas;



		if (itemSelected)

		{

			// Check that the object hasn't become unselectable since the selection changed

			// Needed to cope with cooking appliance fires!

			if (SimsApp.s_MIDlet.IsObjectSelectable(m_selectedObject.m_GuId))

			{

				itemSelected = false;

				m_selectedObject = null;

				return true;

			}



			SimsApp.s_MIDlet.ActivateObject(m_selectedObject);

			handled = true;

		}



		return handled;

	}



	private final void MoveSelection(EdithObject selection)

	{

		// If new selection

		if (selection != m_selectedObject)

		{

			if ( (selection.m_InstanceId == SimsApp.s_MIDlet.m_PlayerSim.m_InstanceId) ||

				 ( (selection.m_GuId > WorldData.LAST_ITEM) &&

				   (selection.m_GuId < WorldData.NPC_ID_START_OFFSET) ) )

			{

				return;

			}



			if (SimsApp.s_MIDlet.IsObjectSelectable(selection.m_GuId))

				return;



			m_selectedObject = selection;



			selectedNameTime = System.currentTimeMillis();

			selectedNameTimer = ITEM_SELECTION_DELAY;



			itemSelected = true;

			// move the arrow to the proper position and draw it

			int[] itemScreenPos = GetItemScreenPos(m_selectedObject);



			// only adjust the position if the screen position isn't null

			if (itemScreenPos != null)

			{

				distanceArrowMoved = 0;

				arrowMovingDown = false;

			}

		}

		else	// same selected again

		{

			if (selection != null)

			{

				// Reset time to dissapear

				selectedNameTime = System.currentTimeMillis();

				selectedNameTimer = ITEM_SELECTION_DELAY;

			}

		}

	}



	/**

	 * Gets the screen position of the object item or character

	 *

	 * @param isCharacter

	 * @return

	 */

	public int[] GetItemScreenPos(EdithObject objectHere)

	{

		Billboard b = objectHere.m_Billboard;

		int w = b.width;

//		int h = b.height;

        int xmin = b.x-(b.mirror ? w-b.anchor_x : b.anchor_x);

        int ymin = b.y-(b.anchor_y);

        int xmid = xmin+w/2;



        // Grab this position.

        int[] itemScreenPos = new int[] {xmid, ymin};



		// Adjust by scroll amount

		itemScreenPos[0] -= m_ScrollX;

		itemScreenPos[1] -= m_ScrollY;



		return (itemScreenPos);



//		int[] itemScreenPos = null;

//

//		// if the item selected is a sim object, get the sim coordinates

//		if (eObject instanceof SimObject)

//		{

//			SimObject sim = (SimObject)eObject;

//			itemScreenPos = Utility.GridToWorldCoords(sim.GetXPos(), sim.GetYPos() );

//		}

//		// othwerise display the item

//		else

//		{

////			ItemObject item = (ItemObject)eObject;

//			itemScreenPos = eObject.GetCentreWorldPos(eObject);

//		}

//

//		// Adjust by scroll amount

//		itemScreenPos[0] -= m_ScrollX;

//		itemScreenPos[1] -= m_ScrollY;

//

//		return (itemScreenPos);



	} // end GetItemScreenPos



	/**

	 * Loads all scripted objects from the given file and adds them to the board.

	 * @param	fileName	Name of file to load scripted objects from

	 */

	public void LoadScriptedObjects()

	{

		//Debug.println("Loading lot objects: " + m_LayoutGuid, //Debug.CHAN_CORE);



		try

		{

			byte[] data = Utility.GetGlobalResource(m_LayoutGuid);



			// Load object from inventory

			Vector objects = EdithObject.ReadFromFile(data);

			Enumeration elements = objects.elements();



			while (elements.hasMoreElements())

			{

				EdithObject curObject = ((EdithObject)elements.nextElement());



				if (!AddObject(curObject))

				{

	//START:IGNORE:debug print 3#

					//Debug.println("failed to add scripted object to (" +

							//		curObject.GetXPos() + "," + curObject.GetYPos() +

							//		") in world: " + curObject.m_GuId, //Debug.CHAN_CORE);

	//END

				}

			}

		}

		catch (Exception e)

		{

			// TODO Auto-generated catch block

			e.printStackTrace();

		}



	} // end loadScriptedObjects



	/**

	 * Scroll so that the given object lies in the centre of view

	 * @param object	Object to centre to

	 */

	private final void CentreOnObject(final EdithObject object)

	{

		int[] pos;



		// Get position of object in world

		// (relative to top of top left tile in world)

		pos = Utility.GridToWorldCoords(object.GetXPos(), object.GetYPos());

		if (object instanceof SimObject)

		{

//START:IGNORE:CentreOnObject#

			int[] offset = ((SimObject)object).GetDrawOffset();

//END

			pos[0] += offset[0];

			pos[1] += offset[1];

		}



		// Subtract half the screen size to centre on this

		// point

		pos[0] -= SKUConsts.ISO_VIEW_HALF_WIDTH;

		pos[1] -= SKUConsts.ISO_VIEW_HALF_HEIGHT;



		m_ScrollX = pos[0];

		m_ScrollY = pos[1];

	}



	/*

	 * Calculates the grid position at the centre of the screen

	 * @return	Grid location closest to centre of screen

	 */

	public int[] GetScreenCenterGridPos()

	{

		// Determine which grid pos lies at centre of screen

		int[] gridPos = Utility.WorldToGridCoords(

						m_ScrollX + SKUConsts.ISO_VIEW_HALF_WIDTH,

						m_ScrollY + SKUConsts.ISO_VIEW_HALF_HEIGHT);



		return gridPos;

	}



	/**

	 * Determine if a space is occupied but item or wall.

	 *

	 * @param x			x position of coordinate to check

	 * @param y			y position of coordinate to check

	 * @return			true if occupied, else false

	 */

	public boolean IsSpaceOccupied(int x, int y)

	{

		return !IsSpaceInWorld(x, y) || itemsPositions[x][y] != null || !IsGridLocationWalkable(x, y);

	}



	/**

	 * Recursive function to seek out attached portals.

	 * @param id

	 * @param portals

	 * @param node

	 */

	public final void FindPortals(byte id, int x, int y, Vector portals)

	{

		// Check other worldliness.

		if(!IsSpaceInWorld(x, y))

			return;



		// Find the portal id here.

		byte sector = getSector(x, y);

		if((sector & 0x80) != 0)

		{

			byte portalId = (byte) (sector & ~0x80);

			if(portalId == id)

			{

				// Ensure that this tile has not already been added.

				for(int i = 0; i < portals.size(); ++i)

				{

					Node node = (Node) portals.elementAt(i);

					// Just check the position.

					if(node.getX() == x && node.getY() == y)

						return;

				}



				// Found a valid new tile.

				portals.addElement(Node.CreateBoardNode(null, x, y, false, 1, 0));



				// Check the connected nodes.

				FindPortals(id, x+1, y, portals);

				FindPortals(id, x-1, y, portals);

				FindPortals(id, x, y+1, portals);

				FindPortals(id, x, y-1, portals);

			}

		}



		// All done.

		return;

	}



	public EdithObject GetItem(int guid)

	{

		if(guid == WorldData.INVALID_ITEM_ID)

		{

			return null;

		}

		else

		{

			return (EdithObject) m_Items.get(new Integer(guid));

		}

	}



	static void LoadArrows()

	{

		Dialogue.LoadStaticImages();

//		s_bottomArrowY = SKUConsts.ISO_VIEW_Y_POS + SKUConsts.ISO_VIEW_HEIGHT;

	}



	static void RenderArrows(Graphics g)

	{

		int w = Dialogue.s_ArrowImages.GetWidth(Dialogue.ARROW_IMAGE_UP_ARROW);

		int h = Dialogue.s_ArrowImages.GetHeight(Dialogue.ARROW_IMAGE_UP_ARROW);



		int left	= SKUConsts.ISO_VIEW_X_POS;

		int right	= left + SKUConsts.ISO_VIEW_WIDTH;

		int top		= SKUConsts.ISO_VIEW_Y_POS + 5;

		int bottom	= top + SKUConsts.ISO_VIEW_HEIGHT + GameDefines.BOTTOM_ARROW_Y_OFFSET;



		int centre 	= (right - w)/2 + 2;

		int middle 	= (bottom - w)/2 + 2;

		//int centre = left + SKUConsts.ISO_VIEW_HALF_WIDTH;

		//int middle = top + SKUConsts.ISO_VIEW_HALF_HEIGHT;

		//int middle = ( (top + bottom + h) / 2);



		Dialogue.s_ArrowImages.Draw(g, Dialogue.ARROW_IMAGE_UP_ARROW_HOLLOW    + ((s_arrowHighlightMask&1)<<2), centre, top+1, false, 0);

		Dialogue.s_ArrowImages.Draw(g, Dialogue.ARROW_IMAGE_RIGHT_ARROW_HOLLOW + ((s_arrowHighlightMask&8)>>1), right-h-1, middle, false, 0);

		Dialogue.s_ArrowImages.Draw(g, Dialogue.ARROW_IMAGE_DOWN_ARROW_HOLLOW  + ((s_arrowHighlightMask&2)<<1), centre, bottom-h-1-10, false, 0);

		Dialogue.s_ArrowImages.Draw(g, Dialogue.ARROW_IMAGE_LEFT_ARROW_HOLLOW  + ((s_arrowHighlightMask&4)   ), left+1, middle, false, 0);

	}



	static void SetArrows(final int x, final int y)

	{

		// set the arrows to active or not:

		s_arrowHighlightMask = 0;

		if (y < 0) s_arrowHighlightMask |= 1;

		if (y > 0) s_arrowHighlightMask |= 2;

		if (x < 0) s_arrowHighlightMask |= 4;

		if (x > 0) s_arrowHighlightMask |= 8;

	}



	/** Maximum dimension of map used */

	private static final int MAX_MAP_DIMENSION = 100;



	/** Whether auto-selection of objects occurs in direct or explore mode */

	private static final boolean AUTO_SELECTION = true;



//	private static final int START_OBJECT_SCREEN_SEARCH_Y = 1;

//	private static final int END_OBJECT_SCREEN_SEARCH_Y = 1;

//	private static final int START_OBJECT_SCREEN_SEARCH_X = 1;

//	private static final int END_OBJECT_SCREEN_SEARCH_X = 0;



	/** How long a character gets selected for (ms) */

	private static final long ITEM_SELECTION_DELAY = AUTO_SELECTION ? 100 : 5000;



//	private static final int OBJECT_ARROW_OFFSET = 8;

	private static final int OBJECT_ARROW_MAX_MOVE_Y = 4;

	private static final int OBJECT_ARROW_MAX_MOVE_Y_PER_SEC = 60;



	/** Minimum pixels moved by pointer in either direction per frame (when a button pressed) */

	//private static final int MIN_POINTER_MOVE_PER_FRAME = 8;

	private static final int MIN_POINTER_MOVE_PER_FRAME = 6;



	/** Maximum pixels moved by pointer in either direction per frame */

	//private static final int MAX_POINTER_MOVE_PER_FRAME = 8;

	private static final int MAX_POINTER_MOVE_PER_FRAME = 6;



	/** Acceleration of pointer in either direction per frame */

	private static final int POINTER_ACCEL_PER_FRAME = 1;



	/** True if objects should be rendered (currently very slow) */

	private static final boolean DISPLAY_OBJECTS = true;



	/** True if we want to display scripted menus */

	public static final boolean USE_SCRIPTED_MENUS = true;



	/** How many tiles across selection works over */

//	private static final int AUTO_SELECTION_TILES_ACROSS_FP = (int)(1.5 * Utility.FIXED_ONE);



	/** The max distance from the cursor that auto-selection can occur at */

//	private static final int AUTO_SELECTION_MAX_DIST_FP =

//		(SKUConsts.TILE_EDGE_LENGTH_FP * AUTO_SELECTION_TILES_ACROSS_FP) >> Utility.FIXED_POS;



	/** The square of the max distance form the curos that auto-selection can occur at */

//	private static final int AUTO_SELECTION_MAX_DIST_SQ =

//		(int)(((long)AUTO_SELECTION_MAX_DIST_FP * (long)AUTO_SELECTION_MAX_DIST_FP) >> (Utility.FIXED_POS * 2));



	/** Singleton instance of class */

	public static House s_LotSingleton;



	public static byte s_arrowHighlightMask;

//	public static int s_bottomArrowY;



	/** Amount the map is scrolled in X direction */

	public int m_ScrollX;

	/** Amount the map is scrolled in Y direction */

	public int m_ScrollY;

	public int m_LastRenderTime;

	public int m_Guid;

	public int m_LotNum;



	/** All items in world, referenced by name */

	private Hashtable m_Items;



	/** Maps locations to item names */

	private Object[][] itemsPositions;



	/** Amount the map is scrolled when it actually was scrolled X direction */

	private int m_LastScrollX;

	/** Amount the map is scrolled when it actually was scrolled Y direction */

	private int m_LastScrollY;

	/** Pointer position from centre of screen*/

	private int m_PointerOffsetX;

	/** Velocity in pixels of pointer */

	private int m_PointerVelX;

	/** Velocity in pixels of pointer */

	private int m_PointerVelY;



	/** Used in pointer control method to determine what to track to */

	private boolean m_trackToPointerNotPlayer;



	private EdithObject m_selectedObject;

	private boolean itemSelected;

	private long selectedNameTime;

	private long selectedNameTimer;



	// sprite objects for the object selection mode

	private int distanceArrowMoved;

	private boolean arrowMovingDown;



	private boolean m_firstFrame = true;

	private int m_LayoutGuid;



} // end Lot class

